/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.remoting;

import java.io.Serializable;
import org.refcodes.remoting.MethodRequest;
import org.refcodes.remoting.Reply;
import org.refcodes.remoting.SerializeUtility;

class ReplyDescriptor
implements Reply,
Serializable {
    private static final long serialVersionUID = 1L;
    private boolean _hasReply = false;
    private String _instanceId = null;
    private Object _returnValue = null;
    private String _sessionId = null;
    private Throwable _throwable = null;

    public ReplyDescriptor() {
    }

    public ReplyDescriptor(Object aReturnValue, Throwable aException, MethodRequest aMethodRequestDescriptor) {
        this(aReturnValue, aException, aMethodRequestDescriptor.getInstanceId(), aMethodRequestDescriptor.getSessionId());
    }

    public ReplyDescriptor(Object aReturnValue, Throwable aException, String aInstanceId, String aSessionId) {
        this._instanceId = aInstanceId;
        this._sessionId = aSessionId;
        this._throwable = aException;
        this._returnValue = aReturnValue;
        this._hasReply = true;
    }

    public ReplyDescriptor(String instanceId, String sessionId) {
        this._returnValue = null;
        this._throwable = null;
        this._sessionId = sessionId;
        this._instanceId = instanceId;
        this._hasReply = false;
    }

    protected ReplyDescriptor(String sessionId) {
        this._sessionId = sessionId;
    }

    public String getInstanceId() {
        return this._instanceId;
    }

    @Override
    public Object getReturnValue() {
        return this._returnValue;
    }

    @Override
    public String getSessionId() {
        return this._sessionId;
    }

    public Throwable getException() {
        return this._throwable;
    }

    @Override
    public boolean hasReply() {
        return this._hasReply;
    }

    @Override
    public boolean isReturnValue() {
        return !this.isException();
    }

    @Override
    public boolean isException() {
        return this._throwable != null;
    }

    @Override
    public void setReply(Reply methodReply) {
        if (methodReply == null) {
            this._returnValue = null;
            this._throwable = null;
            this._hasReply = false;
        } else {
            if (!methodReply.getInstanceId().equals(this.getInstanceId())) {
                throw new IllegalArgumentException("Wrong instance TID of  method reply argument.");
            }
            if (!methodReply.getSessionId().equals(this.getSessionId())) {
                throw new IllegalArgumentException("Wrong session TID of method reply argument.");
            }
            this._returnValue = methodReply.getReturnValue();
            this._throwable = methodReply.getException();
            this._hasReply = true;
        }
    }

    @Override
    public void setReturnValue(Object returnValue) {
        this._returnValue = returnValue;
        if (this._returnValue != null) {
            this._returnValue = SerializeUtility.toSerializable(this._returnValue);
        }
        this._hasReply = true;
    }

    @Override
    public void setException(Throwable aException) {
        this._throwable = aException;
        this._hasReply = true;
    }

    protected void setHasReply(boolean hasReply) {
        this._hasReply = hasReply;
    }

    protected void setInstanceId(String instanceId) {
        this._instanceId = instanceId;
    }

    protected void setMethodReplyDescriptor(Reply methodReplyDescriptor) {
        this._instanceId = methodReplyDescriptor.getInstanceId();
        this._sessionId = methodReplyDescriptor.getSessionId();
        this._returnValue = methodReplyDescriptor.getReturnValue();
        this._throwable = methodReplyDescriptor.getException();
        this._hasReply = true;
    }

    protected void setSessionId(String sessionId) {
        this._sessionId = sessionId;
    }

    protected void clear() {
        this._instanceId = null;
        this._returnValue = null;
        this._sessionId = null;
        this._throwable = null;
        this._hasReply = false;
    }
}

