/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest.ext.eureka;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import org.refcodes.component.Destroyable;
import org.refcodes.component.InitializeException;
import org.refcodes.component.LifeCycleStatus;
import org.refcodes.component.OpenException;
import org.refcodes.component.PauseException;
import org.refcodes.component.ResumeException;
import org.refcodes.component.StartException;
import org.refcodes.component.Startable;
import org.refcodes.component.StopException;
import org.refcodes.component.Stoppable;
import org.refcodes.exception.BugException;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.net.HttpBodyMap;
import org.refcodes.net.HttpStatusException;
import org.refcodes.net.LoadBalancingStrategy;
import org.refcodes.net.LoadBalancingStrategyAccessor;
import org.refcodes.net.Url;
import org.refcodes.net.UrlBuilderImpl;
import org.refcodes.net.UrlImpl;
import org.refcodes.rest.AbstractHttpDiscoverySidecar;
import org.refcodes.rest.HttpDiscoveryUrlAccessor;
import org.refcodes.rest.HttpRestClientImpl;
import org.refcodes.rest.RestResponse;
import org.refcodes.rest.ext.eureka.EurekaDiscovery;
import org.refcodes.rest.ext.eureka.EurekaDiscoverySidecar;
import org.refcodes.rest.ext.eureka.EurekaInstanceDescriptor;
import org.refcodes.rest.ext.eureka.EurekaInstanceDescriptorImpl;
import org.refcodes.rest.ext.eureka.EurekaLoopSleepTime;
import org.refcodes.rest.ext.eureka.EurekaServiceStatus;
import org.refcodes.security.TrustStoreDescriptor;
import org.refcodes.security.TrustStoreDescriptorAccessor;

public class EurekaDiscoverySidecarImpl
extends AbstractHttpDiscoverySidecar<EurekaDiscoverySidecar>
implements EurekaDiscoverySidecar {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private ExecutorService _executorService;
    private RefreshDaemon _refreshDaemon;

    public EurekaDiscoverySidecarImpl() {
        this(null);
    }

    public EurekaDiscoverySidecarImpl(ExecutorService aExecutorService) {
        this._executorService = aExecutorService;
    }

    public void initialize(Url aDiscoveryUrl, LoadBalancingStrategy aStrategy, TrustStoreDescriptor aStoreDescriptor) throws InitializeException {
        aDiscoveryUrl = EurekaDiscoverySidecarImpl.toHttpDiscoveryUrl(aDiscoveryUrl, (HttpDiscoveryUrlAccessor.HttpDiscoveryUrlProperty)this);
        aStrategy = EurekaDiscoverySidecarImpl.toLoadBalancingStrategy((LoadBalancingStrategy)aStrategy, (LoadBalancingStrategyAccessor.LoadBalancingStrategyProperty)this);
        super.initialize();
        this.setLoadBalancingStrategy(aStrategy);
        try {
            this._refreshDaemon = new RefreshDaemon(aDiscoveryUrl, aStoreDescriptor, this, this._executorService);
        }
        catch (Exception e) {
            this._lifeCycleAutomaton.setLifeCycleStatus(LifeCycleStatus.ERROR);
            throw new InitializeException(ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
        }
    }

    public synchronized void start() throws StartException {
        try {
            super.start();
            this._refreshDaemon.start();
        }
        catch (Exception e) {
            this._lifeCycleAutomaton.setLifeCycleStatus(LifeCycleStatus.ERROR);
            throw new StartException(ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
        }
    }

    public synchronized void pause() throws PauseException {
        super.pause();
    }

    public synchronized void stop() throws StopException {
        super.stop();
        try {
            this._refreshDaemon.stop();
        }
        catch (Exception e) {
            this._lifeCycleAutomaton.setLifeCycleStatus(LifeCycleStatus.ERROR);
            throw new StopException(ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
        }
    }

    public synchronized void resume() throws ResumeException {
        super.resume();
    }

    public synchronized void destroy() {
        super.destroy();
        try {
            this._refreshDaemon.destroy();
        }
        catch (Exception e) {
            LOGGER.warn(ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
            this._lifeCycleAutomaton.setLifeCycleStatus(LifeCycleStatus.ERROR);
        }
    }

    public Url toUrl(Url aUrl) {
        return EurekaDiscoverySidecarImpl.toUrl(aUrl, this, this._refreshDaemon);
    }

    protected static Url toUrl(Url aUrl, EurekaDiscovery<?> aDiscovery, RefreshDaemon aRefreshDaemon) {
        EurekaInstanceDescriptor[] theArray;
        List<EurekaInstanceDescriptor> theInstances;
        String theHost = aUrl.getHost();
        if (theHost != null) {
            theHost = theHost.toUpperCase();
        }
        if ((theInstances = aRefreshDaemon.getInstance(theHost)) != null && (theArray = theInstances.toArray(new EurekaInstanceDescriptor[theInstances.size()])).length > 0) {
            switch (aDiscovery.getLoadBalancingStrategy()) {
                case CUSTOM: {
                    throw new IllegalStateException("The load balancing satrategy <" + LoadBalancingStrategy.CUSTOM + "> is cunnrently not supported.");
                }
                case NONE: {
                    break;
                }
                case RANDOM: {
                    int theRnd = ThreadLocalRandom.current().nextInt(0, theArray.length);
                    UrlBuilderImpl theUrl = new UrlBuilderImpl(aUrl);
                    int[] theIAddr = theArray[theRnd].getIpAddress();
                    if (theIAddr != null) {
                        theUrl.setIpAddress(theIAddr);
                    } else {
                        theUrl.setHost(theArray[theRnd].getHost());
                    }
                    theUrl.setPort(theArray[theRnd].getPort());
                    return theUrl;
                }
                case RANDOM_STICKY: {
                    throw new IllegalStateException("The load balancing satrategy <" + LoadBalancingStrategy.RANDOM_STICKY + "> is cunnrently not supported.");
                }
                case ROUND_ROBIN: {
                    throw new IllegalStateException("The load balancing satrategy <" + LoadBalancingStrategy.ROUND_ROBIN + "> is cunnrently not supported.");
                }
                default: {
                    throw new BugException("Missing case statement for <" + aDiscovery.getLoadBalancingStrategy() + "> in implementation!");
                }
            }
        }
        return aUrl;
    }

    protected static Url toHttpDiscoveryUrl(Url aDiscoveryUrl, HttpDiscoveryUrlAccessor.HttpDiscoveryUrlProperty aProperty) {
        if (aDiscoveryUrl != null) {
            aProperty.setHttpDiscoveryUrl(aDiscoveryUrl);
        } else {
            aDiscoveryUrl = aProperty.getHttpDiscoveryUrl();
        }
        if (aDiscoveryUrl != null && aDiscoveryUrl.getPath() == null) {
            aDiscoveryUrl = new UrlImpl(aDiscoveryUrl, new String[]{"/eureka/apps"});
            aProperty.setHttpDiscoveryUrl(aDiscoveryUrl);
        }
        return aDiscoveryUrl;
    }

    static class RefreshDaemon
    extends TimerTask
    implements Startable,
    Stoppable,
    Destroyable {
        private Map<String, List<EurekaInstanceDescriptor>> _instances;
        private EurekaDiscovery<?> _discovery;
        private ExecutorService _executorService;
        private Timer _scheduler;

        RefreshDaemon(Url aDiscoveryUrl, TrustStoreDescriptor aStoreDescriptor, EurekaDiscovery<?> aDiscovery, ExecutorService aExecutorService) throws HttpStatusException, OpenException, MalformedURLException {
            this._executorService = aExecutorService;
            this._discovery = aDiscovery;
            this._instances = this.loadRegisteredServices(aDiscoveryUrl, aStoreDescriptor);
        }

        public Map<String, List<EurekaInstanceDescriptor>> getInstances() {
            return this._instances;
        }

        public List<EurekaInstanceDescriptor> getInstance(String aAlias) {
            return this._instances.get(aAlias);
        }

        public void start() {
            this._scheduler = new Timer(true);
            this._scheduler.schedule((TimerTask)this, EurekaLoopSleepTime.DISCOVERY_SERVICE_REFRESH.getMilliseconds(), (long)EurekaLoopSleepTime.DISCOVERY_SERVICE_REFRESH.getMilliseconds());
        }

        public void stop() {
            this._scheduler.cancel();
        }

        public void destroy() {
            this._scheduler.cancel();
            this._discovery = null;
            this._executorService = null;
            this._instances.clear();
            this._instances = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            if (!this._discovery.isRunning()) return;
            LOGGER.info("Refreshing clients from <" + this._discovery.getHttpDiscoveryUrl().toHttpUrl() + ">...");
            try {
                Map<String, List<EurekaInstanceDescriptor>> theNewInstances = this.loadRegisteredServices(this._discovery.getHttpDiscoveryUrl(), ((TrustStoreDescriptorAccessor.TrustStoreDescriptorProperty)this._discovery).getTrustStoreDescriptor());
                for (String eInstanceId : theNewInstances.keySet()) {
                    RefreshDaemon refreshDaemon = this;
                    synchronized (refreshDaemon) {
                        List<EurekaInstanceDescriptor> eInstances = this.toInstancesUpdate(theNewInstances.get(eInstanceId), this._instances.get(eInstanceId));
                        this._instances.put(eInstanceId, eInstances);
                    }
                }
                return;
            }
            catch (MalformedURLException | OpenException | HttpStatusException e) {
                LOGGER.warn("Encountered an exception of type <" + e.getClass().getName() + "> while refreshing the clients from discovery registry <" + this._discovery.getHttpDiscoveryUrl().toHttpUrl() + ">: " + ExceptionUtility.toMessage((Throwable)e));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, List<EurekaInstanceDescriptor>> loadRegisteredServices(Url aDiscoveryUrl, TrustStoreDescriptor aStoreDescriptor) throws OpenException, HttpStatusException, MalformedURLException {
            HashMap<String, List<EurekaInstanceDescriptor>> theInstances = new HashMap<String, List<EurekaInstanceDescriptor>>();
            aDiscoveryUrl = EurekaDiscoverySidecarImpl.toHttpDiscoveryUrl(aDiscoveryUrl, this._discovery);
            aStoreDescriptor = EurekaDiscoverySidecarImpl.toTrustStoreDescriptor((TrustStoreDescriptor)aStoreDescriptor, (TrustStoreDescriptorAccessor.TrustStoreDescriptorProperty)((TrustStoreDescriptorAccessor.TrustStoreDescriptorProperty)this._discovery));
            HttpRestClientImpl theClient = new HttpRestClientImpl(this._executorService);
            theClient.open(aStoreDescriptor);
            theClient.setBaseUrl(aDiscoveryUrl);
            LOGGER.info("Requesting discoverable services at <" + aDiscoveryUrl.toHttpUrl() + "> Eureka service registry...");
            RestResponse theResponse = theClient.doGet("/");
            if (theResponse.getHttpStatusCode().isErrorStatus()) {
                throw theResponse.getHttpStatusCode().toHttpStatusException("Cannot retrieve any discoverable services with service discovery <" + aDiscoveryUrl.toHttpUrl() + "> due to HTTP-Status-Code " + theResponse.getHttpStatusCode() + "<" + theResponse.getHttpStatusCode().getStatusCode() + ">: " + theResponse.getHttpBody());
            }
            HttpBodyMap theHttpBody = theResponse.getResponse();
            HttpBodyMap theCloud = theHttpBody.retrieveFrom(theHttpBody.toPath(new String[]{"applications", "application"}));
            Set theAppsListing = theCloud.directories();
            for (String eAppIndex : theAppsListing) {
                HttpBodyMap eApp = theCloud.retrieveFrom(theCloud.toPath(new String[]{eAppIndex, "instance"}));
                Set eInstancesListing = eApp.directories();
                for (String eInstanceIndex : eInstancesListing) {
                    ArrayList<EurekaInstanceDescriptorImpl> eDescriptors;
                    EurekaInstanceDescriptorImpl eDescriptor = new EurekaInstanceDescriptorImpl(eApp.retrieveFrom(eInstanceIndex));
                    String eAlias = eDescriptor.getAlias();
                    if (eAlias != null) {
                        eAlias = eAlias.toUpperCase();
                    }
                    if ((eDescriptors = (ArrayList<EurekaInstanceDescriptorImpl>)theInstances.get(eAlias)) == null) {
                        EurekaDiscovery<?> eurekaDiscovery = this._discovery;
                        synchronized (eurekaDiscovery) {
                            eDescriptors = (List)theInstances.get(eAlias);
                            if (eDescriptors == null) {
                                eDescriptors = new ArrayList<EurekaInstanceDescriptorImpl>();
                                theInstances.put(eAlias, eDescriptors);
                            }
                        }
                    }
                    eDescriptors.add(eDescriptor);
                }
            }
            return theInstances;
        }

        private List<EurekaInstanceDescriptor> toInstancesUpdate(List<EurekaInstanceDescriptor> aRemoteInstances, List<EurekaInstanceDescriptor> aLocalInstances) {
            ArrayList<EurekaInstanceDescriptor> theInstances = new ArrayList<EurekaInstanceDescriptor>(aLocalInstances);
            if (aRemoteInstances != null) {
                for (EurekaInstanceDescriptor eRemoteInstance : aRemoteInstances) {
                    EurekaInstanceDescriptor eLocalInstance = this.toInstance(eRemoteInstance, theInstances);
                    if (eLocalInstance != null) {
                        theInstances.remove(eLocalInstance);
                    }
                    if (EurekaServiceStatus.UP != EurekaServiceStatus.toStatus(eRemoteInstance.getStatus())) continue;
                    theInstances.add(eRemoteInstance);
                }
            }
            return theInstances;
        }

        private EurekaInstanceDescriptor toInstance(EurekaInstanceDescriptor aInstance, List<EurekaInstanceDescriptor> aInstances) {
            if (aInstances != null) {
                for (EurekaInstanceDescriptor eInstance : aInstances) {
                    if (!eInstance.getHost().equals(aInstance.getHost())) continue;
                    return eInstance;
                }
            }
            return null;
        }
    }
}

