/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest.ext.eureka;

import java.net.UnknownHostException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import org.refcodes.component.CloseException;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.component.InitializeException;
import org.refcodes.component.LifeCycleStatus;
import org.refcodes.component.OpenException;
import org.refcodes.component.PauseException;
import org.refcodes.component.ResumeException;
import org.refcodes.component.StartException;
import org.refcodes.component.StopException;
import org.refcodes.data.Scheme;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.net.HttpMediaType;
import org.refcodes.net.HttpStatusException;
import org.refcodes.net.MediaType;
import org.refcodes.net.ResponseHeaderFields;
import org.refcodes.net.Url;
import org.refcodes.net.UrlImpl;
import org.refcodes.rest.AbstractHttpRegistryRestServerDecorator;
import org.refcodes.rest.HttpExceptionHandler;
import org.refcodes.rest.HttpExceptionHandling;
import org.refcodes.rest.HttpRestServer;
import org.refcodes.rest.RestRequestObserver;
import org.refcodes.rest.ext.eureka.EurekaDataCenterType;
import org.refcodes.rest.ext.eureka.EurekaLoopSleepTime;
import org.refcodes.rest.ext.eureka.EurekaRegistrySidecarImpl;
import org.refcodes.rest.ext.eureka.EurekaRestServer;
import org.refcodes.rest.ext.eureka.EurekaServerDescriptor;
import org.refcodes.rest.ext.eureka.EurekaServiceStatus;
import org.refcodes.security.TrustStoreDescriptor;

public class EurekaRestServerDecorator
extends AbstractHttpRegistryRestServerDecorator<EurekaServerDescriptor, EurekaRestServer>
implements EurekaRestServer {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private ExecutorService _executorService;
    private Timer _scheduler;
    private EurekaDataCenterType _dataCenterType;
    private String _statusPath;
    private String _homePath;
    private RestRequestObserver _homeRequestObserver;
    private RestRequestObserver _statusRequestObserver;

    public EurekaRestServerDecorator(HttpRestServer aServer) {
        super(aServer);
    }

    public EurekaRestServerDecorator(HttpRestServer aServer, ExecutorService aExecutorService) {
        super(aServer);
        this._executorService = aExecutorService;
    }

    @Override
    public synchronized void initialize(EurekaServerDescriptor aServerDescriptor, RestRequestObserver aPingObserver, RestRequestObserver aStatusObserver, RestRequestObserver aHomeObserver, Url aRegistryUrl, TrustStoreDescriptor aStoreDescriptor) throws InitializeException {
        super.initialize();
        aPingObserver = this.toPingObserver(aPingObserver);
        aHomeObserver = this.toHomeObserver(aHomeObserver);
        aStatusObserver = this.toStatusObserver(aStatusObserver);
        aRegistryUrl = this.toHttpRegistryUrl(aRegistryUrl);
        aStoreDescriptor = this.toTrustStoreDescriptor(aStoreDescriptor);
        aServerDescriptor = (EurekaServerDescriptor)this.toHttpServerDescriptor(aServerDescriptor);
        try {
            if (aPingObserver != null) {
                if (aServerDescriptor.getPingUrl() == null) {
                    throw new InitializeException("Cannot register a PING observer without a PING path being defined in the server descriptor!");
                }
                this.onGet(aServerDescriptor.getPingUrl().getPath(), aPingObserver).open();
            }
            if (aStatusObserver != null) {
                if (aServerDescriptor.getStatusUrl() == null) {
                    throw new InitializeException("Cannot register a STATUS observer without a STATUS path being defined in the server descriptor!");
                }
                this.onGet(aServerDescriptor.getStatusUrl().getPath(), aStatusObserver).open();
            }
            if (aHomeObserver != null) {
                if (aServerDescriptor.getHomeUrl() == null) {
                    throw new InitializeException("Cannot register a HOME observer without a HOME path being defined in the server descriptor!");
                }
                this.onGet(aServerDescriptor.getHomeUrl().getPath(), aHomeObserver).open();
            }
            this.disableObservers();
            this.doRegister(EurekaServiceStatus.STARTING);
        }
        catch (Exception e) {
            this._lifeCycleAutomaton.setLifeCycleStatus(LifeCycleStatus.ERROR);
            throw new InitializeException(ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
        }
    }

    public synchronized void start() throws StartException {
        try {
            if (!this.isConnectionOpened()) {
                LOGGER.warn("This connection not opened yet (it is in status <" + this.getConnectionStatus() + ">, therefore will try to open this connection now...");
                this.open();
            }
            super.start();
            this.enableObservers();
            this.doStatusUpdate(EurekaServiceStatus.UP);
            this._scheduler = new Timer(true);
            this._scheduler.schedule((TimerTask)new EurekaRegistrySidecarImpl.HeartBeatDaemon(this, this._executorService), EurekaLoopSleepTime.REGISTRY_SERVICE_HEARBEAT.getMilliseconds(), (long)EurekaLoopSleepTime.REGISTRY_SERVICE_HEARBEAT.getMilliseconds());
        }
        catch (Exception e) {
            this._lifeCycleAutomaton.setLifeCycleStatus(LifeCycleStatus.ERROR);
            throw new StartException(ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
        }
    }

    public synchronized void pause() throws PauseException {
        super.pause();
        try {
            this.doStatusUpdate(EurekaServiceStatus.DOWN);
            this.disableObservers();
        }
        catch (Exception e) {
            this._lifeCycleAutomaton.setLifeCycleStatus(LifeCycleStatus.ERROR);
            throw new PauseException(ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
        }
    }

    public synchronized void resume() throws ResumeException {
        super.resume();
        try {
            this.enableObservers();
            this.doStatusUpdate(EurekaServiceStatus.UP);
        }
        catch (Exception e) {
            this._lifeCycleAutomaton.setLifeCycleStatus(LifeCycleStatus.ERROR);
            throw new ResumeException(ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
        }
    }

    public synchronized void stop() throws StopException {
        super.stop();
        try {
            this._scheduler.cancel();
            this.doStatusUpdate(EurekaServiceStatus.OUT_OF_SERVICE);
            this.disableObservers();
        }
        catch (Exception e) {
            this._lifeCycleAutomaton.setLifeCycleStatus(LifeCycleStatus.ERROR);
            throw new StopException(ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
        }
    }

    public synchronized void destroy() {
        super.destroy();
        try {
            this._scheduler.cancel();
            this.doDeregister();
        }
        catch (Exception e) {
            LOGGER.warn(ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
            this._lifeCycleAutomaton.setLifeCycleStatus(LifeCycleStatus.ERROR);
        }
        finally {
            try {
                this.disableObservers();
                this.close();
            }
            catch (CloseException e) {
                LOGGER.warn(ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
                this._lifeCycleAutomaton.setLifeCycleStatus(LifeCycleStatus.ERROR);
            }
        }
    }

    public String getHomePath() {
        return this._homePath;
    }

    public void setHomePath(String aHomePath) {
        this._homePath = aHomePath;
    }

    public String getStatusPath() {
        return this._statusPath;
    }

    public void setStatusPath(String aStatusPath) {
        this._statusPath = aStatusPath;
    }

    public ConnectionStatus getConnectionStatus() {
        return this._server.getConnectionStatus();
    }

    public void setObserversActive(boolean isActive) {
        this._server.setObserversActive(isActive);
    }

    public boolean isObserversActive() {
        return this._server.isObserversActive();
    }

    public EurekaRestServer withHttpExceptionHandler(HttpExceptionHandler aHttpErrorHandler) {
        this._server.setHttpExceptionHandler(aHttpErrorHandler);
        return this;
    }

    public void setHttpExceptionHandler(HttpExceptionHandler aHttpErrorHandler) {
        this._server.setHttpExceptionHandler(aHttpErrorHandler);
    }

    public HttpExceptionHandler getHttpExceptionHandler() {
        return this._server.getHttpExceptionHandler();
    }

    public EurekaRestServer withHttpExceptionHandling(HttpExceptionHandling aHttpErrorHandling) {
        this._server.setHttpExceptionHandling(aHttpErrorHandling);
        return this;
    }

    public void setHttpExceptionHandling(HttpExceptionHandling aHttpErrorHandling) {
        this._server.setHttpExceptionHandling(aHttpErrorHandling);
    }

    public HttpExceptionHandling getHttpExceptionHandling() {
        return this._server.getHttpExceptionHandling();
    }

    @Override
    public EurekaDataCenterType getEurekaDataCenterType() {
        return this._dataCenterType;
    }

    @Override
    public void setEurekaDataCenterType(EurekaDataCenterType aDataCenterType) {
        this._dataCenterType = aDataCenterType;
    }

    public void onHomeRequest(RestRequestObserver aRequestObserver) {
        this._homeRequestObserver = aRequestObserver;
    }

    public RestRequestObserver getHomeRequestObserver() {
        return this._homeRequestObserver;
    }

    public void onStatusRequest(RestRequestObserver aRequestObserver) {
        this._statusRequestObserver = aRequestObserver;
    }

    public RestRequestObserver getStatusRequestObserver() {
        return this._statusRequestObserver;
    }

    @Override
    public EurekaServerDescriptor toHttpServerDescriptor(String aAlias, String aInstanceId, Scheme aScheme, String aHost, String aVirtualHost, int[] aIpAddress, int aPort, String aPingPath, String aStatusPath, String aHomePath, EurekaDataCenterType aDataCenterType) {
        return EurekaRegistrySidecarImpl.toHttpServerDescriptor(aAlias, aInstanceId, aScheme, aHost, aVirtualHost, aIpAddress, aPort, aPingPath, aStatusPath, aHomePath, aDataCenterType, this);
    }

    protected void doRegister(EurekaServiceStatus aServiceStatus) throws HttpStatusException, OpenException {
        EurekaRegistrySidecarImpl.doRegister(aServiceStatus, this, this._executorService);
    }

    protected void doStatusUpdate(EurekaServiceStatus aServiceStatus) throws OpenException, UnknownHostException, HttpStatusException {
        EurekaRegistrySidecarImpl.doStatusUpdate(aServiceStatus, this, this._executorService);
    }

    protected void doDeregister() throws OpenException, HttpStatusException {
        EurekaRegistrySidecarImpl.doDeregister(this, this._executorService);
    }

    protected Url toHttpRegistryUrl(Url aRegistryUrl) {
        if ((aRegistryUrl = super.toHttpRegistryUrl(aRegistryUrl)) != null && aRegistryUrl.getPath() == null) {
            aRegistryUrl = new UrlImpl(aRegistryUrl, new String[]{"/eureka/apps"});
            this.setHttpRegistryUrl(aRegistryUrl);
        }
        return aRegistryUrl;
    }

    protected RestRequestObserver toHomeObserver(RestRequestObserver aHomeRequestObserver) {
        if (aHomeRequestObserver == null && (aHomeRequestObserver = this._homeRequestObserver) == null) {
            this._homeRequestObserver = aHomeRequestObserver = (aReq, aResp) -> {
                ((ResponseHeaderFields)aResp.getHeaderFields()).putContentType((HttpMediaType)MediaType.TEXT_PLAIN);
                aResp.setResponse((Object)"Pong!");
                LOGGER.info("Received a HOME request, no HOME handler defined, using default handler!");
            };
        }
        return aHomeRequestObserver;
    }

    protected RestRequestObserver toStatusObserver(RestRequestObserver aStatusRequestObserver) {
        if (aStatusRequestObserver == null && (aStatusRequestObserver = this._statusRequestObserver) == null) {
            this._statusRequestObserver = aStatusRequestObserver = (aReq, aResp) -> {
                ((ResponseHeaderFields)aResp.getHeaderFields()).putContentType((HttpMediaType)MediaType.TEXT_PLAIN);
                aResp.setResponse((Object)"Pong!");
                LOGGER.info("Received a STATUS request, no STATUS handler defined, using default handler!");
            };
        }
        return aStatusRequestObserver;
    }
}

