/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest.ext.eureka;

import java.net.MalformedURLException;
import java.util.Map;
import org.refcodes.exception.BugException;
import org.refcodes.mixin.AliasAccessor;
import org.refcodes.mixin.PortAccessor;
import org.refcodes.net.HostAccessor;
import org.refcodes.net.HttpBodyMap;
import org.refcodes.net.IpAddress;
import org.refcodes.net.IpAddressAccessor;
import org.refcodes.net.Url;
import org.refcodes.net.UrlImpl;
import org.refcodes.rest.HomeUrlAccessor;
import org.refcodes.rest.HttpServerDescriptor;
import org.refcodes.rest.PingUrlAccessor;
import org.refcodes.rest.StatusUrlAccessor;
import org.refcodes.rest.ext.eureka.AmazonMetaData;
import org.refcodes.rest.ext.eureka.AmazonMetaDataAccessor;
import org.refcodes.rest.ext.eureka.EurekaDataCenterType;
import org.refcodes.rest.ext.eureka.EurekaDataCenterTypeAccessor;
import org.refcodes.rest.ext.eureka.EurekaServiceStatus;
import org.refcodes.rest.ext.eureka.EurekaServiceStatusAccessor;
import org.refcodes.structure.CanonicalMap;

public interface EurekaServerDescriptor
extends HttpServerDescriptor,
AliasAccessor.AliasProperty,
PingUrlAccessor.PingUrlProperty,
StatusUrlAccessor.StatusUrlProperty,
HomeUrlAccessor.HomeUrlProperty,
HostAccessor.HostProperty,
IpAddressAccessor.IpAddressProperty,
PortAccessor.PortProperty,
HttpBodyMap,
EurekaDataCenterTypeAccessor.EurekaDataCenterTypeProperty,
EurekaServiceStatusAccessor.EurekaServiceStatusProperty,
AmazonMetaDataAccessor.AmazonMetaDataProperty {
    default public Integer getLeaseEvictionDurationInSecs() {
        return this.getInteger("instance/leaseInfo/evictionDurationInSecs");
    }

    default public void setLeaseEvictionDurationInSecs(Integer aLeaseEvictionDurationInSecs) {
        this.putInteger("instance/leaseInfo/evictionDurationInSecs", aLeaseEvictionDurationInSecs);
    }

    default public String getAlias() {
        return (String)this.get("instance/app");
    }

    default public void setAlias(String aAlias) {
        this.put("instance/app", aAlias);
    }

    default public Url getPingUrl() {
        String theHealthCheckUrl = (String)this.get("instance/healthCheckUrl");
        if (theHealthCheckUrl == null) {
            return null;
        }
        try {
            return new UrlImpl(theHealthCheckUrl);
        }
        catch (MalformedURLException e) {
            throw new BugException("Cannot parse the Health-Check URL <" + theHealthCheckUrl + ">, please use the according setter to ensure correct URL format: " + e.getMessage(), (Throwable)e);
        }
    }

    default public void setPingUrl(Url aUrl) {
        this.put("instance/healthCheckUrl", aUrl.toHttpUrl());
    }

    default public Url getStatusUrl() {
        String theStatusPageUrl = (String)this.get("instance/statusPageUrl");
        if (theStatusPageUrl == null) {
            return null;
        }
        try {
            return new UrlImpl(theStatusPageUrl);
        }
        catch (MalformedURLException e) {
            throw new BugException("Cannot parse the Health-Check URL <" + theStatusPageUrl + ">, please use the according setter to ensure correct URL format: " + e.getMessage(), (Throwable)e);
        }
    }

    default public void setStatusUrl(Url aUrl) {
        this.put("instance/statusPageUrl", aUrl.toHttpUrl());
    }

    default public Url getHomeUrl() {
        String theHomePageUrl = (String)this.get("instance/homePageUrl");
        if (theHomePageUrl == null) {
            return null;
        }
        try {
            return new UrlImpl(theHomePageUrl);
        }
        catch (MalformedURLException e) {
            throw new BugException("Cannot parse the Health-Check URL <" + theHomePageUrl + ">, please use the according setter to ensure correct URL format: " + e.getMessage(), (Throwable)e);
        }
    }

    default public void setHomeUrl(Url aUrl) {
        this.put("instance/homePageUrl", aUrl.toHttpUrl());
    }

    default public String getHost() {
        return (String)this.get("instance/hostName");
    }

    default public void setHost(String aHost) {
        this.put("instance/hostName", aHost);
    }

    default public int getPort() {
        return this.getInteger("instance/port");
    }

    default public void setPort(int aPort) {
        this.putInteger("instance/port", aPort);
    }

    default public int[] getIpAddress() {
        return IpAddress.fromAnyCidrNotation((String)((String)this.get("instance/ipAddr")));
    }

    default public void setIpAddress(int[] aIpAddress) {
        this.put("instance/ipAddr", IpAddress.toString((int[])aIpAddress));
    }

    default public String getVirtualHost() {
        return (String)this.get("instance/vipAddress");
    }

    default public void setVirtualHost(String aVirtualHost) {
        this.put("instance/vipAddress", aVirtualHost);
    }

    @Override
    default public EurekaDataCenterType getEurekaDataCenterType() {
        return EurekaDataCenterType.fromName((String)this.get("instance/dataCenterInfo/name"));
    }

    @Override
    default public void setEurekaDataCenterType(EurekaDataCenterType aDataCenterType) {
        this.put("instance/dataCenterInfo/name", aDataCenterType.getName());
    }

    @Override
    default public AmazonMetaData getAmazonMetaData() {
        return (AmazonMetaData)this.toType("instance/dataCenterInfo/metadata", AmazonMetaData.class);
    }

    @Override
    default public void setAmazonMetaData(AmazonMetaData aDataCenterType) {
        this.insertTo("instance/dataCenterInfo/metadata", (CanonicalMap)aDataCenterType);
    }

    @Override
    default public EurekaServiceStatus getEurekaServiceStatus() {
        return EurekaServiceStatus.valueOf((String)this.get("instance/status"));
    }

    @Override
    default public void setEurekaServiceStatus(EurekaServiceStatus aServiceStatus) {
        this.put("instance/status", aServiceStatus.name());
    }

    default public Map<String, String> getMetaData() {
        return this.retrieveFrom("instance/metadata");
    }

    default public void setMetaData(Map<String, String> aMetaData) {
        for (String eKey : aMetaData.keySet()) {
            this.put(this.toPath(new String[]{"instance/metadata", eKey}), aMetaData.get(eKey));
        }
    }

    default public String putMetaData(String aKey, String aValue) {
        return (String)this.put(this.toPath(new String[]{"instance/metadata", aKey}), aValue);
    }
}

