/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest.ext.eureka;

import java.net.MalformedURLException;
import java.util.Map;
import org.refcodes.exception.BugException;
import org.refcodes.mixin.AliasAccessor;
import org.refcodes.mixin.PortAccessor;
import org.refcodes.net.HostAccessor;
import org.refcodes.net.HttpBodyMap;
import org.refcodes.net.IpAddress;
import org.refcodes.net.IpAddressAccessor;
import org.refcodes.net.Url;
import org.refcodes.net.UrlImpl;
import org.refcodes.rest.HomeUrlAccessor;
import org.refcodes.rest.PingUrlAccessor;
import org.refcodes.rest.StatusUrlAccessor;

public interface EurekaInstanceDescriptor
extends AliasAccessor.AliasProperty,
PingUrlAccessor.PingUrlProperty,
StatusUrlAccessor.StatusUrlProperty,
HomeUrlAccessor.HomeUrlProperty,
HostAccessor.HostProperty,
IpAddressAccessor.IpAddressProperty,
HttpBodyMap,
PortAccessor.PortProperty {
    default public String getActionType() {
        return (String)this.get("/actionType");
    }

    default public void setActionType(String aValue) {
        this.put("/actionType", aValue);
    }

    default public String getAlias() {
        return (String)this.get("/app");
    }

    default public void setAlias(String aAlias) {
        this.put("/app", aAlias);
    }

    default public String getCountryId() {
        return (String)this.get("/countryId");
    }

    default public void setCountryId(String aValue) {
        this.put("/countryId", aValue);
    }

    default public String getDataCenterInfoClass() {
        return (String)this.get("/dataCenterInfo/@class");
    }

    default public void setDataCenterInfoClass(String aValue) {
        this.put("/dataCenterInfo/@class", aValue);
    }

    default public String getDataCenterInfoName() {
        return (String)this.get("/dataCenterInfo/name");
    }

    default public void setDataCenterInfoName(String aValue) {
        this.put("/dataCenterInfo/name", aValue);
    }

    default public Url getPingUrl() {
        String theHealthCheckUrl = (String)this.get("/healthCheckUrl");
        if (theHealthCheckUrl == null) {
            return null;
        }
        try {
            return new UrlImpl(theHealthCheckUrl);
        }
        catch (MalformedURLException e) {
            throw new BugException("Cannot parse the Health-Check URL <" + theHealthCheckUrl + ">, please use the according setter to ensure correct URL format: " + e.getMessage(), (Throwable)e);
        }
    }

    default public void setPingUrl(Url aUrl) {
        this.put("/healthCheckUrl", aUrl.toHttpUrl());
    }

    default public Url getStatusUrl() {
        String theStatusPageUrl = (String)this.get("/statusPageUrl");
        if (theStatusPageUrl == null) {
            return null;
        }
        try {
            return new UrlImpl(theStatusPageUrl);
        }
        catch (MalformedURLException e) {
            throw new BugException("Cannot parse the Health-Check URL <" + theStatusPageUrl + ">, please use the according setter to ensure correct URL format: " + e.getMessage(), (Throwable)e);
        }
    }

    default public void setStatusUrl(Url aUrl) {
        this.put("/statusPageUrl", aUrl.toHttpUrl());
    }

    default public Url getHomeUrl() {
        String theHomePageUrl = (String)this.get("/homePageUrl");
        if (theHomePageUrl == null) {
            return null;
        }
        try {
            return new UrlImpl(theHomePageUrl);
        }
        catch (MalformedURLException e) {
            throw new BugException("Cannot parse the Health-Check URL <" + theHomePageUrl + ">, please use the according setter to ensure correct URL format: " + e.getMessage(), (Throwable)e);
        }
    }

    default public void setHomeUrl(Url aUrl) {
        this.put("/homePageUrl", aUrl.toHttpUrl());
    }

    default public String getHost() {
        return (String)this.get("/hostName");
    }

    default public void setHost(String aHost) {
        this.put("/hostName", aHost);
    }

    default public int[] getIpAddress() {
        return IpAddress.fromAnyCidrNotation((String)((String)this.get("/ipAddr")));
    }

    default public void setIpAddress(int[] aIpAddress) {
        this.put("/ipAddr", IpAddress.toString((int[])aIpAddress));
    }

    default public String isCoordinatingDiscoveryServer() {
        return (String)this.get("/isCoordinatingDiscoveryServer");
    }

    default public void setCoordinatingDiscoveryServer(String aValue) {
        this.put("/isCoordinatingDiscoveryServer", aValue);
    }

    default public Long getLastDirtyTimestamp() {
        return this.getLong("/lastDirtyTimestamp");
    }

    default public void setLastDirtyTimestamp(Long aValue) {
        this.putLong("/lastDirtyTimestamp", aValue);
    }

    default public Long getLastUpdatedTimestamp() {
        return this.getLong("/lastUpdatedTimestamp");
    }

    default public void setLastUpdatedTimestamp(Long aValue) {
        this.putLong("/lastUpdatedTimestamp", aValue);
    }

    default public Integer getLeaseInfoDurationInSecs() {
        return this.getInteger("/leaseInfo/durationInSecs");
    }

    default public void setLeaseInfoDurationInSecs(Integer aValue) {
        this.putInteger("/leaseInfo/durationInSecs", aValue);
    }

    default public Long getLeaseInfoEvictionTimestamp() {
        return this.getLong("/leaseInfo/evictionTimestamp");
    }

    default public void setLeaseInfoEvictionTimestamp(Long aValue) {
        this.putLong("/leaseInfo/evictionTimestamp", aValue);
    }

    default public Long getLeaseInfoLastRenewalTimestamp() {
        return this.getLong("/leaseInfo/lastRenewalTimestamp");
    }

    default public void setLeaseInfoLastRenewalTimestamp(Long aValue) {
        this.putLong("/leaseInfo/lastRenewalTimestamp", aValue);
    }

    default public Long getLeaseInfoRegistrationTimestamp() {
        return this.getLong("/leaseInfo/registrationTimestamp");
    }

    default public void setLeaseInfoRegistrationTimestamp(Long aValue) {
        this.putLong("/leaseInfo/registrationTimestamp", aValue);
    }

    default public Integer getLeaseInfoRenewalIntervalInSecs() {
        return this.getInteger("/leaseInfo/renewalIntervalInSecs");
    }

    default public void setLeaseInfoRenewalIntervalInSecs(Integer aValue) {
        this.putInteger("/leaseInfo/renewalIntervalInSecs", aValue);
    }

    default public Long getLeaseInfoServiceUpTimestamp() {
        return this.getLong("/leaseInfo/serviceUpTimestamp");
    }

    default public void setLeaseInfoServiceUpTimestamp(Long aValue) {
        this.putLong("/leaseInfo/serviceUpTimestamp", aValue);
    }

    default public String getMetadataClass() {
        return (String)this.get("/metadata/@class");
    }

    default public void setMetadataClass(String aValue) {
        this.put("/metadata/@class", aValue);
    }

    default public String getOverriddenstatus() {
        return (String)this.get("/overriddenstatus");
    }

    default public void setOverriddenstatus(String aValue) {
        this.put("/overriddenstatus", aValue);
    }

    default public int getPort() {
        Integer thePort = this.getInteger("/port/$");
        return thePort != null ? thePort : -1;
    }

    default public void setPort(int aPort) {
        this.putInteger("/port/$", aPort);
    }

    default public String getPortEnabled() {
        return (String)this.get("/port/@enabled");
    }

    default public void setPortEnabled(String aValue) {
        this.put("/port/@enabled", aValue);
    }

    default public Integer getSecurePort() {
        return this.getInteger("/securePort/$");
    }

    default public void setSecurePort(Integer aValue) {
        this.putInteger("/securePort/$", aValue);
    }

    default public String getSecurePortEnabled() {
        return (String)this.get("/securePort/@enabled");
    }

    default public void setSecurePortEnabled(String aValue) {
        this.put("/securePort/@enabled", aValue);
    }

    default public String getStatus() {
        return (String)this.get("/status");
    }

    default public void setStatus(String aValue) {
        this.put("/status", aValue);
    }

    default public String getVipAddress() {
        return (String)this.get("/vipAddress");
    }

    default public void setVipAddress(String aValue) {
        this.put("/vipAddress", aValue);
    }

    default public Map<String, String> getMetaData() {
        return this.childrenOf("/metadata");
    }

    default public void setMetaData(Map<String, String> aMetaData) {
        for (String eKey : aMetaData.keySet()) {
            this.put(this.toPath(new String[]{"/metadata", eKey}), aMetaData.get(eKey));
        }
    }

    default public String putMetaData(String aKey, String aValue) {
        return (String)this.put(this.toPath(new String[]{"/metadata", aKey}), aValue);
    }
}

