/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest.ext.eureka;

import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.util.EC2MetadataUtils;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import org.refcodes.component.InitializeException;
import org.refcodes.component.LifeCycleStatus;
import org.refcodes.component.OpenException;
import org.refcodes.component.PauseException;
import org.refcodes.component.ResumeException;
import org.refcodes.component.StartException;
import org.refcodes.component.StopException;
import org.refcodes.data.Scheme;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.mixin.InstanceIdAccessor;
import org.refcodes.mixin.PortAccessor;
import org.refcodes.net.HttpMediaType;
import org.refcodes.net.HttpResponseException;
import org.refcodes.net.HttpStatusException;
import org.refcodes.net.IpAddress;
import org.refcodes.net.MediaType;
import org.refcodes.net.RequestHeaderFields;
import org.refcodes.net.SchemeAccessor;
import org.refcodes.net.Url;
import org.refcodes.net.UrlBuilderImpl;
import org.refcodes.net.UrlImpl;
import org.refcodes.rest.AbstractHttpRegistrySidecar;
import org.refcodes.rest.HomePathAccessor;
import org.refcodes.rest.HttpRegistryUrlAccessor;
import org.refcodes.rest.HttpRestClient;
import org.refcodes.rest.HttpRestClientImpl;
import org.refcodes.rest.HttpServerDescriptor;
import org.refcodes.rest.HttpServerDescriptorAccessor;
import org.refcodes.rest.RestRequestBuilder;
import org.refcodes.rest.RestResponse;
import org.refcodes.rest.StatusPathAccessor;
import org.refcodes.rest.ext.eureka.AmazonMetaData;
import org.refcodes.rest.ext.eureka.AmazonMetaDataImpl;
import org.refcodes.rest.ext.eureka.EurekaDataCenterType;
import org.refcodes.rest.ext.eureka.EurekaDataCenterTypeAccessor;
import org.refcodes.rest.ext.eureka.EurekaLoopSleepTime;
import org.refcodes.rest.ext.eureka.EurekaRegistry;
import org.refcodes.rest.ext.eureka.EurekaRegistrySidecar;
import org.refcodes.rest.ext.eureka.EurekaServerDescriptor;
import org.refcodes.rest.ext.eureka.EurekaServerDescriptorImpl;
import org.refcodes.rest.ext.eureka.EurekaServiceStatus;
import org.refcodes.runtime.SystemUtility;
import org.refcodes.security.TrustStoreDescriptor;
import org.refcodes.security.TrustStoreDescriptorAccessor;

public class EurekaRegistrySidecarImpl
extends AbstractHttpRegistrySidecar<EurekaServerDescriptor, EurekaRegistrySidecar>
implements EurekaRegistrySidecar {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private static final String DEFAULT_PING_PATH = "/ping";
    private static final String DEFAULT_HOME_PATH = "/home";
    private static final String DEFAULT_STATUS_PATH = "/status";
    private ExecutorService _executorService;
    private Timer _scheduler;
    private EurekaDataCenterType _dataCenterType;
    private String _statusPath;
    private String _homePath;
    private int _port = -1;
    private Scheme _scheme = null;
    private String _protocol = null;

    public EurekaRegistrySidecarImpl(ExecutorService aExecutorService) {
        this._executorService = aExecutorService;
    }

    public synchronized void initialize(EurekaServerDescriptor aServerDescriptor, Url aRegistryUrl, TrustStoreDescriptor aStoreDescriptor) throws InitializeException {
        super.initialize();
        aRegistryUrl = EurekaRegistrySidecarImpl.toHttpRegistryUrl(aRegistryUrl, (HttpRegistryUrlAccessor.HttpRegistryUrlProperty)this);
        aStoreDescriptor = EurekaRegistrySidecarImpl.toTrustStoreDescriptor((TrustStoreDescriptor)aStoreDescriptor, (TrustStoreDescriptorAccessor.TrustStoreDescriptorProperty)this);
        aServerDescriptor = (EurekaServerDescriptor)EurekaRegistrySidecarImpl.toHttpServerDescriptor((HttpServerDescriptor)aServerDescriptor, (HttpServerDescriptorAccessor.HttpServerDescriptorProperty)this);
        try {
            this.doRegister(EurekaServiceStatus.STARTING);
        }
        catch (Exception e) {
            this._lifeCycleAutomaton.setLifeCycleStatus(LifeCycleStatus.ERROR);
            throw new InitializeException(ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
        }
    }

    public synchronized void start() throws StartException {
        try {
            super.start();
            this.doStatusUpdate(EurekaServiceStatus.UP);
            this._scheduler = new Timer(true);
            this._scheduler.schedule((TimerTask)new HeartBeatDaemon(this, this._executorService), EurekaLoopSleepTime.REGISTRY_SERVICE_HEARBEAT.getMilliseconds(), (long)EurekaLoopSleepTime.REGISTRY_SERVICE_HEARBEAT.getMilliseconds());
        }
        catch (Exception e) {
            this._lifeCycleAutomaton.setLifeCycleStatus(LifeCycleStatus.ERROR);
            throw new StartException(ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
        }
    }

    public synchronized void pause() throws PauseException {
        super.pause();
        try {
            this.doStatusUpdate(EurekaServiceStatus.DOWN);
        }
        catch (Exception e) {
            this._lifeCycleAutomaton.setLifeCycleStatus(LifeCycleStatus.ERROR);
            throw new PauseException(ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
        }
    }

    public synchronized void resume() throws ResumeException {
        super.resume();
        try {
            this.doStatusUpdate(EurekaServiceStatus.UP);
        }
        catch (Exception e) {
            this._lifeCycleAutomaton.setLifeCycleStatus(LifeCycleStatus.ERROR);
            throw new ResumeException(ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
        }
    }

    public synchronized void stop() throws StopException {
        super.stop();
        try {
            this._scheduler.cancel();
            this.doStatusUpdate(EurekaServiceStatus.OUT_OF_SERVICE);
        }
        catch (Exception e) {
            this._lifeCycleAutomaton.setLifeCycleStatus(LifeCycleStatus.ERROR);
            throw new StopException(ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
        }
    }

    public synchronized void destroy() {
        super.destroy();
        try {
            this._scheduler.cancel();
            this.doDeregister();
        }
        catch (Exception e) {
            LOGGER.warn(ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
            this._lifeCycleAutomaton.setLifeCycleStatus(LifeCycleStatus.ERROR);
        }
    }

    public void setPort(int aPort) {
        this._port = aPort;
    }

    public int getPort() {
        return this._port;
    }

    public String toProtocol() {
        if (this._scheme != null) {
            return this._scheme.toProtocol();
        }
        return this._protocol;
    }

    public void setProtocol(String aProtocol) {
        Scheme theScheme = Scheme.fromProtocol((String)aProtocol);
        if (theScheme != null) {
            this._scheme = theScheme;
            this._protocol = null;
        } else {
            this._protocol = aProtocol;
            this._scheme = null;
        }
    }

    public void setScheme(Scheme aScheme) {
        this._scheme = aScheme;
        this._protocol = null;
    }

    public Scheme getScheme() {
        return this._scheme;
    }

    public String getHomePath() {
        return this._homePath;
    }

    public void setHomePath(String aHomePath) {
        this._homePath = aHomePath;
    }

    public String getStatusPath() {
        return this._statusPath;
    }

    public void setStatusPath(String aStatusPath) {
        this._statusPath = aStatusPath;
    }

    @Override
    public EurekaDataCenterType getEurekaDataCenterType() {
        return this._dataCenterType;
    }

    @Override
    public void setEurekaDataCenterType(EurekaDataCenterType aDataCenterType) {
        this._dataCenterType = aDataCenterType;
    }

    @Override
    public EurekaServerDescriptor toHttpServerDescriptor(String aAlias, String aInstanceId, Scheme aScheme, String aHost, String aVirtualHost, int[] aIpAddress, int aPort, String aPingPath, String aStatusPath, String aHomePath, EurekaDataCenterType aDataCenterType) {
        return EurekaRegistrySidecarImpl.toHttpServerDescriptor(aAlias, aInstanceId, aScheme, aHost, aVirtualHost, aIpAddress, aPort, aPingPath, aStatusPath, aHomePath, aDataCenterType, this);
    }

    static EurekaServerDescriptor toHttpServerDescriptor(String aAlias, String aInstanceId, Scheme aScheme, String aHost, String aVirtualHost, int[] aIpAddress, int aPort, String aPingPath, String aStatusPath, String aHomePath, EurekaDataCenterType aDataCenterType, EurekaRegistry<?> aRegistryService) {
        try {
            aHost = EurekaRegistrySidecarImpl.toHost((String)aHost, aRegistryService);
        }
        catch (UnknownHostException e) {
            LOGGER.warn("Unable to determine host as of <" + e.getClass().getName() + ">: " + ExceptionUtility.toMessage((Throwable)e));
        }
        try {
            aIpAddress = EurekaRegistrySidecarImpl.toIpAddress((int[])aIpAddress, aRegistryService);
        }
        catch (IOException e) {
            LOGGER.warn("Unable to determine host as of <" + e.getClass().getName() + ">: " + ExceptionUtility.toMessage((Throwable)e));
        }
        aPort = EurekaRegistrySidecarImpl.toPort((int)aPort, (PortAccessor.PortProperty)((PortAccessor.PortProperty)aRegistryService));
        aScheme = EurekaRegistrySidecarImpl.toScheme((Scheme)aScheme, (SchemeAccessor.SchemeProperty)((SchemeAccessor.SchemeProperty)aRegistryService));
        aAlias = EurekaRegistrySidecarImpl.toAlias((String)aAlias, aRegistryService);
        aVirtualHost = EurekaRegistrySidecarImpl.toVirtualHost((String)aVirtualHost, aRegistryService);
        aDataCenterType = EurekaRegistrySidecarImpl.toDataCenterType(aDataCenterType, aRegistryService);
        aInstanceId = EurekaRegistrySidecarImpl.toInstanceId(aInstanceId, aHost, aRegistryService);
        EurekaServerDescriptorImpl theServerDescriptor = new EurekaServerDescriptorImpl();
        aPingPath = EurekaRegistrySidecarImpl.toPingPath((String)aPingPath, (String)DEFAULT_PING_PATH, aRegistryService);
        UrlImpl thePingUrl = new UrlImpl(aScheme, aHost, ((PortAccessor.PortProperty)aRegistryService).getPort(), aPingPath);
        theServerDescriptor.setPingUrl((Url)thePingUrl);
        aHomePath = EurekaRegistrySidecarImpl.toHomePath(aHomePath, DEFAULT_HOME_PATH, aRegistryService);
        UrlImpl theHomeUrl = new UrlImpl(aScheme, aHost, ((PortAccessor.PortProperty)aRegistryService).getPort(), aHomePath);
        theServerDescriptor.setHomeUrl((Url)theHomeUrl);
        aStatusPath = EurekaRegistrySidecarImpl.toStatusPath(aStatusPath, DEFAULT_STATUS_PATH, aRegistryService);
        UrlImpl theStatusUrl = new UrlImpl(aScheme, aHost, ((PortAccessor.PortProperty)aRegistryService).getPort(), aStatusPath);
        theServerDescriptor.setStatusUrl((Url)theStatusUrl);
        theServerDescriptor.setHost(aInstanceId);
        theServerDescriptor.setAlias(aAlias);
        theServerDescriptor.setPort(aPort);
        theServerDescriptor.setIpAddress(aIpAddress);
        theServerDescriptor.setLeaseEvictionDurationInSecs(30);
        theServerDescriptor.setVirtualHost(aVirtualHost);
        AmazonMetaData theMetaData = EurekaRegistrySidecarImpl.toAmazonMetaData();
        if (theMetaData != null) {
            theServerDescriptor.setAmazonMetaData(theMetaData);
        }
        if (aDataCenterType == null) {
            aDataCenterType = theMetaData != null ? EurekaDataCenterType.AMAZON : EurekaDataCenterType.MY_OWN;
        }
        theServerDescriptor.setEurekaDataCenterType(aDataCenterType);
        theServerDescriptor.putMetaData("host", aHost);
        theServerDescriptor.putMetaData("uname", SystemUtility.getUname());
        theServerDescriptor.putMetaData("ipAddress", IpAddress.toString((int[])aIpAddress));
        return theServerDescriptor;
    }

    protected static String toHomePath(String aHomePath, String aDefaultHomePath, HomePathAccessor.HomePathProperty aProperty) {
        if (aHomePath != null) {
            aProperty.setHomePath(aHomePath);
        } else {
            aHomePath = aProperty.getHomePath();
            if (aHomePath == null) {
                aHomePath = aDefaultHomePath;
                aProperty.setHomePath(aHomePath);
            }
        }
        return aHomePath;
    }

    protected static String toStatusPath(String aStatusPath, String aDefaultStatusPath, StatusPathAccessor.StatusPathProperty aProperty) {
        if (aStatusPath != null) {
            aProperty.setStatusPath(aStatusPath);
        } else {
            aStatusPath = aProperty.getStatusPath();
            if (aStatusPath == null) {
                aStatusPath = aDefaultStatusPath;
                aProperty.setStatusPath(aStatusPath);
            }
        }
        return aStatusPath;
    }

    protected static String toInstanceId(String aInstanceId, String aHost, InstanceIdAccessor.InstanceIdProperty aProperty) {
        if (aInstanceId != null) {
            aProperty.setInstanceId(aInstanceId);
        } else {
            aInstanceId = aProperty.getInstanceId();
            if (aInstanceId == null) {
                try {
                    String theInstanceId = EC2MetadataUtils.getInstanceId();
                    if (theInstanceId != null && theInstanceId.length() != 0) {
                        aInstanceId = theInstanceId;
                        aProperty.setInstanceId(aInstanceId);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (aInstanceId == null) {
                    aInstanceId = aHost;
                    aProperty.setInstanceId(aInstanceId);
                }
            }
        }
        return aInstanceId;
    }

    protected void doRegister(EurekaServiceStatus aServiceStatus) throws HttpStatusException, OpenException {
        EurekaRegistrySidecarImpl.doRegister(aServiceStatus, this, this._executorService);
    }

    protected static void doRegister(EurekaServiceStatus aServiceStatus, EurekaRegistry<?> aRegistryService, ExecutorService aExecutorService) throws HttpStatusException, OpenException {
        UrlImpl theRegistryUrl = new UrlImpl(aRegistryService.getHttpRegistryUrl(), new String[]{((EurekaServerDescriptor)aRegistryService.getHttpServerDescriptor()).getAlias()});
        HttpRestClientImpl theRestClient = new HttpRestClientImpl(aExecutorService);
        theRestClient.open(aRegistryService.getTrustStoreDescriptor());
        RestRequestBuilder theBuilder = theRestClient.buildPost((Url)theRegistryUrl);
        ((EurekaServerDescriptor)aRegistryService.getHttpServerDescriptor()).put("instance/status", aServiceStatus != null ? aServiceStatus.name() : EurekaServiceStatus.UNKNOWN.name());
        theBuilder.setRequest((Object)((EurekaServerDescriptor)aRegistryService.getHttpServerDescriptor()));
        ((RequestHeaderFields)theBuilder.getHeaderFields()).putContentType((HttpMediaType)MediaType.APPLICATION_XML);
        LOGGER.info("Registering status <" + aServiceStatus + "> at <" + aRegistryService.getHttpRegistryUrl().toHttpUrl() + "> Eureka service registry for app-ID <" + ((EurekaServerDescriptor)aRegistryService.getHttpServerDescriptor()).getAlias() + "> with instance-ID <" + ((EurekaServerDescriptor)aRegistryService.getHttpServerDescriptor()).getHost() + "> ...");
        RestResponse theResponse = theBuilder.toRestResponse();
        if (theResponse.getHttpStatusCode().isErrorStatus()) {
            throw theResponse.getHttpStatusCode().toHttpStatusException("Cannot register service with alias <" + ((EurekaServerDescriptor)aRegistryService.getHttpServerDescriptor()).getAlias() + "> with service registry <" + aRegistryService.getHttpRegistryUrl().toHttpUrl() + "> due to HTTP-Status-Code " + theResponse.getHttpStatusCode() + " <" + theResponse.getHttpStatusCode().getStatusCode() + ">: " + theResponse.getHttpBody());
        }
    }

    protected void doStatusUpdate(EurekaServiceStatus aServiceStatus) throws OpenException, UnknownHostException, HttpStatusException {
        EurekaRegistrySidecarImpl.doStatusUpdate(aServiceStatus, this, this._executorService);
    }

    protected static void doStatusUpdate(EurekaServiceStatus aServiceStatus, EurekaRegistry<?> aRegistryService, ExecutorService aExecutorService) throws OpenException, UnknownHostException, HttpStatusException {
        UrlBuilderImpl theRegistryUrl = new UrlBuilderImpl(aRegistryService.getHttpRegistryUrl(), new String[]{aRegistryService.getAlias(), aRegistryService.getInstanceId(), "status"});
        theRegistryUrl.getQueryFields().put("value", aServiceStatus.name());
        HttpRestClientImpl theRestClient = new HttpRestClientImpl(aExecutorService);
        theRestClient.open(aRegistryService.getTrustStoreDescriptor());
        LOGGER.info("Status update <" + aServiceStatus + "> at <" + theRegistryUrl.toHttpUrl() + "> Eureka service registry for app-ID <" + aRegistryService.getAlias() + "> with instance-ID <" + aRegistryService.getInstanceId() + "> ...");
        RestResponse theResponse = theRestClient.doPut((Url)theRegistryUrl);
        if (theResponse.getHttpStatusCode().isErrorStatus()) {
            throw theResponse.getHttpStatusCode().toHttpStatusException("Cannot register service with alias <" + aRegistryService.getAlias() + "> with service registry <" + aRegistryService.getHttpRegistryUrl().toHttpUrl() + "> due to HTTP-Status-Code " + theResponse.getHttpStatusCode() + " <" + theResponse.getHttpStatusCode().getStatusCode() + ">: " + theResponse.getHttpBody());
        }
    }

    protected void doDeregister() throws OpenException, HttpStatusException {
        EurekaRegistrySidecarImpl.doDeregister(this, this._executorService);
    }

    protected static void doDeregister(EurekaRegistry<?> aRegistryService, ExecutorService aExecutorService) throws OpenException, HttpStatusException {
        UrlImpl theRegistryUrl = new UrlImpl(aRegistryService.getHttpRegistryUrl(), new String[]{aRegistryService.getAlias(), aRegistryService.getInstanceId()});
        HttpRestClientImpl theRestClient = new HttpRestClientImpl(aExecutorService);
        theRestClient.open(aRegistryService.getTrustStoreDescriptor());
        LOGGER.info("Derigstering at <" + aRegistryService.getHttpRegistryUrl().toHttpUrl() + "> Eureka service registry for app-ID <" + aRegistryService.getAlias() + "> with instance-ID <" + aRegistryService.getInstanceId() + "> ...");
        RestResponse theResponse = theRestClient.doDelete((Url)theRegistryUrl);
        if (theResponse.getHttpStatusCode().isErrorStatus()) {
            throw theResponse.getHttpStatusCode().toHttpStatusException("Cannot register service with alias <" + aRegistryService.getAlias() + "> with service registry <" + aRegistryService.getHttpRegistryUrl().toHttpUrl() + "> due to HTTP-Status-Code " + theResponse.getHttpStatusCode() + " <" + theResponse.getHttpStatusCode().getStatusCode() + ">: " + theResponse.getHttpBody());
        }
    }

    protected static Url toHttpRegistryUrl(Url aRegistryUrl, HttpRegistryUrlAccessor.HttpRegistryUrlProperty aProperty) {
        if ((aRegistryUrl = AbstractHttpRegistrySidecar.toHttpRegistryUrl((Url)aRegistryUrl, (HttpRegistryUrlAccessor.HttpRegistryUrlProperty)aProperty)) != null && aRegistryUrl.getPath() == null) {
            aRegistryUrl = new UrlImpl(aRegistryUrl, new String[]{"/eureka/apps"});
            aProperty.setHttpRegistryUrl(aRegistryUrl);
        }
        return aRegistryUrl;
    }

    protected static EurekaDataCenterType toDataCenterType(EurekaDataCenterType aDataCenterType, EurekaDataCenterTypeAccessor.EurekaDataCenterTypeProperty aProperty) {
        if (aDataCenterType != null) {
            aProperty.setEurekaDataCenterType(aDataCenterType);
        } else {
            aDataCenterType = aProperty.getEurekaDataCenterType();
        }
        return aDataCenterType;
    }

    protected static AmazonMetaData toAmazonMetaData() {
        AmazonMetaDataImpl theMetaData = null;
        try {
            Region theRegion = Regions.getCurrentRegion();
            if (theRegion != null) {
                theMetaData = new AmazonMetaDataImpl();
                theMetaData.setAmiId(EC2MetadataUtils.getAmiId());
                String theAmiLaunchIndex = EC2MetadataUtils.getAmiLaunchIndex();
                Integer theLaunchIndex = 0;
                if (theAmiLaunchIndex != null) {
                    theLaunchIndex = Integer.valueOf(theAmiLaunchIndex);
                    theMetaData.setAmiLaunchIndex(theLaunchIndex);
                }
                theMetaData.setAmiManifestPath(EC2MetadataUtils.getAmiManifestPath());
                theMetaData.setAvailabilityZone(EC2MetadataUtils.getAvailabilityZone());
                theMetaData.setInstanceId(EC2MetadataUtils.getInstanceId());
                theMetaData.setInstanceType(EC2MetadataUtils.getInstanceType());
                theMetaData.setLocalHostName(EC2MetadataUtils.getLocalHostName());
                List theInterfaces = EC2MetadataUtils.getNetworkInterfaces();
                if (theInterfaces != null) {
                    List eLocalIPv4s = null;
                    List ePublicIPv4s = null;
                    String ePublicHostName = null;
                    for (EC2MetadataUtils.NetworkInterface eInterface : theInterfaces) {
                        if ((eLocalIPv4s == null || eLocalIPv4s.size() == 0) && (eLocalIPv4s = eInterface.getLocalIPv4s()) != null && eLocalIPv4s.size() != 0) {
                            theMetaData.setLocalIpv4((String)eLocalIPv4s.get(0));
                        }
                        if ((ePublicHostName == null || ePublicHostName.length() == 0) && (ePublicHostName = eInterface.getPublicHostname()) != null && ePublicHostName.length() != 0) {
                            theMetaData.setPublicHostname(ePublicHostName);
                        }
                        if (ePublicIPv4s != null && ePublicIPv4s.size() != 0 || (ePublicIPv4s = eInterface.getPublicIPv4s()) == null || ePublicIPv4s.size() == 0) continue;
                        theMetaData.setPublicIpv4((String)ePublicIPv4s.get(0));
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return theMetaData;
    }

    public static class HeartBeatDaemon
    extends TimerTask {
        private HttpRestClient _client;
        private EurekaRegistry<?> _registry;

        public HeartBeatDaemon(EurekaRegistry<?> aRegistry, ExecutorService aExecutorService) {
            this._client = new HttpRestClientImpl(aExecutorService).withTrustStoreDescriptor(aRegistry.getTrustStoreDescriptor());
            this._registry = aRegistry;
        }

        @Override
        public void run() {
            if (this._registry.isRunning()) {
                UrlImpl theUrl = new UrlImpl(this._registry.getHttpRegistryUrl(), new String[]{this._registry.getAlias(), this._registry.getInstanceId()});
                LOGGER.debug("Sending heartbeat to <" + theUrl.toHttpUrl() + ">...");
                try {
                    RestResponse theResponse = this._client.doPut((Url)theUrl);
                    if (theResponse.getHttpStatusCode().isErrorStatus()) {
                        LOGGER.warn("Received HTTP status code <" + theResponse.getHttpStatusCode().getStatusCode() + "> (" + theResponse.getHttpStatusCode() + ") send heartbeat to URL <" + theUrl.toHttpUrl() + ">: " + theResponse.getHttpBody());
                    }
                }
                catch (HttpResponseException e) {
                    LOGGER.warn("Unable to send heartbeat to URL <" + theUrl.toHttpUrl() + ">: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

