/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest.ext.eureka;

import java.util.concurrent.ExecutorService;
import org.refcodes.component.CloseException;
import org.refcodes.component.InitializeException;
import org.refcodes.component.LifeCycleStatus;
import org.refcodes.component.PauseException;
import org.refcodes.component.ResumeException;
import org.refcodes.component.StartException;
import org.refcodes.component.StopException;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.net.LoadBalancingStrategy;
import org.refcodes.net.Url;
import org.refcodes.rest.AbstractHttpDiscoveryRestClientDecorator;
import org.refcodes.rest.HttpRestClient;
import org.refcodes.rest.ext.eureka.EurekaDiscoverySidecarImpl;
import org.refcodes.rest.ext.eureka.EurekaRestClient;
import org.refcodes.security.TrustStoreDescriptor;

public class EurekaRestClientDecorator
extends AbstractHttpDiscoveryRestClientDecorator<EurekaRestClient>
implements EurekaRestClient {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private ExecutorService _executorService;
    private EurekaDiscoverySidecarImpl.RefreshDaemon _refreshDaemon;

    public EurekaRestClientDecorator(HttpRestClient aClient) {
        super(aClient);
    }

    public EurekaRestClientDecorator(HttpRestClient aClient, ExecutorService aExecutorService) {
        super(aClient);
        this._executorService = aExecutorService;
    }

    public void initialize(Url aDiscoveryUrl, LoadBalancingStrategy aStrategy, TrustStoreDescriptor aStoreDescriptor) throws InitializeException {
        aDiscoveryUrl = this.toHttpDiscoveryUrl(aDiscoveryUrl);
        aStrategy = this.toLoadBalancerStrategy(aStrategy);
        super.initialize();
        this.setLoadBalancingStrategy(aStrategy);
        try {
            this._refreshDaemon = new EurekaDiscoverySidecarImpl.RefreshDaemon(aDiscoveryUrl, aStoreDescriptor, this, this._executorService);
        }
        catch (Exception e) {
            this._lifeCycleAutomaton.setLifeCycleStatus(LifeCycleStatus.ERROR);
            throw new InitializeException(ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
        }
    }

    public synchronized void start() throws StartException {
        try {
            if (!this.isConnectionOpened()) {
                LOGGER.warn("This connection not opened yet (it is in status <" + this.getConnectionStatus() + ">, therefore will try to open this connection now...");
                this.open();
            }
            super.start();
            this._refreshDaemon.start();
        }
        catch (Exception e) {
            this._lifeCycleAutomaton.setLifeCycleStatus(LifeCycleStatus.ERROR);
            throw new StartException(ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
        }
    }

    public synchronized void pause() throws PauseException {
        super.pause();
    }

    public synchronized void stop() throws StopException {
        super.stop();
        try {
            this._refreshDaemon.start();
        }
        catch (Exception e) {
            this._lifeCycleAutomaton.setLifeCycleStatus(LifeCycleStatus.ERROR);
            throw new StopException(ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
        }
    }

    public synchronized void resume() throws ResumeException {
        super.resume();
    }

    public synchronized void destroy() {
        super.destroy();
        try {
            this._refreshDaemon.destroy();
        }
        catch (Exception e) {
            LOGGER.warn(ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
            this._lifeCycleAutomaton.setLifeCycleStatus(LifeCycleStatus.ERROR);
        }
        finally {
            try {
                this.close();
            }
            catch (CloseException e) {
                LOGGER.warn(ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
                this._lifeCycleAutomaton.setLifeCycleStatus(LifeCycleStatus.ERROR);
            }
        }
    }

    public Url toUrl(Url aUrl) {
        return EurekaDiscoverySidecarImpl.toUrl(aUrl, this, this._refreshDaemon);
    }
}

