/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest.ext.eureka;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.refcodes.component.InitializeException;
import org.refcodes.component.LifecycleStatus;
import org.refcodes.component.PauseException;
import org.refcodes.component.ResumeException;
import org.refcodes.component.StartException;
import org.refcodes.component.StopException;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.rest.AbstractHttpDiscoveryRestClientDecorator;
import org.refcodes.rest.HttpRestClient;
import org.refcodes.rest.ext.eureka.EurekaDiscoverySidecar;
import org.refcodes.rest.ext.eureka.EurekaRestClient;
import org.refcodes.security.TrustStoreDescriptor;
import org.refcodes.web.BasicAuthCredentials;
import org.refcodes.web.LoadBalancingStrategy;
import org.refcodes.web.OauthToken;
import org.refcodes.web.Url;

public class EurekaRestClientDecorator
extends AbstractHttpDiscoveryRestClientDecorator<EurekaRestClient>
implements EurekaRestClient {
    private static Logger LOGGER = Logger.getLogger(EurekaRestClientDecorator.class.getName());
    private ExecutorService _executorService;
    private EurekaDiscoverySidecar.RefreshDaemon _refreshDaemon;

    public EurekaRestClientDecorator(HttpRestClient aClient) {
        super(aClient);
    }

    public EurekaRestClientDecorator(HttpRestClient aClient, ExecutorService aExecutorService) {
        super(aClient);
        this._executorService = aExecutorService;
    }

    public void initialize(Url aDiscoveryUrl, LoadBalancingStrategy aStrategy, TrustStoreDescriptor aStoreDescriptor) throws InitializeException {
        aDiscoveryUrl = this.toHttpDiscoveryUrl(aDiscoveryUrl);
        aStrategy = this.toLoadBalancerStrategy(aStrategy);
        super.initialize();
        this.setLoadBalancingStrategy(aStrategy);
        try {
            this._refreshDaemon = new EurekaDiscoverySidecar.RefreshDaemon(aDiscoveryUrl, aStoreDescriptor, this, this._executorService);
        }
        catch (Exception e) {
            this._lifeCycleAutomaton.setLifecycleStatus(LifecycleStatus.ERROR);
            throw new InitializeException(ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
        }
    }

    public synchronized void start() throws StartException {
        try {
            if (!this.isOpened()) {
                LOGGER.log(Level.WARNING, "This connection not opened yet (it is in status <" + this.getConnectionStatus() + ">, therefore will try to open this connection now...");
                this.open();
            }
            super.start();
            this._refreshDaemon.start();
        }
        catch (Exception e) {
            this._lifeCycleAutomaton.setLifecycleStatus(LifecycleStatus.ERROR);
            throw new StartException(ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
        }
    }

    public synchronized void pause() throws PauseException {
        super.pause();
    }

    public synchronized void stop() throws StopException {
        super.stop();
        try {
            this._refreshDaemon.start();
        }
        catch (Exception e) {
            this._lifeCycleAutomaton.setLifecycleStatus(LifecycleStatus.ERROR);
            throw new StopException(ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
        }
    }

    public synchronized void resume() throws ResumeException {
        super.resume();
    }

    public synchronized void destroy() {
        super.destroy();
        try {
            this._refreshDaemon.destroy();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, ExceptionUtility.toMessage((Throwable)e), e);
            this._lifeCycleAutomaton.setLifecycleStatus(LifecycleStatus.ERROR);
        }
        finally {
            try {
                this.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, ExceptionUtility.toMessage((Throwable)e), e);
                this._lifeCycleAutomaton.setLifecycleStatus(LifecycleStatus.ERROR);
            }
        }
    }

    public EurekaRestClient withOAuthToken(OauthToken aOauthToken) {
        this.setOauthToken(aOauthToken);
        return this;
    }

    public Url toUrl(Url aUrl) {
        return EurekaDiscoverySidecar.toUrl(aUrl, this, this._refreshDaemon);
    }

    public BasicAuthCredentials getBasicAuthCredentials() {
        return this._client.getBasicAuthCredentials();
    }

    public void setBasicAuthCredentials(BasicAuthCredentials aBasicAuthCredentials) {
        this._client.setBasicAuthCredentials(aBasicAuthCredentials);
    }

    public EurekaRestClientDecorator withBasicAuthCredentials(BasicAuthCredentials aBasicAuthCredentials) {
        this._client.setBasicAuthCredentials(aBasicAuthCredentials);
        return this;
    }

    public EurekaRestClientDecorator withBasicAuthCredentials(String aUserName, String aSecret) {
        this._client.setBasicAuthCredentials(aUserName, aSecret);
        return this;
    }
}

