/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest.ext.eureka;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.component.InitializeException;
import org.refcodes.component.LifecycleStatus;
import org.refcodes.component.PauseException;
import org.refcodes.component.ResumeException;
import org.refcodes.component.StartException;
import org.refcodes.component.StopException;
import org.refcodes.data.Scheme;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.rest.AbstractHttpRegistryRestServerDecorator;
import org.refcodes.rest.HttpExceptionHandler;
import org.refcodes.rest.HttpExceptionHandling;
import org.refcodes.rest.HttpRestServer;
import org.refcodes.rest.RestRequestConsumer;
import org.refcodes.rest.ext.eureka.EurekaDataCenterType;
import org.refcodes.rest.ext.eureka.EurekaLoopSleepTime;
import org.refcodes.rest.ext.eureka.EurekaRegistrySidecar;
import org.refcodes.rest.ext.eureka.EurekaRestServer;
import org.refcodes.rest.ext.eureka.EurekaServerDescriptor;
import org.refcodes.rest.ext.eureka.EurekaServiceStatus;
import org.refcodes.security.TrustStoreDescriptor;
import org.refcodes.web.HttpMediaType;
import org.refcodes.web.HttpStatusException;
import org.refcodes.web.MediaType;
import org.refcodes.web.Url;

public class EurekaRestServerDecorator
extends AbstractHttpRegistryRestServerDecorator<EurekaServerDescriptor, EurekaRestServer>
implements EurekaRestServer {
    private static Logger LOGGER = Logger.getLogger(EurekaRestServerDecorator.class.getName());
    private ExecutorService _executorService;
    private Timer _scheduler;
    private EurekaDataCenterType _dataCenterType;
    private String _statusPath;
    private String _homePath;
    private RestRequestConsumer _homeRequestConsumer;
    private RestRequestConsumer _statusRequestConsumer;

    public EurekaRestServerDecorator(HttpRestServer aServer) {
        super(aServer);
    }

    public EurekaRestServerDecorator(HttpRestServer aServer, ExecutorService aExecutorService) {
        super(aServer);
        this._executorService = aExecutorService;
    }

    @Override
    public synchronized void initialize(EurekaServerDescriptor aServerDescriptor, RestRequestConsumer aPingObserver, RestRequestConsumer aStatusObserver, RestRequestConsumer aHomeObserver, Url aRegistryUrl, TrustStoreDescriptor aStoreDescriptor) throws InitializeException {
        super.initialize();
        aPingObserver = this.toPingObserver(aPingObserver);
        aHomeObserver = this.toHomeObserver(aHomeObserver);
        aStatusObserver = this.toStatusObserver(aStatusObserver);
        aRegistryUrl = this.toHttpRegistryUrl(aRegistryUrl);
        aStoreDescriptor = this.toTrustStoreDescriptor(aStoreDescriptor);
        aServerDescriptor = (EurekaServerDescriptor)this.toHttpServerDescriptor(aServerDescriptor);
        try {
            if (aPingObserver != null) {
                if (aServerDescriptor.getPingUrl() == null) {
                    throw new InitializeException("Cannot register a PING observer without a PING path being defined in the server descriptor!");
                }
                this.onGet(aServerDescriptor.getPingUrl().getPath(), aPingObserver);
            }
            if (aStatusObserver != null) {
                if (aServerDescriptor.getStatusUrl() == null) {
                    throw new InitializeException("Cannot register a STATUS observer without a STATUS path being defined in the server descriptor!");
                }
                this.onGet(aServerDescriptor.getStatusUrl().getPath(), aStatusObserver);
            }
            if (aHomeObserver != null) {
                if (aServerDescriptor.getHomeUrl() == null) {
                    throw new InitializeException("Cannot register a HOME observer without a HOME path being defined in the server descriptor!");
                }
                this.onGet(aServerDescriptor.getHomeUrl().getPath(), aHomeObserver);
            }
            this.disableObservers();
            this.doRegister(EurekaServiceStatus.STARTING);
        }
        catch (Exception e) {
            this._lifeCycleAutomaton.setLifecycleStatus(LifecycleStatus.ERROR);
            throw new InitializeException(ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
        }
    }

    public synchronized void start() throws StartException {
        try {
            if (!this.isOpened()) {
                LOGGER.log(Level.WARNING, "This connection not opened yet (it is in status <" + this.getConnectionStatus() + ">, therefore will try to open this connection now...");
                this.open();
            }
            super.start();
            this.enableObservers();
            this.doStatusUpdate(EurekaServiceStatus.UP);
            this._scheduler = new Timer(true);
            this._scheduler.schedule((TimerTask)new EurekaRegistrySidecar.HeartBeatDaemon(this, this._executorService), EurekaLoopSleepTime.REGISTRY_SERVICE_HEARBEAT.getTimeMillis(), (long)EurekaLoopSleepTime.REGISTRY_SERVICE_HEARBEAT.getTimeMillis());
        }
        catch (Exception e) {
            this._lifeCycleAutomaton.setLifecycleStatus(LifecycleStatus.ERROR);
            throw new StartException(ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
        }
    }

    public synchronized void pause() throws PauseException {
        super.pause();
        try {
            this.doStatusUpdate(EurekaServiceStatus.DOWN);
            this.disableObservers();
        }
        catch (Exception e) {
            this._lifeCycleAutomaton.setLifecycleStatus(LifecycleStatus.ERROR);
            throw new PauseException(ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
        }
    }

    public synchronized void resume() throws ResumeException {
        super.resume();
        try {
            this.enableObservers();
            this.doStatusUpdate(EurekaServiceStatus.UP);
        }
        catch (Exception e) {
            this._lifeCycleAutomaton.setLifecycleStatus(LifecycleStatus.ERROR);
            throw new ResumeException(ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
        }
    }

    public synchronized void stop() throws StopException {
        super.stop();
        try {
            this._scheduler.cancel();
            this.doStatusUpdate(EurekaServiceStatus.OUT_OF_SERVICE);
            this.disableObservers();
        }
        catch (Exception e) {
            this._lifeCycleAutomaton.setLifecycleStatus(LifecycleStatus.ERROR);
            throw new StopException(ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
        }
    }

    public synchronized void destroy() {
        super.destroy();
        try {
            this._scheduler.cancel();
            this.doDeregister();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, ExceptionUtility.toMessage((Throwable)e), e);
            this._lifeCycleAutomaton.setLifecycleStatus(LifecycleStatus.ERROR);
        }
        finally {
            try {
                this.disableObservers();
                this.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, ExceptionUtility.toMessage((Throwable)e), e);
                this._lifeCycleAutomaton.setLifecycleStatus(LifecycleStatus.ERROR);
            }
        }
    }

    public String getHomePath() {
        return this._homePath;
    }

    public void setHomePath(String aHomePath) {
        this._homePath = aHomePath;
    }

    public String getStatusPath() {
        return this._statusPath;
    }

    public void setStatusPath(String aStatusPath) {
        this._statusPath = aStatusPath;
    }

    public ConnectionStatus getConnectionStatus() {
        return this._server.getConnectionStatus();
    }

    public void setObserversActive(boolean isActive) {
        this._server.setObserversActive(isActive);
    }

    public boolean isObserversActive() {
        return this._server.isObserversActive();
    }

    public EurekaRestServer withHttpExceptionHandler(HttpExceptionHandler aHttpErrorHandler) {
        this._server.setHttpExceptionHandler(aHttpErrorHandler);
        return this;
    }

    public void setHttpExceptionHandler(HttpExceptionHandler aHttpErrorHandler) {
        this._server.setHttpExceptionHandler(aHttpErrorHandler);
    }

    public HttpExceptionHandler getHttpExceptionHandler() {
        return this._server.getHttpExceptionHandler();
    }

    public EurekaRestServer withHttpExceptionHandling(HttpExceptionHandling aHttpErrorHandling) {
        this._server.setHttpExceptionHandling(aHttpErrorHandling);
        return this;
    }

    public void setHttpExceptionHandling(HttpExceptionHandling aHttpErrorHandling) {
        this._server.setHttpExceptionHandling(aHttpErrorHandling);
    }

    public HttpExceptionHandling getHttpExceptionHandling() {
        return this._server.getHttpExceptionHandling();
    }

    @Override
    public EurekaDataCenterType getEurekaDataCenterType() {
        return this._dataCenterType;
    }

    @Override
    public void setEurekaDataCenterType(EurekaDataCenterType aDataCenterType) {
        this._dataCenterType = aDataCenterType;
    }

    public void setHomeRequestConsumer(RestRequestConsumer aRequestConsumer) {
        this._homeRequestConsumer = aRequestConsumer;
    }

    public RestRequestConsumer getHomeRequestConsumer() {
        return this._homeRequestConsumer;
    }

    public void setStatusRequestConsumer(RestRequestConsumer aRequestConsumer) {
        this._statusRequestConsumer = aRequestConsumer;
    }

    public RestRequestConsumer getStatusRequestConsumer() {
        return this._statusRequestConsumer;
    }

    @Override
    public EurekaServerDescriptor toHttpServerDescriptor(String aAlias, String aInstanceId, Scheme aScheme, String aHost, String aVirtualHost, int[] aIpAddress, int aPort, String aPingPath, String aStatusPath, String aHomePath, EurekaDataCenterType aDataCenterType) {
        return EurekaRegistrySidecar.toHttpServerDescriptor(aAlias, aInstanceId, aScheme, aHost, aVirtualHost, aIpAddress, aPort, aPingPath, aStatusPath, aHomePath, aDataCenterType, this);
    }

    protected void doRegister(EurekaServiceStatus aServiceStatus) throws HttpStatusException, IOException {
        EurekaRegistrySidecar.doRegister(aServiceStatus, this, this._executorService);
    }

    protected void doStatusUpdate(EurekaServiceStatus aServiceStatus) throws IOException, UnknownHostException, HttpStatusException {
        EurekaRegistrySidecar.doStatusUpdate(aServiceStatus, this, this._executorService);
    }

    protected void doDeregister() throws IOException, HttpStatusException {
        EurekaRegistrySidecar.doDeregister(this, this._executorService);
    }

    protected Url toHttpRegistryUrl(Url aRegistryUrl) {
        if ((aRegistryUrl = super.toHttpRegistryUrl(aRegistryUrl)) != null && aRegistryUrl.getPath() == null) {
            aRegistryUrl = new Url(aRegistryUrl, new String[]{"/eureka/apps"});
            this.setHttpRegistryUrl(aRegistryUrl);
        }
        return aRegistryUrl;
    }

    protected RestRequestConsumer toHomeObserver(RestRequestConsumer aHomeRequestObserver) {
        if (aHomeRequestObserver == null && (aHomeRequestObserver = this._homeRequestConsumer) == null) {
            this._homeRequestConsumer = aHomeRequestObserver = (aReq, aResp) -> {
                aResp.getHeaderFields().putContentType((HttpMediaType)MediaType.TEXT_PLAIN);
                aResp.setResponse((Object)"Pong!");
                LOGGER.info("Received a HOME request, no HOME handler defined, using default handler!");
            };
        }
        return aHomeRequestObserver;
    }

    protected RestRequestConsumer toStatusObserver(RestRequestConsumer aStatusRequestObserver) {
        if (aStatusRequestObserver == null && (aStatusRequestObserver = this._statusRequestConsumer) == null) {
            this._statusRequestConsumer = aStatusRequestObserver = (aReq, aResp) -> {
                aResp.getHeaderFields().putContentType((HttpMediaType)MediaType.TEXT_PLAIN);
                aResp.setResponse((Object)"Pong!");
                LOGGER.info("Received a STATUS request, no STATUS handler defined, using default handler!");
            };
        }
        return aStatusRequestObserver;
    }
}

