/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest.ext.eureka;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.refcodes.component.Destroyable;
import org.refcodes.component.InitializeException;
import org.refcodes.component.LifecycleStatus;
import org.refcodes.component.PauseException;
import org.refcodes.component.ResumeException;
import org.refcodes.component.StartException;
import org.refcodes.component.Startable;
import org.refcodes.component.StopException;
import org.refcodes.component.Stoppable;
import org.refcodes.exception.BugException;
import org.refcodes.exception.Trap;
import org.refcodes.rest.AbstractHttpDiscoverySidecar;
import org.refcodes.rest.HttpDiscoveryUrlAccessor;
import org.refcodes.rest.HttpRestClient;
import org.refcodes.rest.RestResponse;
import org.refcodes.rest.ext.eureka.EurekaDiscovery;
import org.refcodes.rest.ext.eureka.EurekaInstanceDescriptor;
import org.refcodes.rest.ext.eureka.EurekaLoopSleepTime;
import org.refcodes.rest.ext.eureka.EurekaServiceStatus;
import org.refcodes.security.TrustStoreDescriptor;
import org.refcodes.security.TrustStoreDescriptorAccessor;
import org.refcodes.web.HttpBodyMap;
import org.refcodes.web.HttpStatusException;
import org.refcodes.web.LoadBalancingStrategy;
import org.refcodes.web.LoadBalancingStrategyAccessor;
import org.refcodes.web.Url;
import org.refcodes.web.UrlBuilder;

public class EurekaDiscoverySidecar
extends AbstractHttpDiscoverySidecar<EurekaDiscoverySidecar>
implements EurekaDiscovery<EurekaDiscoverySidecar> {
    private static final Logger LOGGER = Logger.getLogger(EurekaDiscoverySidecar.class.getName());
    private ExecutorService _executorService;
    private RefreshDaemon _refreshDaemon;

    public EurekaDiscoverySidecar() {
        this(null);
    }

    public EurekaDiscoverySidecar(ExecutorService aExecutorService) {
        this._executorService = aExecutorService;
    }

    public void initialize(Url aDiscoveryUrl, LoadBalancingStrategy aStrategy, TrustStoreDescriptor aStoreDescriptor) throws InitializeException {
        aDiscoveryUrl = EurekaDiscoverySidecar.toHttpDiscoveryUrl(aDiscoveryUrl, (HttpDiscoveryUrlAccessor.HttpDiscoveryUrlProperty)this);
        aStrategy = EurekaDiscoverySidecar.toLoadBalancingStrategy((LoadBalancingStrategy)aStrategy, (LoadBalancingStrategyAccessor.LoadBalancingStrategyProperty)this);
        super.initialize();
        this.setLoadBalancingStrategy(aStrategy);
        try {
            this._refreshDaemon = new RefreshDaemon(aDiscoveryUrl, aStoreDescriptor, this, this._executorService);
        }
        catch (Exception e) {
            this._lifeCycleAutomaton.setLifecycleStatus(LifecycleStatus.ERROR);
            throw new InitializeException("Cannot enter the initialize lifecycle!", (Throwable)e);
        }
    }

    public synchronized void start() throws StartException {
        try {
            super.start();
            this._refreshDaemon.start();
        }
        catch (Exception e) {
            this._lifeCycleAutomaton.setLifecycleStatus(LifecycleStatus.ERROR);
            throw new StartException("Cannot enter the start lifecycle!", (Throwable)e);
        }
    }

    public synchronized void pause() throws PauseException {
        super.pause();
    }

    public synchronized void stop() throws StopException {
        super.stop();
        try {
            this._refreshDaemon.stop();
        }
        catch (Exception e) {
            this._lifeCycleAutomaton.setLifecycleStatus(LifecycleStatus.ERROR);
            throw new StopException("Cannot enter the stop lifecycle!", (Throwable)e);
        }
    }

    public synchronized void resume() throws ResumeException {
        super.resume();
    }

    public synchronized void destroy() {
        super.destroy();
        try {
            this._refreshDaemon.destroy();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, Trap.asMessage((Throwable)e), e);
            this._lifeCycleAutomaton.setLifecycleStatus(LifecycleStatus.ERROR);
        }
    }

    public Url toUrl(Url aUrl) {
        return EurekaDiscoverySidecar.toUrl(aUrl, this, this._refreshDaemon);
    }

    protected static Url toUrl(Url aUrl, EurekaDiscovery<?> aDiscovery, RefreshDaemon aRefreshDaemon) {
        EurekaInstanceDescriptor[] theArray;
        List<EurekaInstanceDescriptor> theInstances;
        String theHost = aUrl.getHost();
        if (theHost != null) {
            theHost = theHost.toUpperCase();
        }
        if ((theInstances = aRefreshDaemon.getInstance(theHost)) != null && (theArray = theInstances.toArray(new EurekaInstanceDescriptor[theInstances.size()])).length > 0) {
            switch (aDiscovery.getLoadBalancingStrategy()) {
                case CUSTOM: {
                    throw new IllegalStateException("The load balancing satrategy <" + LoadBalancingStrategy.CUSTOM + "> is cunnrently not supported.");
                }
                case NONE: {
                    break;
                }
                case RANDOM: {
                    int theRnd = ThreadLocalRandom.current().nextInt(0, theArray.length);
                    UrlBuilder theUrl = new UrlBuilder(aUrl);
                    int[] theIAddr = theArray[theRnd].getIpAddress();
                    if (theIAddr != null) {
                        theUrl.setIpAddress(theIAddr);
                    } else {
                        theUrl.setHost(theArray[theRnd].getHost());
                    }
                    theUrl.setPort(theArray[theRnd].getPort());
                    return theUrl;
                }
                case RANDOM_STICKY: {
                    throw new IllegalStateException("The load balancing satrategy <" + LoadBalancingStrategy.RANDOM_STICKY + "> is cunnrently not supported.");
                }
                case ROUND_ROBIN: {
                    throw new IllegalStateException("The load balancing satrategy <" + LoadBalancingStrategy.ROUND_ROBIN + "> is cunnrently not supported.");
                }
                default: {
                    throw new BugException("Missing case statement for <" + aDiscovery.getLoadBalancingStrategy() + "> in implementation!");
                }
            }
        }
        return aUrl;
    }

    protected static Url toHttpDiscoveryUrl(Url aDiscoveryUrl, HttpDiscoveryUrlAccessor.HttpDiscoveryUrlProperty aProperty) {
        if (aDiscoveryUrl != null) {
            aProperty.setHttpDiscoveryUrl(aDiscoveryUrl);
        } else {
            aDiscoveryUrl = aProperty.getHttpDiscoveryUrl();
        }
        if (aDiscoveryUrl != null && aDiscoveryUrl.getPath() == null) {
            aDiscoveryUrl = new Url(aDiscoveryUrl, new String[]{"/eureka/apps"});
            aProperty.setHttpDiscoveryUrl(aDiscoveryUrl);
        }
        return aDiscoveryUrl;
    }

    static class RefreshDaemon
    extends TimerTask
    implements Startable,
    Stoppable,
    Destroyable {
        private Map<String, List<EurekaInstanceDescriptor>> _instances;
        private EurekaDiscovery<?> _discovery;
        private ExecutorService _executorService;
        private Timer _scheduler;

        RefreshDaemon(Url aDiscoveryUrl, TrustStoreDescriptor aStoreDescriptor, EurekaDiscovery<?> aDiscovery, ExecutorService aExecutorService) throws HttpStatusException, IOException {
            this._executorService = aExecutorService;
            this._discovery = aDiscovery;
            this._instances = this.loadRegisteredServices(aDiscoveryUrl, aStoreDescriptor);
        }

        public Map<String, List<EurekaInstanceDescriptor>> getInstances() {
            return this._instances;
        }

        public List<EurekaInstanceDescriptor> getInstance(String aAlias) {
            return this._instances.get(aAlias);
        }

        public void start() {
            this._scheduler = new Timer(true);
            this._scheduler.schedule((TimerTask)this, EurekaLoopSleepTime.DISCOVERY_SERVICE_REFRESH.getTimeMillis(), (long)EurekaLoopSleepTime.DISCOVERY_SERVICE_REFRESH.getTimeMillis());
        }

        public void stop() {
            this._scheduler.cancel();
        }

        public void destroy() {
            this._scheduler.cancel();
            this._discovery = null;
            this._executorService = null;
            this._instances.clear();
            this._instances = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this._discovery.isRunning()) {
                LOGGER.info("Refreshing clients from <" + this._discovery.getHttpDiscoveryUrl().toHttpUrl() + "> ...");
                try {
                    Map<String, List<EurekaInstanceDescriptor>> theNewInstances = this.loadRegisteredServices(this._discovery.getHttpDiscoveryUrl(), ((TrustStoreDescriptorAccessor.TrustStoreDescriptorProperty)this._discovery).getTrustStoreDescriptor());
                    for (String eInstanceId : theNewInstances.keySet()) {
                        RefreshDaemon refreshDaemon = this;
                        synchronized (refreshDaemon) {
                            List<EurekaInstanceDescriptor> eInstances = this.toInstancesUpdate(theNewInstances.get(eInstanceId), this._instances.get(eInstanceId));
                            this._instances.put(eInstanceId, eInstances);
                        }
                    }
                }
                catch (IOException | HttpStatusException e) {
                    LOGGER.log(Level.WARNING, "Cannot refresh clients from discovery registry <" + this._discovery.getHttpDiscoveryUrl().toHttpUrl() + "> as of : " + Trap.asMessage((Throwable)e), e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, List<EurekaInstanceDescriptor>> loadRegisteredServices(Url aDiscoveryUrl, TrustStoreDescriptor aStoreDescriptor) throws IOException, HttpStatusException {
            HashMap<String, List<EurekaInstanceDescriptor>> theInstances = new HashMap<String, List<EurekaInstanceDescriptor>>();
            aDiscoveryUrl = EurekaDiscoverySidecar.toHttpDiscoveryUrl(aDiscoveryUrl, this._discovery);
            aStoreDescriptor = EurekaDiscoverySidecar.toTrustStoreDescriptor((TrustStoreDescriptor)aStoreDescriptor, (TrustStoreDescriptorAccessor.TrustStoreDescriptorProperty)((TrustStoreDescriptorAccessor.TrustStoreDescriptorProperty)this._discovery));
            HttpRestClient theClient = new HttpRestClient(this._executorService);
            theClient.open(aStoreDescriptor);
            theClient.setBaseUrl(aDiscoveryUrl);
            LOGGER.info("Requesting discoverable services at <" + aDiscoveryUrl.toHttpUrl() + "> Eureka service registry...");
            RestResponse theResponse = theClient.doGet("/");
            if (theResponse.getHttpStatusCode().isErrorStatus()) {
                throw theResponse.getHttpStatusCode().toHttpStatusException("Cannot retrieve any discoverable services with service discovery <" + aDiscoveryUrl.toHttpUrl() + "> due to HTTP-Status-Code " + theResponse.getHttpStatusCode() + "<" + theResponse.getHttpStatusCode().getStatusCode() + ">: " + theResponse.getHttpBody());
            }
            HttpBodyMap theHttpBody = theResponse.getResponse();
            HttpBodyMap theCloud = theHttpBody.retrieveFrom(theHttpBody.toPath(new String[]{"applications", "application"}));
            Set theAppsListing = theCloud.dirs();
            for (String eAppIndex : theAppsListing) {
                HttpBodyMap eApp = theCloud.retrieveFrom(theCloud.toPath(new String[]{eAppIndex, "instance"}));
                Set eInstancesListing = eApp.dirs();
                for (String eInstanceIndex : eInstancesListing) {
                    ArrayList<EurekaInstanceDescriptor> eDescriptors;
                    EurekaInstanceDescriptor eDescriptor = new EurekaInstanceDescriptor(eApp.retrieveFrom(eInstanceIndex));
                    String eAlias = eDescriptor.getAlias();
                    if (eAlias != null) {
                        eAlias = eAlias.toUpperCase();
                    }
                    if ((eDescriptors = (ArrayList<EurekaInstanceDescriptor>)theInstances.get(eAlias)) == null) {
                        EurekaDiscovery<?> eurekaDiscovery = this._discovery;
                        synchronized (eurekaDiscovery) {
                            eDescriptors = (List)theInstances.get(eAlias);
                            if (eDescriptors == null) {
                                eDescriptors = new ArrayList<EurekaInstanceDescriptor>();
                                theInstances.put(eAlias, eDescriptors);
                            }
                        }
                    }
                    eDescriptors.add(eDescriptor);
                }
            }
            return theInstances;
        }

        private List<EurekaInstanceDescriptor> toInstancesUpdate(List<EurekaInstanceDescriptor> aRemoteInstances, List<EurekaInstanceDescriptor> aLocalInstances) {
            ArrayList<EurekaInstanceDescriptor> theInstances = new ArrayList<EurekaInstanceDescriptor>(aLocalInstances);
            if (aRemoteInstances != null) {
                for (EurekaInstanceDescriptor eRemoteInstance : aRemoteInstances) {
                    EurekaInstanceDescriptor eLocalInstance = this.toInstance(eRemoteInstance, theInstances);
                    if (eLocalInstance != null) {
                        theInstances.remove((Object)eLocalInstance);
                    }
                    if (EurekaServiceStatus.UP != EurekaServiceStatus.toStatus(eRemoteInstance.getStatus())) continue;
                    theInstances.add(eRemoteInstance);
                }
            }
            return theInstances;
        }

        private EurekaInstanceDescriptor toInstance(EurekaInstanceDescriptor aInstance, List<EurekaInstanceDescriptor> aInstances) {
            if (aInstances != null) {
                for (EurekaInstanceDescriptor eInstance : aInstances) {
                    if (!eInstance.getHost().equals(aInstance.getHost())) continue;
                    return eInstance;
                }
            }
            return null;
        }
    }
}

