/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest.ext.eureka;

import java.net.MalformedURLException;
import java.util.Map;
import org.refcodes.exception.BugException;
import org.refcodes.mixin.AliasAccessor;
import org.refcodes.mixin.PortAccessor;
import org.refcodes.net.IpAddress;
import org.refcodes.net.IpAddressAccessor;
import org.refcodes.rest.HomeUrlAccessor;
import org.refcodes.rest.PingUrlAccessor;
import org.refcodes.rest.StatusUrlAccessor;
import org.refcodes.web.HostAccessor;
import org.refcodes.web.HttpBodyMap;
import org.refcodes.web.Url;

public class EurekaInstanceDescriptor
extends HttpBodyMap
implements AliasAccessor.AliasProperty,
PingUrlAccessor.PingUrlProperty,
StatusUrlAccessor.StatusUrlProperty,
HomeUrlAccessor.HomeUrlProperty,
HostAccessor.HostProperty,
IpAddressAccessor.IpAddressProperty,
PortAccessor.PortProperty {
    private static final long serialVersionUID = 1L;

    public EurekaInstanceDescriptor() {
    }

    public EurekaInstanceDescriptor(Object aObj, String aFromPath) {
        super(aObj, aFromPath);
    }

    public EurekaInstanceDescriptor(Object aObj) {
        super(aObj);
    }

    public EurekaInstanceDescriptor(String aToPath, Object aObj, String aFromPath) {
        super(aToPath, aObj, aFromPath);
    }

    public EurekaInstanceDescriptor(String aToPath, Object aObj) {
        super(aToPath, aObj);
    }

    public String getActionType() {
        return (String)this.get("/actionType");
    }

    public void setActionType(String aValue) {
        this.put("/actionType", aValue);
    }

    public String getAlias() {
        return (String)this.get("/app");
    }

    public void setAlias(String aAlias) {
        this.put("/app", aAlias);
    }

    public String getCountryId() {
        return (String)this.get("/countryId");
    }

    public void setCountryId(String aValue) {
        this.put("/countryId", aValue);
    }

    public String getDataCenterInfoClass() {
        return (String)this.get("/dataCenterInfo/@class");
    }

    public void setDataCenterInfoClass(String aValue) {
        this.put("/dataCenterInfo/@class", aValue);
    }

    public String getDataCenterInfoName() {
        return (String)this.get("/dataCenterInfo/name");
    }

    public void setDataCenterInfoName(String aValue) {
        this.put("/dataCenterInfo/name", aValue);
    }

    public Url getPingUrl() {
        String theHealthCheckUrl = (String)this.get("/healthCheckUrl");
        if (theHealthCheckUrl == null) {
            return null;
        }
        try {
            return new Url(theHealthCheckUrl);
        }
        catch (MalformedURLException e) {
            throw new BugException("Cannot parse malformed Health-Check URL <" + theHealthCheckUrl + ">!", (Throwable)e);
        }
    }

    public void setPingUrl(Url aUrl) {
        this.put("/healthCheckUrl", aUrl.toHttpUrl());
    }

    public Url getStatusUrl() {
        String theStatusPageUrl = (String)this.get("/statusPageUrl");
        if (theStatusPageUrl == null) {
            return null;
        }
        try {
            return new Url(theStatusPageUrl);
        }
        catch (MalformedURLException e) {
            throw new BugException("Cannot parse malformed Health-Check URL <" + theStatusPageUrl + ">!", (Throwable)e);
        }
    }

    public void setStatusUrl(Url aUrl) {
        this.put("/statusPageUrl", aUrl.toHttpUrl());
    }

    public Url getHomeUrl() {
        String theHomePageUrl = (String)this.get("/homePageUrl");
        if (theHomePageUrl == null) {
            return null;
        }
        try {
            return new Url(theHomePageUrl);
        }
        catch (MalformedURLException e) {
            throw new BugException("Cannot parse malformed Health-Check URL <" + theHomePageUrl + ">!", (Throwable)e);
        }
    }

    public void setHomeUrl(Url aUrl) {
        this.put("/homePageUrl", aUrl.toHttpUrl());
    }

    public String getHost() {
        return (String)this.get("/hostName");
    }

    public void setHost(String aHost) {
        this.put("/hostName", aHost);
    }

    public int[] getIpAddress() {
        return IpAddress.fromAnyCidrNotation((String)((String)this.get("/ipAddr")));
    }

    public void setIpAddress(int[] aIpAddress) {
        this.put("/ipAddr", IpAddress.toString((int[])aIpAddress));
    }

    public String isCoordinatingDiscoveryServer() {
        return (String)this.get("/isCoordinatingDiscoveryServer");
    }

    public void setCoordinatingDiscoveryServer(String aValue) {
        this.put("/isCoordinatingDiscoveryServer", aValue);
    }

    public Long getLastDirtyTimestamp() {
        return this.getLong("/lastDirtyTimestamp");
    }

    public void setLastDirtyTimestamp(Long aValue) {
        this.putLong("/lastDirtyTimestamp", aValue);
    }

    public Long getLastUpdatedTimestamp() {
        return this.getLong("/lastUpdatedTimestamp");
    }

    public void setLastUpdatedTimestamp(Long aValue) {
        this.putLong("/lastUpdatedTimestamp", aValue);
    }

    public Integer getLeaseInfoDurationInSecs() {
        return this.getInt("/leaseInfo/durationInSecs");
    }

    public void setLeaseInfoDurationInSecs(Integer aValue) {
        this.putInt("/leaseInfo/durationInSecs", aValue);
    }

    public Long getLeaseInfoEvictionTimestamp() {
        return this.getLong("/leaseInfo/evictionTimestamp");
    }

    public void setLeaseInfoEvictionTimestamp(Long aValue) {
        this.putLong("/leaseInfo/evictionTimestamp", aValue);
    }

    public Long getLeaseInfoLastRenewalTimestamp() {
        return this.getLong("/leaseInfo/lastRenewalTimestamp");
    }

    public void setLeaseInfoLastRenewalTimestamp(Long aValue) {
        this.putLong("/leaseInfo/lastRenewalTimestamp", aValue);
    }

    public Long getLeaseInfoRegistrationTimestamp() {
        return this.getLong("/leaseInfo/registrationTimestamp");
    }

    public void setLeaseInfoRegistrationTimestamp(Long aValue) {
        this.putLong("/leaseInfo/registrationTimestamp", aValue);
    }

    public Integer getLeaseInfoRenewalIntervalInSecs() {
        return this.getInt("/leaseInfo/renewalIntervalInSecs");
    }

    public void setLeaseInfoRenewalIntervalInSecs(Integer aValue) {
        this.putInt("/leaseInfo/renewalIntervalInSecs", aValue);
    }

    public Long getLeaseInfoServiceUpTimestamp() {
        return this.getLong("/leaseInfo/serviceUpTimestamp");
    }

    public void setLeaseInfoServiceUpTimestamp(Long aValue) {
        this.putLong("/leaseInfo/serviceUpTimestamp", aValue);
    }

    public String getMetadataClass() {
        return (String)this.get("/metadata/@class");
    }

    public void setMetadataClass(String aValue) {
        this.put("/metadata/@class", aValue);
    }

    public String getOverriddenstatus() {
        return (String)this.get("/overriddenstatus");
    }

    public void setOverriddenstatus(String aValue) {
        this.put("/overriddenstatus", aValue);
    }

    public int getPort() {
        Integer thePort = this.getInt("/port/$");
        return thePort != null ? thePort : -1;
    }

    public void setPort(int aPort) {
        this.putInt("/port/$", aPort);
    }

    public String getPortEnabled() {
        return (String)this.get("/port/@enabled");
    }

    public void setPortEnabled(String aValue) {
        this.put("/port/@enabled", aValue);
    }

    public Integer getSecurePort() {
        return this.getInt("/securePort/$");
    }

    public void setSecurePort(Integer aValue) {
        this.putInt("/securePort/$", aValue);
    }

    public String getSecurePortEnabled() {
        return (String)this.get("/securePort/@enabled");
    }

    public void setSecurePortEnabled(String aValue) {
        this.put("/securePort/@enabled", aValue);
    }

    public String getStatus() {
        return (String)this.get("/status");
    }

    public void setStatus(String aValue) {
        this.put("/status", aValue);
    }

    public String getVipAddress() {
        return (String)this.get("/vipAddress");
    }

    public void setVipAddress(String aValue) {
        this.put("/vipAddress", aValue);
    }

    public Map<String, String> getMetaData() {
        return this.retrieveFrom("/metadata");
    }

    public void setMetaData(Map<String, String> aMetaData) {
        for (String eKey : aMetaData.keySet()) {
            this.put(this.toPath(new String[]{"/metadata", eKey}), aMetaData.get(eKey));
        }
    }

    public String putMetaData(String aKey, String aValue) {
        return (String)this.put(this.toPath(new String[]{"/metadata", aKey}), aValue);
    }
}

