/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest.ext.eureka;

import java.net.MalformedURLException;
import java.util.Map;
import org.refcodes.exception.BugException;
import org.refcodes.mixin.AliasAccessor;
import org.refcodes.mixin.PortAccessor;
import org.refcodes.net.IpAddress;
import org.refcodes.net.IpAddressAccessor;
import org.refcodes.rest.HomeUrlAccessor;
import org.refcodes.rest.HttpServerDescriptor;
import org.refcodes.rest.PingUrlAccessor;
import org.refcodes.rest.StatusUrlAccessor;
import org.refcodes.rest.ext.eureka.AmazonMetaData;
import org.refcodes.rest.ext.eureka.AmazonMetaDataAccessor;
import org.refcodes.rest.ext.eureka.EurekaDataCenterType;
import org.refcodes.rest.ext.eureka.EurekaDataCenterTypeAccessor;
import org.refcodes.rest.ext.eureka.EurekaServiceStatus;
import org.refcodes.rest.ext.eureka.EurekaServiceStatusAccessor;
import org.refcodes.struct.CanonicalMap;
import org.refcodes.web.HostAccessor;
import org.refcodes.web.HttpBodyMap;
import org.refcodes.web.Url;

public class EurekaServerDescriptor
extends HttpBodyMap
implements HttpServerDescriptor,
AliasAccessor.AliasProperty,
PingUrlAccessor.PingUrlProperty,
StatusUrlAccessor.StatusUrlProperty,
HomeUrlAccessor.HomeUrlProperty,
HostAccessor.HostProperty,
IpAddressAccessor.IpAddressProperty,
PortAccessor.PortProperty,
EurekaDataCenterTypeAccessor.EurekaDataCenterTypeProperty,
EurekaServiceStatusAccessor.EurekaServiceStatusProperty,
AmazonMetaDataAccessor.AmazonMetaDataProperty {
    private static final long serialVersionUID = 1L;

    public Integer getLeaseEvictionDurationInSecs() {
        return this.getInt("instance/leaseInfo/evictionDurationInSecs");
    }

    public void setLeaseEvictionDurationInSecs(Integer aLeaseEvictionDurationInSecs) {
        this.putInt("instance/leaseInfo/evictionDurationInSecs", aLeaseEvictionDurationInSecs);
    }

    public String getAlias() {
        return (String)this.get("instance/app");
    }

    public void setAlias(String aAlias) {
        this.put("instance/app", aAlias);
    }

    public Url getPingUrl() {
        String theHealthCheckUrl = (String)this.get("instance/healthCheckUrl");
        if (theHealthCheckUrl == null) {
            return null;
        }
        try {
            return new Url(theHealthCheckUrl);
        }
        catch (MalformedURLException e) {
            throw new BugException("Cannot parse malformed Health-Check URL <" + theHealthCheckUrl + ">!", (Throwable)e);
        }
    }

    public void setPingUrl(Url aUrl) {
        this.put("instance/healthCheckUrl", aUrl.toHttpUrl());
    }

    public Url getStatusUrl() {
        String theStatusPageUrl = (String)this.get("instance/statusPageUrl");
        if (theStatusPageUrl == null) {
            return null;
        }
        try {
            return new Url(theStatusPageUrl);
        }
        catch (MalformedURLException e) {
            throw new BugException("Cannot parse malformed Health-Check URL <" + theStatusPageUrl + ">!", (Throwable)e);
        }
    }

    public void setStatusUrl(Url aUrl) {
        this.put("instance/statusPageUrl", aUrl.toHttpUrl());
    }

    public Url getHomeUrl() {
        String theHomePageUrl = (String)this.get("instance/homePageUrl");
        if (theHomePageUrl == null) {
            return null;
        }
        try {
            return new Url(theHomePageUrl);
        }
        catch (MalformedURLException e) {
            throw new BugException("Cannot parse malformed Health-Check URL <" + theHomePageUrl + ">!", (Throwable)e);
        }
    }

    public void setHomeUrl(Url aUrl) {
        this.put("instance/homePageUrl", aUrl.toHttpUrl());
    }

    public String getHost() {
        return (String)this.get("instance/hostName");
    }

    public void setHost(String aHost) {
        this.put("instance/hostName", aHost);
    }

    public int getPort() {
        return this.getInt("instance/port");
    }

    public void setPort(int aPort) {
        this.putInt("instance/port", aPort);
    }

    public int[] getIpAddress() {
        return IpAddress.fromAnyCidrNotation((String)((String)this.get("instance/ipAddr")));
    }

    public void setIpAddress(int[] aIpAddress) {
        this.put("instance/ipAddr", IpAddress.toString((int[])aIpAddress));
    }

    public String getVirtualHost() {
        return (String)this.get("instance/vipAddress");
    }

    public void setVirtualHost(String aVirtualHost) {
        this.put("instance/vipAddress", aVirtualHost);
    }

    @Override
    public EurekaDataCenterType getEurekaDataCenterType() {
        return EurekaDataCenterType.fromName((String)this.get("instance/dataCenterInfo/name"));
    }

    @Override
    public void setEurekaDataCenterType(EurekaDataCenterType aDataCenterType) {
        this.put("instance/dataCenterInfo/name", aDataCenterType.getName());
    }

    @Override
    public AmazonMetaData getAmazonMetaData() {
        return (AmazonMetaData)((Object)this.toType("instance/dataCenterInfo/metadata", AmazonMetaData.class));
    }

    @Override
    public void setAmazonMetaData(AmazonMetaData aDataCenterType) {
        this.insertTo("instance/dataCenterInfo/metadata", (CanonicalMap)aDataCenterType);
    }

    @Override
    public EurekaServiceStatus getEurekaServiceStatus() {
        return EurekaServiceStatus.valueOf((String)this.get("instance/status"));
    }

    @Override
    public void setEurekaServiceStatus(EurekaServiceStatus aServiceStatus) {
        this.put("instance/status", aServiceStatus.name());
    }

    public Map<String, String> getMetaData() {
        return this.retrieveFrom("instance/metadata");
    }

    public void setMetaData(Map<String, String> aMetaData) {
        for (String eKey : aMetaData.keySet()) {
            this.put(this.toPath(new String[]{"instance/metadata", eKey}), aMetaData.get(eKey));
        }
    }

    public String putMetaData(String aKey, String aValue) {
        return (String)this.put(this.toPath(new String[]{"instance/metadata", aKey}), aValue);
    }
}

