/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest.ext.eureka;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.refcodes.component.InitializeException;
import org.refcodes.component.LifecycleStatus;
import org.refcodes.component.PauseException;
import org.refcodes.component.ResumeException;
import org.refcodes.component.StartException;
import org.refcodes.component.StopException;
import org.refcodes.data.Scheme;
import org.refcodes.exception.Trap;
import org.refcodes.rest.AbstractRestfulHttpDiscoveryClientDecorator;
import org.refcodes.rest.RestfulHttpClient;
import org.refcodes.rest.ext.eureka.EurekaDiscoverySidecar;
import org.refcodes.rest.ext.eureka.RestfulEurekaClient;
import org.refcodes.security.TrustStoreDescriptor;
import org.refcodes.web.BasicAuthCredentials;
import org.refcodes.web.HttpClientContext;
import org.refcodes.web.LoadBalancingStrategy;
import org.refcodes.web.OauthToken;
import org.refcodes.web.Url;

public class EurekaRestClientDecorator
extends AbstractRestfulHttpDiscoveryClientDecorator<RestfulEurekaClient>
implements RestfulEurekaClient {
    private static final Logger LOGGER = Logger.getLogger(EurekaRestClientDecorator.class.getName());
    private ExecutorService _executorService;
    private EurekaDiscoverySidecar.RefreshDaemon _refreshDaemon;

    public EurekaRestClientDecorator(RestfulHttpClient aClient) {
        super(aClient);
    }

    public EurekaRestClientDecorator(RestfulHttpClient aClient, ExecutorService aExecutorService) {
        super(aClient);
        this._executorService = aExecutorService;
    }

    public void initialize(Url aDiscoveryUrl, LoadBalancingStrategy aStrategy, TrustStoreDescriptor aStoreDescriptor) throws InitializeException {
        aDiscoveryUrl = this.toHttpDiscoveryUrl(aDiscoveryUrl);
        aStrategy = this.toLoadBalancerStrategy(aStrategy);
        super.initialize();
        this.setLoadBalancingStrategy(aStrategy);
        try {
            this._refreshDaemon = new EurekaDiscoverySidecar.RefreshDaemon(aDiscoveryUrl, aStoreDescriptor, this, this._executorService);
        }
        catch (Exception e) {
            this._lifeCycleAutomaton.setLifecycleStatus(LifecycleStatus.ERROR);
            throw new InitializeException("Cannot enter the initialize lifecycle!", (Throwable)e);
        }
    }

    public synchronized void start() throws StartException {
        try {
            if (!this.isOpened()) {
                LOGGER.log(Level.WARNING, "This connection not opened yet (it is in status <" + this.getConnectionStatus() + ">, therefore will try to open this connection now...");
                this.open();
            }
            super.start();
            this._refreshDaemon.start();
        }
        catch (Exception e) {
            this._lifeCycleAutomaton.setLifecycleStatus(LifecycleStatus.ERROR);
            throw new StartException("Cannot enter the start lifecycle!", (Throwable)e);
        }
    }

    public synchronized void pause() throws PauseException {
        super.pause();
    }

    public synchronized void stop() throws StopException {
        super.stop();
        try {
            this._refreshDaemon.start();
        }
        catch (Exception e) {
            this._lifeCycleAutomaton.setLifecycleStatus(LifecycleStatus.ERROR);
            throw new StopException("Cannot enter the stop lifecycle!", (Throwable)e);
        }
    }

    public synchronized void resume() throws ResumeException {
        super.resume();
    }

    public synchronized void destroy() {
        super.destroy();
        try {
            this._refreshDaemon.destroy();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, Trap.asMessage((Throwable)e), e);
            this._lifeCycleAutomaton.setLifecycleStatus(LifecycleStatus.ERROR);
        }
        finally {
            try {
                this.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, Trap.asMessage((Throwable)e), e);
                this._lifeCycleAutomaton.setLifecycleStatus(LifecycleStatus.ERROR);
            }
        }
    }

    public Url toUrl(Url aUrl) {
        return EurekaDiscoverySidecar.toUrl(aUrl, this, this._refreshDaemon);
    }

    public BasicAuthCredentials getBasicAuthCredentials() {
        return this._client.getBasicAuthCredentials();
    }

    public void setBasicAuthCredentials(BasicAuthCredentials aBasicAuthCredentials) {
        this._client.setBasicAuthCredentials(aBasicAuthCredentials);
    }

    public EurekaRestClientDecorator withOpen() throws IOException {
        this._client.open();
        return this;
    }

    public EurekaRestClientDecorator withOpen(HttpClientContext aCtx) throws IOException {
        this._client.open(aCtx);
        return this;
    }

    public EurekaRestClientDecorator withOpen(TrustStoreDescriptor aStoreDescriptor) throws IOException {
        this._client.open(aStoreDescriptor);
        return this;
    }

    public EurekaRestClientDecorator withOpen(Url aBaseUrl) throws IOException {
        this._client.open(aBaseUrl);
        return this;
    }

    public EurekaRestClientDecorator withOpen(Url aBaseUrl, TrustStoreDescriptor aStoreDescriptor) throws IOException {
        this._client.open(aBaseUrl, aStoreDescriptor);
        return this;
    }

    public EurekaRestClientDecorator withBaseUrl(String aBaseUrl) throws MalformedURLException {
        this._client.setBaseUrl(aBaseUrl);
        return this;
    }

    public EurekaRestClientDecorator withBaseUrl(Url aBaseUrl) {
        this._client.setBaseUrl(aBaseUrl);
        return this;
    }

    public EurekaRestClientDecorator withBaseUrl(URL aBaseURL) {
        this._client.setBaseUrl(aBaseURL);
        return this;
    }

    public EurekaRestClientDecorator withBasicAuthCredentials(BasicAuthCredentials aBasicAuthCredentials) {
        this._client.setBasicAuthCredentials(aBasicAuthCredentials);
        return this;
    }

    public EurekaRestClientDecorator withBasicAuthCredentials(String aUserName, String aSecret) {
        this._client.setBasicAuthCredentials(aUserName, aSecret);
        return this;
    }

    public EurekaRestClientDecorator withOAuthToken(OauthToken aOauthToken) {
        this._client.setOauthToken(aOauthToken);
        return this;
    }

    public EurekaRestClientDecorator withTrustStoreDescriptor(TrustStoreDescriptor aStoreDescriptor) {
        this._client.setTrustStoreDescriptor(aStoreDescriptor);
        return this;
    }

    public EurekaRestClientDecorator withUserAgent(String aUserAgent) {
        this._client.setUserAgent(aUserAgent);
        return this;
    }

    public EurekaRestClientDecorator withBaseUrl(String aProtocol, String aHost) throws MalformedURLException {
        this._client.setBaseUrl(aProtocol, aHost);
        return this;
    }

    public EurekaRestClientDecorator withBaseUrl(Scheme aScheme, String aHost) throws MalformedURLException {
        this._client.setBaseUrl(aScheme, aHost);
        return this;
    }

    public EurekaRestClientDecorator withBaseUrl(String aProtocol, String aHost, String aPath) throws MalformedURLException {
        this._client.setBaseUrl(aProtocol, aHost, aPath);
        return this;
    }

    public EurekaRestClientDecorator withBaseUrl(Scheme aScheme, String aHost, String aPath) throws MalformedURLException {
        this._client.setBaseUrl(aScheme, aHost, aPath);
        return this;
    }

    public EurekaRestClientDecorator withBaseUrl(String aProtocol, String aHost, int aPort) throws MalformedURLException {
        this._client.setBaseUrl(aProtocol, aHost, aPort);
        return this;
    }

    public EurekaRestClientDecorator withBaseUrl(Scheme aScheme, String aHost, int aPort) throws MalformedURLException {
        this._client.setBaseUrl(aScheme, aHost, aPort);
        return this;
    }

    public EurekaRestClientDecorator withBaseUrl(String aProtocol, String aHost, int aPort, String aPath) throws MalformedURLException {
        this._client.setBaseUrl(aProtocol, aHost, aPort, aPath);
        return this;
    }

    public EurekaRestClientDecorator withBaseUrl(Scheme aScheme, String aHost, int aPort, String aPath) throws MalformedURLException {
        this._client.setBaseUrl(aScheme, aHost, aPort, aPath);
        return this;
    }

    public EurekaRestClientDecorator withOpenUnchecked() {
        this.openUnchecked();
        return this;
    }

    public EurekaRestClientDecorator withLoadBalancingStrategy(LoadBalancingStrategy aStrategy) {
        this.setLoadBalancingStrategy(aStrategy);
        return this;
    }

    public EurekaRestClientDecorator withHttpDiscoveryUrl(Url aUrl) {
        this.setHttpDiscoveryUrl(aUrl);
        return this;
    }
}

