/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.refcodes.runtime.RuntimeUtility;

public class RuntimeUtilityTest {
    private static Logger LOGGER = Logger.getLogger(RuntimeUtilityTest.class);

    @Test
    public void getStackTraceElement() {
        StackTraceElement theStackTraceElement = RuntimeUtility.getCallerStackTraceElement();
        String theFullyQualifiedMethodName = RuntimeUtility.toFullyQualifiedMethodName((StackTraceElement)theStackTraceElement);
        LOGGER.info((Object)theFullyQualifiedMethodName);
        Assert.assertEquals((Object)(RuntimeUtilityTest.class.getName() + '#' + "getStackTraceElement"), (Object)theFullyQualifiedMethodName);
    }

    @Test
    public void toFullyQualifiedMethodName() {
        StackTraceElement theStackTraceElement = RuntimeUtility.getCallerStackTraceElement(RuntimeUtilityTest.class);
        String theFullyQualifiedMethodName = RuntimeUtility.toFullyQualifiedMethodName((StackTraceElement)theStackTraceElement);
        Assert.assertNotEquals((Object)(RuntimeUtilityTest.class.getName() + '#' + "toFullyQualifiedMethodName"), (Object)theFullyQualifiedMethodName);
    }

    @Test
    public void toFullyQualifiedPackageName() {
        String thePackageName = RuntimeUtility.toFullyQualifiedPackageName();
        Assert.assertEquals((Object)thePackageName, (Object)this.getClass().getPackage().getName());
    }

    @Test
    public void toClassName() {
        String theClassName = RuntimeUtility.toClassName();
        Assert.assertEquals((Object)theClassName, (Object)this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1));
        String theFooBar = "FooBar";
        String theFullyQualifiedClassName = "foo.bar." + theFooBar;
        LOGGER.info((Object)(theFullyQualifiedClassName + " --> toClassName() --> " + RuntimeUtility.toClassName((String)theFullyQualifiedClassName)));
        Assert.assertEquals((Object)theFooBar, (Object)RuntimeUtility.toClassName((String)theFullyQualifiedClassName));
    }

    @Test
    public void toInnerClassName() {
        String theClassName = RuntimeUtility.toClassName();
        Assert.assertEquals((Object)theClassName, (Object)this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1));
        String theInnerFooBar = "InnerFooBar";
        String theFullyQualifiedClassName = "foo.bar.FooBar$" + theInnerFooBar;
        LOGGER.info((Object)(theFullyQualifiedClassName + " --> toClassName() --> " + RuntimeUtility.toClassName((String)theFullyQualifiedClassName)));
        Assert.assertEquals((Object)theInnerFooBar, (Object)RuntimeUtility.toClassName((String)theFullyQualifiedClassName));
    }

    @Test
    public void getPid() {
        LOGGER.info((Object)("PID := " + RuntimeUtility.getPid()));
    }

    @Test
    public void toApplicationBaseFile() throws IOException {
        File theFile = RuntimeUtility.toAppBaseDir();
        LOGGER.info((Object)("Application base file := " + theFile.toURI().toURL().toString()));
    }

    @Test
    public void getMainPath() throws IOException {
        Class theMainClass = RuntimeUtility.getMainClass();
        LOGGER.info((Object)("Main class := " + theMainClass.getName()));
    }
}

