/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.refcodes.data.CommandArgPrefix;
import org.refcodes.data.Delimiter;
import org.refcodes.data.Folder;
import org.refcodes.data.Literal;
import org.refcodes.data.Scheme;
import org.refcodes.data.SystemProperty;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.exception.HiddenException;
import org.refcodes.runtime.OperatingSystem;

public final class RuntimeUtility {
    private static final String[] RESERVED_PACKAGE_PREFIXES = new String[]{"sun.", "com.sun.", "java.", "javax."};
    private static String[] MAIN_METHODS = new String[]{"main", "start", "<clinit>", "<init>"};
    private static String[] MAIN_METHOD_PREFIXES = new String[]{"test"};
    private static String[] FRAMEWORK_LAUNCHERS = new String[]{"JarLauncher", "TestRunner", "ForkedBooter"};
    private static Scheme[] JAR_PROTOCOLS = new Scheme[]{Scheme.JAR, Scheme.ZIP, Scheme.SH};
    private static Boolean _isUnderTest = null;

    private RuntimeUtility() {
    }

    public static boolean isUnderTest() {
        block2: {
            if (_isUnderTest != null) {
                return _isUnderTest;
            }
            StackTraceElement[] theStackTrace = Thread.currentThread().getStackTrace();
            List<StackTraceElement> theList = Arrays.asList(theStackTrace);
            for (StackTraceElement eElement : theList) {
                if (!eElement.getClassName().startsWith("org.junit.") && !eElement.getClassName().startsWith("org.testng.")) continue;
                _isUnderTest = true;
                break block2;
            }
            _isUnderTest = false;
        }
        return _isUnderTest;
    }

    public static String toStackTrace() {
        StringWriter theStringWriter = new StringWriter();
        new Throwable("").printStackTrace(new PrintWriter(theStringWriter));
        return theStringWriter.toString();
    }

    public static StackTraceElement getCallerStackTraceElement() {
        StackTraceElement[] theStackTraceElements;
        for (StackTraceElement eStackTraceElement : theStackTraceElements = Thread.currentThread().getStackTrace()) {
            if (RuntimeUtility.isSkipStackTraceElement(eStackTraceElement)) continue;
            return eStackTraceElement;
        }
        return null;
    }

    public static StackTraceElement getCallerStackTraceElement(Class<?> aCallee) {
        return RuntimeUtility.getCallerStackTraceElement(aCallee.getName());
    }

    public static StackTraceElement getCallerStackTraceElement(StackTraceElement aCallee) {
        return RuntimeUtility.getCallerStackTraceElement(aCallee.getClassName());
    }

    public static StackTraceElement getCallerStackTraceElement(Class<?> ... aCallees) {
        StackTraceElement eCaller = null;
        for (Class<?> eClallee : aCallees) {
            eCaller = RuntimeUtility.getCallerStackTraceElement(eClallee);
            if (eCaller == null) continue;
            return eCaller;
        }
        return null;
    }

    public static StackTraceElement getCallerStackTraceElement(StackTraceElement ... aCallees) {
        StackTraceElement eCaller = null;
        for (StackTraceElement eClallee : aCallees) {
            eCaller = RuntimeUtility.getCallerStackTraceElement(eClallee);
            if (eCaller == null) continue;
            return eCaller;
        }
        return null;
    }

    public static StackTraceElement getCallerStackTraceElement(String ... aCalleeClassNames) {
        StackTraceElement eCaller = null;
        for (String eClallee : aCalleeClassNames) {
            eCaller = RuntimeUtility.getCallerStackTraceElement(eClallee);
            if (eCaller == null) continue;
            return eCaller;
        }
        return null;
    }

    public static StackTraceElement getCallerStackTraceElement(String aCalleeClassName) {
        StackTraceElement[] theStackTraceElements = Thread.currentThread().getStackTrace();
        boolean hasCalleeElement = false;
        for (StackTraceElement eStackTraceElement : theStackTraceElements) {
            if (hasCalleeElement && !eStackTraceElement.getClassName().startsWith(aCalleeClassName)) {
                return eStackTraceElement;
            }
            if (!eStackTraceElement.getClassName().startsWith(aCalleeClassName)) continue;
            hasCalleeElement = true;
        }
        return null;
    }

    private static boolean hasReservedPackagePrefix(StackTraceElement aCaller) {
        String theClassName = aCaller.getClassName();
        for (String ePrefix : RESERVED_PACKAGE_PREFIXES) {
            if (!theClassName.startsWith(ePrefix)) continue;
            return true;
        }
        return false;
    }

    public static StackTraceElement toBestCallerStackTraceElement(String aCalleeClassName) {
        StackTraceElement theStackTraceElement;
        StackTraceElement eStackTraceElement = theStackTraceElement = RuntimeUtility.getCallerStackTraceElement(aCalleeClassName);
        while (eStackTraceElement != null && RuntimeUtility.hasReservedPackagePrefix(eStackTraceElement)) {
            eStackTraceElement = RuntimeUtility.getCallerStackTraceElement(eStackTraceElement);
        }
        return eStackTraceElement != null ? eStackTraceElement : theStackTraceElement;
    }

    public static StackTraceElement toBestCallerStackTraceElement(StackTraceElement aCallee) {
        return RuntimeUtility.toBestCallerStackTraceElement(aCallee.getClassName());
    }

    public static StackTraceElement toBestCallerStackTraceElement(Class<?> aCallee) {
        return RuntimeUtility.toBestCallerStackTraceElement(aCallee.getName());
    }

    public static StackTraceElement toBestCallerStackTraceElement(String[] aCallees) {
        for (String e : aCallees) {
            StackTraceElement eStackTraceElement = RuntimeUtility.toBestCallerStackTraceElement(e);
            if (eStackTraceElement == null) continue;
            return eStackTraceElement;
        }
        return null;
    }

    public static StackTraceElement toBestCallerStackTraceElement(StackTraceElement[] aCallees) {
        for (StackTraceElement e : aCallees) {
            StackTraceElement eStackTraceElement = RuntimeUtility.toBestCallerStackTraceElement(e);
            if (eStackTraceElement == null) continue;
            return eStackTraceElement;
        }
        return null;
    }

    public static StackTraceElement toBestCallerStackTraceElement(Class<?>[] aCallees) {
        for (Class<?> e : aCallees) {
            StackTraceElement eStackTraceElement = RuntimeUtility.toBestCallerStackTraceElement(e);
            if (eStackTraceElement == null) continue;
            return eStackTraceElement;
        }
        return null;
    }

    public static Class<?> getCallerType() {
        StackTraceElement theStackTraceElement = RuntimeUtility.getCallerStackTraceElement();
        return RuntimeUtility.toClass(theStackTraceElement);
    }

    public static Class<?> getCallerType(Class<?> aCallee) {
        StackTraceElement theStackTraceElement = RuntimeUtility.getCallerStackTraceElement(aCallee);
        return RuntimeUtility.toClass(theStackTraceElement);
    }

    public static Class<?> getCallerType(Class<?> ... aCallees) {
        StackTraceElement theStackTraceElement = RuntimeUtility.getCallerStackTraceElement(aCallees);
        return RuntimeUtility.toClass(theStackTraceElement);
    }

    public static Class<?> getCallerType(StackTraceElement aCallee) {
        StackTraceElement theStackTraceElement = RuntimeUtility.getCallerStackTraceElement(aCallee);
        return RuntimeUtility.toClass(theStackTraceElement);
    }

    public static Class<?> getCallerType(String ... aCallees) {
        StackTraceElement theStackTraceElement = RuntimeUtility.getCallerStackTraceElement(aCallees);
        return RuntimeUtility.toClass(theStackTraceElement);
    }

    public static Class<?> getCallerType(String aCallee) {
        StackTraceElement theStackTraceElement = RuntimeUtility.getCallerStackTraceElement(aCallee);
        return RuntimeUtility.toClass(theStackTraceElement);
    }

    public static Class<?> getCallerType(StackTraceElement ... aCallees) {
        StackTraceElement theStackTraceElement = RuntimeUtility.getCallerStackTraceElement(aCallees);
        return RuntimeUtility.toClass(theStackTraceElement);
    }

    public static Class<?> toClass(StackTraceElement aStackTraceElement) {
        try {
            return Class.forName(aStackTraceElement.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new HiddenException((Throwable)e);
        }
    }

    public static String toMethodName(StackTraceElement aStackTraceElement) {
        if (aStackTraceElement == null) {
            return null;
        }
        return aStackTraceElement.getMethodName();
    }

    public static String toClassName(StackTraceElement aStackTraceElement) {
        if (aStackTraceElement == null) {
            return null;
        }
        return RuntimeUtility.toClassName(aStackTraceElement.getClassName());
    }

    public static String toFullyQualifiedClassName(StackTraceElement aStackTraceElement) {
        if (aStackTraceElement == null) {
            return null;
        }
        return aStackTraceElement.getClassName();
    }

    public static String toFullyQualifiedMethodName(StackTraceElement aStackTraceElement) {
        if (aStackTraceElement == null) {
            return null;
        }
        return aStackTraceElement.getClassName() + Delimiter.METHOD_NAME.getChar() + aStackTraceElement.getMethodName();
    }

    public static String toFullyQualifiedClassName() {
        StackTraceElement theStackTraceElement = RuntimeUtility.getCallerStackTraceElement();
        return theStackTraceElement.getClassName();
    }

    public static String toFullyQualifiedMethodName() {
        StackTraceElement theStackTraceElement = RuntimeUtility.getCallerStackTraceElement();
        return theStackTraceElement.getClassName() + Delimiter.METHOD_NAME.getChar() + theStackTraceElement.getMethodName();
    }

    public static String toMethodName() {
        StackTraceElement theStackTraceElement = RuntimeUtility.getCallerStackTraceElement();
        return theStackTraceElement.getMethodName();
    }

    public static String toClassName() {
        return RuntimeUtility.toClassName(RuntimeUtility.toFullyQualifiedClassName());
    }

    public static String toFullyQualifiedPackageName() {
        return RuntimeUtility.toFullyQualifiedPackageName(RuntimeUtility.toFullyQualifiedClassName());
    }

    public static String toFullyQualifiedPackageName(StackTraceElement aStackTraceElement) {
        return RuntimeUtility.toFullyQualifiedPackageName(RuntimeUtility.toFullyQualifiedClassName(aStackTraceElement));
    }

    public static String toClassName(String aFullyQualifiedClassName) {
        int theClassIndex = aFullyQualifiedClassName.lastIndexOf(46);
        String theClassName = theClassIndex != -1 ? aFullyQualifiedClassName.substring(theClassIndex + 1) : aFullyQualifiedClassName;
        int theInnerClassIndex = theClassName.indexOf(36);
        if (theInnerClassIndex != -1) {
            theClassName = theClassName.substring(theInnerClassIndex + 1);
        }
        return theClassName;
    }

    public static String toFullyQualifiedPackageName(String aFullyQualifiedClassName) {
        int theIndex = aFullyQualifiedClassName.lastIndexOf(46);
        if (theIndex != -1) {
            return aFullyQualifiedClassName.substring(0, theIndex);
        }
        return "";
    }

    public static <T> T toClone(T aObj) throws CloneNotSupportedException {
        if (aObj instanceof Cloneable) {
            try {
                return (T)aObj.getClass().getMethod("clone", new Class[0]).invoke(aObj, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new CloneNotSupportedException(ExceptionUtility.toMessage((Throwable)e));
            }
        }
        throw new CloneNotSupportedException("The type \"" + aObj.getClass().getName() + "}\" does not implement the \"" + Cloneable.class.getName() + "\" interface.");
    }

    public static String toString(String aToString, String aSuperToString) {
        return aToString + " (" + aSuperToString + ")";
    }

    public static Long getPid() {
        Long thePid;
        block4: {
            thePid = null;
            try {
                thePid = Long.parseLong(SystemProperty.PROCESS_ID.getValue());
            }
            catch (NumberFormatException e1) {
                String theJvmName = ManagementFactory.getRuntimeMXBean().getName();
                if (theJvmName.indexOf(64) == -1) break block4;
                try {
                    thePid = Long.parseLong(theJvmName.substring(0, theJvmName.indexOf(64)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return thePid;
    }

    public static Process killProcess(Long aPid) throws IOException {
        Process theProcess = null;
        switch (OperatingSystem.toOperatingSystem()) {
            case WINDOWS: {
                String theCmd = "taskkill /F /PID " + aPid;
                theProcess = Runtime.getRuntime().exec(theCmd);
                break;
            }
            case UNIX: {
                String theCmd = "kill -9 " + aPid;
                theProcess = Runtime.getRuntime().exec(theCmd);
                break;
            }
        }
        return theProcess;
    }

    public static boolean kill(Long aPid) throws IOException, InterruptedException {
        Process theProcess = RuntimeUtility.killProcess(aPid);
        if (theProcess != null) {
            theProcess.waitFor();
            return theProcess.exitValue() == 0;
        }
        return false;
    }

    public static File toLauncherDir() {
        Scheme eProtocol;
        String truncate;
        String basePath;
        Class<RuntimeUtility> baseClass = RuntimeUtility.getMainClass();
        if (baseClass == null) {
            baseClass = RuntimeUtility.class;
        }
        if ((basePath = baseClass.getProtectionDomain().getCodeSource().getLocation().getPath()).startsWith(Scheme.FILE.toProtocol())) {
            basePath = basePath.substring(Scheme.FILE.toProtocol().length());
        }
        try {
            String theCanonicalName = baseClass.getCanonicalName();
            truncate = theCanonicalName.replace('.', '/');
        }
        catch (Exception e) {
            return null;
        }
        truncate = truncate.substring(0, truncate.indexOf(baseClass.getSimpleName()));
        int endIndex = basePath.indexOf(truncate);
        if (endIndex > 0) {
            basePath = basePath.substring(0, endIndex);
        }
        if (basePath.endsWith("" + Delimiter.PATH.getChar())) {
            basePath = basePath.substring(0, basePath.length() - 1);
        }
        if (basePath.endsWith(Folder.CLASSES.getName())) {
            basePath = basePath.substring(0, basePath.indexOf(Folder.CLASSES.getName()));
        }
        int index = -1;
        Scheme[] schemeArray = JAR_PROTOCOLS;
        int n = schemeArray.length;
        for (int i = 0; i < n && (index = (eProtocol = schemeArray[i]).firstMarkerIndex(basePath.toLowerCase())) == -1; ++i) {
        }
        if (index != -1 && (index = (basePath = basePath.substring(0, index)).lastIndexOf(Delimiter.PATH.getChar())) != -1) {
            basePath = basePath.substring(0, index);
        }
        if (!basePath.endsWith("" + Delimiter.PATH.getChar())) {
            basePath = basePath + Delimiter.PATH.getChar();
        }
        File baseFile = new File(basePath);
        if (basePath.endsWith(Folder.TARGET.getName() + Delimiter.PATH.getChar())) {
            return baseFile;
        }
        File parentFile = baseFile.getParentFile();
        return parentFile;
    }

    public static Class getMainClass() {
        Class<?> mainClass;
        StackTraceElement eElement;
        int i;
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        ArrayList<StackTraceElement> theCandidates = new ArrayList<StackTraceElement>();
        for (i = 0; i < stack.length; ++i) {
            eElement = stack[i];
            if (!RuntimeUtility.hasTestAnnotation(eElement)) continue;
            theCandidates.add(eElement);
        }
        for (i = stack.length - 1; i > 0; --i) {
            eElement = stack[i];
            for (String eMain : MAIN_METHODS) {
                if (!eElement.getMethodName().equals(eMain)) continue;
                theCandidates.add(eElement);
            }
            for (String ePrefix : MAIN_METHOD_PREFIXES) {
                if (!eElement.getMethodName().startsWith(ePrefix)) continue;
                theCandidates.add(eElement);
            }
        }
        block8: for (StackTraceElement eCandidate : theCandidates) {
            for (String eLauncer : FRAMEWORK_LAUNCHERS) {
                if (eCandidate.getClassName().toLowerCase().contains(eLauncer.toLowerCase())) continue block8;
            }
            try {
                mainClass = Class.forName(eCandidate.getClassName());
                if (mainClass.getProtectionDomain().getCodeSource() == null) continue;
                return mainClass;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        for (StackTraceElement eCandidate : theCandidates) {
            try {
                mainClass = Class.forName(eCandidate.getClassName());
                if (mainClass.getProtectionDomain().getCodeSource() == null) continue;
                return mainClass;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    private static boolean hasTestAnnotation(StackTraceElement aElement) {
        try {
            Method[] methods;
            Class<?> aClass = Class.forName(aElement.getClassName());
            String methodName = aElement.getMethodName();
            for (Method method : methods = aClass.getMethods()) {
                Annotation[] eAnnotations;
                if (!method.getName().equals(methodName)) continue;
                for (Annotation eAnnotation : eAnnotations = method.getDeclaredAnnotations()) {
                    String theSimpleName = eAnnotation.annotationType().getSimpleName();
                    if (!theSimpleName.equals("Test")) continue;
                    return true;
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public static Map<String, String> toProperties(String[] aArgs) {
        return RuntimeUtility.toProperties(aArgs, CommandArgPrefix.toPrefixes(), Delimiter.INDEX.getChar());
    }

    public static Map<String, String> toProperties(String[] aArgs, String[] aPrefixes, char aDelimiter) {
        HashMap<String, String> theBuilder = new HashMap<String, String>();
        String eOption = null;
        for (int i = 0; i < aArgs.length; ++i) {
            String eArg = aArgs[i];
            String eNextOption = RuntimeUtility.toOption(eArg, aPrefixes);
            if (eOption != null) {
                if (eNextOption == null) {
                    RuntimeUtility.putProperty(theBuilder, eOption, eArg, aDelimiter);
                    eOption = null;
                    continue;
                }
                RuntimeUtility.putProperty(theBuilder, eOption, Literal.TRUE.getName(), aDelimiter);
                eOption = eNextOption;
                if (i != aArgs.length - 1) continue;
                RuntimeUtility.putProperty(theBuilder, eOption, Literal.TRUE.getName(), aDelimiter);
                continue;
            }
            if (eNextOption != null) {
                eOption = eNextOption;
                if (i != aArgs.length - 1) continue;
                RuntimeUtility.putProperty(theBuilder, eOption, Literal.TRUE.getName(), aDelimiter);
                continue;
            }
            RuntimeUtility.putProperty(theBuilder, null, eArg, aDelimiter);
        }
        return theBuilder;
    }

    protected static void putProperty(Map<String, String> aProperties, String aKey, String aValue, char aDelimiter) {
        if (aProperties.containsKey(aKey)) {
            String eNextKey = RuntimeUtility.toNextKey(aProperties, aKey, aDelimiter);
            aProperties.put(eNextKey, aProperties.remove(aKey));
            eNextKey = RuntimeUtility.toNextKey(aProperties, aKey, aDelimiter);
            aProperties.put(eNextKey, aValue);
        } else if (aProperties.containsKey(aKey + aDelimiter + "0")) {
            String eNextKey = RuntimeUtility.toNextKey(aProperties, aKey, aDelimiter);
            aProperties.put(eNextKey, aValue);
        } else {
            aProperties.put(aKey, aValue);
        }
    }

    protected static String toNextKey(Map<String, String> aProperties, String aKey, char aDelimiter) {
        if (aProperties.containsKey(aKey) || aProperties.containsKey(aKey + aDelimiter + "0")) {
            int index = 0;
            String eNextKey = aKey + aDelimiter + index;
            while (aProperties.containsKey(eNextKey)) {
                eNextKey = aKey + aDelimiter + ++index;
            }
            return eNextKey;
        }
        return null;
    }

    protected static String toOption(String aArg, String ... aPrefixes) {
        Arrays.sort(aPrefixes, Collections.reverseOrder());
        for (String ePrefix : aPrefixes) {
            if (!aArg.startsWith(ePrefix)) continue;
            return aArg.substring(ePrefix.length());
        }
        return null;
    }

    @SafeVarargs
    protected static boolean containsDir(File aDir, List<File> ... aDirs) {
        for (List<File> eDirs : aDirs) {
            if (!eDirs.contains(aDir)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSkipStackTraceElement(StackTraceElement aStackTraceElement) {
        return aStackTraceElement.getClassName().equals(Thread.class.getName()) || aStackTraceElement.getClassName().equals(RuntimeUtility.class.getName()) || aStackTraceElement.getLineNumber() <= 1;
    }
}

