/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.refcodes.data.DaemonLoopSleepTime;
import org.refcodes.data.EnvironmentVariable;
import org.refcodes.data.Literal;
import org.refcodes.data.SystemProperty;
import org.refcodes.runtime.OperatingSystem;
import org.refcodes.runtime.ProcessResult;
import org.refcodes.runtime.RuntimeUtility;
import org.refcodes.runtime.Shell;
import org.refcodes.runtime.SystemContext;
import org.refcodes.runtime.Terminal;

public final class SystemUtility {
    private static String _uname = null;
    private static boolean _hasUname = false;

    private SystemUtility() {
    }

    public static String getComputerName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            String theName = EnvironmentVariable.COMPUTERNAME.getValue();
            if (theName == null || theName.length() == 0) {
                theName = EnvironmentVariable.HOSTNAME.getValue();
            }
            if (theName != null && theName.length() > 0) {
                return theName;
            }
            return Literal.LOCALHOST.getName();
        }
    }

    public static String getUname() {
        if (_hasUname) {
            return _uname;
        }
        try {
            _uname = SystemUtility.exec(DaemonLoopSleepTime.NORM.getMilliseconds(), "uname -a");
        }
        catch (IOException | InterruptedException exception) {
            // empty catch block
        }
        _hasUname = true;
        return _uname;
    }

    public static String toPropertyValue(String aDefaultValue, SystemProperty aSystemProperty, EnvironmentVariable ... aEnvironmentProperties) {
        String theValue = aSystemProperty.getValue();
        if (theValue != null && theValue.length() > 0) {
            return theValue;
        }
        if (aEnvironmentProperties != null) {
            for (EnvironmentVariable eProperty : aEnvironmentProperties) {
                theValue = eProperty.getValue();
                if (theValue == null || theValue.length() <= 0) continue;
                return theValue;
            }
        }
        if (theValue != null && theValue.length() > 0) {
            return theValue;
        }
        return aDefaultValue;
    }

    public static String toPropertyValue(SystemProperty aSystemProperty, EnvironmentVariable ... aEnvironmentProperties) {
        String theValue = aSystemProperty.getValue();
        if (theValue != null && theValue.length() != 0) {
            return theValue;
        }
        if (aEnvironmentProperties != null) {
            for (EnvironmentVariable eProperty : aEnvironmentProperties) {
                theValue = eProperty.getValue();
                if (theValue == null || theValue.length() == 0) continue;
                return theValue;
            }
        }
        if (theValue != null && theValue.length() != 0) {
            return theValue;
        }
        return null;
    }

    public static String exec(int aTimeOutMillis, String aCommandLine) throws IOException, InterruptedException {
        ProcessBuilder theProcessBuilder = new ProcessBuilder(aCommandLine);
        Process theProcess = theProcessBuilder.start();
        String theOut = new ProcessResult(theProcess, aTimeOutMillis).toString();
        return theOut;
    }

    public static String exec(int aTimeOutMillis, String ... aCommandLine) throws IOException, InterruptedException {
        ProcessBuilder theProcessBuilder = new ProcessBuilder(aCommandLine);
        Process theProcess = theProcessBuilder.start();
        String theOut = new ProcessResult(theProcess, aTimeOutMillis).toString();
        return theOut;
    }

    public static String exec(String aCommandLine) throws IOException {
        ProcessBuilder theProcessBuilder = new ProcessBuilder(aCommandLine);
        Process theProcess = theProcessBuilder.start();
        String theOut = new ProcessResult(theProcess).toString();
        return theOut;
    }

    public static String exec(String ... aCommandLine) throws IOException {
        ProcessBuilder theProcessBuilder = new ProcessBuilder(aCommandLine);
        Process theProcess = theProcessBuilder.start();
        String theOut = new ProcessResult(theProcess).toString();
        return theOut;
    }

    public static Map<String, String> toSystemInfo() {
        HashMap<String, String> theInfo = new HashMap<String, String>();
        theInfo.put("applicationId", SystemContext.APPLICATION.toContextId() + "");
        theInfo.put("applicationIds", Arrays.toString(SystemContext.APPLICATION.toContextIds(3)));
        theInfo.put("applicationString", Arrays.toString(SystemContext.APPLICATION.toContextSequence().getBytes()));
        theInfo.put("computerName", SystemUtility.getComputerName());
        theInfo.put("hostId", SystemContext.HOST.toContextId() + "");
        theInfo.put("hostIds", Arrays.toString(SystemContext.HOST.toContextIds(3)));
        theInfo.put("hostString", Arrays.toString(SystemContext.HOST.toContextSequence().getBytes()));
        try {
            theInfo.put("ipAddress", Arrays.toString(SystemUtility.toHostIpAddress()));
        }
        catch (SocketException | UnknownHostException e) {
            theInfo.put("ipAddress", e.getMessage());
        }
        theInfo.put("isAnsiTerminalPreferred", Terminal.isAnsiTerminalPreferred() + "");
        theInfo.put("isAnsiTerminal", Terminal.isAnsiTerminal() + "");
        theInfo.put("isCygwinTerminal", Terminal.isCygwinTerminal() + "");
        theInfo.put("isLineBreakRequired", Terminal.isLineBreakRequired(Terminal.getTerminalWidth()) + "");
        theInfo.put("launcherDir", RuntimeUtility.toLauncherDir().getAbsolutePath());
        theInfo.put("lineBreak", Terminal.getLineBreak().replaceAll("\\n", "\\\\n").replaceAll("\\r", "\\\\r"));
        try {
            theInfo.put("macAddress", Arrays.toString(SystemUtility.toHostMacAddress()));
        }
        catch (SocketException | UnknownHostException e) {
            theInfo.put("macAddress", e.getMessage());
        }
        theInfo.put("mainClass", RuntimeUtility.getMainClass().getName());
        theInfo.put("operatingSystem", (Object)((Object)OperatingSystem.toOperatingSystem()) + "");
        theInfo.put("preferredTerminalHeight", Terminal.toPreferredTerminalHeight() + "");
        theInfo.put("preferredTerminalWidth", Terminal.toPreferredTerminalWidth() + "");
        theInfo.put("shell", (Object)((Object)Shell.toShell()) + "");
        theInfo.put("systemConsole", System.console() != null ? System.console().toString() : null);
        theInfo.put("terminalEncoding", Terminal.getTerminalEncoding());
        theInfo.put("tempDir", SystemProperty.TEMP_DIR.getValue());
        theInfo.put("terminal", (Object)((Object)Terminal.toTerminal()) + "");
        theInfo.put("terminalHeight", Terminal.getTerminalHeight() + "");
        theInfo.put("terminalWidth", Terminal.getTerminalWidth() + "");
        theInfo.put("uname", SystemUtility.getUname());
        theInfo.put("userId", SystemContext.USER.toContextId() + "");
        theInfo.put("userIds", Arrays.toString(SystemContext.USER.toContextIds(3)));
        theInfo.put("userString", Arrays.toString(SystemContext.USER.toContextSequence().getBytes()));
        return theInfo;
    }

    public static String toPrettySystemInfo() {
        StringBuffer theBuffer = new StringBuffer();
        Map<String, String> theInfo = SystemUtility.toSystemInfo();
        int maxLength = -1;
        for (String eKey : theInfo.keySet()) {
            if (eKey.length() <= maxLength) continue;
            maxLength = eKey.length();
        }
        ArrayList<String> theKeys = new ArrayList<String>(theInfo.keySet());
        Collections.sort(theKeys);
        Iterator iterator = theKeys.iterator();
        while (iterator.hasNext()) {
            String eKey;
            String tmpKey = eKey = (String)iterator.next();
            while (tmpKey.length() < maxLength) {
                tmpKey = tmpKey + " ";
            }
            theBuffer.append(tmpKey + " = " + theInfo.get(eKey) + Terminal.getLineBreak());
        }
        return theBuffer.toString();
    }

    public static byte[] toHostIpAddress() throws SocketException, UnknownHostException {
        Enumeration<NetworkInterface> eNetworks = NetworkInterface.getNetworkInterfaces();
        while (eNetworks.hasMoreElements()) {
            NetworkInterface eNetwork = eNetworks.nextElement();
            Enumeration<InetAddress> eAddresses = eNetwork.getInetAddresses();
            while (eAddresses.hasMoreElements()) {
                try {
                    InetAddress eAddress = eAddresses.nextElement();
                    if (eAddress.isAnyLocalAddress() || eAddress.isLoopbackAddress()) continue;
                    return eAddress.getAddress();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
        return InetAddress.getLocalHost().getAddress();
    }

    public static byte[] toHostMacAddress() throws SocketException, UnknownHostException {
        Enumeration<NetworkInterface> eNetworks = NetworkInterface.getNetworkInterfaces();
        while (eNetworks.hasMoreElements()) {
            NetworkInterface eNetwork = eNetworks.nextElement();
            if (eNetwork.getHardwareAddress() == null || eNetwork.getHardwareAddress().length == 0) continue;
            return eNetwork.getHardwareAddress();
        }
        return NetworkInterface.getByInetAddress(InetAddress.getLocalHost()).getHardwareAddress();
    }
}

