/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import java.io.OutputStreamWriter;
import org.fusesource.jansi.internal.WindowsSupport;
import org.refcodes.data.ConsoleDimension;
import org.refcodes.data.DaemonLoopSleepTime;
import org.refcodes.data.EnvironmentVariable;
import org.refcodes.data.SystemProperty;
import org.refcodes.exception.BugException;
import org.refcodes.numerical.NumericalUtility;
import org.refcodes.runtime.OperatingSystem;
import org.refcodes.runtime.Shell;
import org.refcodes.runtime.SystemUtility;

public enum Terminal {
    XTERM,
    CYGWIN,
    UNKNOWN;

    private static Boolean _isAnsiTerminal;
    private static Boolean _isCygwinTerminal;
    private static Integer _terminalHeight;
    private static Integer _terminalWidth;
    private static long _lastTerminalHeightUpdate;
    private static long _lastTerminalWidthUpdate;
    private static boolean _canTput;
    private static boolean _canBashTput;
    private static boolean _canModeCon;
    private static boolean _canCmdModeCon;
    private static boolean _canPowershell;
    private static boolean _canStty;
    private static boolean _canBashStty;
    private static boolean _canNativeWindows;
    private static boolean _canBashTputExe;
    private static boolean _canTputExe;
    private static boolean _canBashSttyExe;
    private static boolean _canSttyExe;
    private static final int WIDTH_ABOVE_UNREALSITIC = 1024;
    private static final int HEIGHT_ABOVE_UNREALSITIC = 256;
    private static final int PRESET_TERMINAL_HEIGHT = 25;
    private static final int PRESET_TERMINAL_WIDTH = 80;

    public static String getTerminalEncoding() {
        OutputStreamWriter theOutWriter = new OutputStreamWriter(System.out);
        return theOutWriter.getEncoding();
    }

    public static String getLineBreak() {
        String theLineBreak = SystemProperty.CONSOLE_LINE_BREAK.getValue();
        if (!(theLineBreak != null && theLineBreak.length() != 0 || (theLineBreak = EnvironmentVariable.CONSOLE_LINE_BREAK.getValue()) != null && theLineBreak.length() != 0)) {
            theLineBreak = System.lineSeparator();
        }
        if (theLineBreak == null || theLineBreak.length() == 0) {
            theLineBreak = OperatingSystem.toOperatingSystem() == OperatingSystem.WINDOWS ? "\r\n" : "\n";
        }
        return theLineBreak;
    }

    public static int getCurrentTerminalHeight() {
        return Terminal.getTerminalHeight(0);
    }

    public static int getTerminalHeight() {
        return Terminal.getTerminalHeight(-1);
    }

    public static int getTerminalHeight(int aValidityTimeMillis) {
        String theResult2;
        if (_terminalHeight != null && aValidityTimeMillis != 0 && (aValidityTimeMillis == -1 || _lastTerminalHeightUpdate + (long)aValidityTimeMillis > System.currentTimeMillis())) {
            return _terminalHeight;
        }
        int theTerminalHeight = -1;
        if ((theTerminalHeight <= 1 || theTerminalHeight > 256 || theTerminalHeight == 25) && Terminal.isCygwinTerminal()) {
            theTerminalHeight = Terminal.getNativeWindowsHeight();
            if (theTerminalHeight <= 1 || theTerminalHeight > 256 || theTerminalHeight == 25) {
                theTerminalHeight = Terminal.getTputExeHeight();
            }
            if (theTerminalHeight <= 1 || theTerminalHeight > 256 || theTerminalHeight == 25) {
                theTerminalHeight = Terminal.getSttyExeHeight();
            }
            if (theTerminalHeight <= 1 || theTerminalHeight > 256 || theTerminalHeight == 25) {
                theTerminalHeight = Terminal.getPowershellHeight();
            }
            if (theTerminalHeight <= 1 || theTerminalHeight > 256 || theTerminalHeight == 25) {
                theTerminalHeight = Terminal.getModeConHeight();
            }
        }
        if (theTerminalHeight <= 1 || theTerminalHeight > 256 || theTerminalHeight == 25) {
            OperatingSystem theOs = OperatingSystem.toOperatingSystem();
            switch (theOs) {
                case MAC: {
                    theTerminalHeight = Terminal.getNativeWindowsHeight();
                    if (theTerminalHeight <= 1 || theTerminalHeight > 256 || theTerminalHeight == 25) {
                        theTerminalHeight = Terminal.getTputHeight();
                    }
                    if (theTerminalHeight > 1 && theTerminalHeight <= 256 && theTerminalHeight != 25) break;
                    theTerminalHeight = Terminal.getSttyHeight();
                    break;
                }
                case UNIX: {
                    theTerminalHeight = Terminal.getNativeWindowsHeight();
                    if (theTerminalHeight <= 1 || theTerminalHeight > 256 || theTerminalHeight == 25) {
                        theTerminalHeight = Terminal.getTputHeight();
                    }
                    if (theTerminalHeight > 1 && theTerminalHeight <= 256 && theTerminalHeight != 25) break;
                    theTerminalHeight = Terminal.getSttyHeight();
                    break;
                }
                case UNKNOWN: {
                    theTerminalHeight = Terminal.getNativeWindowsHeight();
                    if (theTerminalHeight <= 1 || theTerminalHeight > 256 || theTerminalHeight == 25) {
                        theTerminalHeight = Terminal.getTputHeight();
                    }
                    if (theTerminalHeight <= 1 || theTerminalHeight > 256 || theTerminalHeight == 25) {
                        theTerminalHeight = Terminal.getTputExeHeight();
                    }
                    if (theTerminalHeight <= 1 || theTerminalHeight > 256 || theTerminalHeight == 25) {
                        theTerminalHeight = Terminal.getSttyHeight();
                    }
                    if (theTerminalHeight <= 1 || theTerminalHeight > 256 || theTerminalHeight == 25) {
                        theTerminalHeight = Terminal.getSttyExeHeight();
                    }
                    if (theTerminalHeight <= 1 || theTerminalHeight > 256 || theTerminalHeight == 25) {
                        theTerminalHeight = Terminal.getNativeWindowsHeight();
                    }
                    if (theTerminalHeight <= 1 || theTerminalHeight > 256 || theTerminalHeight == 25) {
                        theTerminalHeight = Terminal.getPowershellHeight();
                    }
                    if (theTerminalHeight > 1 && theTerminalHeight <= 256 && theTerminalHeight != 25) break;
                    theTerminalHeight = Terminal.getModeConHeight();
                    break;
                }
                case WINDOWS: {
                    theTerminalHeight = Terminal.getNativeWindowsHeight();
                    if (theTerminalHeight <= 1 || theTerminalHeight > 256 || theTerminalHeight == 25) {
                        theTerminalHeight = Terminal.getPowershellHeight();
                    }
                    if (theTerminalHeight > 1 && theTerminalHeight <= 256 && theTerminalHeight != 25) break;
                    theTerminalHeight = Terminal.getModeConHeight();
                    break;
                }
                default: {
                    throw new BugException("Missing case statement for <" + (Object)((Object)theOs) + "> in implementation!");
                }
            }
        }
        if (theTerminalHeight <= 1 || theTerminalHeight > 256 || theTerminalHeight == 25) {
            try {
                theResult2 = EnvironmentVariable.ANSICON.getValue();
                if (theResult2 != null && theResult2.length() != 0) {
                    theTerminalHeight = Terminal.toAnsiconHeight(theResult2);
                }
            }
            catch (Exception theResult2) {
                // empty catch block
            }
        }
        if ((theTerminalHeight <= 1 || theTerminalHeight > 256 || theTerminalHeight == 25) && (theResult2 = EnvironmentVariable.TERMINAL_HEIGHT.getValue()) != null) {
            try {
                theTerminalHeight = Integer.valueOf(theResult2.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (theTerminalHeight <= 1 || theTerminalHeight > 256 || theTerminalHeight == 25) {
            theTerminalHeight = -1;
        }
        _terminalHeight = theTerminalHeight;
        _lastTerminalHeightUpdate = System.currentTimeMillis();
        return theTerminalHeight;
    }

    public static int getCurrentTerminalWidth() {
        return Terminal.getTerminalWidth(0);
    }

    public static int getTerminalWidth() {
        return Terminal.getTerminalWidth(-1);
    }

    public static int getTerminalWidth(int aValidityTimeMillis) {
        String theResult2;
        if (_terminalWidth != null && aValidityTimeMillis != 0 && (aValidityTimeMillis == -1 || _lastTerminalWidthUpdate + (long)aValidityTimeMillis > System.currentTimeMillis())) {
            return _terminalWidth;
        }
        int theTerminalWidth = -1;
        if ((theTerminalWidth <= 1 || theTerminalWidth > 1024 || theTerminalWidth == 80) && Terminal.isCygwinTerminal()) {
            theTerminalWidth = Terminal.getNativeWindowsWidth();
            if (theTerminalWidth <= 1 || theTerminalWidth > 1024 || theTerminalWidth == 80) {
                theTerminalWidth = Terminal.getTputExeWidth();
            }
            if (theTerminalWidth <= 1 || theTerminalWidth > 1024 || theTerminalWidth == 80) {
                theTerminalWidth = Terminal.getSttyExeWidth();
            }
            if (theTerminalWidth <= 1 || theTerminalWidth > 1024 || theTerminalWidth == 80) {
                theTerminalWidth = Terminal.getModeConWidth();
            }
            if (theTerminalWidth <= 1 || theTerminalWidth > 1024 || theTerminalWidth == 80) {
                theTerminalWidth = Terminal.getPowershellWidth();
            }
        }
        if (theTerminalWidth <= 1 || theTerminalWidth > 1024 || theTerminalWidth == 80) {
            OperatingSystem theOs = OperatingSystem.toOperatingSystem();
            switch (theOs) {
                case MAC: {
                    theTerminalWidth = Terminal.getNativeWindowsWidth();
                    if (theTerminalWidth <= 1 || theTerminalWidth > 1024 || theTerminalWidth == 80) {
                        theTerminalWidth = Terminal.getTputWidth();
                    }
                    if (theTerminalWidth > 1 && theTerminalWidth <= 1024 && theTerminalWidth != 80) break;
                    theTerminalWidth = Terminal.getSttyWidth();
                    break;
                }
                case UNIX: {
                    theTerminalWidth = Terminal.getNativeWindowsWidth();
                    if (theTerminalWidth <= 1 || theTerminalWidth > 1024 || theTerminalWidth == 80) {
                        theTerminalWidth = Terminal.getTputWidth();
                    }
                    if (theTerminalWidth > 1 && theTerminalWidth <= 1024 && theTerminalWidth != 80) break;
                    theTerminalWidth = Terminal.getSttyWidth();
                    break;
                }
                case UNKNOWN: {
                    theTerminalWidth = Terminal.getNativeWindowsWidth();
                    if (theTerminalWidth <= 1 || theTerminalWidth > 1024 || theTerminalWidth == 80) {
                        theTerminalWidth = Terminal.getTputWidth();
                    }
                    if (theTerminalWidth <= 1 || theTerminalWidth > 1024 || theTerminalWidth == 80) {
                        theTerminalWidth = Terminal.getTputExeWidth();
                    }
                    if (theTerminalWidth <= 1 || theTerminalWidth > 1024 || theTerminalWidth == 80) {
                        theTerminalWidth = Terminal.getSttyWidth();
                    }
                    if (theTerminalWidth <= 1 || theTerminalWidth > 1024 || theTerminalWidth == 80) {
                        theTerminalWidth = Terminal.getSttyExeWidth();
                    }
                    if (theTerminalWidth <= 1 || theTerminalWidth > 1024 || theTerminalWidth == 80) {
                        theTerminalWidth = Terminal.getNativeWindowsWidth();
                    }
                    if (theTerminalWidth <= 1 || theTerminalWidth > 1024 || theTerminalWidth == 80) {
                        theTerminalWidth = Terminal.getPowershellWidth();
                    }
                    if (theTerminalWidth > 1 && theTerminalWidth <= 1024 && theTerminalWidth != 80) break;
                    theTerminalWidth = Terminal.getModeConWidth();
                    break;
                }
                case WINDOWS: {
                    theTerminalWidth = Terminal.getNativeWindowsWidth();
                    if (theTerminalWidth <= 1 || theTerminalWidth > 1024 || theTerminalWidth == 80) {
                        theTerminalWidth = Terminal.getPowershellWidth();
                    }
                    if (theTerminalWidth > 1 && theTerminalWidth <= 1024 && theTerminalWidth != 80) break;
                    theTerminalWidth = Terminal.getModeConWidth();
                    break;
                }
                default: {
                    throw new BugException("Missing case statement for <" + (Object)((Object)theOs) + "> in implementation!");
                }
            }
        }
        if (theTerminalWidth <= 1 || theTerminalWidth > 1024 || theTerminalWidth == 80) {
            try {
                theResult2 = EnvironmentVariable.ANSICON.getValue();
                if (theResult2 != null && theResult2.length() != 0) {
                    theTerminalWidth = Terminal.toAnsiconWidth(theResult2);
                }
            }
            catch (Exception theResult2) {
                // empty catch block
            }
        }
        if ((theTerminalWidth <= 1 || theTerminalWidth > 1024 || theTerminalWidth == 80) && (theResult2 = EnvironmentVariable.TERMINAL_WIDTH.getValue()) != null) {
            try {
                theTerminalWidth = Integer.valueOf(theResult2.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (theTerminalWidth <= 1 || theTerminalWidth > 1024) {
            theTerminalWidth = -1;
        }
        _terminalWidth = theTerminalWidth;
        _lastTerminalWidthUpdate = System.currentTimeMillis();
        return theTerminalWidth;
    }

    public static boolean isAnsiTerminal() {
        if (_isAnsiTerminal != null) {
            return _isAnsiTerminal;
        }
        String theAnsicon = EnvironmentVariable.ANSICON.getValue();
        if (theAnsicon != null && theAnsicon.length() != 0) {
            _isAnsiTerminal = true;
        } else if (Terminal.isCygwinTerminal()) {
            _isAnsiTerminal = true;
        } else if (Shell.toShell() == Shell.POWER_SHELL) {
            _isAnsiTerminal = true;
        } else if (Shell.toShell() == Shell.WIN_CMD) {
            _isAnsiTerminal = true;
        } else {
            int theColors;
            String theRersult;
            if (_canTput) {
                try {
                    theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getMilliseconds(), "tput colors");
                    if (theRersult != null && (theColors = Integer.parseInt(theRersult.trim())) > 4) {
                        _isAnsiTerminal = true;
                    }
                }
                catch (Exception ignore) {
                    _canTput = false;
                }
            }
            if (_isAnsiTerminal == null && _canBashTput) {
                try {
                    theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getMilliseconds(), "bash", "-c", "tput colors");
                    if (theRersult != null && (theColors = Integer.parseInt(theRersult.trim())) > 4) {
                        _isAnsiTerminal = true;
                    }
                }
                catch (Exception ignore) {
                    _canBashTput = false;
                }
            }
        }
        if (_isAnsiTerminal == null) {
            _isAnsiTerminal = false;
        }
        return _isAnsiTerminal;
    }

    public static boolean isAnsiTerminalPreferred() {
        String theResult = SystemUtility.toPropertyValue(SystemProperty.CONSOLE_ANSI, EnvironmentVariable.CONSOLE_ANSI, EnvironmentVariable.CONSOLE_CONEMU_ANSI);
        if (theResult != null) {
            try {
                return NumericalUtility.toBoolean((String)theResult.toString());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return Terminal.isAnsiTerminal();
    }

    static boolean isCygwinTerminal() {
        if (_isCygwinTerminal != null) {
            return _isCygwinTerminal;
        }
        _isCygwinTerminal = false;
        if (OperatingSystem.toOperatingSystem() == OperatingSystem.WINDOWS && "cygwin".equalsIgnoreCase(EnvironmentVariable.TERM.getValue())) {
            _isCygwinTerminal = true;
        }
        return _isCygwinTerminal;
    }

    public static boolean isCurrentlyLineBreakRequired(int aRowWidth) {
        return Terminal.isLineBreakRequired(aRowWidth, 0);
    }

    public static boolean isLineBreakRequired(int aRowWidth) {
        return Terminal.isLineBreakRequired(aRowWidth, -1);
    }

    public static boolean isLineBreakRequired(int aRowWidth, int aValidityTimeMillis) {
        int theWidth = Terminal.getTerminalWidth(aValidityTimeMillis);
        return OperatingSystem.toOperatingSystem() != OperatingSystem.WINDOWS || Terminal.getTerminalHeight(aValidityTimeMillis) <= 0 || theWidth == 80 || aRowWidth != theWidth;
    }

    public static int toPreferredTerminalHeight() {
        int theConsoleHeight = Terminal.getTerminalHeight();
        int theHeight = -1;
        String theResult = SystemUtility.toPropertyValue(SystemProperty.CONSOLE_HEIGHT, EnvironmentVariable.CONSOLE_HEIGHT);
        if (theResult != null) {
            try {
                theHeight = Integer.valueOf(theResult.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (theHeight <= 1) {
            theHeight = theConsoleHeight;
        }
        if (theHeight < ConsoleDimension.MIN_HEIGHT.getValue() || theHeight > 256) {
            theHeight = ConsoleDimension.MIN_HEIGHT.getValue();
        }
        return theHeight;
    }

    public static int toPreferredTerminalWidth() {
        int theConsoleWidth = Terminal.getTerminalWidth();
        int theWidth = -1;
        String theResult = SystemUtility.toPropertyValue(SystemProperty.CONSOLE_WIDTH, EnvironmentVariable.CONSOLE_WIDTH);
        if (theResult != null) {
            try {
                theWidth = Integer.valueOf(theResult.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (theWidth <= 1) {
            theWidth = theConsoleWidth;
        }
        if (theWidth < ConsoleDimension.MIN_WIDTH.getValue() || theWidth > 1024) {
            theWidth = ConsoleDimension.MIN_WIDTH.getValue();
        }
        return theWidth;
    }

    public static String toLineBreak(int aRowWidth) {
        if (Terminal.isLineBreakRequired(aRowWidth)) {
            return Terminal.getLineBreak();
        }
        return "\r";
    }

    public static Terminal toTerminal() {
        String theTerminal = EnvironmentVariable.TERM.getValue();
        if (theTerminal != null) {
            if ((theTerminal = theTerminal.toLowerCase()).indexOf("cygwin") >= 0) {
                return CYGWIN;
            }
            if (theTerminal.indexOf("xterm") >= 0) {
                return XTERM;
            }
        }
        return UNKNOWN;
    }

    private static int getNativeWindowsWidth() {
        if (_canNativeWindows) {
            try {
                return WindowsSupport.getWindowsTerminalWidth();
            }
            catch (Error ignore) {
                _canNativeWindows = false;
            }
        }
        return -1;
    }

    private static int getNativeWindowsHeight() {
        if (_canNativeWindows) {
            try {
                return WindowsSupport.getWindowsTerminalHeight();
            }
            catch (Error ignore) {
                _canNativeWindows = false;
            }
        }
        return -1;
    }

    private static int getModeConHeight() {
        if (_canModeCon) {
            try {
                String theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getMilliseconds(), "mode.com con");
                return Terminal.toModeConHeight(theRersult);
            }
            catch (Exception ignore) {
                _canModeCon = false;
            }
        }
        if (_canCmdModeCon) {
            try {
                String theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getMilliseconds(), "cmd.exe", "/c", "mode con");
                return Terminal.toModeConHeight(theRersult);
            }
            catch (Exception ignore) {
                _canCmdModeCon = false;
            }
        }
        return -1;
    }

    private static int getModeConWidth() {
        if (_canModeCon) {
            try {
                String theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getMilliseconds(), "mode.com con");
                return Terminal.toModeConWidth(theRersult);
            }
            catch (Exception ignore) {
                _canModeCon = false;
            }
        }
        if (_canCmdModeCon) {
            try {
                String theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getMilliseconds(), "cmd.exe", "/c", "mode con");
                return Terminal.toModeConWidth(theRersult);
            }
            catch (Exception ignore) {
                _canCmdModeCon = false;
            }
        }
        return -1;
    }

    private static int getPowershellHeight() {
        if (_canPowershell) {
            try {
                String theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getMilliseconds(), "powershell.exe", "/c", "$host.UI.RawUI.WindowSize.Height");
                if (theRersult != null) {
                    return Integer.parseInt(theRersult.trim());
                }
            }
            catch (Exception ignore) {
                _canPowershell = false;
            }
        }
        return -1;
    }

    private static int getPowershellWidth() {
        if (_canPowershell) {
            try {
                String theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getMilliseconds(), "powershell.exe", "/c", "$host.UI.RawUI.WindowSize.Width");
                if (theRersult != null) {
                    return Integer.parseInt(theRersult.trim());
                }
            }
            catch (Exception ignore) {
                _canPowershell = false;
            }
        }
        return -1;
    }

    private static int getSttyHeight() {
        String[] theSize;
        String theRersult;
        if (_canStty) {
            try {
                theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getMilliseconds(), "stty size");
                if (theRersult != null && (theSize = theRersult.trim().split(" ")).length == 2) {
                    return Integer.parseInt(theSize[0]);
                }
            }
            catch (Exception ignore) {
                _canStty = false;
            }
        }
        if (_canBashStty) {
            try {
                theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getMilliseconds(), "bash", "-c", "stty size");
                if (theRersult != null && (theSize = theRersult.trim().split(" ")).length == 2) {
                    return Integer.parseInt(theSize[0]);
                }
            }
            catch (Exception ignore) {
                _canBashStty = false;
            }
        }
        return -1;
    }

    private static int getSttyWidth() {
        String[] theSize;
        String theRersult;
        if (_canStty) {
            try {
                theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getMilliseconds(), "stty size");
                if (theRersult != null && (theSize = theRersult.trim().split(" ")).length == 2) {
                    return Integer.parseInt(theSize[1]);
                }
            }
            catch (Exception ignore) {
                _canStty = false;
            }
        }
        if (_canBashStty) {
            try {
                theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getMilliseconds(), "bash", "-c", "stty size");
                if (theRersult != null && (theSize = theRersult.trim().split(" ")).length == 2) {
                    return Integer.parseInt(theSize[1]);
                }
            }
            catch (Exception ignore) {
                _canBashStty = false;
            }
        }
        return -1;
    }

    private static int getSttyExeHeight() {
        String[] theSize;
        String theRersult;
        if (_canSttyExe) {
            try {
                theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getMilliseconds(), "stty.exe size");
                if (theRersult != null && (theSize = theRersult.trim().split(" ")).length == 2) {
                    return Integer.parseInt(theSize[0]);
                }
            }
            catch (Exception ignore) {
                _canSttyExe = false;
            }
        }
        if (_canBashSttyExe) {
            try {
                theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getMilliseconds(), "bash.exe", "-c", "stty size");
                if (theRersult != null && (theSize = theRersult.trim().split(" ")).length == 2) {
                    return Integer.parseInt(theSize[0]);
                }
            }
            catch (Exception ignore) {
                _canBashSttyExe = false;
            }
        }
        return -1;
    }

    private static int getSttyExeWidth() {
        String[] theSize;
        String theRersult;
        if (_canSttyExe) {
            try {
                theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getMilliseconds(), "stty.exe size");
                if (theRersult != null && (theSize = theRersult.trim().split(" ")).length == 2) {
                    return Integer.parseInt(theSize[1]);
                }
            }
            catch (Exception ignore) {
                _canSttyExe = false;
            }
        }
        if (_canBashSttyExe) {
            try {
                theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getMilliseconds(), "bash.exe", "-c", "stty size");
                if (theRersult != null && (theSize = theRersult.trim().split(" ")).length == 2) {
                    return Integer.parseInt(theSize[1]);
                }
            }
            catch (Exception ignore) {
                _canBashSttyExe = false;
            }
        }
        return -1;
    }

    private static int getTputHeight() {
        String theRersult;
        if (_canTput) {
            try {
                theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getMilliseconds(), "tput lines");
                if (theRersult != null) {
                    return Integer.parseInt(theRersult.trim());
                }
            }
            catch (Exception ignore) {
                _canTput = false;
            }
        }
        if (_canBashTput) {
            try {
                theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getMilliseconds(), "bash", "-c", "tput lines");
                if (theRersult != null) {
                    return Integer.parseInt(theRersult.trim());
                }
            }
            catch (Exception ignore) {
                _canBashTput = false;
            }
        }
        return -1;
    }

    private static int getTputWidth() {
        String theRersult;
        if (_canTput) {
            try {
                theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getMilliseconds(), "tput cols");
                if (theRersult != null) {
                    return Integer.parseInt(theRersult.trim());
                }
            }
            catch (Exception ignore) {
                _canTput = false;
            }
        }
        if (_canBashTput) {
            try {
                theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getMilliseconds(), "bash", "-c", "tput cols");
                if (theRersult != null) {
                    return Integer.parseInt(theRersult.trim());
                }
            }
            catch (Exception ignore) {
                _canBashTput = false;
            }
        }
        return -1;
    }

    private static int getTputExeHeight() {
        String theRersult;
        if (_canTputExe) {
            try {
                theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getMilliseconds(), "tput.exe lines");
                if (theRersult != null) {
                    return Integer.parseInt(theRersult.trim());
                }
            }
            catch (Exception ignore) {
                _canTputExe = false;
            }
        }
        if (_canBashTputExe) {
            try {
                theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getMilliseconds(), "bash.exe", "-c", "tput lines");
                if (theRersult != null) {
                    return Integer.parseInt(theRersult.trim());
                }
            }
            catch (Exception ignore) {
                _canBashTputExe = false;
            }
        }
        return -1;
    }

    private static int getTputExeWidth() {
        String theRersult;
        if (_canTputExe) {
            try {
                theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getMilliseconds(), "tput.exe cols");
                if (theRersult != null) {
                    return Integer.parseInt(theRersult.trim());
                }
            }
            catch (Exception ignore) {
                _canTputExe = false;
            }
        }
        if (_canBashTputExe) {
            try {
                theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getMilliseconds(), "bash.exe", "-c", "tput cols");
                if (theRersult != null) {
                    return Integer.parseInt(theRersult.trim());
                }
            }
            catch (Exception ignore) {
                _canBashTputExe = false;
            }
        }
        return -1;
    }

    static int toAnsiconHeight(String aAnsiconEnvVarValue) throws NumberFormatException {
        int index = aAnsiconEnvVarValue.lastIndexOf("x");
        if (index != -1 && aAnsiconEnvVarValue.length() > index + 1) {
            if ((aAnsiconEnvVarValue = aAnsiconEnvVarValue.substring(index + 1)).length() != 0 && aAnsiconEnvVarValue.endsWith(")")) {
                aAnsiconEnvVarValue = aAnsiconEnvVarValue.substring(0, aAnsiconEnvVarValue.length() - 1);
            }
            return Integer.valueOf(aAnsiconEnvVarValue.toString());
        }
        throw new NumberFormatException("Cannot extract width from ANSICON formatted value <" + aAnsiconEnvVarValue + ">.");
    }

    static int toAnsiconWidth(String aAnsiconEnvVarValue) throws NumberFormatException {
        int index = aAnsiconEnvVarValue.indexOf("x");
        if (index != -1) {
            aAnsiconEnvVarValue = aAnsiconEnvVarValue.substring(0, index);
            return Integer.valueOf(aAnsiconEnvVarValue.toString());
        }
        throw new NumberFormatException("Cannot extract width from ANSICON formatted value <" + aAnsiconEnvVarValue + ">.");
    }

    static int toModeConHeight(String aModeConOutput) throws NumberFormatException {
        return Terminal.toModeConValue(aModeConOutput, 3);
    }

    static int toModeConValue(String aModeConOutput, int aValueIndex) throws NumberFormatException {
        try {
            int i;
            int index = 0;
            for (i = 0; i < aValueIndex - 1; ++i) {
                index = aModeConOutput.indexOf(58);
                if (index == -1 || index == aModeConOutput.length() - 1) {
                    return -1;
                }
                aModeConOutput = aModeConOutput.substring(index + 1);
            }
            aModeConOutput = aModeConOutput.trim();
            index = -1;
            i = 0;
            while (i < aModeConOutput.length() && Character.isDigit(aModeConOutput.charAt(i))) {
                index = i++;
            }
            if (index == -1) {
                return -1;
            }
            aModeConOutput = aModeConOutput.substring(0, index + 1);
            int theValue = Integer.parseInt(aModeConOutput);
            return theValue;
        }
        catch (Exception exception) {
            throw new NumberFormatException("Cannot extract the value from \"mode con\" formatted value <" + aModeConOutput + "> for row <" + aValueIndex + ">.");
        }
    }

    static int toModeConWidth(String aModeConOutput) throws NumberFormatException {
        return Terminal.toModeConValue(aModeConOutput, 4);
    }

    static {
        _isAnsiTerminal = null;
        _isCygwinTerminal = null;
        _terminalHeight = null;
        _terminalWidth = null;
        _lastTerminalHeightUpdate = -1L;
        _lastTerminalWidthUpdate = -1L;
        _canTput = true;
        _canBashTput = true;
        _canModeCon = true;
        _canCmdModeCon = true;
        _canPowershell = true;
        _canStty = true;
        _canBashStty = true;
        _canNativeWindows = true;
        _canBashTputExe = true;
        _canTputExe = true;
        _canBashSttyExe = true;
        _canSttyExe = true;
    }
}

