// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.runtime;

import java.util.Map;

import org.refcodes.mixin.ObjectAccessor.ObjectBuilder;
import org.refcodes.mixin.ObjectAccessor.ObjectProperty;

/**
 * The {@link DumpBuilder} assists you in inspecting the content of an object.
 * Creates a {@link Map} containing the dump of an object's the member
 * variable's values, the names being the keys and the values being the member
 * variables' values.
 */
public interface DumpBuilder extends ObjectProperty, ObjectBuilder<DumpBuilder> {

	/**
	 * Dumps the state of the contained object (as of
	 * {@link #setObject(Object)}) into a {@link Map} which is returned as
	 * result.
	 * 
	 * @return The {@link Map} with the dumped properties of the implementing
	 *         instance.
	 */
	default Map<String, String> toDump() {
		return toDump( getObject() );
	}

	/**
	 * Dumps the state of the provided object into a {@link Map} which is
	 * returned as result.
	 * 
	 * @param aObj The object for which to create the dump.
	 * 
	 * @return The {@link Map} with the dumped properties of the implementing
	 *         instance.
	 */
	Map<String, String> toDump( Object aObj );
}
