// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.runtime;

import org.refcodes.data.SystemProperty;

/**
 * Enumeration with the (supported) operating systems.
 *
 * @author steiner
 */
public enum OperatingSystem {
	/** Unix / Linux / BSD like operating system. */
	UNIX,

	WINDOWS,

	MAC,
	/**
	 * Unknown operating system.
	 */
	UNKNOWN;
	/**
	 * Determines the operating system your application is currently running on.
	 * 
	 * @return The {@link OperatingSystem} being detected.
	 */
	public static OperatingSystem toOperatingSystem() {
		String theOperationSystem = SystemProperty.OPERATING_SYSTEM_NAME.getValue();
		if ( theOperationSystem != null ) {
			theOperationSystem = theOperationSystem.toLowerCase();
			if ( theOperationSystem.indexOf( "win" ) >= 0 ) {
				return OperatingSystem.WINDOWS;
			}
			if ( theOperationSystem.indexOf( "mac" ) >= 0 ) {
				return OperatingSystem.MAC;
			}
			if ( theOperationSystem.indexOf( "linux" ) >= 0 ) {
				return OperatingSystem.UNIX;
			}
			if ( theOperationSystem.indexOf( "sunos" ) >= 0 ) {
				return OperatingSystem.UNIX;
			}
			if ( theOperationSystem.indexOf( "aix" ) >= 0 ) {
				return OperatingSystem.UNIX;
			}
			if ( theOperationSystem.indexOf( "nix" ) >= 0 ) {
				return OperatingSystem.UNIX;
			}
		}
		return OperatingSystem.UNKNOWN;
	}
}