// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.runtime;

import org.refcodes.data.EnvironmentProperty;

/**
 * Enumeration with the (relevant) terminals.
 *
 * @author steiner
 */
public enum Terminal {

	XTERM,

	CYGWIN,
	/**
	 * Unknown terminal.
	 */
	UNKNOWN;
	/**
	 * Determines the terminal your application is currently in.
	 * 
	 * @return The {@link Terminal} being detected.
	 */
	public static Terminal toTerminal() {
		String theTerminal = EnvironmentProperty.TERM.getValue();
		if ( theTerminal != null ) {
			theTerminal = theTerminal.toLowerCase();
			if ( theTerminal.indexOf( "cygwin" ) >= 0 ) {
				return Terminal.CYGWIN;
			}
			if ( theTerminal.indexOf( "xterm" ) >= 0 ) {
				return XTERM;
			}
		}
		return Terminal.UNKNOWN;
	}
}