/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import org.refcodes.data.Delimiter;
import org.refcodes.data.Literal;
import org.refcodes.generator.Generator;
import org.refcodes.generator.UniqueIdGenerator;
import org.refcodes.mixin.IdAccessor;

public enum Correlation implements IdAccessor.IdProperty<String>
{
    REQUEST(8),
    SESSION(8);

    private ThreadLocal<String> _correlationId = new ThreadLocal();
    private Generator<String> _generator;

    private Correlation(int aIdlength) {
        this._generator = new UniqueIdGenerator(aIdlength);
    }

    public void setId(String aCorrelationId) {
        this._correlationId.set(aCorrelationId);
    }

    public String getId() {
        return this._correlationId.get();
    }

    public String pullId() {
        String theId = this._correlationId.get();
        if (theId == null) {
            theId = (String)this._generator.next();
            this._correlationId.set(theId);
        }
        return theId;
    }

    public String nextId() {
        String theNext = (String)this._generator.next();
        this._correlationId.set(theNext);
        return theNext;
    }

    public static String toFullCorrelationId() {
        String theFullCorrelationId = "";
        Correlation[] correlations = Correlation.values();
        int i = correlations.length - 1;
        while (i >= 0) {
            String eId;
            if (theFullCorrelationId.length() != 0) {
                theFullCorrelationId = String.valueOf(theFullCorrelationId) + Delimiter.CORRELATION_ID.getChar();
            }
            if ((eId = correlations[i].getId()) == null) {
                eId = Literal.UNKNOWN.getValue();
            }
            theFullCorrelationId = String.valueOf(theFullCorrelationId) + eId;
            --i;
        }
        return theFullCorrelationId;
    }

    public static boolean hasAnyCorrelationId() {
        Correlation[] correlationArray = Correlation.values();
        int n = correlationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Correlation aCorrelation = correlationArray[n2];
            if (aCorrelation.getId() != null) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

