/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import org.refcodes.data.SystemProperty;

public enum OperatingSystem {
    UNIX(SystemProperty.OPERATING_SYSTEM_NAME.getValue()),
    WINDOWS(SystemProperty.OPERATING_SYSTEM_NAME.getValue()),
    MAC(SystemProperty.OPERATING_SYSTEM_NAME.getValue()),
    UNKNOWN(null);

    private String _version = SystemProperty.OPERATING_SYSTEM_VERSION.getValue();

    private OperatingSystem(String aName) {
        if (aName != null && (this._version == null || this._version.length() == 0)) {
            int i = 0;
            while (i < aName.length()) {
                if (Character.isDigit(aName.charAt(i)) || aName.charAt(i) == '.') {
                    this._version = String.valueOf(this._version) + aName.charAt(i);
                }
                ++i;
            }
        }
    }

    public static OperatingSystem toOperatingSystem() {
        String theOperationSystem = SystemProperty.OPERATING_SYSTEM_NAME.getValue();
        if (theOperationSystem != null) {
            if ((theOperationSystem = theOperationSystem.toLowerCase()).indexOf("win") >= 0) {
                return WINDOWS;
            }
            if (theOperationSystem.indexOf("mac") >= 0) {
                return MAC;
            }
            if (theOperationSystem.indexOf("linux") >= 0) {
                return UNIX;
            }
            if (theOperationSystem.indexOf("sunos") >= 0) {
                return UNIX;
            }
            if (theOperationSystem.indexOf("aix") >= 0) {
                return UNIX;
            }
            if (theOperationSystem.indexOf("nix") >= 0) {
                return UNIX;
            }
        }
        return UNKNOWN;
    }

    public String getVersion() {
        if (this == OperatingSystem.toOperatingSystem()) {
            return this._version;
        }
        return null;
    }
}

