/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;
import org.refcodes.mixin.ResultAccessor;

public class ProcessResult
implements ResultAccessor<String, RuntimeException> {
    private String _result;

    public ProcessResult(Process aProcess) throws IOException {
        try {
            aProcess.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this._result = this.toResult(aProcess);
    }

    public ProcessResult(Process aProcess, int aTimeoutMillis) throws InterruptedException, IOException {
        if (aTimeoutMillis != -1) {
            aProcess.waitFor(aTimeoutMillis, TimeUnit.MILLISECONDS);
            if (aProcess.isAlive()) {
                try {
                    aProcess.destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new InterruptedException("Killed process <" + aProcess.toString() + ">!");
            }
        } else {
            aProcess.waitFor();
        }
        this._result = this.toResult(aProcess);
    }

    public String getResult() {
        return this._result;
    }

    public boolean hasResult() {
        return this._result != null;
    }

    public String toString() {
        return this._result;
    }

    private String toResult(Process aProcess) throws IOException {
        StringBuilder theErrBuilder;
        try {
            StringBuilder theOutBuilder = new StringBuilder();
            Throwable throwable = null;
            Object var4_7 = null;
            try (BufferedReader theOutReader = new BufferedReader(new InputStreamReader(aProcess.getInputStream()));){
                String eLine;
                while ((eLine = theOutReader.readLine()) != null) {
                    theOutBuilder.append(eLine);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return theOutBuilder.toString();
        }
        catch (IOException e) {
            theErrBuilder = new StringBuilder();
            try {
                Throwable throwable = null;
                Object var5_13 = null;
                try (BufferedReader theErrReader = new BufferedReader(new InputStreamReader(aProcess.getInputStream()));){
                    if (theErrReader != null) {
                        String eErr;
                        while ((eErr = theErrReader.readLine()) != null) {
                            theErrBuilder.append(eErr);
                        }
                        theErrReader.close();
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (theErrBuilder.length() != 0) {
            throw new IOException(theErrBuilder.toString(), e);
        }
        throw e;
    }
}

