/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.refcodes.struct.Attribute;
import org.refcodes.struct.AttributeImpl;

public final class ReflectionUtility {
    public static final String ALIAS_SET = "set";
    public static final String ALIAS_GET = "get";
    public static final String ALIAS_HAS = "has";
    public static final String ALIAS_IS = "is";
    public static final String ALIAS_TOSTRING = "toString";
    public static final NonExistingValueClass NON_EXISTING_VALUE = new NonExistingValueClass();

    private ReflectionUtility() {
    }

    public static Set<Annotation> annotations(Class<?> aClass) {
        return ReflectionUtility.annotations(aClass.getAnnotations(), new HashSet<Annotation>());
    }

    public static Set<Annotation> annotations(Field aField) {
        return ReflectionUtility.annotations(aField.getAnnotations(), new HashSet<Annotation>());
    }

    public static Set<Annotation> annotations(Method aMethod) {
        return ReflectionUtility.annotations(aMethod.getAnnotations(), new HashSet<Annotation>());
    }

    public static Set<Annotation> annotations(Object aObj) {
        return ReflectionUtility.annotations(aObj.getClass().getAnnotations(), new HashSet<Annotation>());
    }

    public static Annotation findAnnotation(Class<? extends Annotation> aAnnotation, Class<?> aClass) {
        return ReflectionUtility.findAnnotation(aAnnotation, aClass.getAnnotations(), new HashSet<Annotation>());
    }

    public static Annotation findAnnotation(Class<? extends Annotation> aAnnotation, Field aField) {
        return ReflectionUtility.findAnnotation(aAnnotation, aField.getAnnotations(), new HashSet<Annotation>());
    }

    public static Annotation findAnnotation(Class<? extends Annotation> aAnnotation, Method aMethod) {
        return ReflectionUtility.findAnnotation(aAnnotation, aMethod.getAnnotations(), new HashSet<Annotation>());
    }

    public static Annotation findAnnotation(Class<? extends Annotation> aAnnotation, Object aObj) {
        return ReflectionUtility.findAnnotation(aAnnotation, aObj.getClass().getAnnotations(), new HashSet<Annotation>());
    }

    public static boolean hasAnnotation(Class<? extends Annotation> aAnnotation, Class<?> aClass) {
        return ReflectionUtility.hasAnnotation(aAnnotation, aClass.getAnnotations(), new HashSet<Annotation>());
    }

    public static boolean hasAnnotation(Class<? extends Annotation> aAnnotation, Field aField) {
        return ReflectionUtility.hasAnnotation(aAnnotation, aField.getAnnotations(), new HashSet<Annotation>());
    }

    public static boolean hasAnnotation(Class<? extends Annotation> aAnnotation, Method aMethod) {
        return ReflectionUtility.hasAnnotation(aAnnotation, aMethod.getAnnotations(), new HashSet<Annotation>());
    }

    public static boolean hasAnnotation(Class<? extends Annotation> aAnnotation, Object aObj) {
        return ReflectionUtility.hasAnnotation(aAnnotation, aObj.getClass().getAnnotations(), new HashSet<Annotation>());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasGetterAttribute(Object anObject, String anAttributeName, Class<?> aReturnType) {
        Method[] theMethodArray = anObject.getClass().getMethods();
        try {
            int i = 0;
            while (true) {
                if (i >= theMethodArray.length) {
                    return false;
                }
                if (theMethodArray[i].getParameterTypes().length == 0 && theMethodArray[i].getReturnType().equals(aReturnType)) {
                    String theMethodName = theMethodArray[i].getName();
                    if ((theMethodArray[i].getModifiers() == 1 || theMethodArray[i].getModifiers() == 9) && (theMethodName.indexOf(ALIAS_GET) == 0 && Character.isUpperCase(theMethodName.charAt(ALIAS_GET.length())) ? anAttributeName.equalsIgnoreCase(theMethodName = theMethodName.substring(ALIAS_GET.length(), theMethodName.length())) : (theMethodName.indexOf(ALIAS_HAS) == 0 && Character.isUpperCase(theMethodName.charAt(ALIAS_HAS.length())) ? anAttributeName.equalsIgnoreCase(theMethodName = theMethodName.substring(ALIAS_HAS.length(), theMethodName.length())) : (theMethodName.indexOf(ALIAS_IS) == 0 && Character.isUpperCase(theMethodName.charAt(ALIAS_IS.length())) ? anAttributeName.equalsIgnoreCase(theMethodName = theMethodName.substring(ALIAS_IS.length(), theMethodName.length())) : theMethodName.indexOf(ALIAS_TOSTRING) == 0 && Character.isUpperCase(theMethodName.charAt(ALIAS_TOSTRING.length())) && anAttributeName.equalsIgnoreCase(theMethodName = theMethodName.substring(ALIAS_TOSTRING.length(), theMethodName.length())))))) {
                        return true;
                    }
                }
                ++i;
            }
        }
        catch (Exception exc) {
            System.err.println("ReflectionUtility.setAttribute(): Caught an exception of aClass <" + exc.getClass().getName() + "> with message = " + exc.getMessage() + ".");
            exc.printStackTrace();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasSetterAttribute(Object anObject, String anAttributeName, Class<?> anAttributeType) {
        Method[] theMethodArray = anObject.getClass().getMethods();
        try {
            int i = 0;
            while (true) {
                if (i >= theMethodArray.length) {
                    return false;
                }
                if (theMethodArray[i].getParameterTypes().length == 1 && theMethodArray[i].getParameterTypes()[0].isAssignableFrom(anAttributeType) && theMethodArray[i].getReturnType().equals(Void.TYPE)) {
                    String theMethodName = theMethodArray[i].getName();
                    if ((theMethodArray[i].getModifiers() == 1 || theMethodArray[i].getModifiers() == 9) && theMethodName.indexOf(ALIAS_SET) == 0 && Character.isUpperCase(theMethodName.charAt(ALIAS_SET.length())) && anAttributeName.equalsIgnoreCase(theMethodName = theMethodName.substring(ALIAS_SET.length(), theMethodName.length()))) {
                        return true;
                    }
                }
                ++i;
            }
        }
        catch (Exception exc) {
            System.err.println("ReflectionUtility.setAttribute(): Caught an exception of aClass <" + exc.getClass().getName() + "> with message = " + exc.getMessage() + ".");
            exc.printStackTrace();
        }
        return false;
    }

    public static void setAttribute(Object anObject, Attribute anAttributeValueStruct) throws NoSuchMethodException {
        ReflectionUtility.setAttribute(anObject, (String)anAttributeValueStruct.getKey(), anAttributeValueStruct.getValue());
    }

    public static void setAttribute(Object anObject, String anAttributeName, Object anAttributeValue) throws NoSuchMethodException {
        boolean isCalled = false;
        Method[] theMethodArray = anObject.getClass().getMethods();
        try {
            int i = 0;
            while (i < theMethodArray.length) {
                if (theMethodArray[i].getParameterTypes().length == 1 && theMethodArray[i].getParameterTypes()[0].isAssignableFrom(anAttributeValue.getClass()) && theMethodArray[i].getReturnType().equals(Void.TYPE)) {
                    String theMethodName = theMethodArray[i].getName();
                    if ((theMethodArray[i].getModifiers() == 1 || theMethodArray[i].getModifiers() == 9) && theMethodName.indexOf(ALIAS_SET) == 0 && Character.isUpperCase(theMethodName.charAt(ALIAS_SET.length())) && anAttributeName.equalsIgnoreCase(theMethodName = theMethodName.substring(ALIAS_SET.length(), theMethodName.length()))) {
                        try {
                            theMethodArray[i].invoke(anObject, anAttributeValue);
                            isCalled = true;
                        }
                        catch (Exception e) {
                            System.err.println("ReflectionUtility.setAttribute(): Caught an exception of aClass <" + e.getClass().getName() + "> while invoking the method <" + theMethodName + "> with message = " + e.getMessage() + ".");
                            e.printStackTrace();
                        }
                        break;
                    }
                }
                ++i;
            }
        }
        catch (Exception exc) {
            System.err.println("ReflectionUtility.setAttribute(): Caught an exception of aClass <" + exc.getClass().getName() + "> with message = " + exc.getMessage() + ".");
            exc.printStackTrace();
        }
        if (!isCalled) {
            throw new NoSuchMethodException("ReflectionUtility.setAttribute(): The method for the attribute <" + anAttributeName + "> for the class <" + anObject.getClass().getName() + "> cannot be found.");
        }
    }

    public static Attribute[] toBeanAttributes(Object anObject) {
        ArrayList<AttributeImpl> theAttributeValueStructList = new ArrayList<AttributeImpl>();
        Method[] theMethodArray = anObject.getClass().getMethods();
        try {
            int i = 0;
            while (i < theMethodArray.length) {
                if (theMethodArray[i].getParameterTypes().length == 0 && !theMethodArray[i].getReturnType().equals(Void.TYPE)) {
                    boolean isBeanMethod = false;
                    Object eInvokeReturn = NON_EXISTING_VALUE;
                    String eMethodName = theMethodArray[i].getName();
                    if (theMethodArray[i].getModifiers() == 1 || theMethodArray[i].getModifiers() == 9) {
                        if (eMethodName.indexOf(ALIAS_GET) == 0 && Character.isUpperCase(eMethodName.charAt(ALIAS_GET.length()))) {
                            isBeanMethod = true;
                            eMethodName = eMethodName.substring(ALIAS_GET.length(), eMethodName.length());
                        } else if (eMethodName.indexOf(ALIAS_HAS) == 0 && Character.isUpperCase(eMethodName.charAt(ALIAS_HAS.length()))) {
                            isBeanMethod = true;
                            eMethodName = eMethodName.substring(ALIAS_HAS.length(), eMethodName.length());
                        } else if (eMethodName.indexOf(ALIAS_IS) == 0 && Character.isUpperCase(eMethodName.charAt(ALIAS_IS.length()))) {
                            isBeanMethod = true;
                            eMethodName = eMethodName.substring(ALIAS_IS.length(), eMethodName.length());
                        } else if (eMethodName.equals(ALIAS_TOSTRING)) {
                            isBeanMethod = true;
                        }
                        if (isBeanMethod) {
                            try {
                                eInvokeReturn = theMethodArray[i].invoke(anObject, new Object[0]);
                            }
                            catch (Exception e) {
                                System.err.println("ReflectionUtility.setAttribute(): Caught an exception of aClass <" + e.getClass().getName() + "> while invoking the method <" + eMethodName + "> with message = " + e.getMessage() + ".");
                                e.printStackTrace();
                            }
                            theAttributeValueStructList.add(new AttributeImpl(eMethodName, eInvokeReturn));
                        }
                    }
                }
                ++i;
            }
        }
        catch (Exception exc) {
            System.err.println("ReflectionUtility.setAttribute(): Caught an exception of aClass <" + exc.getClass().getName() + "> with message = " + exc.getMessage() + ".");
            exc.printStackTrace();
        }
        return (Attribute[])theAttributeValueStructList.toArray(new AttributeImpl[theAttributeValueStructList.size()]);
    }

    private static Set<Annotation> annotations(Annotation[] aAnnotations, Set<Annotation> aVisted) {
        Annotation[] annotationArray = aAnnotations;
        int n = aAnnotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation eAnno = annotationArray[n2];
            if (!aVisted.contains(eAnno)) {
                aVisted.add(eAnno);
                ReflectionUtility.annotations(eAnno.annotationType().getAnnotations(), aVisted);
            }
            ++n2;
        }
        return aVisted;
    }

    private static Annotation findAnnotation(Class<? extends Annotation> aAnnotation, Annotation[] aAnnotations, Set<Annotation> aVisted) {
        Annotation[] annotationArray = aAnnotations;
        int n = aAnnotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation eAnno = annotationArray[n2];
            if (!aVisted.contains(eAnno)) {
                if (aAnnotation.isAssignableFrom(eAnno.getClass())) {
                    return eAnno;
                }
                aVisted.add(eAnno);
                Annotation result = ReflectionUtility.findAnnotation(aAnnotation, eAnno.annotationType().getAnnotations(), aVisted);
                if (result != null) {
                    return result;
                }
            }
            ++n2;
        }
        return null;
    }

    private static boolean hasAnnotation(Class<? extends Annotation> aAnnotation, Annotation[] aAnnotations, Set<Annotation> aVisted) {
        Annotation[] annotationArray = aAnnotations;
        int n = aAnnotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation eAnno = annotationArray[n2];
            if (!aVisted.contains(eAnno)) {
                if (aAnnotation.isAssignableFrom(eAnno.getClass())) {
                    return true;
                }
                aVisted.add(eAnno);
                if (ReflectionUtility.hasAnnotation(aAnnotation, eAnno.annotationType().getAnnotations(), aVisted)) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    public static class NonExistingValueClass {
    }
}

