/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.fusesource.jansi.AnsiConsole;
import org.refcodes.data.ArgsPrefix;
import org.refcodes.data.Delimiter;
import org.refcodes.data.EnvironmentVariable;
import org.refcodes.data.ExitCode;
import org.refcodes.data.Folder;
import org.refcodes.data.Literal;
import org.refcodes.data.Scheme;
import org.refcodes.data.SleepLoopTime;
import org.refcodes.data.SystemProperty;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.runtime.OperatingSystem;
import sun.misc.Signal;

public final class RuntimeUtility {
    public static final String CTRL_C_SIGNAL = "INT";
    private static final String SPACE_PLACEHOLDER = "%20";
    private static final String[] RESERVED_PACKAGE_PREFIXES = new String[]{"sun.", "com.sun.", "java.", "javax."};
    private static String[] MAIN_METHODS = new String[]{"main", "start", "<clinit>", "<init>"};
    private static String[] MAIN_METHOD_PREFIXES = new String[]{"test"};
    private static String[] FRAMEWORK_LAUNCHERS = new String[]{"JarLauncher", "TestRunner", "ForkedBooter"};
    private static Scheme[] JAR_PROTOCOLS = new Scheme[]{Scheme.JAR, Scheme.ZIP, Scheme.SH};
    private static boolean _hasShutdownHandle = false;
    private static Boolean _isUnderTest = null;
    private static Class<?> _mainClass = null;
    private static File _launcherDir = null;
    private static File _currentDir = null;
    private static boolean _isAnsiInstalled = false;

    private RuntimeUtility() {
    }

    public static void setLoggingHandler(Handler aHandler) {
        LogManager.getLogManager().reset();
        Logger theRootLogger = LogManager.getLogManager().getLogger("");
        theRootLogger.addHandler(aHandler);
    }

    public static void setLoggingStreams(OutputStream aStdStream, OutputStream aErrStream, final Level aLevel) {
        RuntimeUtility.setLoggingHandler(new Handler(aStdStream, aErrStream){
            PrintWriter _stdWriter;
            PrintWriter _errWriter;
            {
                this._stdWriter = new PrintWriter(outputStream);
                this._errWriter = new PrintWriter(outputStream2);
            }

            @Override
            public void publish(LogRecord aRecord) {
                if (aRecord.getLevel().intValue() >= aLevel.intValue()) {
                    Throwable theThrown = aRecord.getThrown();
                    String theLine = aRecord.getLevel() + ": " + RuntimeUtility.toFormatted(aRecord.getMessage(), aRecord.getParameters());
                    if (theThrown != null && theThrown.getMessage() != null) {
                        theLine = String.valueOf(theLine) + " (" + theThrown.getMessage() + ")";
                    }
                    if (aRecord.getLevel().intValue() > Level.INFO.intValue()) {
                        this._errWriter.println(theLine);
                        if (theThrown != null) {
                            theThrown.printStackTrace(this._errWriter);
                        }
                    } else {
                        if (theThrown == null) {
                            this._stdWriter.println(theLine);
                        } else {
                            this._errWriter.println(theLine);
                        }
                        if (theThrown != null) {
                            theThrown.printStackTrace(this._errWriter);
                        }
                    }
                }
            }

            @Override
            public void flush() {
                this._stdWriter.flush();
                this._errWriter.flush();
            }

            @Override
            public void close() throws SecurityException {
                this._stdWriter.close();
                this._errWriter.close();
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    public static String toFormatted(String aMessage, Object ... aArguments) {
        try {
            return MessageFormat.format(aMessage, aArguments);
        }
        catch (IllegalArgumentException e) {
            if (aArguments == null || aArguments.length == 0) {
                return aMessage;
            }
            theArguments = new Object[aArguments.length];
            i = 0;
            ** while (i < aArguments.length)
        }
lbl-1000:
        // 1 sources

        {
            theArguments[i] = aArguments[i] instanceof String != false ? "\"" + aArguments[i] + "\"" : (aArguments[i] instanceof Character != false ? "'" + aArguments[i] + "'" : aArguments[i]);
            ++i;
            continue;
        }
lbl12:
        // 1 sources

        theArgsString = Arrays.toString(theArguments);
        if (theArgsString.startsWith("[") && theArgsString.endsWith("]")) {
            theArgsString = theArgsString.substring(1, theArgsString.length() - 1);
        }
        return String.valueOf(aMessage) + " (" + theArgsString + ")";
    }

    public static PrintStream toBootstrapStandardOut() {
        return new PrintStream(new FileOutputStream(FileDescriptor.out){

            @Override
            public void close() throws IOException {
            }
        });
    }

    public static PrintStream toBootstrapStandardError() {
        return new PrintStream(new FileOutputStream(FileDescriptor.err){

            @Override
            public void close() throws IOException {
            }
        });
    }

    public static InputStream toBootstrapStandardIn() {
        return new FileInputStream(FileDescriptor.in){

            @Override
            public void close() throws IOException {
            }
        };
    }

    public static PrintStream toSystemOut() {
        return OperatingSystem.toOperatingSystem() == OperatingSystem.WINDOWS && !RuntimeUtility.isUnderTest() ? RuntimeUtility.toAnsiOut() : new PrintStream(System.out){

            @Override
            public void close() {
            }
        };
    }

    public static PrintStream toSystemErr() {
        return OperatingSystem.toOperatingSystem() == OperatingSystem.WINDOWS && !RuntimeUtility.isUnderTest() ? RuntimeUtility.toAnsiErr() : new PrintStream(System.err){

            @Override
            public void close() {
            }
        };
    }

    public static boolean isUnderTest() {
        block4: {
            if (_isUnderTest != null) {
                return _isUnderTest;
            }
            if (Boolean.getBoolean("log.test")) {
                return true;
            }
            if (SystemProperty.LOG_DEBUG.isEnabled()) {
                return true;
            }
            StackTraceElement[] theStackTrace = Thread.currentThread().getStackTrace();
            List<StackTraceElement> theList = Arrays.asList(theStackTrace);
            for (StackTraceElement eElement : theList) {
                if (!eElement.getClassName().startsWith("org.junit.") && !eElement.getClassName().startsWith("org.testng.")) continue;
                _isUnderTest = true;
                break block4;
            }
            _isUnderTest = false;
        }
        return _isUnderTest;
    }

    public static String toStackTrace() {
        StringWriter theStringWriter = new StringWriter();
        new Throwable("").printStackTrace(new PrintWriter(theStringWriter));
        return theStringWriter.toString();
    }

    public static StackTraceElement getCallerStackTraceElement() {
        StackTraceElement[] theStackTraceElements;
        StackTraceElement[] stackTraceElementArray = theStackTraceElements = Thread.currentThread().getStackTrace();
        int n = theStackTraceElements.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement eStackTraceElement = stackTraceElementArray[n2];
            if (!RuntimeUtility.isSkipStackTraceElement(eStackTraceElement)) {
                return eStackTraceElement;
            }
            ++n2;
        }
        return null;
    }

    public static StackTraceElement getCallerStackTraceElement(Class<?> aCallee) {
        return RuntimeUtility.getCallerStackTraceElement(aCallee.getName());
    }

    public static StackTraceElement getCallerStackTraceElement(StackTraceElement aCallee) {
        return RuntimeUtility.getCallerStackTraceElement(aCallee.getClassName());
    }

    public static StackTraceElement getCallerStackTraceElement(Class<?> ... aCallees) {
        StackTraceElement eCaller = null;
        Class<?>[] classArray = aCallees;
        int n = aCallees.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> eClallee = classArray[n2];
            eCaller = RuntimeUtility.getCallerStackTraceElement(eClallee);
            if (eCaller != null) {
                return eCaller;
            }
            ++n2;
        }
        return null;
    }

    public static StackTraceElement getCallerStackTraceElement(StackTraceElement ... aCallees) {
        StackTraceElement eCaller = null;
        StackTraceElement[] stackTraceElementArray = aCallees;
        int n = aCallees.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement eClallee = stackTraceElementArray[n2];
            eCaller = RuntimeUtility.getCallerStackTraceElement(eClallee);
            if (eCaller != null) {
                return eCaller;
            }
            ++n2;
        }
        return null;
    }

    public static StackTraceElement getCallerStackTraceElement(String ... aCalleeClassNames) {
        StackTraceElement eCaller = null;
        String[] stringArray = aCalleeClassNames;
        int n = aCalleeClassNames.length;
        int n2 = 0;
        while (n2 < n) {
            String eClallee = stringArray[n2];
            eCaller = RuntimeUtility.getCallerStackTraceElement(eClallee);
            if (eCaller != null) {
                return eCaller;
            }
            ++n2;
        }
        return null;
    }

    public static StackTraceElement getCallerStackTraceElement(String aCalleeClassName) {
        StackTraceElement[] theStackTraceElements = Thread.currentThread().getStackTrace();
        boolean hasCalleeElement = false;
        StackTraceElement[] stackTraceElementArray = theStackTraceElements;
        int n = theStackTraceElements.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement eStackTraceElement = stackTraceElementArray[n2];
            if (hasCalleeElement && !eStackTraceElement.getClassName().startsWith(aCalleeClassName)) {
                return eStackTraceElement;
            }
            if (eStackTraceElement.getClassName().startsWith(aCalleeClassName)) {
                hasCalleeElement = true;
            }
            ++n2;
        }
        return null;
    }

    private static boolean hasReservedPackagePrefix(StackTraceElement aCaller) {
        String theClassName = aCaller.getClassName();
        String[] stringArray = RESERVED_PACKAGE_PREFIXES;
        int n = RESERVED_PACKAGE_PREFIXES.length;
        int n2 = 0;
        while (n2 < n) {
            String ePrefix = stringArray[n2];
            if (theClassName.startsWith(ePrefix)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static StackTraceElement toBestCallerStackTraceElement(String aCalleeClassName) {
        StackTraceElement theStackTraceElement;
        StackTraceElement eStackTraceElement = theStackTraceElement = RuntimeUtility.getCallerStackTraceElement(aCalleeClassName);
        while (eStackTraceElement != null && RuntimeUtility.hasReservedPackagePrefix(eStackTraceElement)) {
            eStackTraceElement = RuntimeUtility.getCallerStackTraceElement(eStackTraceElement);
        }
        return eStackTraceElement != null ? eStackTraceElement : theStackTraceElement;
    }

    public static StackTraceElement toBestCallerStackTraceElement(StackTraceElement aCallee) {
        return RuntimeUtility.toBestCallerStackTraceElement(aCallee.getClassName());
    }

    public static StackTraceElement toBestCallerStackTraceElement(Class<?> aCallee) {
        return RuntimeUtility.toBestCallerStackTraceElement(aCallee.getName());
    }

    public static StackTraceElement toBestCallerStackTraceElement(String[] aCallees) {
        String[] stringArray = aCallees;
        int n = aCallees.length;
        int n2 = 0;
        while (n2 < n) {
            String e = stringArray[n2];
            StackTraceElement eStackTraceElement = RuntimeUtility.toBestCallerStackTraceElement(e);
            if (eStackTraceElement != null) {
                return eStackTraceElement;
            }
            ++n2;
        }
        return null;
    }

    public static StackTraceElement toBestCallerStackTraceElement(StackTraceElement[] aCallees) {
        StackTraceElement[] stackTraceElementArray = aCallees;
        int n = aCallees.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement e = stackTraceElementArray[n2];
            StackTraceElement eStackTraceElement = RuntimeUtility.toBestCallerStackTraceElement(e);
            if (eStackTraceElement != null) {
                return eStackTraceElement;
            }
            ++n2;
        }
        return null;
    }

    public static StackTraceElement toBestCallerStackTraceElement(Class<?>[] aCallees) {
        Class<?>[] classArray = aCallees;
        int n = aCallees.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> e = classArray[n2];
            StackTraceElement eStackTraceElement = RuntimeUtility.toBestCallerStackTraceElement(e);
            if (eStackTraceElement != null) {
                return eStackTraceElement;
            }
            ++n2;
        }
        return null;
    }

    public static Class<?> getCallerType() {
        StackTraceElement theStackTraceElement = RuntimeUtility.getCallerStackTraceElement();
        return RuntimeUtility.toClass(theStackTraceElement);
    }

    public static Class<?> getCallerType(Class<?> aCallee) {
        StackTraceElement theStackTraceElement = RuntimeUtility.getCallerStackTraceElement(aCallee);
        return RuntimeUtility.toClass(theStackTraceElement);
    }

    public static Class<?> getCallerType(Class<?> ... aCallees) {
        StackTraceElement theStackTraceElement = RuntimeUtility.getCallerStackTraceElement(aCallees);
        return RuntimeUtility.toClass(theStackTraceElement);
    }

    public static Class<?> getCallerType(StackTraceElement aCallee) {
        StackTraceElement theStackTraceElement = RuntimeUtility.getCallerStackTraceElement(aCallee);
        return RuntimeUtility.toClass(theStackTraceElement);
    }

    public static Class<?> getCallerType(String ... aCallees) {
        StackTraceElement theStackTraceElement = RuntimeUtility.getCallerStackTraceElement(aCallees);
        return RuntimeUtility.toClass(theStackTraceElement);
    }

    public static Class<?> getCallerType(String aCallee) {
        StackTraceElement theStackTraceElement = RuntimeUtility.getCallerStackTraceElement(aCallee);
        return RuntimeUtility.toClass(theStackTraceElement);
    }

    public static Class<?> getCallerType(StackTraceElement ... aCallees) {
        StackTraceElement theStackTraceElement = RuntimeUtility.getCallerStackTraceElement(aCallees);
        return RuntimeUtility.toClass(theStackTraceElement);
    }

    public static Class<?> toClass(StackTraceElement aStackTraceElement) {
        try {
            return Class.forName(aStackTraceElement.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new InternalError(e);
        }
    }

    public static String toMethodName(StackTraceElement aStackTraceElement) {
        if (aStackTraceElement == null) {
            return null;
        }
        return aStackTraceElement.getMethodName();
    }

    public static String toClassName(StackTraceElement aStackTraceElement) {
        if (aStackTraceElement == null) {
            return null;
        }
        return RuntimeUtility.toClassName(aStackTraceElement.getClassName());
    }

    public static String toFullyQualifiedClassName(StackTraceElement aStackTraceElement) {
        if (aStackTraceElement == null) {
            return null;
        }
        return aStackTraceElement.getClassName();
    }

    public static String toFullyQualifiedMethodName(StackTraceElement aStackTraceElement) {
        if (aStackTraceElement == null) {
            return null;
        }
        return String.valueOf(aStackTraceElement.getClassName()) + Delimiter.METHOD_NAME.getChar() + aStackTraceElement.getMethodName();
    }

    public static String toFullyQualifiedClassName() {
        StackTraceElement theStackTraceElement = RuntimeUtility.getCallerStackTraceElement();
        return theStackTraceElement.getClassName();
    }

    public static String toFullyQualifiedMethodName() {
        StackTraceElement theStackTraceElement = RuntimeUtility.getCallerStackTraceElement();
        return String.valueOf(theStackTraceElement.getClassName()) + Delimiter.METHOD_NAME.getChar() + theStackTraceElement.getMethodName();
    }

    public static String toMethodName() {
        StackTraceElement theStackTraceElement = RuntimeUtility.getCallerStackTraceElement();
        return theStackTraceElement.getMethodName();
    }

    public static String toClassName() {
        return RuntimeUtility.toClassName(RuntimeUtility.toFullyQualifiedClassName());
    }

    public static String toFullyQualifiedPackageName() {
        return RuntimeUtility.toFullyQualifiedPackageName(RuntimeUtility.toFullyQualifiedClassName());
    }

    public static String toFullyQualifiedPackageName(StackTraceElement aStackTraceElement) {
        return RuntimeUtility.toFullyQualifiedPackageName(RuntimeUtility.toFullyQualifiedClassName(aStackTraceElement));
    }

    public static String toClassName(String aFullyQualifiedClassName) {
        int theClassIndex = aFullyQualifiedClassName.lastIndexOf(46);
        String theClassName = theClassIndex != -1 ? aFullyQualifiedClassName.substring(theClassIndex + 1) : aFullyQualifiedClassName;
        int theInnerClassIndex = theClassName.indexOf(36);
        if (theInnerClassIndex != -1) {
            theClassName = theClassName.substring(theInnerClassIndex + 1);
        }
        return theClassName;
    }

    public static String toFullyQualifiedPackageName(String aFullyQualifiedClassName) {
        int theIndex = aFullyQualifiedClassName.lastIndexOf(46);
        if (theIndex != -1) {
            return aFullyQualifiedClassName.substring(0, theIndex);
        }
        return "";
    }

    public static <T> T toClone(T aObj) throws CloneNotSupportedException {
        if (aObj instanceof Cloneable) {
            try {
                return (T)aObj.getClass().getMethod("clone", new Class[0]).invoke(aObj, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new CloneNotSupportedException(ExceptionUtility.toMessage((Throwable)e));
            }
        }
        throw new CloneNotSupportedException("The type \"" + aObj.getClass().getName() + "}\" does not implement the \"" + Cloneable.class.getName() + "\" interface.");
    }

    public static String toString(String aToString, String aSuperToString) {
        return String.valueOf(aToString) + " (" + aSuperToString + ")";
    }

    public static Long getPid() {
        Long thePid;
        block4: {
            thePid = null;
            try {
                thePid = Long.parseLong(SystemProperty.PROCESS_ID.getValue());
            }
            catch (NumberFormatException e1) {
                String theJvmName = ManagementFactory.getRuntimeMXBean().getName();
                if (theJvmName.indexOf(64) == -1) break block4;
                try {
                    thePid = Long.parseLong(theJvmName.substring(0, theJvmName.indexOf(64)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return thePid;
    }

    public static Process killProcess(long aPid) throws IOException {
        Process theProcess = null;
        switch (OperatingSystem.toOperatingSystem()) {
            case WINDOWS: {
                String[] theCmd = new String[]{"taskkill", "/F", "/PID", Long.toString(aPid)};
                theProcess = Runtime.getRuntime().exec(theCmd);
                break;
            }
            case UNIX: {
                String[] theCmd = new String[]{"kill", "-9", Long.toString(aPid)};
                theProcess = Runtime.getRuntime().exec(theCmd);
            }
        }
        return theProcess;
    }

    public static boolean kill(Long aPid) throws IOException, InterruptedException {
        Process theProcess = RuntimeUtility.killProcess(aPid);
        if (theProcess != null) {
            theProcess.waitFor();
            return theProcess.exitValue() == 0;
        }
        return false;
    }

    public static File toUserWorkingDir() {
        String theCurrentDir;
        if (_currentDir == null && (theCurrentDir = SystemProperty.USER_DIR.getValue()) != null && theCurrentDir.length() != 0) {
            File theCurrentFile = new File(theCurrentDir);
            if (theCurrentFile.exists() && theCurrentFile.isDirectory()) {
                _currentDir = theCurrentFile;
            } else {
                theCurrentDir = EnvironmentVariable.USER_DIR.getValue();
                if (theCurrentDir != null && theCurrentDir.length() != 0 && (theCurrentFile = new File(theCurrentDir)).exists() && theCurrentFile.isDirectory()) {
                    _currentDir = theCurrentFile;
                }
            }
        }
        return _currentDir;
    }

    public static File toLauncherDir() {
        if (_launcherDir == null) {
            String truncate;
            String basePath;
            File theLauncherFile;
            String theLauncherDir = SystemProperty.LAUNCHER_DIR.getValue();
            if (theLauncherDir != null && theLauncherDir.length() != 0 && (theLauncherFile = new File(theLauncherDir)).exists() && theLauncherFile.isDirectory()) {
                return theLauncherFile;
            }
            Class<RuntimeUtility> baseClass = RuntimeUtility.getMainClass();
            if (baseClass == null) {
                baseClass = RuntimeUtility.class;
            }
            if ((basePath = baseClass.getProtectionDomain().getCodeSource().getLocation().getPath()).startsWith(Scheme.FILE.toProtocol())) {
                basePath = basePath.substring(Scheme.FILE.toProtocol().length());
            }
            try {
                String theCanonicalName = baseClass.getCanonicalName();
                truncate = theCanonicalName.replace('.', '/');
            }
            catch (Exception e) {
                return null;
            }
            truncate = truncate.substring(0, truncate.indexOf(baseClass.getSimpleName()));
            int endIndex = basePath.indexOf(truncate);
            if (endIndex > 0) {
                basePath = basePath.substring(0, endIndex);
            }
            if (basePath.endsWith("" + Delimiter.PATH.getChar())) {
                basePath = basePath.substring(0, basePath.length() - 1);
            }
            if (basePath.endsWith(Folder.CLASSES.getName())) {
                basePath = basePath.substring(0, basePath.indexOf(Folder.CLASSES.getName()));
            }
            int index = -1;
            Scheme[] schemeArray = JAR_PROTOCOLS;
            int n = JAR_PROTOCOLS.length;
            int n2 = 0;
            while (n2 < n) {
                Scheme eProtocol = schemeArray[n2];
                index = eProtocol.firstMarkerIndex(basePath.toLowerCase());
                if (index != -1) break;
                ++n2;
            }
            if (index != -1 && (index = (basePath = basePath.substring(0, index)).lastIndexOf(Delimiter.PATH.getChar())) != -1) {
                basePath = basePath.substring(0, index);
            }
            if (!basePath.endsWith("" + Delimiter.PATH.getChar())) {
                basePath = String.valueOf(basePath) + Delimiter.PATH.getChar();
            }
            _launcherDir = new File(basePath);
            if (!basePath.endsWith(String.valueOf(Folder.TARGET.getName()) + Delimiter.PATH.getChar())) {
                _launcherDir = _launcherDir.getParentFile();
            }
            if (!_launcherDir.exists() && basePath.contains(SPACE_PLACEHOLDER)) {
                basePath = basePath.replaceAll(Matcher.quoteReplacement(SPACE_PLACEHOLDER), " ");
                _launcherDir = new File(basePath);
                if (!basePath.endsWith(String.valueOf(Folder.TARGET.getName()) + Delimiter.PATH.getChar())) {
                    _launcherDir = _launcherDir.getParentFile();
                }
            }
        }
        return _launcherDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Class getMainClass() {
        if (_mainClass != null) return _mainClass;
        Class<RuntimeUtility> clazz = RuntimeUtility.class;
        synchronized (RuntimeUtility.class) {
            Class<?> mainClass;
            int n;
            StackTraceElement eElement;
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            ArrayList<StackTraceElement> theCandidates = new ArrayList<StackTraceElement>();
            int i = 0;
            while (i < stack.length) {
                eElement = stack[i];
                if (RuntimeUtility.hasTestAnnotation(eElement)) {
                    theCandidates.add(eElement);
                }
                ++i;
            }
            i = stack.length - 1;
            while (i > 0) {
                eElement = stack[i];
                String[] stringArray = MAIN_METHODS;
                n = MAIN_METHODS.length;
                int n2 = 0;
                while (n2 < n) {
                    String eMain = stringArray[n2];
                    if (eElement.getMethodName().equals(eMain)) {
                        theCandidates.add(eElement);
                    }
                    ++n2;
                }
                stringArray = MAIN_METHOD_PREFIXES;
                n = MAIN_METHOD_PREFIXES.length;
                n2 = 0;
                while (n2 < n) {
                    String ePrefix = stringArray[n2];
                    if (eElement.getMethodName().startsWith(ePrefix)) {
                        theCandidates.add(eElement);
                    }
                    ++n2;
                }
                --i;
            }
            block11: for (StackTraceElement eCandidate : theCandidates) {
                String[] stringArray = FRAMEWORK_LAUNCHERS;
                int n3 = FRAMEWORK_LAUNCHERS.length;
                n = 0;
                while (n < n3) {
                    String eLauncer = stringArray[n];
                    if (eCandidate.getClassName().toLowerCase().contains(eLauncer.toLowerCase())) continue block11;
                    ++n;
                }
                try {
                    mainClass = Class.forName(eCandidate.getClassName());
                    if (mainClass.getProtectionDomain().getCodeSource() == null) continue;
                    _mainClass = mainClass;
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return _mainClass;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            for (StackTraceElement eCandidate : theCandidates) {
                try {
                    mainClass = Class.forName(eCandidate.getClassName());
                    if (mainClass.getProtectionDomain().getCodeSource() == null) continue;
                    _mainClass = mainClass;
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return _mainClass;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _mainClass;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasTestAnnotation(StackTraceElement aElement) {
        try {
            Method[] methods;
            Class<?> aClass = Class.forName(aElement.getClassName());
            String methodName = aElement.getMethodName();
            Method[] methodArray = methods = aClass.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                Method method = methodArray[n2];
                if (method.getName().equals(methodName)) {
                    Annotation[] eAnnotations;
                    Annotation[] annotationArray = eAnnotations = method.getDeclaredAnnotations();
                    int n3 = eAnnotations.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Annotation eAnnotation = annotationArray[n4];
                        String theSimpleName = eAnnotation.annotationType().getSimpleName();
                        if (theSimpleName.equals("Test")) {
                            return true;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public static Map<String, String> toProperties(String[] aArgs) {
        return RuntimeUtility.toProperties(aArgs, ArgsPrefix.toPrefixes(), Delimiter.INDEX.getChar());
    }

    public static Map<String, String> toProperties(String[] aArgs, Collection<String> aPrefixes, char aDelimiter) {
        return RuntimeUtility.toProperties(aArgs, aPrefixes.toArray(new String[aPrefixes.size()]), aDelimiter);
    }

    public static Map<String, String> toProperties(String[] aArgs, String[] aPrefixes, char aDelimiter) {
        HashMap<String, String> theProperties = new HashMap<String, String>();
        String eOption = null;
        int i = 0;
        while (i < aArgs.length) {
            String eArg = aArgs[i];
            boolean isLast = i == aArgs.length - 1;
            String eNextOption = RuntimeUtility.toOption(eArg, aPrefixes);
            if (eOption != null) {
                if (eNextOption == null) {
                    RuntimeUtility.putProperty(theProperties, eOption, eArg, aDelimiter);
                    eOption = null;
                } else {
                    RuntimeUtility.putProperty(theProperties, eOption, Literal.TRUE.getValue(), aDelimiter);
                    eOption = eNextOption;
                    if (isLast) {
                        RuntimeUtility.putProperty(theProperties, eOption, Literal.TRUE.getValue(), aDelimiter);
                    }
                }
            } else if (eNextOption != null) {
                eOption = eNextOption;
                if (isLast) {
                    RuntimeUtility.putProperty(theProperties, eOption, Literal.TRUE.getValue(), aDelimiter);
                }
            } else {
                RuntimeUtility.putProperty(theProperties, null, eArg, aDelimiter);
            }
            ++i;
        }
        return theProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addShutdownHook(Thread hook) {
        Runtime.getRuntime().addShutdownHook(hook);
        if (_hasShutdownHandle || !"runtime".equalsIgnoreCase(SystemProperty.GRAALVM_IMAGE_CODE_KEY.getValue())) return;
        Class<RuntimeUtility> clazz = RuntimeUtility.class;
        synchronized (RuntimeUtility.class) {
            if (_hasShutdownHandle) return;
            _hasShutdownHandle = true;
            Signal.handle(new Signal(CTRL_C_SIGNAL), sig -> System.exit(ExitCode.CONTROL_C.getStatusCode()));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addShutdownHook(Runnable hook) {
        Runtime.getRuntime().addShutdownHook(new Thread(hook));
        if (_hasShutdownHandle || !"runtime".equalsIgnoreCase(SystemProperty.GRAALVM_IMAGE_CODE_KEY.getValue())) return;
        Class<RuntimeUtility> clazz = RuntimeUtility.class;
        synchronized (RuntimeUtility.class) {
            if (_hasShutdownHandle) return;
            _hasShutdownHandle = true;
            Signal.handle(new Signal(CTRL_C_SIGNAL), sig -> System.exit(ExitCode.CONTROL_C.getStatusCode()));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected static void putProperty(Map<String, String> aProperties, String aKey, String aValue, char aDelimiter) {
        if (aProperties.containsKey(aKey)) {
            String eNextKey = RuntimeUtility.toNextKey(aProperties, aKey, aDelimiter);
            aProperties.put(eNextKey, aProperties.remove(aKey));
            eNextKey = RuntimeUtility.toNextKey(aProperties, aKey, aDelimiter);
            aProperties.put(eNextKey, aValue);
        } else if (aProperties.containsKey(String.valueOf(aKey) + aDelimiter + "0")) {
            String eNextKey = RuntimeUtility.toNextKey(aProperties, aKey, aDelimiter);
            aProperties.put(eNextKey, aValue);
        } else {
            aProperties.put(aKey, aValue);
        }
    }

    protected static String toNextKey(Map<String, String> aProperties, String aKey, char aDelimiter) {
        if (aProperties.containsKey(aKey) || aProperties.containsKey(String.valueOf(aKey) + aDelimiter + "0")) {
            int index = 0;
            String eNextKey = String.valueOf(aKey) + aDelimiter + index;
            while (aProperties.containsKey(eNextKey)) {
                eNextKey = String.valueOf(aKey) + aDelimiter + ++index;
            }
            return eNextKey;
        }
        return null;
    }

    protected static String toOption(String aArg, String ... aPrefixes) {
        Arrays.sort(aPrefixes, Collections.reverseOrder());
        String[] stringArray = aPrefixes;
        int n = aPrefixes.length;
        int n2 = 0;
        while (n2 < n) {
            String ePrefix = stringArray[n2];
            if (aArg.startsWith(ePrefix)) {
                return aArg.substring(ePrefix.length());
            }
            ++n2;
        }
        return null;
    }

    @SafeVarargs
    protected static boolean containsDir(File aDir, List<File> ... aDirs) {
        List<File>[] listArray = aDirs;
        int n = aDirs.length;
        int n2 = 0;
        while (n2 < n) {
            List<File> eDirs = listArray[n2];
            if (eDirs.contains(aDir)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isSkipStackTraceElement(StackTraceElement aStackTraceElement) {
        return aStackTraceElement.getClassName().equals(Thread.class.getName()) || aStackTraceElement.getClassName().equals(RuntimeUtility.class.getName()) || aStackTraceElement.getLineNumber() <= 1;
    }

    private static PrintStream toAnsiOut() {
        RuntimeUtility.doInstallAnsi();
        return new PrintStream((OutputStream)AnsiConsole.out()){

            @Override
            public void close() {
            }
        };
    }

    private static PrintStream toAnsiErr() {
        RuntimeUtility.doInstallAnsi();
        return new PrintStream((OutputStream)AnsiConsole.err()){

            @Override
            public void close() {
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void doInstallAnsi() {
        if (_isAnsiInstalled) return;
        Class<RuntimeUtility> clazz = RuntimeUtility.class;
        synchronized (RuntimeUtility.class) {
            if (_isAnsiInstalled) return;
            AnsiConsole.systemInstall();
            try {
                Thread theHook = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            RuntimeUtility.doUninstallAnsi();
                        }
                        catch (Error | Exception throwable) {
                            // empty catch block
                        }
                    }
                });
                theHook.setDaemon(true);
                RuntimeUtility.addShutdownHook(theHook);
            }
            catch (Exception exception) {
                // empty catch block
            }
            _isAnsiInstalled = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void doUninstallAnsi() {
        try {
            Thread.sleep(SleepLoopTime.MIN.getTimeMillis());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        RuntimeUtility.toSystemOut().flush();
        RuntimeUtility.toSystemErr().flush();
        AnsiConsole.systemUninstall();
    }
}

