/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.refcodes.data.Delimiter;
import org.refcodes.data.EnvironmentVariable;
import org.refcodes.data.SystemProperty;
import org.refcodes.data.Text;
import org.refcodes.numerical.NumericalUtility;
import org.refcodes.runtime.RuntimeUtility;
import org.refcodes.runtime.SystemUtility;

public enum SystemContext {
    APPLICATION(false, false, true, false),
    USER_APPLICATION(false, true, true, false),
    HOST_USER_APPLICATION(true, true, true, false),
    HOST_APPLICATION(true, false, true, false),
    USER(false, true, false, false),
    HOST_USER(true, true, false, false),
    HOST(true, false, false, false),
    SESSION(false, false, false, true),
    APPLICATION_SESSION(false, false, true, true),
    USER_APPLICATION_SESSION(false, true, true, true),
    HOST_USER_APPLICATION_SESSION(true, true, true, true),
    HOST_APPLICATION_SESSION(true, false, true, true),
    USER_SESSION(false, true, false, true),
    HOST_USER_SESSION(true, true, false, true),
    HOST_SESSION(true, false, false, true);

    private static String _hostAddress;
    private static volatile long SESSION_SEED;
    private boolean _isHostLevel;
    private boolean _isUserLevel;
    private boolean _isApplicationLevel;
    private boolean _isSessionLevel;
    private String _ctxSequence = null;

    static {
        _hostAddress = null;
        SESSION_SEED = System.currentTimeMillis();
    }

    private SystemContext(boolean isHostLevel, boolean isUserLevel, boolean isApplicationLevel, boolean isSessionLevel) {
        this._isHostLevel = isHostLevel;
        this._isUserLevel = isUserLevel;
        this._isApplicationLevel = isApplicationLevel;
        this._isSessionLevel = isSessionLevel;
    }

    public boolean isHostLevel() {
        return this._isHostLevel;
    }

    public boolean isUserLevel() {
        return this._isUserLevel;
    }

    public boolean isApplicationLevel() {
        return this._isApplicationLevel;
    }

    public boolean isSessionLevel() {
        return this._isSessionLevel;
    }

    public String toContextString() {
        return this.toContextBuffer(null).toString();
    }

    public String toContextString(String aSeed) {
        return this.toContextBuffer(aSeed != null ? aSeed.toCharArray() : null).toString();
    }

    public String toContextString(char[] aSeed) {
        return this.toContextBuffer(aSeed).toString();
    }

    public char[] toContextSequence() {
        return this.toContextSequence((char[])null);
    }

    public char[] toContextSequence(String aSeed) {
        return this.toContextSequence(aSeed != null ? aSeed.toCharArray() : null);
    }

    public char[] toContextSequence(char[] aSeed) {
        StringBuffer theBuffer = this.toContextBuffer(aSeed);
        int length = theBuffer.length();
        char[] theSequence = new char[length];
        theBuffer.getChars(0, length, theSequence, 0);
        return theSequence;
    }

    public int toContextId() {
        return this.toContextId(null);
    }

    public int toContextId(String aSeed) {
        String theSystemString = this.toContextString(aSeed);
        return NumericalUtility.toHashCode((String)theSystemString);
    }

    public int[] toContextIds(int aIdLength) {
        return this.toContextIds(aIdLength, null);
    }

    public int[] toContextIds(int aIdLength, String aSeed) {
        String theSystemString = this.toContextString(aSeed);
        return NumericalUtility.toHashCodes((String)theSystemString, (int)aIdLength);
    }

    private StringBuffer toContextBuffer(char[] aSeed) {
        String theSeed;
        StringBuffer theBuffer = new StringBuffer();
        if (this._ctxSequence != null) {
            theBuffer.append(this._ctxSequence);
        } else {
            if (this.isSessionLevel()) {
                if (theBuffer.length() != 0) {
                    theBuffer.append(Delimiter.LIST.getChar());
                }
                theBuffer.append(SESSION_SEED);
                for (String eValue : System.getenv().keySet()) {
                    theBuffer.append(Delimiter.LIST.getChar());
                    theBuffer.append(System.getenv(eValue));
                }
            }
            if (this.isHostLevel()) {
                String theCores;
                String theComputerName;
                String theArch;
                if (theBuffer.length() != 0) {
                    theBuffer.append(Delimiter.LIST.getChar());
                }
                if (!((theArch = SystemProperty.OS_ARCH.getValue()) != null && theArch.length() != 0 || (theArch = EnvironmentVariable.PROCESSOR_ARCHITECTURE.getKey()) != null && theArch.length() != 0 || (theArch = EnvironmentVariable.PROCESSOR_ARCHITEW6432.getKey()) != null)) {
                    theArch = Text.ARECIBO_MESSAGE.getText().substring(32, 48);
                }
                theBuffer.append(theArch);
                if (theBuffer.length() != 0) {
                    theBuffer.append(Delimiter.LIST.getChar());
                }
                if (_hostAddress == null) {
                    try {
                        _hostAddress = Arrays.toString(SystemUtility.toHostMacAddress());
                    }
                    catch (SocketException | UnknownHostException iOException) {
                        // empty catch block
                    }
                    if (_hostAddress == null || _hostAddress.length() == 0) {
                        try {
                            _hostAddress = Arrays.toString(SystemUtility.toHostIpAddress());
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (_hostAddress == null || _hostAddress.length() == 0) {
                            _hostAddress = Text.ARECIBO_MESSAGE.getText().substring(64, 80);
                        }
                    }
                }
                theBuffer.append(_hostAddress);
                if (theBuffer.length() != 0) {
                    theBuffer.append(Delimiter.LIST.getChar());
                }
                if ((theComputerName = SystemUtility.getComputerName()) == null || theComputerName.length() == 0) {
                    theComputerName = Text.ARECIBO_MESSAGE.getText().substring(96, 112);
                }
                theBuffer.append(theComputerName);
                if (theBuffer.length() != 0) {
                    theBuffer.append(Delimiter.LIST.getChar());
                }
                try {
                    theCores = "" + Runtime.getRuntime().availableProcessors();
                }
                catch (Exception ignore) {
                    theCores = EnvironmentVariable.NUMBER_OF_PROCESSORS.getValue();
                }
                if (theCores == null || theCores.length() == 0) {
                    theCores = Text.ARECIBO_MESSAGE.getText().substring(112, 128);
                }
                theBuffer.append(theCores);
            }
            if (this.isUserLevel()) {
                String theTemp;
                String theUserHome;
                String theUserName;
                if (theBuffer.length() != 0) {
                    theBuffer.append(Delimiter.LIST.getChar());
                }
                if ((theUserName = SystemProperty.USER_NAME.getValue()) == null || theUserName.length() == 0) {
                    theUserName = Text.ARECIBO_MESSAGE.getText().substring(0, 16);
                }
                theBuffer.append(theUserName);
                if (theBuffer.length() != 0) {
                    theBuffer.append(Delimiter.LIST.getChar());
                }
                if ((theUserHome = SystemProperty.USER_HOME.getValue()) == null || theUserHome.length() == 0) {
                    theUserHome = Text.ARECIBO_MESSAGE.getText().substring(16, 32);
                }
                theBuffer.append(theUserHome);
                if (theBuffer.length() != 0) {
                    theBuffer.append(Delimiter.LIST.getChar());
                }
                if ((theTemp = SystemProperty.TEMP_DIR.getValue()) == null) {
                    theTemp = new String(Text.ARECIBO_MESSAGE.getText().substring(48, 64));
                }
                theBuffer.append(theTemp);
            }
            if (this.isApplicationLevel()) {
                Class theMainClass;
                if (theBuffer.length() != 0) {
                    theBuffer.append(Delimiter.LIST.getChar());
                }
                String theMainString = (theMainClass = RuntimeUtility.getMainClass()) != null ? theMainClass.getName() : Text.ARECIBO_MESSAGE.getText().substring(128, 144);
                theBuffer.append(theMainString);
            }
            this._ctxSequence = theBuffer.toString();
        }
        if (aSeed != null && aSeed.length != 0) {
            if (theBuffer.length() != 0) {
                theBuffer.append(Delimiter.LIST.getChar());
            }
            theBuffer.append(aSeed);
        }
        if ((theSeed = EnvironmentVariable.HOST_SEED.getValue()) != null && theSeed.length() != 0) {
            if (theBuffer.length() != 0) {
                theBuffer.append(Delimiter.LIST.getChar());
            }
            theBuffer.append(theSeed);
        }
        if ((theSeed = SystemProperty.HOST_SEED.getValue()) != null && theSeed.length() != 0) {
            if (theBuffer.length() != 0) {
                theBuffer.append(Delimiter.LIST.getChar());
            }
            theBuffer.append(theSeed);
        }
        return theBuffer;
    }
}

