/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.refcodes.data.DaemonLoopSleepTime;
import org.refcodes.data.EnvironmentVariable;
import org.refcodes.data.Literal;
import org.refcodes.data.SystemProperty;
import org.refcodes.numerical.NumericalUtility;
import org.refcodes.runtime.OperatingSystem;
import org.refcodes.runtime.ProcessResult;
import org.refcodes.runtime.RuntimeUtility;
import org.refcodes.runtime.Shell;
import org.refcodes.runtime.SystemContext;
import org.refcodes.runtime.Terminal;

public final class SystemUtility {
    private static String _uname = null;
    private static boolean _hasUname = false;

    private SystemUtility() {
    }

    public static String getComputerName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            String theName = EnvironmentVariable.COMPUTERNAME.getValue();
            if (theName == null || theName.length() == 0) {
                theName = EnvironmentVariable.HOSTNAME.getValue();
            }
            if (theName != null && theName.length() > 0) {
                return theName;
            }
            return Literal.LOCALHOST.getValue();
        }
    }

    public static String getUname() {
        if (_hasUname) {
            return _uname;
        }
        try {
            _uname = SystemUtility.exec(DaemonLoopSleepTime.NORM.getTimeMillis(), "uname -a");
        }
        catch (IOException | InterruptedException exception) {
            // empty catch block
        }
        _hasUname = true;
        return _uname;
    }

    public static String toPropertyValue(String aDefaultValue, SystemProperty aSystemProperty, EnvironmentVariable ... aEnvironmentProperties) {
        String theValue = aSystemProperty.getValue();
        if (theValue != null && theValue.length() > 0) {
            return theValue;
        }
        if (aEnvironmentProperties != null) {
            EnvironmentVariable[] environmentVariableArray = aEnvironmentProperties;
            int n = aEnvironmentProperties.length;
            int n2 = 0;
            while (n2 < n) {
                EnvironmentVariable eProperty = environmentVariableArray[n2];
                theValue = eProperty.getValue();
                if (theValue != null && theValue.length() > 0) {
                    return theValue;
                }
                ++n2;
            }
        }
        if (theValue != null && theValue.length() > 0) {
            return theValue;
        }
        return aDefaultValue;
    }

    public static String toPropertyValue(SystemProperty aSystemProperty, EnvironmentVariable ... aEnvironmentProperties) {
        String theValue = null;
        if (aSystemProperty != null && (theValue = aSystemProperty.getValue()) != null && theValue.length() != 0) {
            return theValue;
        }
        if (aEnvironmentProperties != null) {
            EnvironmentVariable[] environmentVariableArray = aEnvironmentProperties;
            int n = aEnvironmentProperties.length;
            int n2 = 0;
            while (n2 < n) {
                EnvironmentVariable eProperty = environmentVariableArray[n2];
                theValue = eProperty.getValue();
                if (theValue != null && theValue.length() != 0) {
                    return theValue;
                }
                ++n2;
            }
        }
        return null;
    }

    public static String exec(int aTimeoutMillis, String aCommandLine) throws IOException, InterruptedException {
        ProcessBuilder theProcessBuilder = new ProcessBuilder(aCommandLine);
        Process theProcess = theProcessBuilder.start();
        String theOut = new ProcessResult(theProcess, aTimeoutMillis).toString();
        return theOut;
    }

    public static String exec(int aTimeoutMillis, String ... aCommandLine) throws IOException, InterruptedException {
        ProcessBuilder theProcessBuilder = new ProcessBuilder(aCommandLine);
        Process theProcess = theProcessBuilder.start();
        String theOut = new ProcessResult(theProcess, aTimeoutMillis).toString();
        return theOut;
    }

    public static String exec(String aCommandLine) throws IOException {
        ProcessBuilder theProcessBuilder = new ProcessBuilder(aCommandLine);
        Process theProcess = theProcessBuilder.start();
        String theOut = new ProcessResult(theProcess).toString();
        return theOut;
    }

    public static String exec(String ... aCommandLine) throws IOException {
        ProcessBuilder theProcessBuilder = new ProcessBuilder(aCommandLine);
        Process theProcess = theProcessBuilder.start();
        String theOut = new ProcessResult(theProcess).toString();
        return theOut;
    }

    public static Map<String, String> toSystemInfo() {
        HashMap<String, String> theInfo = new HashMap<String, String>();
        theInfo.put("applicationId", String.valueOf(NumericalUtility.toHexString((String)":", (byte[])NumericalUtility.toBytes((int)SystemContext.APPLICATION.toContextId()))));
        int[] theIds = SystemContext.APPLICATION.toContextIds(3);
        Object[] theIdTexts = new String[3];
        int i = 0;
        while (i < 3) {
            theIdTexts[i] = NumericalUtility.toHexString((String)":", (byte[])NumericalUtility.toBytes((int)theIds[i]));
            ++i;
        }
        theInfo.put("applicationIds", Arrays.toString(theIdTexts));
        theInfo.put("applicationString", NumericalUtility.toHexString((String)":", (byte[])SystemContext.APPLICATION.toContextString().getBytes()));
        theInfo.put("hostId", String.valueOf(NumericalUtility.toHexString((String)":", (byte[])NumericalUtility.toBytes((int)SystemContext.HOST.toContextId()))));
        theIds = SystemContext.HOST.toContextIds(3);
        i = 0;
        while (i < 3) {
            theIdTexts[i] = NumericalUtility.toHexString((String)":", (byte[])NumericalUtility.toBytes((int)theIds[i]));
            ++i;
        }
        theInfo.put("hostIds", Arrays.toString(theIdTexts));
        theInfo.put("hostString", NumericalUtility.toHexString((String)":", (byte[])SystemContext.HOST.toContextString().getBytes()));
        theInfo.put("userId", String.valueOf(NumericalUtility.toHexString((String)":", (byte[])NumericalUtility.toBytes((int)SystemContext.USER.toContextId()))));
        theIds = SystemContext.USER.toContextIds(3);
        i = 0;
        while (i < 3) {
            theIdTexts[i] = NumericalUtility.toHexString((String)":", (byte[])NumericalUtility.toBytes((int)theIds[i]));
            ++i;
        }
        theInfo.put("userIds", Arrays.toString(theIdTexts));
        theInfo.put("userString", NumericalUtility.toHexString((String)":", (byte[])SystemContext.USER.toContextString().getBytes()));
        theInfo.put("computerName", SystemUtility.getComputerName());
        try {
            theInfo.put("ipAddress", NumericalUtility.toHexString((String)":", (byte[])SystemUtility.toHostIpAddress()));
        }
        catch (SocketException | UnknownHostException e) {
            theInfo.put("ipAddress", e.getMessage());
        }
        theInfo.put("isAnsiTerminalPreferred", String.valueOf(Terminal.isAnsiTerminalPreferred()));
        theInfo.put("isAnsiTerminal", String.valueOf(Terminal.isAnsiTerminal()));
        theInfo.put("isCygwinTerminal", String.valueOf(Terminal.isCygwinTerminal()));
        theInfo.put("isLineBreakRequired", String.valueOf(Terminal.isLineBreakRequired(Terminal.getTerminalWidth())));
        theInfo.put("launcherDir", RuntimeUtility.toLauncherDir().getAbsolutePath());
        theInfo.put("lineBreak", Terminal.getLineBreak().replaceAll("\\n", "\\\\n").replaceAll("\\r", "\\\\r"));
        try {
            theInfo.put("macAddress", NumericalUtility.toHexString((String)":", (byte[])SystemUtility.toHostMacAddress()));
        }
        catch (SocketException | UnknownHostException e) {
            theInfo.put("macAddress", e.getMessage());
        }
        theInfo.put("mainClass", RuntimeUtility.getMainClass().getName());
        theInfo.put("operatingSystem", "" + (Object)((Object)OperatingSystem.toOperatingSystem()));
        theInfo.put("operatingSystemVersion", OperatingSystem.toOperatingSystem().getVersion());
        theInfo.put("preferredTerminalHeight", String.valueOf(Terminal.toPreferredTerminalHeight()));
        theInfo.put("preferredTerminalWidth", String.valueOf(Terminal.toPreferredTerminalWidth()));
        theInfo.put("shell", "" + (Object)((Object)Shell.toShell()));
        theInfo.put("systemConsole", System.console() != null ? System.console().toString() : null);
        theInfo.put("terminalEncoding", Terminal.getTerminalEncoding());
        theInfo.put("tempDir", SystemProperty.TEMP_DIR.getValue());
        theInfo.put("terminal", "" + (Object)((Object)Terminal.toTerminal()));
        theInfo.put("terminalHeight", String.valueOf(Terminal.getTerminalHeight()));
        theInfo.put("terminalWidth", String.valueOf(Terminal.getTerminalWidth()));
        theInfo.put("uname", SystemUtility.getUname());
        return theInfo;
    }

    public static String toPrettySystemInfo() {
        StringBuffer theBuffer = new StringBuffer();
        Map<String, String> theInfo = SystemUtility.toSystemInfo();
        int maxLength = -1;
        for (String eKey : theInfo.keySet()) {
            if (eKey.length() <= maxLength) continue;
            maxLength = eKey.length();
        }
        ArrayList<String> theKeys = new ArrayList<String>(theInfo.keySet());
        Collections.sort(theKeys);
        Iterator iterator = theKeys.iterator();
        while (iterator.hasNext()) {
            String eKey;
            String tmpKey = eKey = (String)iterator.next();
            while (tmpKey.length() < maxLength) {
                tmpKey = String.valueOf(tmpKey) + " ";
            }
            theBuffer.append(String.valueOf(tmpKey) + " = " + theInfo.get(eKey) + Terminal.getLineBreak());
        }
        return theBuffer.toString();
    }

    public static byte[] toHostIpAddress() throws SocketException, UnknownHostException {
        Enumeration<NetworkInterface> eNetworks = NetworkInterface.getNetworkInterfaces();
        while (eNetworks.hasMoreElements()) {
            NetworkInterface eNetwork = eNetworks.nextElement();
            Enumeration<InetAddress> eAddresses = eNetwork.getInetAddresses();
            while (eAddresses.hasMoreElements()) {
                try {
                    InetAddress eAddress = eAddresses.nextElement();
                    if (eAddress.isAnyLocalAddress() || eAddress.isLoopbackAddress()) continue;
                    return eAddress.getAddress();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return InetAddress.getLocalHost().getAddress();
    }

    public static byte[] toHostMacAddress() throws SocketException, UnknownHostException {
        Enumeration<NetworkInterface> eNetworks = NetworkInterface.getNetworkInterfaces();
        while (eNetworks.hasMoreElements()) {
            NetworkInterface eNetwork = eNetworks.nextElement();
            byte[] eAddress = eNetwork.getHardwareAddress();
            if (eAddress == null || eAddress.length == 0) continue;
            return eAddress;
        }
        try {
            return NetworkInterface.getByInetAddress(InetAddress.getLocalHost()).getHardwareAddress();
        }
        catch (SocketException | UnknownHostException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnknownHostException("Unable to determine host address: " + e.getMessage());
        }
    }
}

