/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import java.io.OutputStreamWriter;
import java.util.function.IntSupplier;
import org.fusesource.jansi.AnsiConsole;
import org.refcodes.data.ConsoleDimension;
import org.refcodes.data.DaemonLoopSleepTime;
import org.refcodes.data.EnvironmentVariable;
import org.refcodes.data.SystemProperty;
import org.refcodes.exception.BugException;
import org.refcodes.numerical.NumericalUtility;
import org.refcodes.runtime.OperatingSystem;
import org.refcodes.runtime.RuntimeUtility;
import org.refcodes.runtime.Shell;
import org.refcodes.runtime.SystemUtility;

public enum Terminal {
    XTERM,
    CYGWIN,
    UNKNOWN;

    private static Boolean _isAnsiTerminal;
    private static Boolean _isCygwinTerminal;
    private static Integer _terminalHeight;
    private static Integer _terminalWidth;
    private static long _lastTerminalHeightUpdate;
    private static long _lastTerminalWidthUpdate;
    private static boolean _canTput;
    private static boolean _canBashTput;
    private static boolean _canModeCon;
    private static boolean _canCmdModeCon;
    private static boolean _canPowershell;
    private static boolean _canStty;
    private static boolean _canBashStty;
    private static boolean _canNativeWindows;
    private static boolean _canBashTputExe;
    private static boolean _canTputExe;
    private static boolean _canBashSttyExe;
    private static boolean _canSttyExe;
    private static final int WIDTH_ABOVE_UNREALSITIC = 1024;
    private static final int HEIGHT_ABOVE_UNREALSITIC = 256;
    private static final int PRESET_TERMINAL_HEIGHT = 25;
    private static final int PRESET_TERMINAL_WIDTH = 80;
    private static final int PRESET_WINCMD_WIDTH = 120;

    static {
        _isAnsiTerminal = null;
        _isCygwinTerminal = null;
        _terminalHeight = null;
        _terminalWidth = null;
        _lastTerminalHeightUpdate = -1L;
        _lastTerminalWidthUpdate = -1L;
        _canTput = true;
        _canBashTput = true;
        _canModeCon = true;
        _canCmdModeCon = true;
        _canPowershell = true;
        _canStty = true;
        _canBashStty = true;
        _canNativeWindows = true;
        _canBashTputExe = true;
        _canTputExe = true;
        _canBashSttyExe = true;
        _canSttyExe = true;
    }

    private static int getAnsiconHeight() {
        try {
            return Terminal.toAnsiconHeight(EnvironmentVariable.ANSICON.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private static int getAnsiconWidth() {
        try {
            return Terminal.toAnsiconWidth(EnvironmentVariable.ANSICON.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static int getCurrentTerminalHeight() {
        return Terminal.getTerminalHeight(0);
    }

    public static int getCurrentTerminalWidth() {
        return Terminal.getTerminalWidth(0);
    }

    public static String getLineBreak() {
        String theLineBreak = SystemProperty.CONSOLE_LINE_BREAK.getValue();
        if (!(theLineBreak != null && theLineBreak.length() != 0 || (theLineBreak = EnvironmentVariable.CONSOLE_LINE_BREAK.getValue()) != null && theLineBreak.length() != 0)) {
            theLineBreak = System.lineSeparator();
        }
        if (theLineBreak == null || theLineBreak.length() == 0) {
            theLineBreak = OperatingSystem.toOperatingSystem() == OperatingSystem.WINDOWS ? "\r\n" : "\n";
        }
        return theLineBreak;
    }

    private static int getModeConHeight() {
        if (_canModeCon) {
            try {
                String theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeMillis(), "mode.com con");
                return Terminal.toModeConHeight(theRersult);
            }
            catch (Exception ignore) {
                _canModeCon = false;
            }
        }
        if (_canCmdModeCon) {
            try {
                String theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeMillis(), "cmd.exe", "/c", "mode con");
                return Terminal.toModeConHeight(theRersult);
            }
            catch (Exception ignore) {
                _canCmdModeCon = false;
            }
        }
        return -1;
    }

    private static int getModeConWidth() {
        if (_canModeCon) {
            try {
                String theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeMillis(), "mode.com con");
                return Terminal.toModeConWidth(theRersult);
            }
            catch (Exception ignore) {
                _canModeCon = false;
            }
        }
        if (_canCmdModeCon) {
            try {
                String theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeMillis(), "cmd.exe", "/c", "mode con");
                return Terminal.toModeConWidth(theRersult);
            }
            catch (Exception ignore) {
                _canCmdModeCon = false;
            }
        }
        return -1;
    }

    private static int getNativeWindowsWidth() {
        if (_canNativeWindows) {
            try {
                return AnsiConsole.getTerminalWidth();
            }
            catch (Error e) {
                _canNativeWindows = false;
            }
        }
        return -1;
    }

    private static int getPowershellHeight() {
        if (_canPowershell) {
            try {
                String theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeMillis(), "powershell.exe", "/c", "$host.UI.RawUI.WindowSize.Height");
                if (theRersult != null) {
                    return Integer.parseInt(theRersult.trim());
                }
            }
            catch (Exception ignore) {
                _canPowershell = false;
            }
        }
        return -1;
    }

    private static int getPowershellWidth() {
        if (_canPowershell) {
            try {
                String theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeMillis(), "powershell.exe", "/c", "$host.UI.RawUI.WindowSize.Width");
                if (theRersult != null) {
                    return Integer.parseInt(theRersult.trim());
                }
            }
            catch (Exception ignore) {
                _canPowershell = false;
            }
        }
        return -1;
    }

    private static int getSttyExeHeight() {
        String[] theSize;
        String theRersult;
        if (_canSttyExe) {
            try {
                theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeMillis(), "stty.exe size");
                if (theRersult != null && (theSize = theRersult.trim().split(" ")).length == 2) {
                    return Integer.parseInt(theSize[0]);
                }
            }
            catch (Exception ignore) {
                _canSttyExe = false;
            }
        }
        if (_canBashSttyExe) {
            try {
                theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeMillis(), "bash.exe", "-c", "stty size");
                if (theRersult != null && (theSize = theRersult.trim().split(" ")).length == 2) {
                    return Integer.parseInt(theSize[0]);
                }
            }
            catch (Exception ignore) {
                _canBashSttyExe = false;
            }
        }
        return -1;
    }

    private static int getSttyExeWidth() {
        String[] theSize;
        String theRersult;
        if (_canSttyExe) {
            try {
                theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeMillis(), "stty.exe size");
                if (theRersult != null && (theSize = theRersult.trim().split(" ")).length == 2) {
                    return Integer.parseInt(theSize[1]);
                }
            }
            catch (Exception ignore) {
                _canSttyExe = false;
            }
        }
        if (_canBashSttyExe) {
            try {
                theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeMillis(), "bash.exe", "-c", "stty size");
                if (theRersult != null && (theSize = theRersult.trim().split(" ")).length == 2) {
                    return Integer.parseInt(theSize[1]);
                }
            }
            catch (Exception ignore) {
                _canBashSttyExe = false;
            }
        }
        return -1;
    }

    private static int getSttyHeight() {
        String[] theSize;
        String theRersult;
        if (_canStty) {
            try {
                theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeMillis(), "stty size");
                if (theRersult != null && (theSize = theRersult.trim().split(" ")).length == 2) {
                    return Integer.parseInt(theSize[0]);
                }
            }
            catch (Exception ignore) {
                _canStty = false;
            }
        }
        if (_canBashStty) {
            try {
                theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeMillis(), "bash", "-c", "stty size");
                if (theRersult != null && (theSize = theRersult.trim().split(" ")).length == 2) {
                    return Integer.parseInt(theSize[0]);
                }
            }
            catch (Exception ignore) {
                _canBashStty = false;
            }
        }
        return -1;
    }

    private static int getSttyWidth() {
        String[] theSize;
        String theRersult;
        if (_canStty) {
            try {
                theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeMillis(), "stty size");
                if (theRersult != null && (theSize = theRersult.trim().split(" ")).length == 2) {
                    return Integer.parseInt(theSize[1]);
                }
            }
            catch (Exception ignore) {
                _canStty = false;
            }
        }
        if (_canBashStty) {
            try {
                theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeMillis(), "bash", "-c", "stty size");
                if (theRersult != null && (theSize = theRersult.trim().split(" ")).length == 2) {
                    return Integer.parseInt(theSize[1]);
                }
            }
            catch (Exception ignore) {
                _canBashStty = false;
            }
        }
        return -1;
    }

    private static int getTerminalColumns() {
        String theResult = EnvironmentVariable.TERMINAL_COLUMNS.getValue();
        if (theResult != null) {
            try {
                return Integer.valueOf(theResult.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public static String getTerminalEncoding() {
        OutputStreamWriter theOutWriter = new OutputStreamWriter(System.out);
        return theOutWriter.getEncoding();
    }

    public static int getTerminalHeight() {
        return Terminal.getTerminalHeight(-1);
    }

    public static int getTerminalHeight(int aValidityTimeMillis) {
        if (_terminalHeight != null && aValidityTimeMillis != 0 && (aValidityTimeMillis == -1 || _lastTerminalHeightUpdate + (long)aValidityTimeMillis > System.currentTimeMillis())) {
            return _terminalHeight;
        }
        int theTerminalHeight = -1;
        theTerminalHeight = Terminal.toTerminalHeight(theTerminalHeight, Terminal::getAnsiconHeight);
        theTerminalHeight = Terminal.toTerminalHeight(theTerminalHeight, Terminal::getTerminalLines);
        if (Terminal.isCygwinTerminal()) {
            theTerminalHeight = Terminal.toTerminalHeight(theTerminalHeight, Terminal::getTputExeHeight);
            theTerminalHeight = Terminal.toTerminalHeight(theTerminalHeight, Terminal::getSttyExeHeight);
            theTerminalHeight = Terminal.toTerminalHeight(theTerminalHeight, Terminal::getPowershellHeight);
            theTerminalHeight = Terminal.toTerminalHeight(theTerminalHeight, Terminal::getModeConHeight);
        }
        OperatingSystem theOs = OperatingSystem.toOperatingSystem();
        switch (theOs) {
            case MAC: {
                theTerminalHeight = Terminal.toTerminalHeight(theTerminalHeight, Terminal::getTputHeight);
                theTerminalHeight = Terminal.toTerminalHeight(theTerminalHeight, Terminal::getSttyHeight);
                break;
            }
            case UNIX: {
                theTerminalHeight = Terminal.toTerminalHeight(theTerminalHeight, Terminal::getTputHeight);
                theTerminalHeight = Terminal.toTerminalHeight(theTerminalHeight, Terminal::getSttyHeight);
                break;
            }
            case UNKNOWN: {
                theTerminalHeight = Terminal.toTerminalHeight(theTerminalHeight, Terminal::getTputHeight);
                theTerminalHeight = Terminal.toTerminalHeight(theTerminalHeight, Terminal::getTputExeHeight);
                theTerminalHeight = Terminal.toTerminalHeight(theTerminalHeight, Terminal::getSttyHeight);
                theTerminalHeight = Terminal.toTerminalHeight(theTerminalHeight, Terminal::getSttyExeHeight);
                theTerminalHeight = Terminal.toTerminalHeight(theTerminalHeight, Terminal::getPowershellHeight);
                theTerminalHeight = Terminal.toTerminalHeight(theTerminalHeight, Terminal::getModeConHeight);
                break;
            }
            case WINDOWS: {
                theTerminalHeight = Terminal.toTerminalHeight(theTerminalHeight, Terminal::getPowershellHeight);
                theTerminalHeight = Terminal.toTerminalHeight(theTerminalHeight, Terminal::getModeConHeight);
                break;
            }
            default: {
                throw new BugException("Missing case statement for <" + (Object)((Object)theOs) + "> in implementation!");
            }
        }
        if (Terminal.isUnrealsiticHeight(theTerminalHeight)) {
            theTerminalHeight = -1;
        }
        _terminalHeight = theTerminalHeight;
        _lastTerminalHeightUpdate = System.currentTimeMillis();
        return theTerminalHeight;
    }

    private static int getTerminalLines() {
        String theResult = EnvironmentVariable.TERMINAL_LINES.getValue();
        if (theResult != null) {
            try {
                return Integer.valueOf(theResult.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public static int getTerminalWidth() {
        return Terminal.getTerminalWidth(-1);
    }

    public static int getTerminalWidth(int aValidityTimeMillis) {
        if (_terminalWidth != null && aValidityTimeMillis != 0 && (aValidityTimeMillis == -1 || _lastTerminalWidthUpdate + (long)aValidityTimeMillis > System.currentTimeMillis())) {
            return _terminalWidth;
        }
        int theTerminalWidth = -1;
        theTerminalWidth = Terminal.toTerminalWidth(theTerminalWidth, Terminal::getAnsiconWidth);
        theTerminalWidth = Terminal.toTerminalWidth(theTerminalWidth, Terminal::getTerminalColumns);
        theTerminalWidth = Terminal.toTerminalWidth(theTerminalWidth, Terminal::getNativeWindowsWidth);
        if (Terminal.isCygwinTerminal()) {
            theTerminalWidth = Terminal.toTerminalWidth(theTerminalWidth, Terminal::getTputExeWidth);
            theTerminalWidth = Terminal.toTerminalWidth(theTerminalWidth, Terminal::getSttyExeWidth);
            theTerminalWidth = Terminal.toTerminalWidth(theTerminalWidth, Terminal::getPowershellWidth);
            theTerminalWidth = Terminal.toTerminalWidth(theTerminalWidth, Terminal::getModeConWidth);
        }
        OperatingSystem theOs = OperatingSystem.toOperatingSystem();
        switch (theOs) {
            case MAC: {
                theTerminalWidth = Terminal.toTerminalWidth(theTerminalWidth, Terminal::getTputWidth);
                theTerminalWidth = Terminal.toTerminalWidth(theTerminalWidth, Terminal::getSttyWidth);
                break;
            }
            case UNIX: {
                theTerminalWidth = Terminal.toTerminalWidth(theTerminalWidth, Terminal::getTputWidth);
                theTerminalWidth = Terminal.toTerminalWidth(theTerminalWidth, Terminal::getSttyWidth);
                break;
            }
            case UNKNOWN: {
                theTerminalWidth = Terminal.toTerminalWidth(theTerminalWidth, Terminal::getTputWidth);
                theTerminalWidth = Terminal.toTerminalWidth(theTerminalWidth, Terminal::getTputExeWidth);
                theTerminalWidth = Terminal.toTerminalWidth(theTerminalWidth, Terminal::getSttyWidth);
                theTerminalWidth = Terminal.toTerminalWidth(theTerminalWidth, Terminal::getSttyExeWidth);
                theTerminalWidth = Terminal.toTerminalWidth(theTerminalWidth, Terminal::getPowershellWidth);
                theTerminalWidth = Terminal.toTerminalWidth(theTerminalWidth, Terminal::getModeConWidth);
                break;
            }
            case WINDOWS: {
                theTerminalWidth = Terminal.toTerminalWidth(theTerminalWidth, Terminal::getPowershellWidth);
                theTerminalWidth = Terminal.toTerminalWidth(theTerminalWidth, Terminal::getModeConWidth);
                break;
            }
            default: {
                throw new BugException("Missing case statement for <" + (Object)((Object)theOs) + "> in implementation!");
            }
        }
        if (Terminal.isUnrealsiticWidth(theTerminalWidth)) {
            theTerminalWidth = -1;
        }
        _terminalWidth = theTerminalWidth;
        _lastTerminalWidthUpdate = System.currentTimeMillis();
        return theTerminalWidth;
    }

    private static int getTputExeHeight() {
        String theRersult;
        if (_canTputExe) {
            try {
                theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeMillis(), "tput.exe lines");
                if (theRersult != null) {
                    return Integer.parseInt(theRersult.trim());
                }
            }
            catch (Exception ignore) {
                _canTputExe = false;
            }
        }
        if (_canBashTputExe) {
            try {
                theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeMillis(), "bash.exe", "-c", "tput lines");
                if (theRersult != null) {
                    return Integer.parseInt(theRersult.trim());
                }
            }
            catch (Exception ignore) {
                _canBashTputExe = false;
            }
        }
        return -1;
    }

    private static int getTputExeWidth() {
        String theRersult;
        if (_canTputExe) {
            try {
                theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeMillis(), "tput.exe cols");
                if (theRersult != null) {
                    return Integer.parseInt(theRersult.trim());
                }
            }
            catch (Exception ignore) {
                _canTputExe = false;
            }
        }
        if (_canBashTputExe) {
            try {
                theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeMillis(), "bash.exe", "-c", "tput cols");
                if (theRersult != null) {
                    return Integer.parseInt(theRersult.trim());
                }
            }
            catch (Exception ignore) {
                _canBashTputExe = false;
            }
        }
        return -1;
    }

    private static int getTputHeight() {
        String theRersult;
        if (_canTput) {
            try {
                theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeMillis(), "tput lines");
                if (theRersult != null) {
                    return Integer.parseInt(theRersult.trim());
                }
            }
            catch (Exception ignore) {
                _canTput = false;
            }
        }
        if (_canBashTput) {
            try {
                theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeMillis(), "bash", "-c", "tput lines");
                if (theRersult != null) {
                    return Integer.parseInt(theRersult.trim());
                }
            }
            catch (Exception ignore) {
                _canBashTput = false;
            }
        }
        return -1;
    }

    private static int getTputWidth() {
        String theRersult;
        if (_canTput) {
            try {
                theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeMillis(), "tput cols");
                if (theRersult != null) {
                    return Integer.parseInt(theRersult.trim());
                }
            }
            catch (Exception ignore) {
                _canTput = false;
            }
        }
        if (_canBashTput) {
            try {
                theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeMillis(), "bash", "-c", "tput cols");
                if (theRersult != null) {
                    return Integer.parseInt(theRersult.trim());
                }
            }
            catch (Exception ignore) {
                _canBashTput = false;
            }
        }
        return -1;
    }

    public static boolean isAnsiTerminal() {
        if (_isAnsiTerminal != null) {
            return _isAnsiTerminal;
        }
        if (EnvironmentVariable.ANSICON.getValue() != null && EnvironmentVariable.ANSICON.getValue().length() != 0) {
            _isAnsiTerminal = true;
        } else if (Terminal.isCygwinTerminal()) {
            _isAnsiTerminal = true;
        } else if (Shell.toShell() == Shell.POWER_SHELL) {
            _isAnsiTerminal = true;
        } else if (Shell.toShell() == Shell.WIN_CMD) {
            _isAnsiTerminal = true;
        } else {
            int theColors;
            String theRersult;
            if (_canTput) {
                try {
                    theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeMillis(), "tput colors");
                    if (theRersult != null && (theColors = Integer.parseInt(theRersult.trim())) > 4) {
                        _isAnsiTerminal = true;
                    }
                }
                catch (Exception ignore) {
                    _canTput = false;
                }
            }
            if (_isAnsiTerminal == null && _canBashTput) {
                try {
                    theRersult = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeMillis(), "bash", "-c", "tput colors");
                    if (theRersult != null && (theColors = Integer.parseInt(theRersult.trim())) > 4) {
                        _isAnsiTerminal = true;
                    }
                }
                catch (Exception ignore) {
                    _canBashTput = false;
                }
            }
        }
        if (_isAnsiTerminal == null) {
            _isAnsiTerminal = false;
        }
        return _isAnsiTerminal;
    }

    public static boolean isAnsiTerminalPreferred() {
        String theResult = SystemUtility.toPropertyValue(SystemProperty.CONSOLE_ANSI, EnvironmentVariable.CONSOLE_ANSI, EnvironmentVariable.CONSOLE_CONEMU_ANSI);
        if (theResult != null) {
            try {
                return NumericalUtility.toBoolean((String)theResult.toString());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return Terminal.isAnsiTerminal();
    }

    public static boolean isCurrentlyLineBreakRequired(int aRowWidth) {
        return Terminal.isLineBreakRequired(aRowWidth, 0);
    }

    static boolean isCygwinTerminal() {
        if (_isCygwinTerminal != null) {
            return _isCygwinTerminal;
        }
        _isCygwinTerminal = false;
        if ("cygwin".equalsIgnoreCase(EnvironmentVariable.TERM.getValue())) {
            _isCygwinTerminal = true;
        }
        return _isCygwinTerminal;
    }

    public static boolean isLineBreakRequired(int aRowWidth) {
        return Terminal.isLineBreakRequired(aRowWidth, -1);
    }

    public static boolean isLineBreakRequired(int aRowWidth, int aValidityTimeMillis) {
        if (RuntimeUtility.isUnderTest() && (aRowWidth == 80 || aRowWidth == 120)) {
            return true;
        }
        if (Shell.toShell() == Shell.NONE) {
            return true;
        }
        int theWidth = Terminal.getTerminalWidth(aValidityTimeMillis);
        if (OperatingSystem.toOperatingSystem() == OperatingSystem.WINDOWS && aRowWidth == theWidth) {
            try {
                float theVersion = Float.parseFloat(OperatingSystem.WINDOWS.getVersion());
                if (theVersion < 10.0f) {
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    private static boolean isReconsiderableHeight(int eTerminalHeight) {
        return eTerminalHeight <= 1 || eTerminalHeight > 256 || eTerminalHeight == 25;
    }

    private static boolean isReconsiderableWidth(int eTerminalWidth) {
        return eTerminalWidth <= 1 || eTerminalWidth > 1024 || eTerminalWidth == 80;
    }

    private static boolean isUnrealsiticHeight(int eTerminalHeight) {
        return eTerminalHeight <= 1 || eTerminalHeight > 256;
    }

    private static boolean isUnrealsiticWidth(int eTerminalWidth) {
        return eTerminalWidth <= 1 || eTerminalWidth > 1024;
    }

    static int toAnsiconHeight(String aAnsiconEnvVarValue) throws NumberFormatException {
        int index;
        if (aAnsiconEnvVarValue != null && (index = aAnsiconEnvVarValue.lastIndexOf("x")) != -1 && aAnsiconEnvVarValue.length() > index + 1) {
            if ((aAnsiconEnvVarValue = aAnsiconEnvVarValue.substring(index + 1)).length() != 0 && aAnsiconEnvVarValue.endsWith(")")) {
                aAnsiconEnvVarValue = aAnsiconEnvVarValue.substring(0, aAnsiconEnvVarValue.length() - 1);
            }
            return Integer.valueOf(aAnsiconEnvVarValue.toString());
        }
        throw new NumberFormatException("Cannot extract width from ANSICON formatted value <" + aAnsiconEnvVarValue + ">.");
    }

    static int toAnsiconWidth(String aAnsiconEnvVarValue) throws NumberFormatException {
        int index;
        if (aAnsiconEnvVarValue != null && (index = aAnsiconEnvVarValue.indexOf("x")) != -1) {
            aAnsiconEnvVarValue = aAnsiconEnvVarValue.substring(0, index);
            return Integer.valueOf(aAnsiconEnvVarValue.toString());
        }
        throw new NumberFormatException("Cannot extract width from ANSICON formatted value <" + aAnsiconEnvVarValue + ">.");
    }

    public static String toLineBreak(int aRowWidth) {
        if (Terminal.isLineBreakRequired(aRowWidth)) {
            return Terminal.getLineBreak();
        }
        return "\r";
    }

    static int toModeConHeight(String aModeConOutput) throws NumberFormatException {
        return Terminal.toModeConValue(aModeConOutput, 3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int toModeConValue(String aModeConOutput, int aValueIndex) throws NumberFormatException {
        try {
            int index = 0;
            int i = 0;
            while (i < aValueIndex - 1) {
                index = aModeConOutput.indexOf(58);
                if (index == -1) return -1;
                if (index == aModeConOutput.length() - 1) {
                    return -1;
                }
                aModeConOutput = aModeConOutput.substring(index + 1);
                ++i;
            }
            aModeConOutput = aModeConOutput.trim();
            index = -1;
            i = 0;
            while (i < aModeConOutput.length()) {
                if (!Character.isDigit(aModeConOutput.charAt(i))) break;
                index = i++;
            }
            if (index == -1) {
                return -1;
            }
            aModeConOutput = aModeConOutput.substring(0, index + 1);
            return Integer.parseInt(aModeConOutput);
        }
        catch (Exception exception) {
            throw new NumberFormatException("Cannot extract the value from \"mode con\" formatted value <" + aModeConOutput + "> for row <" + aValueIndex + ">.");
        }
    }

    static int toModeConWidth(String aModeConOutput) throws NumberFormatException {
        return Terminal.toModeConValue(aModeConOutput, 4);
    }

    public static int toPreferredTerminalHeight() {
        int theHeight = -1;
        String theResult = SystemUtility.toPropertyValue(SystemProperty.CONSOLE_HEIGHT, EnvironmentVariable.CONSOLE_HEIGHT);
        if (theResult != null) {
            try {
                theHeight = Integer.valueOf(theResult.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (theHeight <= 1) {
            theHeight = Terminal.getTerminalHeight();
        }
        if (theHeight < ConsoleDimension.MIN_HEIGHT.getValue() || theHeight > 256) {
            theHeight = ConsoleDimension.MIN_HEIGHT.getValue();
        }
        return theHeight;
    }

    public static int toPreferredTerminalWidth() {
        int theWidth = -1;
        String theResult = SystemUtility.toPropertyValue(SystemProperty.CONSOLE_WIDTH, EnvironmentVariable.CONSOLE_WIDTH);
        if (theResult != null) {
            try {
                theWidth = Integer.valueOf(theResult.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (theWidth <= 1) {
            theWidth = Terminal.getTerminalWidth();
        }
        if (theWidth < ConsoleDimension.MIN_WIDTH.getValue() || theWidth > 1024) {
            theWidth = ConsoleDimension.MIN_WIDTH.getValue();
        }
        return theWidth;
    }

    public static Terminal toTerminal() {
        String theTerminal = EnvironmentVariable.TERM.getValue();
        if (theTerminal != null) {
            if ((theTerminal = theTerminal.toLowerCase()).indexOf("cygwin") >= 0) {
                return CYGWIN;
            }
            if (theTerminal.indexOf("xterm") >= 0) {
                return XTERM;
            }
        }
        return UNKNOWN;
    }

    private static int toTerminalHeight(int aCurrentTerminalHeight, IntSupplier aNewHeightCandidate) {
        int theNewHeight;
        if (Terminal.isReconsiderableHeight(aCurrentTerminalHeight) && !Terminal.isUnrealsiticHeight(theNewHeight = aNewHeightCandidate.getAsInt())) {
            return theNewHeight;
        }
        return aCurrentTerminalHeight;
    }

    private static int toTerminalWidth(int aCurrentTerminalWidth, IntSupplier aNewWidthCandidate) {
        int theNewWidthCandidate;
        if (Terminal.isReconsiderableWidth(aCurrentTerminalWidth) && !Terminal.isUnrealsiticWidth(theNewWidthCandidate = aNewWidthCandidate.getAsInt())) {
            return theNewWidthCandidate;
        }
        return aCurrentTerminalWidth;
    }
}

