/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.refcodes.exception.BugException;

class AnsiWrapper {
    private static final String ANSI_CONSOLE_CLASS_NAME = "org.fusesource.jansi.AnsiConsole";
    private static final String OUT_METHOD = "out";
    private static final String ERR_METHOD = "err";
    private static final String SYSTEM_INSTALL_METHOD = "systemInstall";
    private static final String SYSTEM_UNINSTALL_METHOD = "systemUninstall";
    private static final String GET_TERMINAL_WIDTH_METHOD = "getTerminalWidth";
    private static boolean _hasOutMethodFailGuard = false;
    private static boolean _hasErrMethodFailGuard = false;
    private static boolean _hasSystemInstallMethodFailGuard = false;
    private static boolean _hasSystemUninstallMethodFailGuard = false;
    private static boolean _hasGetTerminalWidthMethodFailGuard = false;

    AnsiWrapper() {
    }

    public static PrintStream toAnsiOut() {
        if (!_hasOutMethodFailGuard) {
            try {
                Class<?> theClass = Class.forName(ANSI_CONSOLE_CLASS_NAME);
                Method theMethod = theClass.getMethod(OUT_METHOD, new Class[0]);
                return (PrintStream)theMethod.invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException e) {
                _hasOutMethodFailGuard = true;
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
                _hasOutMethodFailGuard = true;
            }
            catch (NoSuchMethodException e) {
                _hasOutMethodFailGuard = true;
                throw new BugException("There is no (more) method <out()> for class <org.fusesource.jansi.AnsiConsole>, please fix the code!", (Throwable)e);
            }
            catch (Throwable e) {
                _hasOutMethodFailGuard = true;
            }
        }
        return System.out;
    }

    public static PrintStream toAnsiErr() {
        if (!_hasErrMethodFailGuard) {
            try {
                Class<?> theClass = Class.forName(ANSI_CONSOLE_CLASS_NAME);
                Method theMethod = theClass.getMethod(ERR_METHOD, new Class[0]);
                return (PrintStream)theMethod.invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException e) {
                _hasErrMethodFailGuard = true;
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
                _hasErrMethodFailGuard = true;
            }
            catch (NoSuchMethodException e) {
                _hasErrMethodFailGuard = true;
                throw new BugException("There is no (more) method <err()> for class <org.fusesource.jansi.AnsiConsole>, please fix the code!", (Throwable)e);
            }
            catch (Throwable e) {
                _hasErrMethodFailGuard = true;
            }
        }
        return System.err;
    }

    public static boolean systemInstall() {
        if (!_hasSystemInstallMethodFailGuard) {
            try {
                Class<?> theClass = Class.forName(ANSI_CONSOLE_CLASS_NAME);
                Method theMethod = theClass.getMethod(SYSTEM_INSTALL_METHOD, new Class[0]);
                theMethod.invoke(null, new Object[0]);
                return true;
            }
            catch (ClassNotFoundException e) {
                _hasSystemInstallMethodFailGuard = true;
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
                _hasSystemInstallMethodFailGuard = true;
            }
            catch (NoSuchMethodException e) {
                _hasSystemInstallMethodFailGuard = true;
                throw new BugException("There is no (more) method <systemInstall()> for class <org.fusesource.jansi.AnsiConsole>, please fix the code!", (Throwable)e);
            }
            catch (Throwable e) {
                _hasSystemInstallMethodFailGuard = true;
            }
        }
        return false;
    }

    public static boolean systemUninstall() {
        if (!_hasSystemUninstallMethodFailGuard) {
            try {
                Class<?> theClass = Class.forName(ANSI_CONSOLE_CLASS_NAME);
                Method theMethod = theClass.getMethod(SYSTEM_UNINSTALL_METHOD, new Class[0]);
                theMethod.invoke(null, new Object[0]);
                return true;
            }
            catch (ClassNotFoundException e) {
                _hasSystemUninstallMethodFailGuard = true;
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
                _hasSystemUninstallMethodFailGuard = true;
            }
            catch (NoSuchMethodException e) {
                _hasSystemUninstallMethodFailGuard = true;
                throw new BugException("There is no (more) method <systemUninstall()> for class <org.fusesource.jansi.AnsiConsole>, please fix the code!", (Throwable)e);
            }
            catch (Throwable e) {
                _hasSystemUninstallMethodFailGuard = true;
            }
        }
        return false;
    }

    public static int getTerminalWidth() {
        if (!_hasGetTerminalWidthMethodFailGuard) {
            try {
                Class<?> theClass = Class.forName(ANSI_CONSOLE_CLASS_NAME);
                Method theMethod = theClass.getMethod(GET_TERMINAL_WIDTH_METHOD, new Class[0]);
                return (Integer)theMethod.invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException e) {
                _hasGetTerminalWidthMethodFailGuard = true;
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
                _hasGetTerminalWidthMethodFailGuard = true;
            }
            catch (NoSuchMethodException e) {
                _hasGetTerminalWidthMethodFailGuard = true;
                throw new BugException("There is no (more) method <getTerminalWidth()> for class <org.fusesource.jansi.AnsiConsole>, please fix the code!", (Throwable)e);
            }
            catch (Throwable e) {
                _hasGetTerminalWidthMethodFailGuard = true;
            }
        }
        return -1;
    }

    public static boolean hasFailure() {
        return _hasErrMethodFailGuard || _hasGetTerminalWidthMethodFailGuard || _hasOutMethodFailGuard || _hasSystemInstallMethodFailGuard || _hasSystemUninstallMethodFailGuard;
    }
}

