/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.refcodes.data.Folder;
import org.refcodes.runtime.Execution;
import org.refcodes.runtime.Host;
import org.refcodes.runtime.SystemProperty;

public enum ConfigLocator {
    DEFAULT(true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, true),
    HOST_ETC(true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false),
    APPLICATION_DIR(false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false),
    APPLICATION_DIR_CONFIG(false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false),
    APPLICATION_DIR_ETC(false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false),
    APPLICATION_DIR_SETTINGS(false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false),
    APPLICATION_DIR_DOT_CONFIG(false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false),
    APPLICATION_DIR_DOT_ETC(false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false),
    APPLICATION_DIR_DOT_SETTINGS(false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false),
    APPLICATION_DIR_ALL(false, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false),
    APPLICATION_PARENT_CONFIG(false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false),
    APPLICATION_PARENT_ETC(false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false),
    APPLICATION_PARENT_SETTINGS(false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false),
    APPLICATION_PARENT_DOT_CONFIG(false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false),
    APPLICATION_PARENT_DOT_ETC(false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false),
    APPLICATION_PARENT_DOT_SETTINGS(false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false),
    APPLICATION_PARENT_ALL(false, false, false, false, false, false, false, false, true, true, true, true, true, true, false, false, false, false, false, false, false, false),
    APPLICATION_ALL(false, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false),
    USER_HOME(false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false),
    USER_HOME_CONFIG(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false),
    USER_HOME_ETC(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false),
    USER_HOME_SETTINGS(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false),
    USER_HOME_DOT_CONFIG(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false),
    USER_HOME_DOT_ETC(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false),
    USER_HOME_DOT_SETTINGS(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false),
    USER_HOME_ALL(false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, false),
    USER_WORKING_DIRECTORY(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true),
    USER_HOME_WORKING_DIRECTORY_ALL(false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true),
    ALL(true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false),
    ABSOLUTE(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false);

    private boolean _isHostEtc;
    private boolean _isApplicationBase;
    private boolean _isApplicationBaseConfig;
    private boolean _isApplicationBaseEtc;
    private boolean _isApplicationBaseSettings;
    private boolean _isApplicationBaseDotConfig;
    private boolean _isApplicationBaseDotEtc;
    private boolean _isApplicationBaseDotSettings;
    private boolean _isApplicationParentConfig;
    private boolean _isApplicationParentEtc;
    private boolean _isApplicationParentSettings;
    private boolean _isApplicationParentDotConfig;
    private boolean _isApplicationParentDotEtc;
    private boolean _isApplicationParentDotSettings;
    private boolean _isUserHome;
    private boolean _isUserHomeConfig;
    private boolean _isUserHomeEtc;
    private boolean _isUserHomeSettings;
    private boolean _isUserHomeDotConfig;
    private boolean _isUserHomeDotEtc;
    private boolean _isUserHomeDotSettings;
    private boolean _isUserWorkingDir;

    private ConfigLocator(boolean isHostEtc, boolean isApplicationBase, boolean isApplicationBaseConfig, boolean isApplicationBaseEtc, boolean isApplicationBaseSettings, boolean isApplicationBaseDotConfig, boolean isApplicationBaseDotEtc, boolean isApplicationBaseDotSettings, boolean isApplicationParentConfig, boolean isApplicationParentEtc, boolean isApplicationParentSettings, boolean isApplicationParentDotConfig, boolean isApplicationParentDotEtc, boolean isApplicationParentDotSettings, boolean isUserHome, boolean isUserHomeConfig, boolean isUserHomeEtc, boolean isUserHomeSettings, boolean isUserHomeDotConfig, boolean isUserHomeDotEtc, boolean isUserHomeDotSettings, boolean isUserWorkingDir) {
        this._isHostEtc = isHostEtc;
        this._isApplicationBase = isApplicationBase;
        this._isApplicationBaseConfig = isApplicationBaseConfig;
        this._isApplicationBaseEtc = isApplicationBaseEtc;
        this._isApplicationBaseSettings = isApplicationBaseSettings;
        this._isApplicationBaseDotConfig = isApplicationBaseDotConfig;
        this._isApplicationBaseDotEtc = isApplicationBaseDotEtc;
        this._isApplicationBaseDotSettings = isApplicationBaseDotSettings;
        this._isApplicationParentConfig = isApplicationParentConfig;
        this._isApplicationParentEtc = isApplicationParentEtc;
        this._isApplicationParentSettings = isApplicationParentSettings;
        this._isApplicationParentDotConfig = isApplicationParentDotConfig;
        this._isApplicationParentDotEtc = isApplicationParentDotEtc;
        this._isApplicationParentDotSettings = isApplicationParentDotSettings;
        this._isUserHome = isUserHome;
        this._isUserHomeConfig = isUserHomeConfig;
        this._isUserHomeEtc = isUserHomeEtc;
        this._isUserHomeSettings = isUserHomeSettings;
        this._isUserHomeDotConfig = isUserHomeDotConfig;
        this._isUserHomeDotEtc = isUserHomeDotEtc;
        this._isUserHomeDotSettings = isUserHomeDotSettings;
        this._isUserWorkingDir = isUserWorkingDir;
    }

    public boolean isHostEtc() {
        return this._isHostEtc;
    }

    public boolean isApplicationBase() {
        return this._isApplicationBase;
    }

    public boolean isApplicationBaseConfig() {
        return this._isApplicationBaseConfig;
    }

    public boolean isApplicationBaseEtc() {
        return this._isApplicationBaseEtc;
    }

    public boolean isApplicationBaseSettings() {
        return this._isApplicationBaseSettings;
    }

    public boolean isApplicationBaseDotConfig() {
        return this._isApplicationBaseDotConfig;
    }

    public boolean isApplicationBaseDotEtc() {
        return this._isApplicationBaseDotEtc;
    }

    public boolean isApplicationBaseDotSettings() {
        return this._isApplicationBaseDotSettings;
    }

    public boolean isApplicationParentConfig() {
        return this._isApplicationParentConfig;
    }

    public boolean isApplicationParentEtc() {
        return this._isApplicationParentEtc;
    }

    public boolean isApplicationParentSettings() {
        return this._isApplicationParentSettings;
    }

    public boolean isApplicationParentDotConfig() {
        return this._isApplicationParentDotConfig;
    }

    public boolean isApplicationParentDotEtc() {
        return this._isApplicationParentDotEtc;
    }

    public boolean isApplicationParentDotSettings() {
        return this._isApplicationParentDotSettings;
    }

    public boolean isUserHome() {
        return this._isUserHome;
    }

    public boolean isUserHomeConfig() {
        return this._isUserHomeConfig;
    }

    public boolean isUserHomeEtc() {
        return this._isUserHomeEtc;
    }

    public boolean isUserHomeSettings() {
        return this._isUserHomeSettings;
    }

    public boolean isUserHomeDotConfig() {
        return this._isUserHomeDotConfig;
    }

    public boolean isUserHomeDotEtc() {
        return this._isUserHomeDotEtc;
    }

    public boolean isUserHomeDotSettings() {
        return this._isUserHomeDotSettings;
    }

    public boolean isUserWorkingDir() {
        return this._isUserWorkingDir;
    }

    public File toFile(String aFileName) {
        return this.toFile(aFileName, null);
    }

    public File toFile(String aFileName, File ... aFolders) {
        File eFile = new File(aFileName);
        if (this == ABSOLUTE) {
            if (eFile.isAbsolute() && eFile.exists() && eFile.isFile() && eFile.canRead()) {
                return eFile;
            }
        } else {
            for (File eFolder : this.getFolders(aFolders)) {
                eFile = ConfigLocator.toFile(aFileName, eFolder);
                if (eFile == null) continue;
                return eFile;
            }
        }
        return null;
    }

    public File[] getFolders() {
        return this.getFolders(null);
    }

    public File[] getFolders(File ... aFolders) {
        File theBuildFolder;
        ArrayList<File> theFolders = new ArrayList<File>();
        this.addFolder(ConfigLocator.toFolder(SystemProperty.CONFIG_DIR.getValue()), theFolders);
        if (aFolders != null) {
            for (File eFile : aFolders) {
                this.addFolder(eFile, theFolders);
            }
        }
        if (this._isUserWorkingDir) {
            this.addFolder(Host.toUserWorkingDir(), theFolders);
        }
        File theLauncherDir = Execution.toLauncherDir();
        if (this._isApplicationBase) {
            this.addFolder(theLauncherDir, theFolders);
        }
        if (this._isApplicationBaseConfig) {
            this.addFolder(theLauncherDir, Folder.CONFIG, theFolders);
        }
        if (this._isApplicationBaseEtc) {
            this.addFolder(theLauncherDir, Folder.ETC, theFolders);
        }
        if (this._isApplicationBaseSettings) {
            this.addFolder(theLauncherDir, Folder.SETTINGS, theFolders);
        }
        if (this._isApplicationBaseDotConfig) {
            this.addFolder(theLauncherDir, Folder.DOT_CONFIG, theFolders);
        }
        if (this._isApplicationBaseDotEtc) {
            this.addFolder(theLauncherDir, Folder.DOT_ETC, theFolders);
        }
        if (this._isApplicationBaseDotSettings) {
            this.addFolder(theLauncherDir, Folder.DOT_SETTINGS, theFolders);
        }
        if (this._isApplicationParentConfig) {
            this.addParentFolder(theLauncherDir, Folder.CONFIG, theFolders);
        }
        if (this._isApplicationParentEtc) {
            this.addParentFolder(theLauncherDir, Folder.ETC, theFolders);
        }
        if (this._isApplicationParentSettings) {
            this.addParentFolder(theLauncherDir, Folder.SETTINGS, theFolders);
        }
        if (this._isApplicationParentDotConfig) {
            this.addParentFolder(theLauncherDir, Folder.DOT_CONFIG, theFolders);
        }
        if (this._isApplicationParentDotEtc) {
            this.addParentFolder(theLauncherDir, Folder.DOT_ETC, theFolders);
        }
        if (this._isApplicationParentDotSettings) {
            this.addParentFolder(theLauncherDir, Folder.DOT_SETTINGS, theFolders);
        }
        if ((theBuildFolder = theLauncherDir) != null) {
            if (theBuildFolder.getAbsolutePath().endsWith(Folder.TARGET.getName())) {
                this.addFolder(new File(theBuildFolder, Folder.CLASSES.getName()), theFolders);
                this.addFolder(new File(theBuildFolder, Folder.TEST_CLASSES.getName()), theFolders);
            } else {
                this.addFolder(new File(new File(theBuildFolder, Folder.TARGET.getName()), Folder.CLASSES.getName()), theFolders);
                this.addFolder(new File(new File(theBuildFolder, Folder.TARGET.getName()), Folder.TEST_CLASSES.getName()), theFolders);
            }
        }
        if (this._isUserHome) {
            this.addUserHomeFolder(theFolders);
        }
        if (this._isUserHomeConfig) {
            this.addUserHomeFolder(Folder.CONFIG, theFolders);
        }
        if (this._isUserHomeEtc) {
            this.addUserHomeFolder(Folder.ETC, theFolders);
        }
        if (this._isUserHomeSettings) {
            this.addUserHomeFolder(Folder.SETTINGS, theFolders);
        }
        if (this._isUserHomeDotConfig) {
            this.addUserHomeFolder(Folder.DOT_CONFIG, theFolders);
        }
        if (this._isUserHomeDotEtc) {
            this.addUserHomeFolder(Folder.DOT_ETC, theFolders);
        }
        if (this._isUserHomeDotSettings) {
            this.addUserHomeFolder(Folder.DOT_SETTINGS, theFolders);
        }
        if (this._isHostEtc) {
            this.addFolder(new File("/" + Folder.ETC.getName()), theFolders);
        }
        return theFolders.toArray(new File[theFolders.size()]);
    }

    private static File toFile(String aFileName, File aFolder) {
        File theFile;
        if (aFolder != null && aFolder.isDirectory() && aFolder.canRead() && (theFile = new File(aFolder, aFileName)).exists() && theFile.isFile() && theFile.canRead()) {
            return theFile;
        }
        return null;
    }

    private static File toFolder(String aFolderPath) {
        File theFolder;
        if (aFolderPath != null && (theFolder = new File(aFolderPath)).exists() && theFolder.isDirectory() && theFolder.canRead()) {
            return theFolder;
        }
        return null;
    }

    static File toHomeFolder() {
        File theFolder;
        String theValue = SystemProperty.USER_HOME.getValue();
        if (theValue != null && theValue.length() != 0 && (theFolder = new File(theValue)).exists() && theFolder.isDirectory() && theFolder.canRead()) {
            return theFolder;
        }
        return null;
    }

    private void addUserHomeFolder(List<File> aFolders) {
        this.addFolder(ConfigLocator.toHomeFolder(), aFolders);
    }

    private void addUserHomeFolder(Folder aChildFolder, List<File> aFolders) {
        this.addFolder(ConfigLocator.toHomeFolder(), aChildFolder, aFolders);
    }

    private void addFolder(File aFolder, List<File> aFolders) {
        if (aFolder != null && aFolder.exists() && aFolder.isDirectory() && aFolder.canRead()) {
            aFolders.add(aFolder);
        }
    }

    private void addFolder(File aBaseFolder, Folder aChildFolder, List<File> aFolders) {
        if (aBaseFolder != null && aBaseFolder.exists() && aBaseFolder.isDirectory() && aBaseFolder.canRead()) {
            aBaseFolder = new File(aBaseFolder, aChildFolder.getName());
            this.addFolder(aBaseFolder, aFolders);
        }
    }

    private void addParentFolder(File aBaseFolder, Folder aChildFolder, List<File> aFolders) {
        File theParentFolder;
        if (aBaseFolder != null && aBaseFolder.exists() && aBaseFolder.isDirectory() && aBaseFolder.canRead() && (theParentFolder = aBaseFolder.getParentFile()) != null && theParentFolder.exists() && theParentFolder.isDirectory() && theParentFolder.canRead()) {
            theParentFolder = new File(theParentFolder, aChildFolder.getName());
            this.addFolder(theParentFolder, aFolders);
        }
    }
}

