/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.security.ext.chaos.impls;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import org.refcodes.exception.HiddenException;
import org.refcodes.security.DecryptionException;
import org.refcodes.security.EncryptionException;
import org.refcodes.security.alt.chaos.ChaosDecrypter;
import org.refcodes.security.alt.chaos.ChaosEncrypter;
import org.refcodes.security.alt.chaos.ChaosKey;
import org.refcodes.security.alt.chaos.impls.ChaosDecrypterImpl;
import org.refcodes.security.alt.chaos.impls.ChaosEncrypterImpl;
import org.refcodes.security.ext.chaos.impls.ChaosKeyImpl;

public class ChaosCipherImpl
extends CipherSpi {
    private ChaosDecrypter _chaosDecrypter = null;
    private ChaosEncrypter _chaosEncrypter = null;
    private int _mode;

    @Override
    protected byte[] engineDoFinal(byte[] aInput, int aInputOffset, int aInputLength) throws IllegalBlockSizeException, BadPaddingException {
        return this.engineUpdate(aInput, aInputOffset, aInputLength);
    }

    @Override
    protected int engineDoFinal(byte[] aInput, int aInputOffset, int aInputLength, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.engineUpdate(aInput, aInputOffset, aInputLength, output, outputOffset);
    }

    @Override
    protected int engineGetBlockSize() {
        return 1;
    }

    @Override
    protected byte[] engineGetIV() {
        return null;
    }

    @Override
    protected int engineGetOutputSize(int aInputLength) {
        return 0;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    @Override
    protected void engineInit(int aMode, Key aKey, SecureRandom aRandom) throws InvalidKeyException {
        this._mode = aMode;
        if (!(aKey instanceof ChaosKeyImpl)) {
            throw new InvalidKeyException("The chaos cipher requires a refcodes-security-ext-chaos (chaos) key!");
        }
        this._chaosDecrypter = new ChaosDecrypterImpl((ChaosKey)((ChaosKeyImpl)aKey));
        this._chaosEncrypter = new ChaosEncrypterImpl((ChaosKey)((ChaosKeyImpl)aKey));
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec aParams, SecureRandom aRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(opmode, key, aRandom);
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters aParams, SecureRandom aRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(opmode, key, aRandom);
    }

    @Override
    protected void engineSetMode(String aMode) throws NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException();
    }

    @Override
    protected void engineSetPadding(String aPading) throws NoSuchPaddingException {
        throw new NoSuchPaddingException();
    }

    @Override
    protected byte[] engineUpdate(byte[] aInput, int aInputOffset, int aInputLength) {
        byte[] output = new byte[aInputLength];
        try {
            this.engineUpdate(aInput, aInputOffset, aInputLength, output, 0);
        }
        catch (ShortBufferException shortBufferException) {
            // empty catch block
        }
        return output;
    }

    @Override
    protected int engineUpdate(byte[] aInput, int aInputOffset, int aInputLength, byte[] aOutput, int aOutputOffset) throws ShortBufferException {
        if (aOutput.length - aOutputOffset < aInputLength) {
            throw new ShortBufferException("Buffer too short to hold encrypted data!");
        }
        if (this._mode == 1) {
            try {
                this._chaosEncrypter.toEncrypted(aInput, aInputOffset, aInputLength, aOutput, aOutputOffset);
            }
            catch (EncryptionException e) {
                throw new HiddenException((Throwable)e);
            }
        } else if (this._mode == 2) {
            try {
                this._chaosDecrypter.toDecrypted(aInput, aInputOffset, aInputLength, aOutput, aOutputOffset);
            }
            catch (DecryptionException e) {
                throw new HiddenException((Throwable)e);
            }
        } else {
            throw new IllegalStateException("The aMode of operation is <" + this._mode + "> which does neither reflect Cipher.ENCRYPT_MODE <" + 1 + "> nor Cipher.DECRYPT_MODE <" + 2 + ">!");
        }
        return aInputLength;
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (key instanceof ChaosCipherImpl) {
            return 1;
        }
        throw new InvalidKeyException("The chaos cipher requires a refcodes-security-ext-chaos (chaos) key!");
    }
}

