/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.security.ext.chaos.impls;

import javax.crypto.SecretKey;
import org.apache.commons.lang.ArrayUtils;
import org.refcodes.numerical.NumericalUtility;
import org.refcodes.security.alt.chaos.ChaosKey;

public class ChaosKeyImpl
implements ChaosKey,
SecretKey {
    private static final long serialVersionUID = 1L;
    private double _x0;
    private double _a;
    private double _s;

    public ChaosKeyImpl(double x0, double a, double s) {
        if (x0 < 0.0 || x0 > 1.0) {
            throw new IllegalArgumentException("The value x(0) was <" + x0 + ">, though must be between <0> and <1> (0 <= x0 <= 1)");
        }
        if (a < 3.57 || a > 4.0) {
            throw new IllegalArgumentException("The value A was <" + a + ">, though must be between <3.57> and <4> (3.57 <= A <= 4)");
        }
        if (s > 9.223372036854776E18) {
            throw new IllegalArgumentException("The value S was <" + s + ">, though must be at most <" + Long.MAX_VALUE + "> (S <= Long.MAX_VALUE)");
        }
        this._x0 = x0;
        this._a = a;
        this._s = s;
    }

    @Override
    public String getAlgorithm() {
        return "refcodes-security-ext-chaos";
    }

    @Override
    public String getFormat() {
        return this.getAlgorithm() + " format";
    }

    @Override
    public byte[] getEncoded() {
        byte[] theXs = NumericalUtility.toBytes((Double)this._x0);
        byte[] theAs = NumericalUtility.toBytes((Double)this._a);
        byte[] theSs = NumericalUtility.toBytes((Double)this._s);
        byte[] theTmps = ArrayUtils.addAll((byte[])theXs, (byte[])theAs);
        return ArrayUtils.addAll((byte[])theTmps, (byte[])theSs);
    }

    public double getX0() {
        return this._x0;
    }

    public double getA() {
        return this._a;
    }

    public double getS() {
        return this._s;
    }
}

