/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.security.ext.chaos;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import org.refcodes.exception.HiddenException;
import org.refcodes.security.DecryptionException;
import org.refcodes.security.EncryptionException;
import org.refcodes.security.alt.chaos.ChaosDecrypter;
import org.refcodes.security.alt.chaos.ChaosEncrypter;
import org.refcodes.security.alt.chaos.ChaosKey;

public class ChaosCipherSpi
extends CipherSpi {
    private ChaosDecrypter _chaosDecrypter = null;
    private ChaosEncrypter _chaosEncrypter = null;
    private int _mode;

    @Override
    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        return this.engineUpdate(byArray, n, n2);
    }

    @Override
    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.engineUpdate(byArray, n, n2, byArray2, n3);
    }

    @Override
    protected int engineGetBlockSize() {
        return 1;
    }

    @Override
    protected byte[] engineGetIV() {
        return null;
    }

    @Override
    protected int engineGetOutputSize(int n) {
        return 0;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    @Override
    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this._mode = n;
        if (!(key instanceof ChaosKey)) {
            throw new InvalidKeyException("The chaos cipher requires a CHAOS (chaos) key!");
        }
        this._chaosDecrypter = new ChaosDecrypter((ChaosKey)key);
        this._chaosEncrypter = new ChaosEncrypter((ChaosKey)key);
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(n, key, secureRandom);
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(n, key, secureRandom);
    }

    @Override
    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException();
    }

    @Override
    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        throw new NoSuchPaddingException();
    }

    @Override
    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        try {
            this.engineUpdate(byArray, n, n2, byArray2, 0);
        }
        catch (ShortBufferException shortBufferException) {
            // empty catch block
        }
        return byArray2;
    }

    @Override
    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        if (byArray2.length - n3 < n2) {
            throw new ShortBufferException("Buffer too short to hold encrypted data!");
        }
        if (this._mode == 1) {
            try {
                this._chaosEncrypter.toEncrypted(byArray, n, n2, byArray2, n3);
            }
            catch (EncryptionException encryptionException) {
                throw new HiddenException((Throwable)encryptionException);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new ShortBufferException(arrayIndexOutOfBoundsException.getMessage());
            }
        } else if (this._mode == 2) {
            try {
                this._chaosDecrypter.toDecrypted(byArray, n, n2, byArray2, n3);
            }
            catch (DecryptionException decryptionException) {
                throw new HiddenException((Throwable)decryptionException);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new ShortBufferException(arrayIndexOutOfBoundsException.getMessage());
            }
        } else {
            throw new IllegalStateException("The aMode of operation is <" + this._mode + "> which does neither reflect Cipher.ENCRYPT_MODE <1> nor Cipher.DECRYPT_MODE <2>!");
        }
        return n2;
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (key instanceof ChaosCipherSpi) {
            return 1;
        }
        throw new InvalidKeyException("The chaos cipher requires a CHAOS (chaos) key!");
    }
}

