/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.security.ext.chaos;

import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import org.refcodes.numerical.NumericalUtility;
import org.refcodes.security.alt.chaos.ChaosKey;

public class ChaosKeyGenerator
extends KeyGeneratorSpi {
    SecureRandom _randomSource;

    @Override
    public void engineInit(SecureRandom secureRandom) {
        this._randomSource = secureRandom;
    }

    @Override
    public void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("No parameters supported in this class");
    }

    @Override
    public SecretKey engineGenerateKey() {
        if (this._randomSource == null) {
            this._randomSource = new SecureRandom();
        }
        double d = this._randomSource.nextDouble();
        double d2 = NumericalUtility.toScaled((double)this._randomSource.nextDouble(), (double)3.57, (double)4.0);
        long l = this._randomSource.nextLong();
        return new ChaosKey(d, d2, l);
    }

    @Override
    protected void engineInit(int n, SecureRandom secureRandom) {
        this.engineInit(secureRandom);
    }
}

