// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.security;

/**
 * Thrown in case an decryption issue occurred regarding the {@link Encrypter}.
 * Probably the configuration of your {@link Encrypter} does not fit the one of
 * the {@link Decrypter}.
 */
public class DecryptionException extends SecurityException {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	private static final long serialVersionUID = 1L;

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new decryption exception.
	 *
	 * @param aMessage the message
	 * @param aErrorCode the error code
	 */
	public DecryptionException( String aMessage, String aErrorCode ) {
		super( aMessage, aErrorCode );
	}

	/**
	 * Instantiates a new decryption exception.
	 *
	 * @param aMessage the message
	 * @param aCause the cause
	 * @param aErrorCode the error code
	 */
	public DecryptionException( String aMessage, Throwable aCause, String aErrorCode ) {
		super( aMessage, aCause, aErrorCode );
	}

	/**
	 * Instantiates a new decryption exception.
	 *
	 * @param message the message
	 * @param cause the cause
	 */
	public DecryptionException( String message, Throwable cause ) {
		super( message, cause );
	}

	/**
	 * Instantiates a new decryption exception.
	 *
	 * @param message the message
	 */
	public DecryptionException( String message ) {
		super( message );
	}

	/**
	 * Instantiates a new decryption exception.
	 *
	 * @param aCause the cause
	 * @param aErrorCode the error code
	 */
	public DecryptionException( Throwable aCause, String aErrorCode ) {
		super( aCause, aErrorCode );
	}

	/**
	 * Instantiates a new decryption exception.
	 *
	 * @param cause the cause
	 */
	public DecryptionException( Throwable cause ) {
		super( cause );
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Thrown in case an decryption issue occurred regarding the
	 * {@link Encrypter}.
	 */
	public static class DecryptionRuntimeException extends SecurityRuntimeException {

		// /////////////////////////////////////////////////////////////////////////
		// STATICS:
		// /////////////////////////////////////////////////////////////////////////

		// /////////////////////////////////////////////////////////////////////////
		// CONSTANTS:
		// /////////////////////////////////////////////////////////////////////////

		private static final long serialVersionUID = 1L;

		// /////////////////////////////////////////////////////////////////////////
		// VARIABLES:
		// /////////////////////////////////////////////////////////////////////////

		// /////////////////////////////////////////////////////////////////////////
		// CONSTRUCTORS:
		// /////////////////////////////////////////////////////////////////////////

		/**
		 * Instantiates a new decryption runtime exception.
		 *
		 * @param aMessage the message
		 * @param aErrorCode the error code
		 */
		public DecryptionRuntimeException( String aMessage, String aErrorCode ) {
			super( aMessage, aErrorCode );
		}

		/**
		 * Instantiates a new decryption runtime exception.
		 *
		 * @param aMessage the message
		 * @param aCause the cause
		 * @param aErrorCode the error code
		 */
		public DecryptionRuntimeException( String aMessage, Throwable aCause, String aErrorCode ) {
			super( aMessage, aCause, aErrorCode );
		}

		/**
		 * Instantiates a new decryption runtime exception.
		 *
		 * @param message the message
		 * @param cause the cause
		 */
		public DecryptionRuntimeException( String message, Throwable cause ) {
			super( message, cause );
		}

		/**
		 * Instantiates a new decryption runtime exception.
		 *
		 * @param message the message
		 */
		public DecryptionRuntimeException( String message ) {
			super( message );
		}

		/**
		 * Instantiates a new decryption runtime exception.
		 *
		 * @param aCause the cause
		 * @param aErrorCode the error code
		 */
		public DecryptionRuntimeException( Throwable aCause, String aErrorCode ) {
			super( aCause, aErrorCode );
		}

		/**
		 * Instantiates a new decryption runtime exception.
		 *
		 * @param cause the cause
		 */
		public DecryptionRuntimeException( Throwable cause ) {
			super( cause );
		}

		// /////////////////////////////////////////////////////////////////////////
		// INJECTION:
		// /////////////////////////////////////////////////////////////////////////

		// /////////////////////////////////////////////////////////////////////////
		// METHODS:
		// /////////////////////////////////////////////////////////////////////////

		// /////////////////////////////////////////////////////////////////////////
		// HOOKS:
		// /////////////////////////////////////////////////////////////////////////

		// /////////////////////////////////////////////////////////////////////////
		// HELPER:
		// /////////////////////////////////////////////////////////////////////////

		// /////////////////////////////////////////////////////////////////////////
		// INNER CLASSES:
		// /////////////////////////////////////////////////////////////////////////

	}

}
