/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial.ext.handshake;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.refcodes.serial.AssertMagicBytesSegment;
import org.refcodes.serial.CrcSegmentDecorator;
import org.refcodes.serial.Segment;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SequenceNumberSegment;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.SerialSugar;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.serial.ext.handshake.AcknowledgeType;
import org.refcodes.serial.ext.handshake.AcknowledgeTypeAccessor;
import org.refcodes.serial.ext.handshake.HandshakeMessage;
import org.refcodes.serial.ext.handshake.HandshakeTransmissionMetrics;
import org.refcodes.struct.SimpleTypeMap;
import org.refcodes.struct.SimpleTypeMapImpl;

class AcknowledgeMessage
implements HandshakeMessage,
AcknowledgeTypeAccessor {
    private static final long serialVersionUID = 1L;
    protected Segment _delegatee = null;
    private SequenceNumberSegment _sequenceNumberSegment;
    private AssertMagicBytesSegment _assertMagicBytesSegment;
    private HandshakeTransmissionMetrics _transmissionMetrics;

    public AcknowledgeMessage(AcknowledgeType aAcknowledgeType, int aSequenceNumber) {
        this(aAcknowledgeType, aSequenceNumber, new HandshakeTransmissionMetrics());
    }

    public AcknowledgeMessage(AcknowledgeType aAcknowledgeType, int aSequenceNumber, HandshakeTransmissionMetrics aTransmissionMetrics) {
        aTransmissionMetrics = aTransmissionMetrics != null ? aTransmissionMetrics : new HandshakeTransmissionMetrics();
        CrcSegmentDecorator[] crcSegmentDecoratorArray = new CrcSegmentDecorator[1];
        Segment.SegmentMixin[] segmentMixinArray = new Segment.SegmentMixin[2];
        this._assertMagicBytesSegment = SerialSugar.assertMagicBytesSegment((byte[])aTransmissionMetrics.toMagicBytes(aAcknowledgeType), (TransmissionMetrics)aTransmissionMetrics);
        segmentMixinArray[0] = this._assertMagicBytesSegment;
        this._sequenceNumberSegment = SerialSugar.sequenceNumberSegment((long)aSequenceNumber, (TransmissionMetrics)aTransmissionMetrics);
        segmentMixinArray[1] = this._sequenceNumberSegment;
        crcSegmentDecoratorArray[0] = SerialSugar.crcSegment((Segment)SerialSugar.segmentComposite((Segment[])segmentMixinArray), (TransmissionMetrics)aTransmissionMetrics);
        this._delegatee = SerialSugar.segmentComposite((Segment[])crcSegmentDecoratorArray);
        this._transmissionMetrics = aTransmissionMetrics;
    }

    public AcknowledgeMessage(AcknowledgeType aAcknowledgeType) {
        this(aAcknowledgeType, -1, new HandshakeTransmissionMetrics());
    }

    public AcknowledgeMessage(AcknowledgeType aAcknowledgeType, HandshakeTransmissionMetrics aTransmissionMetrics) {
        this(aAcknowledgeType, -1, aTransmissionMetrics);
    }

    public int getLength() {
        return this._delegatee.getLength();
    }

    public Sequence toSequence() {
        return this._delegatee.toSequence();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [segment=" + this._delegatee + "]";
    }

    public SimpleTypeMap toSimpleTypeMap() {
        return this._delegatee != null ? this._delegatee.toSimpleTypeMap() : new SimpleTypeMapImpl();
    }

    public void transmitTo(OutputStream aOutputStream, InputStream aReturnStream) throws IOException {
        this._delegatee.transmitTo(aOutputStream, aReturnStream);
    }

    public SerialSchema toSchema() {
        return this._delegatee.toSchema();
    }

    public int fromTransmission(Sequence aSequence, int aOffset) throws TransmissionException {
        return this._delegatee.fromTransmission(aSequence, aOffset);
    }

    public void receiveFrom(InputStream aInputStream, OutputStream aReturnStream) throws IOException, TransmissionException {
        this._delegatee.receiveFrom(aInputStream, aReturnStream);
    }

    public int getSequenceNumber() {
        return this._sequenceNumberSegment != null ? (this._sequenceNumberSegment.getValue() != null ? this._sequenceNumberSegment.getValue().intValue() : -1) : -1;
    }

    public byte[] getMagicBytes() {
        return this._assertMagicBytesSegment.getMagicBytes();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._delegatee == null ? 0 : this._delegatee.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AcknowledgeMessage other = (AcknowledgeMessage)obj;
        return !(this._delegatee == null ? other._delegatee != null : !this._delegatee.equals(other._delegatee));
    }

    @Override
    public AcknowledgeType getAcknowledgeType() {
        return this._transmissionMetrics.toAcknowledgeType(this._assertMagicBytesSegment.getMagicBytes());
    }
}

