/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial.ext.handshake;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import org.refcodes.data.AckTimeout;
import org.refcodes.data.IoRetryCount;
import org.refcodes.mixin.ConcatenateMode;
import org.refcodes.numerical.ChecksumValidationMode;
import org.refcodes.numerical.CrcAlgorithm;
import org.refcodes.numerical.Endianess;
import org.refcodes.serial.MagicBytes;
import org.refcodes.serial.SegmentPackager;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.serial.ext.handshake.AcknowledgeType;
import org.refcodes.serial.ext.handshake.ReplyRetryNumberAccessor;
import org.refcodes.serial.ext.handshake.ReplyTimeoutMillisAccessor;
import org.refcodes.serial.ext.handshake.TransmissionType;

public class HandshakeTransmissionMetrics
extends TransmissionMetrics
implements ReplyRetryNumberAccessor,
ReplyTimeoutMillisAccessor {
    private static final byte[] DEFAULT_ACKNOWLEDGEABLE_TRANSMISSION_MAGIC_BYTES = MagicBytes.ACKNOWLEDGEABLE_TRANSMISSION.getMagicBytes();
    private static final byte[] DEFAULT_ACKNOWLEDGEABLE_RESPONSE_MAGIC_BYTES = MagicBytes.ACKNOWLEDGEABLE_RESPONSE.getMagicBytes();
    private static final byte[] DEFAULT_ACKNOWLEDGEABLE_REQUEST_MAGIC_BYTES = MagicBytes.ACKNOWLEDGEABLE_REQUEST.getMagicBytes();
    private static final byte[] DEFAULT_TRANSMISSION_MAGIC_BYTES = MagicBytes.TRANSMISSION.getMagicBytes();
    private static final byte[] DEFAULT_RESPONSE_MAGIC_BYTES = MagicBytes.RESPONSE.getMagicBytes();
    private static final byte[] DEFAULT_RESPONSE_ACKNOWLEDGE_MAGIC_BYTES = MagicBytes.RESPONSE_ACKNOWLEDGE.getMagicBytes();
    private static final byte[] DEFAULT_REQUEST_MAGIC_BYTES = MagicBytes.REQUEST.getMagicBytes();
    private static final byte[] DEFAULT_TRANSMISSION_DISMISSED_MAGIC_BYTES = MagicBytes.TRANSMISSION_DISMISSED.getMagicBytes();
    private static final byte[] DEFAULT_REQUEST_DISMISSED_MAGIC_BYTES = MagicBytes.REQUEST_DISMISSED.getMagicBytes();
    public static final int DEFAULT_REPLY_RETRY_NUMBER = IoRetryCount.NORM.getValue();
    public static final long DEFAULT_REPLY_TIMEOUT_IN_MS = AckTimeout.NORM.getTimeMillis();
    private byte[] _acknowledgeableTransmissionMagicBytes = DEFAULT_ACKNOWLEDGEABLE_TRANSMISSION_MAGIC_BYTES;
    private byte[] _acknowledgeableResponseMagicBytes = DEFAULT_ACKNOWLEDGEABLE_RESPONSE_MAGIC_BYTES;
    private byte[] _acknowledgeableRequestMagicBytes = DEFAULT_ACKNOWLEDGEABLE_REQUEST_MAGIC_BYTES;
    private byte[] _transmissionMagicBytes = DEFAULT_TRANSMISSION_MAGIC_BYTES;
    private byte[] _responseMagicBytes = DEFAULT_RESPONSE_MAGIC_BYTES;
    private byte[] _responseAcknowledgeMagicBytes = DEFAULT_RESPONSE_ACKNOWLEDGE_MAGIC_BYTES;
    private byte[] _requestMagicBytes = DEFAULT_REQUEST_MAGIC_BYTES;
    private byte[] _transmissionDismissedMagicBytes = DEFAULT_TRANSMISSION_DISMISSED_MAGIC_BYTES;
    private byte[] _requestDismissedMagicBytes = DEFAULT_REQUEST_DISMISSED_MAGIC_BYTES;
    protected int _replyRetryNumber = DEFAULT_REPLY_RETRY_NUMBER;
    protected long _replyTimeoutInMs = DEFAULT_REPLY_TIMEOUT_IN_MS;

    protected HandshakeTransmissionMetrics(Builder aBuilder) {
        super((TransmissionMetrics.Builder)aBuilder);
        this._acknowledgeableRequestMagicBytes = aBuilder.acknowledgeableRequestMagicBytes;
        this._acknowledgeableResponseMagicBytes = aBuilder.acknowledgeableResponseMagicBytes;
        this._acknowledgeableTransmissionMagicBytes = aBuilder.acknowledgeableTransmissionMagicBytes;
        this._requestMagicBytes = aBuilder.requestMagicBytes;
        this._responseMagicBytes = aBuilder.responseMagicBytes;
        this._responseAcknowledgeMagicBytes = aBuilder.responseAcknowledgeMagicBytes;
        this._transmissionMagicBytes = aBuilder.transmissionMagicBytes;
        this._requestDismissedMagicBytes = aBuilder.requestDismissedMagicBytes;
        this._transmissionDismissedMagicBytes = aBuilder.transmissionDismissedMagicBytes;
        this._replyRetryNumber = aBuilder.replyRetryNumber;
        this._replyTimeoutInMs = aBuilder.replyTimeoutInMs;
        this.validateMagicBytes();
    }

    public HandshakeTransmissionMetrics() {
        this.validateMagicBytes();
    }

    @Override
    public int getReplyRetryNumber() {
        return this._replyRetryNumber;
    }

    @Override
    public long getReplyTimeoutMillis() {
        return this._replyTimeoutInMs;
    }

    public byte[] getAcknowledgeableTransmissionMagicBytes() {
        return this._acknowledgeableTransmissionMagicBytes;
    }

    public byte[] getAcknowledgeableResponseMagicBytes() {
        return this._acknowledgeableResponseMagicBytes;
    }

    public byte[] getAcknowledgeableRequestMagicBytes() {
        return this._acknowledgeableRequestMagicBytes;
    }

    public byte[] getTransmissionMagicBytes() {
        return this._transmissionMagicBytes;
    }

    public byte[] getResponseMagicBytes() {
        return this._responseMagicBytes;
    }

    public byte[] getResponseAcknowledgeMagicBytes() {
        return this._responseAcknowledgeMagicBytes;
    }

    public byte[] getRequestMagicBytes() {
        return this._requestMagicBytes;
    }

    public byte[] getTransmissionDismissedMagicBytes() {
        return this._transmissionDismissedMagicBytes;
    }

    public byte[] getRequestDismissedMagicBytes() {
        return this._requestDismissedMagicBytes;
    }

    public AcknowledgeType toAcknowledgeType(byte[] aMagicBytes) throws IllegalArgumentException {
        if (Arrays.equals(this.getAcknowledgeMagicBytes(), aMagicBytes)) {
            return AcknowledgeType.ACKNOWLEDGE;
        }
        if (Arrays.equals(this.getResponseAcknowledgeMagicBytes(), aMagicBytes)) {
            return AcknowledgeType.RESPONSE;
        }
        if (Arrays.equals(this.getTransmissionDismissedMagicBytes(), aMagicBytes)) {
            return AcknowledgeType.TRANSMISSION_DISMISSED;
        }
        if (Arrays.equals(this.getRequestDismissedMagicBytes(), aMagicBytes)) {
            return AcknowledgeType.REQUEST_DISMISSED;
        }
        if (Arrays.equals(this.getPongMagicBytes(), aMagicBytes)) {
            return AcknowledgeType.PONG;
        }
        throw new IllegalArgumentException((String)("The provided magic bytes <" + aMagicBytes.length != null ? Arrays.toString(aMagicBytes) : "null> did not match any <" + AcknowledgeType.class.getSimpleName() + ">!"));
    }

    public byte[] toMagicBytes(AcknowledgeType aAcknowledgeType) {
        switch (aAcknowledgeType) {
            case ACKNOWLEDGE: {
                return this.getAcknowledgeMagicBytes();
            }
            case REQUEST_DISMISSED: {
                return this.getRequestDismissedMagicBytes();
            }
            case RESPONSE: {
                return this.getResponseAcknowledgeMagicBytes();
            }
            case TRANSMISSION_DISMISSED: {
                return this.getTransmissionDismissedMagicBytes();
            }
            case PONG: {
                return this.getPongMagicBytes();
            }
        }
        return null;
    }

    public TransmissionType toTransmissionType(byte[] aMagicBytes) throws IllegalArgumentException {
        if (Arrays.equals(this.getAcknowledgeableRequestMagicBytes(), aMagicBytes)) {
            return TransmissionType.ACKNOWLEDGEABLE_REQUEST;
        }
        if (Arrays.equals(this.getAcknowledgeableResponseMagicBytes(), aMagicBytes)) {
            return TransmissionType.ACKNOWLEDGEABLE_RESPONSE;
        }
        if (Arrays.equals(this.getAcknowledgeableTransmissionMagicBytes(), aMagicBytes)) {
            return TransmissionType.ACKNOWLEDGEABLE_TRANSMISSION;
        }
        if (Arrays.equals(this.getRequestMagicBytes(), aMagicBytes)) {
            return TransmissionType.REQUEST;
        }
        if (Arrays.equals(this.getResponseMagicBytes(), aMagicBytes)) {
            return TransmissionType.RESPONSE;
        }
        if (Arrays.equals(this.getTransmissionMagicBytes(), aMagicBytes)) {
            return TransmissionType.TRANSMISSION;
        }
        if (Arrays.equals(this.getPingMagicBytes(), aMagicBytes)) {
            return TransmissionType.PING;
        }
        throw new IllegalArgumentException((String)("The provided magic bytes <" + aMagicBytes.length != null ? Arrays.toString(aMagicBytes) : "null> did not match any <" + TransmissionType.class.getSimpleName() + ">!"));
    }

    public byte[] toMagicBytes(TransmissionType aTransmissionType) {
        switch (aTransmissionType) {
            case ACKNOWLEDGEABLE_REQUEST: {
                return this.getAcknowledgeableRequestMagicBytes();
            }
            case ACKNOWLEDGEABLE_RESPONSE: {
                return this.getAcknowledgeableResponseMagicBytes();
            }
            case ACKNOWLEDGEABLE_TRANSMISSION: {
                return this.getAcknowledgeableTransmissionMagicBytes();
            }
            case REQUEST: {
                return this.getRequestMagicBytes();
            }
            case RESPONSE: {
                return this.getResponseMagicBytes();
            }
            case TRANSMISSION: {
                return this.getTransmissionMagicBytes();
            }
            case PING: {
                return this.getPingMagicBytes();
            }
        }
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    private void validateMagicBytes() {
        HashMap<Enum, byte[]> theValidationMap = new HashMap<Enum, byte[]>();
        for (AcknowledgeType acknowledgeType : AcknowledgeType.values()) {
            for (Object eKey : theValidationMap.keySet()) {
                if (!Arrays.equals((byte[])theValidationMap.get(eKey), this.toMagicBytes(acknowledgeType))) continue;
                throw new IllegalArgumentException("The magic bytes (" + Arrays.toString((byte[])theValidationMap.get(eKey)) + ") assigned to <" + eKey.getClass().getSimpleName() + "." + eKey.toString() + "> must not be the same as the magic bytes (" + Arrays.toString(this.toMagicBytes(acknowledgeType)) + ") assigned to <" + ((Object)((Object)acknowledgeType)).getClass().getSimpleName() + "." + acknowledgeType.toString() + ">!");
            }
            theValidationMap.put(acknowledgeType, this.toMagicBytes(acknowledgeType));
        }
        for (Enum enum_ : TransmissionType.values()) {
            for (Object eKey : theValidationMap.keySet()) {
                if (!Arrays.equals((byte[])theValidationMap.get(eKey), this.toMagicBytes((TransmissionType)enum_))) continue;
                throw new IllegalArgumentException("The magic bytes (" + Arrays.toString((byte[])theValidationMap.get(eKey)) + ") assigned to <" + eKey.getClass().getSimpleName() + "." + eKey.toString() + "> must not be the same as the magic bytes (" + Arrays.toString(this.toMagicBytes((TransmissionType)enum_)) + ") assigned to <" + enum_.getClass().getSimpleName() + "." + enum_.toString() + ">!");
            }
            theValidationMap.put(enum_, this.toMagicBytes((TransmissionType)enum_));
        }
    }

    public static class Builder
    extends TransmissionMetrics.Builder
    implements ReplyRetryNumberAccessor.ReplyRetryNumberBuilder<Builder>,
    ReplyTimeoutMillisAccessor.ReplyTimeoutMillisBuilder<Builder> {
        protected byte[] acknowledgeableTransmissionMagicBytes = DEFAULT_ACKNOWLEDGEABLE_TRANSMISSION_MAGIC_BYTES;
        protected byte[] acknowledgeableResponseMagicBytes = DEFAULT_ACKNOWLEDGEABLE_RESPONSE_MAGIC_BYTES;
        protected byte[] acknowledgeableRequestMagicBytes = DEFAULT_ACKNOWLEDGEABLE_REQUEST_MAGIC_BYTES;
        protected byte[] transmissionMagicBytes = DEFAULT_TRANSMISSION_MAGIC_BYTES;
        protected byte[] responseMagicBytes = DEFAULT_RESPONSE_MAGIC_BYTES;
        protected byte[] requestMagicBytes = DEFAULT_REQUEST_MAGIC_BYTES;
        protected byte[] transmissionDismissedMagicBytes = DEFAULT_TRANSMISSION_DISMISSED_MAGIC_BYTES;
        protected byte[] requestDismissedMagicBytes = DEFAULT_REQUEST_DISMISSED_MAGIC_BYTES;
        protected byte[] responseAcknowledgeMagicBytes = DEFAULT_RESPONSE_ACKNOWLEDGE_MAGIC_BYTES;
        protected int replyRetryNumber = DEFAULT_REPLY_RETRY_NUMBER;
        protected long replyTimeoutInMs = DEFAULT_REPLY_TIMEOUT_IN_MS;

        protected Builder() {
        }

        @Override
        public Builder withReplyRetryNumber(int aReplyRetryNumber) {
            this.replyRetryNumber = aReplyRetryNumber;
            return this;
        }

        @Override
        public Builder withReplyTimeoutMillis(long aReplyTimeoutInMs) {
            this.replyTimeoutInMs = aReplyTimeoutInMs;
            return this;
        }

        public Builder withIoHeuristicsTimeToLiveMillis(long aIoHeuristicsTimeToLiveInMs) {
            this.ioHeuristicsTimeToLiveInMs = aIoHeuristicsTimeToLiveInMs;
            return this;
        }

        public Builder withPongMagicBytes(byte[] aPongMagicBytes) {
            this.pongMagicBytes = aPongMagicBytes;
            return this;
        }

        public Builder withPingMagicBytes(byte[] aPingMagicBytes) {
            this.pingMagicBytes = aPingMagicBytes;
            return this;
        }

        public Builder withPingRetryNumber(int aPingRetryNumber) {
            this.pingRetryNumber = aPingRetryNumber;
            return this;
        }

        public Builder withPingTimeoutMillis(long aPingTimeoutInMs) {
            this.pingTimeoutInMs = aPingTimeoutInMs;
            return this;
        }

        public Builder withAcknowledgeMagicBytes(byte[] aAcknowledgeMagicBytes) {
            this.acknowledgeMagicBytes = aAcknowledgeMagicBytes;
            return this;
        }

        public Builder withClearToSendMagicBytes(byte[] aClearToSendMagicBytes) {
            this.clearToSendMagicBytes = aClearToSendMagicBytes;
            return this;
        }

        public Builder withPacketMagicBytes(byte[] aPacketMagicBytes) {
            this.packetMagicBytes = aPacketMagicBytes;
            return this;
        }

        public Builder withReadyToReceiveMagicBytes(byte[] aReadyToReceiveMagicBytes) {
            this.readyToReceiveMagicBytes = aReadyToReceiveMagicBytes;
            return this;
        }

        public Builder withReadyToSendMagicBytes(byte[] aReadyToSendMagicBytes) {
            this.readyToSendMagicBytes = aReadyToSendMagicBytes;
            return this;
        }

        public Builder withAcknowledgeRetryNumber(int aAcknowledgeRetryNumber) {
            this.acknowledgeRetryNumber = aAcknowledgeRetryNumber;
            return this;
        }

        public Builder withAcknowledgeSegmentPackager(SegmentPackager aAcknowledgeSegmentPackager) {
            this.acknowledgeSegmentPackager = aAcknowledgeSegmentPackager;
            return this;
        }

        public Builder withAcknowledgeTimeoutMillis(long aAcknowledgeTimeoutInMs) {
            this.acknowledgeTimeoutInMs = aAcknowledgeTimeoutInMs;
            return this;
        }

        public Builder withBlockSize(int aBlockSize) {
            this.blockSize = aBlockSize;
            return this;
        }

        public Builder withChecksumValidationMode(ChecksumValidationMode aChecksumValidationMode) {
            this.checksumValidationMode = aChecksumValidationMode;
            return this;
        }

        public Builder withClearToSendSegmentPackager(SegmentPackager aClearToSendSegmentPackager) {
            this.clearToSendSegmentPackager = aClearToSendSegmentPackager;
            return this;
        }

        public Builder withClearToSendTimeoutMillis(long aClearToSendTimeoutInMs) {
            this.clearToSendTimeoutInMs = aClearToSendTimeoutInMs;
            return this;
        }

        public Builder withCrcAlgorithm(CrcAlgorithm aCrcAlgorithm) {
            this.crcAlgorithm = aCrcAlgorithm;
            return this;
        }

        public Builder withCrcChecksumConcatenateMode(ConcatenateMode aChecksumConcatenateMode) {
            this.crcChecksumConcatenateMode = aChecksumConcatenateMode;
            return this;
        }

        public Builder withEncoding(Charset aEncoding) {
            this.encoding = aEncoding;
            return this;
        }

        public Builder withEndianess(Endianess aEndianess) {
            this.endianess = aEndianess;
            return this;
        }

        public Builder withEndOfStringByte(byte aEndOfStringByte) {
            this.endOfStringByte = aEndOfStringByte;
            return this;
        }

        public Builder withEnquiryStandbyTimeMillis(long aEnquiryStandbyTimeInMs) {
            this.enquiryStandbyTimeInMs = aEnquiryStandbyTimeInMs;
            return this;
        }

        public Builder withLengthWidth(int aLengthWidth) {
            this.lengthWidth = aLengthWidth;
            return this;
        }

        public Builder withPacketLengthWidth(int aPacketLengthWidth) {
            this.packetLengthWidth = aPacketLengthWidth;
            return this;
        }

        public Builder withMagicBytesLength(int aMagicBytesLength) {
            this.magicBytesLength = aMagicBytesLength;
            return this;
        }

        public Builder withPacketSegmentPackager(SegmentPackager aPacketSegmentPackager) {
            this.packetSegmentPackager = aPacketSegmentPackager;
            return this;
        }

        public Builder withReadTimeoutMillis(long aReadTimeoutInMs) {
            this.readTimeoutInMs = aReadTimeoutInMs;
            return this;
        }

        public Builder withReadyToReceiveRetryNumber(int aReadyToReceiveRetryNumber) {
            this.readyToReceiveRetryNumber = aReadyToReceiveRetryNumber;
            return this;
        }

        public Builder withReadyToReceiveSegmentPackager(SegmentPackager aReadyToReceiveSegmentPackager) {
            this.readyToReceiveSegmentPackager = aReadyToReceiveSegmentPackager;
            return this;
        }

        public Builder withReadyToReceiveTimeoutMillis(long aReadyToReceiveTimeoutInMs) {
            this.readyToReceiveTimeoutInMs = aReadyToReceiveTimeoutInMs;
            return this;
        }

        public Builder withReadyToSendRetryNumber(int aReadyToSendRetryNumber) {
            this.readyToSendRetryNumber = aReadyToSendRetryNumber;
            return this;
        }

        public Builder withReadyToSendSegmentPackager(SegmentPackager aReadyToSendSegmentPackager) {
            this.readyToSendSegmentPackager = aReadyToSendSegmentPackager;
            return this;
        }

        public Builder withReadyToSendTimeoutMillis(long aReadyToSendTimeoutInMs) {
            this.readyToSendTimeoutInMs = aReadyToSendTimeoutInMs;
            return this;
        }

        public Builder withSequenceNumberConcatenateMode(ConcatenateMode aSequenceNumberConcatenateMode) {
            this.sequenceNumberConcatenateMode = aSequenceNumberConcatenateMode;
            return this;
        }

        public Builder withSequenceNumberInitValue(int aSequenceNumberInitValue) {
            this.sequenceNumberInitValue = aSequenceNumberInitValue;
            return this;
        }

        public Builder withSequenceNumberWidth(int aSequenceNumberWidth) {
            this.sequenceNumberWidth = aSequenceNumberWidth;
            return this;
        }

        public Builder withTransmissionRetryNumber(int aTransmissionRetryNumber) {
            this.transmissionRetryNumber = aTransmissionRetryNumber;
            return this;
        }

        public Builder withTransmissionTimeoutMillis(long aTransmissionTimeoutInMs) {
            this.transmissionTimeoutInMs = aTransmissionTimeoutInMs;
            return this;
        }

        public Builder withWriteTimeoutMillis(long aWriteTimeoutInMs) {
            this.writeTimeoutInMs = aWriteTimeoutInMs;
            return this;
        }

        public Builder withAcknowledgeableTransmissionMagicBytes(byte[] aAcknowledgeableTransmissionMagicBytes) {
            this.acknowledgeableTransmissionMagicBytes = aAcknowledgeableTransmissionMagicBytes;
            return this;
        }

        public Builder withAcknowledgeableResponseMagicBytes(byte[] aAcknowledgeableResponseMagicBytes) {
            this.acknowledgeableResponseMagicBytes = aAcknowledgeableResponseMagicBytes;
            return this;
        }

        public Builder withAcknowledgeableRequestMagicBytes(byte[] aAcknowledgeableRequestMagicBytes) {
            this.acknowledgeableRequestMagicBytes = aAcknowledgeableRequestMagicBytes;
            return this;
        }

        public Builder withTransmissionMagicBytes(byte[] aTransmissionMagicBytes) {
            this.transmissionMagicBytes = aTransmissionMagicBytes;
            return this;
        }

        public Builder withResponseMagicBytes(byte[] aResponseMagicBytes) {
            this.responseMagicBytes = aResponseMagicBytes;
            return this;
        }

        public Builder withResponseAcknowledgeMagicBytes(byte[] aResponseAcknowledgeMagicBytes) {
            this.responseAcknowledgeMagicBytes = aResponseAcknowledgeMagicBytes;
            return this;
        }

        public Builder withRequestMagicBytes(byte[] aRequestMagicBytes) {
            this.requestMagicBytes = aRequestMagicBytes;
            return this;
        }

        public Builder withTransmissionDismissedMagicBytes(byte[] aTransmissionDismissedMagicBytes) {
            this.transmissionDismissedMagicBytes = aTransmissionDismissedMagicBytes;
            return this;
        }

        public Builder withRequestDismissedMagicBytes(byte[] aRequestDismissedMagicBytes) {
            this.requestDismissedMagicBytes = aRequestDismissedMagicBytes;
            return this;
        }

        public HandshakeTransmissionMetrics build() {
            return new HandshakeTransmissionMetrics(this);
        }
    }
}

