/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial.ext.handshake;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.refcodes.exception.ExceptionAccessor;
import org.refcodes.mixin.PayloadAccessor;
import org.refcodes.serial.AllocSegmentBody;
import org.refcodes.serial.AllocSegmentHead;
import org.refcodes.serial.AssertMagicBytesSegment;
import org.refcodes.serial.ComplexTypeSegment;
import org.refcodes.serial.CrcSegmentDecorator;
import org.refcodes.serial.PayloadSegment;
import org.refcodes.serial.Section;
import org.refcodes.serial.Segment;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SequenceNumberSegment;
import org.refcodes.serial.SequenceSection;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.SerialSugar;
import org.refcodes.serial.Transmission;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.serial.ext.handshake.HandshakeMessage;
import org.refcodes.serial.ext.handshake.HandshakeTransmissionMetrics;
import org.refcodes.serial.ext.handshake.TransmissionType;
import org.refcodes.serial.ext.handshake.TransmissionTypeAccessor;
import org.refcodes.struct.SimpleTypeMap;
import org.refcodes.struct.SimpleTypeMapImpl;

class TransmissionMessage
implements HandshakeMessage,
ExceptionAccessor.ExceptionProperty<IOException>,
PayloadAccessor<Transmission>,
TransmissionTypeAccessor {
    private static final long serialVersionUID = 1L;
    private IOException _exception = null;
    private boolean _hasAcknowledge = false;
    private boolean _hasResponse = false;
    private Segment _delegatee = null;
    private Transmission _cargo;
    private SequenceNumberSegment _sequenceNumberSegment;
    private AssertMagicBytesSegment _assertMagicBytesSegment;
    private HandshakeTransmissionMetrics _transmissionMetrics;
    private Segment _responseSegment;

    public TransmissionMessage(TransmissionType aTransmissionType, HandshakeTransmissionMetrics aTransmissionMetrics) {
        if (aTransmissionType == TransmissionType.PING) {
            this.toPingMessage(-1, aTransmissionType, aTransmissionMetrics);
        } else {
            this.toTransmissionMessage(-1, aTransmissionType, (Sequence)null, aTransmissionMetrics);
        }
    }

    public <T> TransmissionMessage(int aSequenceNumber, TransmissionType aTransmissionType, T aPayload, HandshakeTransmissionMetrics aTransmissionMetrics) {
        if (aTransmissionType == TransmissionType.PING) {
            throw new IllegalArgumentException("This constructor must not(!) be invoked for a transmission type <" + TransmissionType.PING + ">!");
        }
        this.toTransmissionMessage(aSequenceNumber, aTransmissionType, (Segment)new ComplexTypeSegment(aPayload, (TransmissionMetrics)aTransmissionMetrics), aTransmissionMetrics);
    }

    public TransmissionMessage(int aSequenceNumber, TransmissionType aTransmissionType, Segment aRequestSegment, Segment aResponseSegment, HandshakeTransmissionMetrics aTransmissionMetrics) {
        if (aTransmissionType == TransmissionType.PING) {
            throw new IllegalArgumentException("This constructor must not(!) be invoked for a transmission type <" + TransmissionType.PING + ">!");
        }
        this.toTransmissionMessage(aSequenceNumber, aTransmissionType, aRequestSegment, aTransmissionMetrics);
        this._responseSegment = aResponseSegment;
    }

    public TransmissionMessage(int aSequenceNumber, TransmissionType aTransmissionType, HandshakeTransmissionMetrics aTransmissionMetrics) {
        if (aTransmissionType != TransmissionType.PING) {
            throw new IllegalArgumentException("This constructor must only be invoked for a transmission type <" + TransmissionType.PING + ">!");
        }
        this.toPingMessage(aSequenceNumber, aTransmissionType, aTransmissionMetrics);
    }

    public TransmissionMessage(int aSequenceNumber, TransmissionType aTransmissionType, Segment aCargoSegment, HandshakeTransmissionMetrics aTransmissionMetrics) {
        if (aTransmissionType == TransmissionType.PING) {
            throw new IllegalArgumentException("This constructor must not(!) be invoked for a transmission type <" + TransmissionType.PING + ">!");
        }
        this.toTransmissionMessage(aSequenceNumber, aTransmissionType, aCargoSegment, aTransmissionMetrics);
    }

    public TransmissionMessage(int aSequenceNumber, TransmissionType aTransmissionType, Sequence aCargoSequence, HandshakeTransmissionMetrics aTransmissionMetrics) {
        if (aTransmissionType == TransmissionType.PING) {
            throw new IllegalArgumentException("This constructor must not(!) be invoked for a transmission type <" + TransmissionType.PING + ">!");
        }
        this.toTransmissionMessage(aSequenceNumber, aTransmissionType, aCargoSequence, aTransmissionMetrics);
    }

    public int getLength() {
        return this._delegatee.getLength();
    }

    public Sequence toSequence() {
        return this._delegatee.toSequence();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [segment=" + this._delegatee + "]";
    }

    public SimpleTypeMap toSimpleTypeMap() {
        return this._delegatee != null ? this._delegatee.toSimpleTypeMap() : new SimpleTypeMapImpl();
    }

    public void transmitTo(OutputStream aOutputStream, InputStream aReturnStream) throws IOException {
        this._delegatee.transmitTo(aOutputStream, aReturnStream);
    }

    public SerialSchema toSchema() {
        return this._delegatee.toSchema();
    }

    public int fromTransmission(Sequence aSequence, int aOffset) throws TransmissionException {
        return this._delegatee.fromTransmission(aSequence, aOffset);
    }

    public void receiveFrom(InputStream aInputStream, OutputStream aReturnStream) throws IOException, TransmissionException {
        this._delegatee.receiveFrom(aInputStream, aReturnStream);
    }

    public int getSequenceNumber() {
        if (this._sequenceNumberSegment != null) {
            return this._sequenceNumberSegment.getValue() != null ? this._sequenceNumberSegment.getValue().intValue() : -1;
        }
        throw new IllegalStateException("A transmission segment of type <" + this.getTransmissionType() + "> does not have a sequence nummber!");
    }

    public byte[] getMagicBytes() {
        return this._assertMagicBytesSegment.getMagicBytes();
    }

    public Transmission getPayload() {
        return this._cargo;
    }

    public <SEGMENT extends Segment> SEGMENT toPayloadSegment(SEGMENT aPayloadSegment) throws TransmissionException {
        aPayloadSegment.fromTransmission(this._cargo.toSequence());
        return aPayloadSegment;
    }

    public <SEGMENT extends PayloadSegment<T>, T> T toPayload(SEGMENT aPayloadSegment) throws TransmissionException {
        aPayloadSegment.fromTransmission(this._cargo.toSequence());
        return (T)aPayloadSegment.getPayload();
    }

    public <T> T toPayload(Class<T> aType) throws TransmissionException {
        return this.toPayload(new ComplexTypeSegment(aType, (TransmissionMetrics)this._transmissionMetrics));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._delegatee == null ? 0 : this._delegatee.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TransmissionMessage other = (TransmissionMessage)obj;
        return !(this._delegatee == null ? other._delegatee != null : !this._delegatee.equals(other._delegatee));
    }

    public void acknowledge() {
        this.setAcknowledge(true);
    }

    public boolean hasAcknowledge() {
        return this._hasAcknowledge;
    }

    public void setAcknowledge(boolean hasAcknowledge) {
        this._hasAcknowledge = hasAcknowledge;
    }

    public boolean hasResponse() {
        return this._hasResponse;
    }

    public void setResponse(Sequence aResponse) throws TransmissionException {
        this._responseSegment.fromTransmission(aResponse);
        this._hasResponse = true;
    }

    public IOException getException() {
        return this._exception;
    }

    public void setException(IOException aException) {
        this._exception = aException;
    }

    @Override
    public TransmissionType getTransmissionType() {
        return this._transmissionMetrics.toTransmissionType(this._assertMagicBytesSegment.getMagicBytes());
    }

    private void toPingMessage(int aSequenceNumber, TransmissionType aTransmissionType, HandshakeTransmissionMetrics aTransmissionMetrics) {
        CrcSegmentDecorator[] crcSegmentDecoratorArray = new CrcSegmentDecorator[1];
        Segment.SegmentMixin[] segmentMixinArray = new Segment.SegmentMixin[2];
        this._assertMagicBytesSegment = SerialSugar.assertMagicBytesSegment((byte[])aTransmissionMetrics.toMagicBytes(aTransmissionType), (TransmissionMetrics)aTransmissionMetrics);
        segmentMixinArray[0] = this._assertMagicBytesSegment;
        this._sequenceNumberSegment = SerialSugar.sequenceNumberSegment((long)aSequenceNumber, (TransmissionMetrics)aTransmissionMetrics);
        segmentMixinArray[1] = this._sequenceNumberSegment;
        crcSegmentDecoratorArray[0] = SerialSugar.crcSegment((Segment)SerialSugar.segmentComposite((Segment[])segmentMixinArray), (TransmissionMetrics)aTransmissionMetrics);
        this._delegatee = SerialSugar.segmentComposite((Segment[])crcSegmentDecoratorArray);
        this._transmissionMetrics = aTransmissionMetrics;
    }

    private void toTransmissionMessage(int aSequenceNumber, TransmissionType aTransmissionType, Segment aCargoSegment, HandshakeTransmissionMetrics aTransmissionMetrics) {
        CrcSegmentDecorator[] crcSegmentDecoratorArray = new CrcSegmentDecorator[2];
        Segment[] segmentArray = new Segment[3];
        this._assertMagicBytesSegment = SerialSugar.assertMagicBytesSegment((byte[])aTransmissionMetrics.toMagicBytes(aTransmissionType), (TransmissionMetrics)aTransmissionMetrics);
        segmentArray[0] = this._assertMagicBytesSegment;
        segmentArray[1] = SerialSugar.segmentLength((Transmission)aCargoSegment, (TransmissionMetrics)aTransmissionMetrics);
        this._sequenceNumberSegment = SerialSugar.sequenceNumberSegment((long)aSequenceNumber, (TransmissionMetrics)aTransmissionMetrics);
        segmentArray[2] = this._sequenceNumberSegment;
        crcSegmentDecoratorArray[0] = SerialSugar.crcSegment((Segment)SerialSugar.segmentComposite((Segment[])segmentArray), (TransmissionMetrics)aTransmissionMetrics);
        crcSegmentDecoratorArray[1] = SerialSugar.crcSegment((Segment)aCargoSegment, (TransmissionMetrics)aTransmissionMetrics);
        this._delegatee = SerialSugar.segmentComposite((Segment[])crcSegmentDecoratorArray);
        this._cargo = aCargoSegment;
        this._transmissionMetrics = aTransmissionMetrics;
    }

    private void toTransmissionMessage(int aSequenceNumber, TransmissionType aTransmissionType, Sequence aCargoSequence, HandshakeTransmissionMetrics aTransmissionMetrics) {
        aTransmissionMetrics = aTransmissionMetrics != null ? aTransmissionMetrics : new HandshakeTransmissionMetrics();
        SequenceSection theSequenceSection = aCargoSequence != null ? SerialSugar.sequenceSection((Sequence)aCargoSequence) : SerialSugar.sequenceSection();
        AllocSegmentBody theAllocBody = SerialSugar.allocSegmentBody((Section)theSequenceSection);
        AllocSegmentHead theAllocHead = SerialSugar.allocSegmentHead((AllocSegmentBody)theAllocBody, (TransmissionMetrics)aTransmissionMetrics);
        CrcSegmentDecorator[] crcSegmentDecoratorArray = new CrcSegmentDecorator[2];
        Segment[] segmentArray = new Segment[3];
        this._assertMagicBytesSegment = SerialSugar.assertMagicBytesSegment((byte[])aTransmissionMetrics.toMagicBytes(aTransmissionType), (TransmissionMetrics)aTransmissionMetrics);
        segmentArray[0] = this._assertMagicBytesSegment;
        segmentArray[1] = theAllocHead;
        this._sequenceNumberSegment = SerialSugar.sequenceNumberSegment((long)aSequenceNumber, (TransmissionMetrics)aTransmissionMetrics);
        segmentArray[2] = this._sequenceNumberSegment;
        crcSegmentDecoratorArray[0] = SerialSugar.crcSegment((Segment)SerialSugar.segmentComposite((Segment[])segmentArray), (TransmissionMetrics)aTransmissionMetrics);
        crcSegmentDecoratorArray[1] = SerialSugar.crcSegment((Segment)theAllocBody, (TransmissionMetrics)aTransmissionMetrics);
        this._delegatee = SerialSugar.segmentComposite((Segment[])crcSegmentDecoratorArray);
        this._cargo = theAllocBody;
        this._transmissionMetrics = aTransmissionMetrics;
    }
}

