/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.data.Text;
import org.refcodes.numerical.CrcAlgorithm;
import org.refcodes.numerical.CrcAlgorithmConfig;
import org.refcodes.numerical.Endianess;
import org.refcodes.serial.AllocSectionDecoratorSegment;
import org.refcodes.serial.AllocSegmentHead;
import org.refcodes.serial.CrcSegmentDecorator;
import org.refcodes.serial.LengthSegment;
import org.refcodes.serial.Section;
import org.refcodes.serial.Segment;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSugar;
import org.refcodes.serial.TransmissionException;

public class AllocSegmentTest {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");

    @Test
    public void testAllocSegmentDecorator() throws TransmissionException {
        for (int eLengthWidth = 2; eLengthWidth <= 8; ++eLengthWidth) {
            for (Endianess eEndianess : Endianess.values()) {
                if (IS_LOG_TESTS) {
                    System.out.println("---------- Length width = <" + eLengthWidth + ">, endianess = <" + eEndianess + "> ----------");
                }
                AllocSectionDecoratorSegment theSegment = SerialSugar.allocSegment((Section)SerialSugar.stringSection((String)Text.ARECIBO_MESSAGE.toString()), (int)eLengthWidth, (Endianess)eEndianess);
                Sequence theSequence = theSegment.toSequence();
                if (IS_LOG_TESTS) {
                    System.out.println("Sequence (hex) = " + theSequence.toHexString());
                    System.out.println("Transmission = " + theSegment.toString());
                    System.out.println("AbstractSchema = " + theSegment.toSchema());
                }
                AllocSectionDecoratorSegment theOtherSegment = SerialSugar.allocSegment((Section)SerialSugar.stringSection(), (int)eLengthWidth, (Endianess)eEndianess);
                theOtherSegment.fromTransmission(theSequence);
                Assertions.assertEquals((Object)theSegment, (Object)theOtherSegment);
                if (!IS_LOG_TESTS) continue;
                System.out.println("Other segment = " + theOtherSegment.toString());
                System.out.println("Other schema = " + theOtherSegment.toSchema());
            }
        }
    }

    @Test
    public void testLengthSegment() throws TransmissionException {
        for (int eLengthWidth = 2; eLengthWidth <= 8; ++eLengthWidth) {
            for (Endianess eEndianess : Endianess.values()) {
                if (IS_LOG_TESTS) {
                    System.out.println("---------- Length width = <" + eLengthWidth + ">, endianess = <" + eEndianess + "> ----------");
                }
                Segment[] segmentArray = new Segment[2];
                LengthSegment theLen = SerialSugar.segmentLength((int)eLengthWidth, (Endianess)eEndianess);
                segmentArray[0] = theLen;
                segmentArray[1] = (Segment)theLen.letReferencee((Object)SerialSugar.segmentComposite((Segment[])new Segment[]{SerialSugar.booleanSegment((boolean)true), SerialSugar.intSegment((Integer)5161), SerialSugar.allocSegment((Section)SerialSugar.stringSection((String)"Hello World!"))}));
                CrcSegmentDecorator theSegment = SerialSugar.crcPrefixSegment((Segment)SerialSugar.segmentComposite((Segment[])segmentArray), (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE);
                Sequence theSequence = theSegment.toSequence();
                if (IS_LOG_TESTS) {
                    System.out.println("Sequence (hex) = " + theSequence.toHexString());
                    System.out.println("Transmission = " + theSegment.toString());
                    System.out.println("AbstractSchema = " + theSegment.toSchema());
                }
                int theLength = theSegment.getLength();
                Assertions.assertEquals((int)(23 + eLengthWidth), (int)theLength);
                Assertions.assertEquals((int)(23 + eLengthWidth), (int)theSequence.getLength());
                Segment[] segmentArray2 = new Segment[2];
                LengthSegment theOtherLen = SerialSugar.segmentLength((int)eLengthWidth, (Endianess)eEndianess);
                segmentArray2[0] = theOtherLen;
                segmentArray2[1] = (Segment)theOtherLen.letReferencee((Object)SerialSugar.segmentComposite((Segment[])new Segment[]{SerialSugar.booleanSegment((boolean)true), SerialSugar.intSegment(), SerialSugar.allocSegment((Section)SerialSugar.stringSection())}));
                CrcSegmentDecorator theOtherSegment = SerialSugar.crcPrefixSegment((Segment)SerialSugar.segmentComposite((Segment[])segmentArray2), (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE);
                theOtherSegment.fromTransmission(theSequence);
                Assertions.assertEquals((Object)theSegment, (Object)theOtherSegment);
                if (IS_LOG_TESTS) {
                    System.out.println("Other segment = " + theOtherSegment.toString());
                    System.out.println("Other schema = " + theOtherSegment.toSchema());
                }
                Assertions.assertEquals((int)(23 + eLengthWidth), (int)theOtherSegment.getLength());
            }
        }
    }

    @Test
    public void testAllocHeadBodySegmentDecorator1() throws TransmissionException {
        for (int eLengthWidth = 2; eLengthWidth <= 8; ++eLengthWidth) {
            for (Endianess eEndianess : Endianess.values()) {
                if (IS_LOG_TESTS) {
                    System.out.println("---------- Length width = <" + eLengthWidth + ">, endianess = <" + eEndianess + "> ----------");
                }
                Segment[] segmentArray = new Segment[2];
                AllocSegmentHead theLen = SerialSugar.allocSegmentHead((int)eLengthWidth, (Endianess)eEndianess);
                segmentArray[0] = theLen;
                segmentArray[1] = (Segment)theLen.letBody((Object)SerialSugar.allocSegmentBody((Section)SerialSugar.stringSection((String)"Hello World!")));
                CrcSegmentDecorator theSegment = SerialSugar.crcPrefixSegment((Segment)SerialSugar.segmentComposite((Segment[])segmentArray), (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE);
                Sequence theSequence = theSegment.toSequence();
                if (IS_LOG_TESTS) {
                    System.out.println("Sequence (hex) = " + theSequence.toHexString());
                    System.out.println("Transmission = " + theSegment.toString());
                    System.out.println("AbstractSchema = " + theSegment.toSchema());
                }
                Assertions.assertEquals((int)(14 + eLengthWidth), (int)theSegment.getLength());
                Assertions.assertEquals((int)(14 + eLengthWidth), (int)theSequence.getLength());
                Segment[] segmentArray2 = new Segment[2];
                AllocSegmentHead theOtherLen = SerialSugar.allocSegmentHead((int)eLengthWidth, (Endianess)eEndianess);
                segmentArray2[0] = theOtherLen;
                segmentArray2[1] = (Segment)theOtherLen.letBody((Object)SerialSugar.allocSegmentBody((Section)SerialSugar.stringSection()));
                CrcSegmentDecorator theOtherSegment = SerialSugar.crcPrefixSegment((Segment)SerialSugar.segmentComposite((Segment[])segmentArray2), (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE);
                theOtherSegment.fromTransmission(theSequence);
                Assertions.assertEquals((Object)theOtherSegment, (Object)theOtherSegment);
                if (IS_LOG_TESTS) {
                    System.out.println("Other segment = " + theOtherSegment.toString());
                    System.out.println("Other schema = " + theOtherSegment.toSchema());
                }
                Assertions.assertEquals((int)(14 + eLengthWidth), (int)theOtherSegment.getLength());
            }
        }
    }

    @Test
    public void testAllocHeadBodySegmentDecorator2() throws TransmissionException {
        for (int eLengthWidth = 2; eLengthWidth <= 8; ++eLengthWidth) {
            for (Endianess eEndianess : Endianess.values()) {
                if (IS_LOG_TESTS) {
                    System.out.println("---------- Length width = <" + eLengthWidth + ">, endianess = <" + eEndianess + "> ----------");
                }
                Segment[] segmentArray = new Segment[4];
                AllocSegmentHead theLen = SerialSugar.allocSegmentHead((int)eLengthWidth, (Endianess)eEndianess);
                segmentArray[0] = theLen;
                segmentArray[1] = SerialSugar.booleanSegment((boolean)true);
                segmentArray[2] = SerialSugar.intSegment((Integer)5161);
                segmentArray[3] = (Segment)theLen.letBody((Object)SerialSugar.allocSegmentBody((Section)SerialSugar.stringSection((String)Text.ARECIBO_MESSAGE.toString())));
                CrcSegmentDecorator theSegment = SerialSugar.crcPrefixSegment((Segment)SerialSugar.segmentComposite((Segment[])segmentArray), (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE);
                Sequence theSequence = theSegment.toSequence();
                if (IS_LOG_TESTS) {
                    System.out.println("Sequence (hex) = " + theSequence.toHexString());
                    System.out.println("Transmission = " + theSegment.toString());
                    System.out.println("AbstractSchema = " + theSegment.toSchema());
                }
                Segment[] segmentArray2 = new Segment[4];
                AllocSegmentHead theOtherLen = SerialSugar.allocSegmentHead((int)eLengthWidth, (Endianess)eEndianess);
                segmentArray2[0] = theOtherLen;
                segmentArray2[1] = SerialSugar.booleanSegment();
                segmentArray2[2] = SerialSugar.intSegment();
                segmentArray2[3] = (Segment)theOtherLen.letBody((Object)SerialSugar.allocSegmentBody((Section)SerialSugar.stringSection()));
                CrcSegmentDecorator theOtherSegment = SerialSugar.crcPrefixSegment((Segment)SerialSugar.segmentComposite((Segment[])segmentArray2), (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE);
                theOtherSegment.fromTransmission(theSequence);
                Assertions.assertEquals((Object)theOtherSegment, (Object)theOtherSegment);
                if (!IS_LOG_TESTS) continue;
                System.out.println("Other segment = " + theOtherSegment.toString());
                System.out.println("Other schema = " + theOtherSegment.toSchema());
            }
        }
    }
}

