/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.refcodes.numerical.CrcAlgorithm;
import org.refcodes.numerical.CrcAlgorithmConfig;
import org.refcodes.security.alt.chaos.ChaosKey;
import org.refcodes.security.ext.chaos.ChaosProvider;
import org.refcodes.serial.AbstractLoopbackPortTest;
import org.refcodes.serial.BadCrcChecksumException;
import org.refcodes.serial.CipherSegmentDecorator;
import org.refcodes.serial.ComplexTypeSegment;
import org.refcodes.serial.LengthSegmentDecoratorSegment;
import org.refcodes.serial.Port;
import org.refcodes.serial.ReadyToSendSegmentDecorator;
import org.refcodes.serial.Section;
import org.refcodes.serial.Segment;
import org.refcodes.serial.SegmentResult;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSugar;
import org.refcodes.serial.SerialTransceiver;
import org.refcodes.serial.TestFixures;
import org.refcodes.serial.TransmissionException;

public class CipherTest
extends AbstractLoopbackPortTest {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");
    private static final int LOOPS = 15;

    @Disabled
    @Test
    public void testCipherSimple() throws TransmissionException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        LengthSegmentDecoratorSegment theSegment = SerialSugar.lengthSegment((Segment)SerialSugar.allocSegment((Section)SerialSugar.cipherSection((Section)SerialSugar.stringSection((String)"Hello World!"), (Cipher)CipherTest.toCipher("TopSecret123!"))));
        if (IS_LOG_TESTS) {
            System.out.println(theSegment.toSchema());
        }
        Sequence theSequence = theSegment.toSequence();
        LengthSegmentDecoratorSegment theOtherSegment = SerialSugar.lengthSegment((Segment)SerialSugar.allocSegment((Section)SerialSugar.cipherSection((Section)SerialSugar.stringSection(), (Cipher)CipherTest.toCipher("TopSecret123!"))));
        theOtherSegment.fromTransmission(theSequence);
        if (IS_LOG_TESTS) {
            System.out.println(theOtherSegment.toSchema());
        }
        Assertions.assertEquals((Object)theSegment, (Object)theOtherSegment);
    }

    @Disabled
    @Test
    public void testCipherSimpleFail() throws TransmissionException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        LengthSegmentDecoratorSegment theSegment = SerialSugar.lengthSegment((Segment)SerialSugar.allocSegment((Section)SerialSugar.cipherSection((Section)SerialSugar.stringSection((String)"Hello World!"), (Cipher)CipherTest.toCipher("TopSecret123!"))));
        if (IS_LOG_TESTS) {
            System.out.println(theSegment.toSchema());
        }
        Sequence theSequence = theSegment.toSequence();
        LengthSegmentDecoratorSegment theOtherSegment = SerialSugar.lengthSegment((Segment)SerialSugar.allocSegment((Section)SerialSugar.cipherSection((Section)SerialSugar.stringSection(), (Cipher)CipherTest.toCipher("NotSecret123!"))));
        theOtherSegment.fromTransmission(theSequence);
        if (IS_LOG_TESTS) {
            System.out.println(theOtherSegment.toSchema());
        }
        Assertions.assertNotEquals((Object)theSegment, (Object)theOtherSegment);
    }

    @Disabled
    @Test
    public void testCipherComplex() throws IOException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        if (this.hasPorts()) {
            Port theTransmitPort = (Port)this.getTransmitterPort().withOpen();
            Port theReceiverPort = (Port)this.getReceiverPort().withOpen();
            TestFixures.WeatherData theSenderData = TestFixures.createWeatherData();
            for (int i = 0; i < 15; ++i) {
                String eSecret = "TopSecret" + (65 + i);
                Cipher eCipher = CipherTest.toCipher(eSecret);
                ReadyToSendSegmentDecorator theSenderSeg = SerialSugar.readyToSendSegment((Segment)SerialSugar.cipherSegment((Segment)SerialSugar.crcPrefixSegment((Segment)SerialSugar.complexTypeSegment((Object)theSenderData), (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE), (Cipher)eCipher));
                ComplexTypeSegment theReceiverSegment = SerialSugar.complexTypeSegment(TestFixures.WeatherData.class);
                ReadyToSendSegmentDecorator theReceiverSeg = SerialSugar.readyToSendSegment((Segment)SerialSugar.cipherSegment((Segment)SerialSugar.crcPrefixSegment((Segment)theReceiverSegment, (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE), (Cipher)eCipher));
                SegmentResult theResult = theReceiverPort.onReceiveSegment((Segment)theReceiverSeg);
                theSenderSeg.transmitTo((SerialTransceiver)theTransmitPort);
                theResult.waitForResult();
                if (IS_LOG_TESTS) {
                    try {
                        System.out.println("Expected [" + eCipher + "]= " + theResult.getResult());
                    }
                    catch (BadCrcChecksumException e) {
                        System.out.println("Unexpected exceptio = " + e.getMessage());
                        Assertions.fail((String)("Not Expecting a <" + BadCrcChecksumException.class.getSimpleName() + "> instead of a resul!t"));
                    }
                }
                TestFixures.WeatherData theReceiverData = (TestFixures.WeatherData)theReceiverSegment.getPayload();
                if (IS_LOG_TESTS) {
                    System.out.println(theReceiverData);
                }
                Assertions.assertEquals((Object)theSenderData, (Object)theReceiverData);
            }
            theTransmitPort.close();
            theReceiverPort.close();
        } else {
            System.out.println("Skipping test, please connect your null modem cable to two serial ports on your box, seeking for exactly two FT232 (ftdi_sio) type ports!");
        }
    }

    @Disabled
    @Test
    public void testCipherComplexFail() throws IOException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        if (this.hasPorts()) {
            Port theTransmitPort = (Port)this.getTransmitterPort().withOpen();
            Port theReceiverPort = (Port)this.getReceiverPort().withOpen();
            TestFixures.WeatherData theSenderData = TestFixures.createWeatherData();
            CipherSegmentDecorator theSenderSeg = SerialSugar.cipherSegment((Segment)SerialSugar.crcPrefixSegment((Segment)SerialSugar.complexTypeSegment((Object)theSenderData), (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE), (Cipher)CipherTest.toCipher("TopSecret123!"));
            ComplexTypeSegment theReceiverSegment = SerialSugar.complexTypeSegment(TestFixures.WeatherData.class);
            CipherSegmentDecorator theReceiverSeg = SerialSugar.cipherSegment((Segment)SerialSugar.crcPrefixSegment((Segment)theReceiverSegment, (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE), (Cipher)CipherTest.toCipher("NotSecret123!"));
            SegmentResult theResult = theReceiverPort.onReceiveSegment((Segment)theReceiverSeg);
            theSenderSeg.transmitTo((SerialTransceiver)theTransmitPort);
            theResult.waitForResult();
            if (IS_LOG_TESTS) {
                try {
                    System.out.println("Result = " + theResult.getResult());
                    Assertions.fail((String)("Expecting a <" + BadCrcChecksumException.class.getSimpleName() + "> instead of a resul!t"));
                }
                catch (BadCrcChecksumException expected) {
                    System.out.println("Expected = " + expected.getMessage());
                }
            }
            TestFixures.WeatherData theReceiverData = (TestFixures.WeatherData)theReceiverSegment.getPayload();
            if (IS_LOG_TESTS) {
                System.out.println(theReceiverData);
            }
            Assertions.assertNotEquals((Object)theSenderData, (Object)theReceiverData);
            theTransmitPort.close();
            theReceiverPort.close();
        } else {
            System.out.println("Skipping test, please connect your null modem cable to two serial ports on your box, seeking for exactly two FT232 (ftdi_sio) type ports!");
        }
    }

    public static Cipher toCipher(String aSecret) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        int theIndex = Security.addProvider((Provider)new ChaosProvider());
        if (IS_LOG_TESTS) {
            for (Provider eProvider : Security.getProviders()) {
                System.out.println(eProvider.getName() + " - " + eProvider.getInfo());
            }
        }
        Assertions.assertTrue((theIndex >= 0 ? 1 : 0) != 0);
        Cipher c = Cipher.getInstance("CHAOS", (Provider)new ChaosProvider());
        ChaosKey key = new ChaosKey(aSecret);
        c.init(1, (Key)key);
        return c;
    }
}

