/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.refcodes.runtime.RuntimeUtility;
import org.refcodes.serial.ComplexTypeSegment;
import org.refcodes.serial.LoopbackPort;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.TestFixures;
import org.refcodes.serial.Transmission;
import org.refcodes.serial.TransmissionException;
import org.refcodes.struct.SimpleTypeMap;
import org.refcodes.textual.CaseStyleBuilder;

public class ComplexTypeSegmentTest
extends TestFixures {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");

    @Test
    public void testEdgeCase1() throws TransmissionException {
        this.printTestName(RuntimeUtility.toMethodName());
        String theValue = "Hallo Welt!";
        ComplexTypeSegment theSegment = new ComplexTypeSegment((Object)theValue);
        this.printSchema((Transmission)theSegment);
        this.printSimpleTypeMap((Transmission)theSegment);
        Sequence theSequence = theSegment.toSequence();
        ComplexTypeSegment theOtherSegment = new ComplexTypeSegment(String.class);
        theOtherSegment.fromTransmission(theSequence);
        this.printSchema((Transmission)theOtherSegment);
        this.printSimpleTypeMap((Transmission)theOtherSegment);
        String theOtherValue = (String)theOtherSegment.getPayload();
        if (IS_LOG_TESTS) {
            System.out.println(theOtherValue);
        }
        Sequence theOtherSequence = theOtherSegment.toSequence();
        Assertions.assertEquals((Object)theValue, (Object)theOtherValue);
        Assertions.assertEquals((Object)theSequence, (Object)theOtherSequence);
        Assertions.assertNotSame((Object)theValue, (Object)theOtherValue);
    }

    @Test
    public void testEdgeCase2() throws TransmissionException {
        this.printTestName(RuntimeUtility.toMethodName());
        ReadySteadyGo theValue = ReadySteadyGo.STEADY;
        ComplexTypeSegment theSegment = new ComplexTypeSegment((Object)theValue);
        this.printSchema((Transmission)theSegment);
        this.printSimpleTypeMap((Transmission)theSegment);
        Sequence theSequence = theSegment.toSequence();
        ComplexTypeSegment theOtherSegment = new ComplexTypeSegment(ReadySteadyGo.class);
        theOtherSegment.fromTransmission(theSequence);
        this.printSchema((Transmission)theOtherSegment);
        this.printSimpleTypeMap((Transmission)theOtherSegment);
        ReadySteadyGo theOtherValue = (ReadySteadyGo)((Object)theOtherSegment.getPayload());
        if (IS_LOG_TESTS) {
            System.out.println((Object)theOtherValue);
        }
        Sequence theOtherSequence = theOtherSegment.toSequence();
        Assertions.assertEquals((Object)((Object)theValue), (Object)((Object)theOtherValue));
        Assertions.assertEquals((Object)theSequence, (Object)theOtherSequence);
        Assertions.assertSame((Object)((Object)theValue), (Object)((Object)theOtherValue));
    }

    @Test
    public void testComplexType1() throws TransmissionException {
        this.printTestName(RuntimeUtility.toMethodName());
        int[] theValues = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        ComplexTypeSegment theSegment = new ComplexTypeSegment((Object)theValues);
        this.printSchema((Transmission)theSegment);
        this.printSimpleTypeMap((Transmission)theSegment);
        Sequence theSequence = theSegment.toSequence();
        ComplexTypeSegment theOtherSegment = new ComplexTypeSegment(int[].class);
        theOtherSegment.fromTransmission(theSequence);
        this.printSchema((Transmission)theOtherSegment);
        this.printSimpleTypeMap((Transmission)theOtherSegment);
        int[] theOtherValues = (int[])theOtherSegment.getPayload();
        if (IS_LOG_TESTS) {
            System.out.println(Arrays.toString(theOtherValues));
        }
        Sequence theOtherSequence = theOtherSegment.toSequence();
        Assertions.assertArrayEquals((int[])theValues, (int[])theOtherValues);
        Assertions.assertEquals((Object)theSequence, (Object)theOtherSequence);
        Assertions.assertNotSame((Object)theValues, (Object)theOtherValues);
    }

    @Test
    public void testComplexType2() throws TransmissionException {
        this.printTestName(RuntimeUtility.toMethodName());
        TestFixures.Values theValues = ComplexTypeSegmentTest.createValues();
        ComplexTypeSegment theSegment = new ComplexTypeSegment((Object)theValues);
        this.printSchema((Transmission)theSegment);
        this.printSimpleTypeMap((Transmission)theSegment);
        Sequence theSequence = theSegment.toSequence();
        ComplexTypeSegment theOtherSegment = new ComplexTypeSegment(TestFixures.Values.class);
        theOtherSegment.fromTransmission(theSequence);
        this.printSchema((Transmission)theOtherSegment);
        this.printSimpleTypeMap((Transmission)theOtherSegment);
        TestFixures.Values theOtherValues = (TestFixures.Values)theOtherSegment.getPayload();
        if (IS_LOG_TESTS) {
            System.out.println(theOtherValues);
        }
        Sequence theOtherSequence = theOtherSegment.toSequence();
        Assertions.assertEquals((Object)theSequence, (Object)theOtherSequence);
        Assertions.assertEquals((Object)theValues, (Object)theOtherValues);
        Assertions.assertNotSame((Object)theValues, (Object)theOtherValues);
    }

    @Test
    public void testComplexType3() throws TransmissionException {
        this.printTestName(RuntimeUtility.toMethodName());
        TestFixures.SensorValues theSensorValues = ComplexTypeSegmentTest.createSensorValues();
        ComplexTypeSegment theSegment = new ComplexTypeSegment((Object)theSensorValues);
        this.printSchema((Transmission)theSegment);
        this.printSimpleTypeMap((Transmission)theSegment);
        Sequence theSequence = theSegment.toSequence();
        ComplexTypeSegment theOtherSegment = new ComplexTypeSegment(TestFixures.SensorValues.class);
        theOtherSegment.fromTransmission(theSequence);
        this.printSchema((Transmission)theOtherSegment);
        this.printSimpleTypeMap((Transmission)theOtherSegment);
        TestFixures.SensorValues theOtherValues = (TestFixures.SensorValues)theOtherSegment.getPayload();
        if (IS_LOG_TESTS) {
            System.out.println(theOtherValues);
        }
        Sequence theOtherSequence = theOtherSegment.toSequence();
        Assertions.assertEquals((Object)theSequence, (Object)theOtherSequence);
        Assertions.assertEquals((Object)theSensorValues, (Object)theOtherValues);
        Assertions.assertNotSame((Object)theSensorValues, (Object)theOtherSegment);
    }

    @Test
    public void testComplexType4() throws TransmissionException {
        this.printTestName(RuntimeUtility.toMethodName());
        TestFixures.Wrapper theWrapper = ComplexTypeSegmentTest.createWrapper();
        ComplexTypeSegment theSegment = new ComplexTypeSegment((Object)theWrapper);
        this.printSchema((Transmission)theSegment);
        this.printSimpleTypeMap((Transmission)theSegment);
        Sequence theSequence = theSegment.toSequence();
        ComplexTypeSegment theOtherSegment = new ComplexTypeSegment(TestFixures.Wrapper.class);
        theOtherSegment.fromTransmission(theSequence);
        this.printSchema((Transmission)theOtherSegment);
        this.printSimpleTypeMap((Transmission)theOtherSegment);
        TestFixures.Wrapper theOtherWrapper = (TestFixures.Wrapper)theOtherSegment.getPayload();
        if (IS_LOG_TESTS) {
            System.out.println(theOtherWrapper);
        }
        Sequence theOtherSequence = theOtherSegment.toSequence();
        Assertions.assertEquals((Object)theSequence, (Object)theOtherSequence);
        Assertions.assertEquals((Object)theWrapper, (Object)theOtherWrapper);
        Assertions.assertNotSame((Object)theWrapper, (Object)theOtherWrapper);
    }

    @Test
    public void testComplexType5() throws TransmissionException {
        this.printTestName(RuntimeUtility.toMethodName());
        TestFixures.Sensors theSensors = ComplexTypeSegmentTest.createSensors();
        ComplexTypeSegment theSegment = new ComplexTypeSegment((Object)theSensors);
        this.printSchema((Transmission)theSegment);
        this.printSimpleTypeMap((Transmission)theSegment);
        Sequence theSequence = theSegment.toSequence();
        ComplexTypeSegment theOtherSegment = new ComplexTypeSegment(TestFixures.Sensors.class);
        theOtherSegment.fromTransmission(theSequence);
        this.printSchema((Transmission)theOtherSegment);
        this.printSimpleTypeMap((Transmission)theOtherSegment);
        TestFixures.Sensors theOtherSensors = (TestFixures.Sensors)theOtherSegment.getPayload();
        if (IS_LOG_TESTS) {
            System.out.println(theOtherSensors);
        }
        Sequence theOtherSequence = theOtherSegment.toSequence();
        Assertions.assertEquals((Object)theSequence, (Object)theOtherSequence);
        Assertions.assertEquals((Object)theSensors, (Object)theOtherSensors);
        Assertions.assertNotSame((Object)theSensors, (Object)theOtherSensors);
    }

    @Disabled(value="Under construction")
    @Test
    public void testComplexType6() throws TransmissionException {
        this.printTestName(RuntimeUtility.toMethodName());
        Object[] theArray = new TestFixures.Sensors[]{ComplexTypeSegmentTest.createSensors(), ComplexTypeSegmentTest.createSensors(), ComplexTypeSegmentTest.createSensors(), ComplexTypeSegmentTest.createSensors(), ComplexTypeSegmentTest.createSensors()};
        ComplexTypeSegment theSegment = new ComplexTypeSegment((Object)theArray);
        this.printSchema((Transmission)theSegment);
        this.printSimpleTypeMap((Transmission)theSegment);
        Sequence theSequence = theSegment.toSequence();
        ComplexTypeSegment theOtherSegment = new ComplexTypeSegment(TestFixures.Sensors[].class);
        theOtherSegment.fromTransmission(theSequence);
        this.printSchema((Transmission)theOtherSegment);
        this.printSimpleTypeMap((Transmission)theOtherSegment);
        Object[] theOtherArray = (TestFixures.Sensors[])theOtherSegment.getPayload();
        if (IS_LOG_TESTS) {
            System.out.println(theOtherArray);
        }
        Sequence theOtherSequence = theOtherSegment.toSequence();
        Assertions.assertEquals((Object)theSequence, (Object)theOtherSequence);
        Assertions.assertArrayEquals((Object[])theArray, (Object[])theOtherArray);
        Assertions.assertNotSame((Object)theArray, (Object)theOtherArray);
    }

    @Test
    public void testCompositeArrayType1() throws TransmissionException {
        this.printTestName(RuntimeUtility.toMethodName());
        Object[] theValues = new TestFixures.Sensors[]{ComplexTypeSegmentTest.createSensors(), ComplexTypeSegmentTest.createSensors(), ComplexTypeSegmentTest.createSensors()};
        ComplexTypeSegment theSegment = new ComplexTypeSegment((Object)theValues);
        this.printSchema((Transmission)theSegment);
        this.printSimpleTypeMap((Transmission)theSegment);
        Sequence theSequence = theSegment.toSequence();
        ComplexTypeSegment theOtherSegment = new ComplexTypeSegment(TestFixures.Sensors[].class);
        theOtherSegment.fromTransmission(theSequence);
        this.printSchema((Transmission)theOtherSegment);
        this.printSimpleTypeMap((Transmission)theOtherSegment);
        Sequence theOtherSequence = theOtherSegment.toSequence();
        Object[] theOtherValues = (TestFixures.Sensors[])theOtherSegment.getPayload();
        if (IS_LOG_TESTS) {
            for (Object eValue : theOtherValues) {
                System.out.println(eValue);
            }
        }
        Assertions.assertEquals((Object)theSequence, (Object)theOtherSequence);
        Assertions.assertArrayEquals((Object[])theValues, (Object[])theOtherValues);
        Assertions.assertNotSame((Object)theValues, (Object)theOtherValues);
    }

    @Test
    public void testCompositeArrayType2() throws TransmissionException {
        this.printTestName(RuntimeUtility.toMethodName());
        TestFixures.SensorArray theValues = new TestFixures.SensorArray(new TestFixures.Sensor[]{new TestFixures.Sensor("Sensor1", 1), new TestFixures.Sensor("Sensor2", 22), new TestFixures.Sensor("Sensor3", 333)});
        ComplexTypeSegment theSegment = new ComplexTypeSegment((Object)theValues);
        this.printSchema((Transmission)theSegment);
        this.printSimpleTypeMap((Transmission)theSegment);
        Sequence theSequence = theSegment.toSequence();
        ComplexTypeSegment theOtherSegment = new ComplexTypeSegment(TestFixures.SensorArray.class);
        theOtherSegment.fromTransmission(theSequence);
        this.printSchema((Transmission)theOtherSegment);
        this.printSimpleTypeMap((Transmission)theOtherSegment);
        Sequence theOtherSequence = theOtherSegment.toSequence();
        TestFixures.SensorArray theOtherValues = (TestFixures.SensorArray)theOtherSegment.getPayload();
        if (IS_LOG_TESTS) {
            for (TestFixures.Sensor eValue : theOtherValues.getSensors()) {
                System.out.println(eValue);
            }
        }
        Assertions.assertEquals((Object)theSequence, (Object)theOtherSequence);
        Assertions.assertEquals((Object)theValues, (Object)theOtherValues);
        Assertions.assertNotSame((Object)theValues, (Object)theOtherValues);
    }

    @Test
    public void testCompositeArrayType3() throws TransmissionException {
        this.printTestName(RuntimeUtility.toMethodName());
        Object[] theValues = new TestFixures.SensorArray[]{new TestFixures.SensorArray(new TestFixures.Sensor[]{new TestFixures.Sensor("Sensor1", 1), new TestFixures.Sensor("Sensor2", 22), new TestFixures.Sensor("Sensor3", 333)}), new TestFixures.SensorArray(new TestFixures.Sensor[]{new TestFixures.Sensor("Sensor4", 4), new TestFixures.Sensor("Sensor5", 55), new TestFixures.Sensor("Sensor6", 666)}), new TestFixures.SensorArray(new TestFixures.Sensor[]{new TestFixures.Sensor("Sensor7", 7), new TestFixures.Sensor("Sensor8", 88), new TestFixures.Sensor("Sensor9", 999)})};
        ComplexTypeSegment theSegment = new ComplexTypeSegment((Object)theValues);
        this.printSegment((Transmission)theSegment);
        this.printSimpleTypeMap((Transmission)theSegment);
        Sequence theSequence = theSegment.toSequence();
        ComplexTypeSegment theOtherSegment = new ComplexTypeSegment(TestFixures.SensorArray[].class);
        theOtherSegment.fromTransmission(theSequence);
        this.printSegment((Transmission)theOtherSegment);
        this.printSimpleTypeMap((Transmission)theOtherSegment);
        Sequence theOtherSequence = theOtherSegment.toSequence();
        Object[] theOtherValues = (TestFixures.SensorArray[])theOtherSegment.getPayload();
        if (IS_LOG_TESTS) {
            for (Object eArray : theOtherValues) {
                for (TestFixures.Sensor eValue : ((TestFixures.SensorArray)eArray).getSensors()) {
                    System.out.println(eValue);
                }
            }
        }
        Assertions.assertEquals((Object)theSequence, (Object)theOtherSequence);
        Assertions.assertArrayEquals((Object[])theValues, (Object[])theOtherValues);
        Assertions.assertNotSame((Object)theValues, (Object)theOtherValues);
    }

    @Test
    public void testCompositeArrayType4() throws TransmissionException {
        this.printTestName(RuntimeUtility.toMethodName());
        TestFixures.SensorValues theValues = ComplexTypeSegmentTest.createSensorValues();
        ComplexTypeSegment theSegment = new ComplexTypeSegment((Object)theValues);
        this.printSchema((Transmission)theSegment);
        this.printSimpleTypeMap((Transmission)theSegment);
        Sequence theSequence = theSegment.toSequence();
        ComplexTypeSegment theOtherSegment = new ComplexTypeSegment(TestFixures.SensorValues.class);
        theOtherSegment.fromTransmission(theSequence);
        this.printSchema((Transmission)theOtherSegment);
        this.printSimpleTypeMap((Transmission)theOtherSegment);
        Sequence theOtherSequence = theOtherSegment.toSequence();
        TestFixures.SensorValues theOtherValues = (TestFixures.SensorValues)theOtherSegment.getPayload();
        Assertions.assertEquals((Object)theSequence, (Object)theOtherSequence);
        Assertions.assertEquals((Object)theValues, (Object)theOtherValues);
        Assertions.assertNotSame((Object)theValues, (Object)theOtherValues);
    }

    @Test
    public void testCompositeArrayType5() throws TransmissionException {
        this.printTestName(RuntimeUtility.toMethodName());
        TestFixures.Values theValues = ComplexTypeSegmentTest.createValues();
        ComplexTypeSegment theSegment = new ComplexTypeSegment((Object)theValues);
        this.printSchema((Transmission)theSegment);
        this.printSimpleTypeMap((Transmission)theSegment);
        Sequence theSequence = theSegment.toSequence();
        ComplexTypeSegment theOtherSegment = new ComplexTypeSegment(TestFixures.Values.class);
        theOtherSegment.fromTransmission(theSequence);
        this.printSchema((Transmission)theOtherSegment);
        this.printSimpleTypeMap((Transmission)theOtherSegment);
        Sequence theOtherSequence = theOtherSegment.toSequence();
        TestFixures.Values theOtherValues = (TestFixures.Values)theOtherSegment.getPayload();
        Assertions.assertEquals((Object)theSequence, (Object)theOtherSequence);
        Assertions.assertEquals((Object)theValues, (Object)theOtherValues);
        Assertions.assertNotSame((Object)theValues, (Object)theOtherValues);
    }

    @Test
    public void testCompositeArrayType6() throws TransmissionException {
        this.printTestName(RuntimeUtility.toMethodName());
        TestFixures.Wrapper theValues = ComplexTypeSegmentTest.createWrapper();
        ComplexTypeSegment theSegment = new ComplexTypeSegment((Object)theValues);
        this.printSchema((Transmission)theSegment);
        this.printSimpleTypeMap((Transmission)theSegment);
        Sequence theSequence = theSegment.toSequence();
        ComplexTypeSegment theOtherSegment = new ComplexTypeSegment(TestFixures.Wrapper.class);
        theOtherSegment.fromTransmission(theSequence);
        this.printSchema((Transmission)theOtherSegment);
        this.printSimpleTypeMap((Transmission)theOtherSegment);
        Sequence theOtherSequence = theOtherSegment.toSequence();
        TestFixures.Wrapper theOtherValues = (TestFixures.Wrapper)theOtherSegment.getPayload();
        Assertions.assertEquals((Object)theSequence, (Object)theOtherSequence);
        Assertions.assertEquals((Object)theValues, (Object)theOtherValues);
        Assertions.assertNotSame((Object)theValues, (Object)theOtherValues);
    }

    @Test
    public void testComplexTypeStream() throws TransmissionException, IOException {
        this.printTestName(RuntimeUtility.toMethodName());
        Object[] theValues = new TestFixures.SensorArray[]{new TestFixures.SensorArray(new TestFixures.Sensor[]{new TestFixures.Sensor("Sensor1", 1), new TestFixures.Sensor("Sensor2", 22), new TestFixures.Sensor("Sensor3", 333)}), new TestFixures.SensorArray(new TestFixures.Sensor[]{new TestFixures.Sensor("Sensor4", 4), new TestFixures.Sensor("Sensor5", 55), new TestFixures.Sensor("Sensor6", 666)}), new TestFixures.SensorArray(new TestFixures.Sensor[]{new TestFixures.Sensor("Sensor7", 7), new TestFixures.Sensor("Sensor8", 88), new TestFixures.Sensor("Sensor9", 999)})};
        ComplexTypeSegment theSegment = new ComplexTypeSegment((Object)theValues);
        this.printSchema((Transmission)theSegment);
        this.printSimpleTypeMap((Transmission)theSegment);
        LoopbackPort theTransceiver = new LoopbackPort("loop0").withOpen();
        theSegment.transmitTo(theTransceiver.getOutputStream());
        ComplexTypeSegment theOtherSegment = new ComplexTypeSegment(TestFixures.SensorArray[].class);
        theOtherSegment.receiveFrom(theTransceiver.getInputStream());
        this.printSchema((Transmission)theOtherSegment);
        this.printSimpleTypeMap((Transmission)theOtherSegment);
        Object[] theOtherValues = (TestFixures.SensorArray[])theOtherSegment.getPayload();
        Assertions.assertArrayEquals((Object[])theValues, (Object[])theOtherValues);
        Assertions.assertNotSame((Object)theValues, (Object)theOtherValues);
    }

    private void printTestName(String aMethodName) {
        if (IS_LOG_TESTS) {
            System.out.println();
            System.out.println("[---------- " + CaseStyleBuilder.asSnakeCase((String)aMethodName) + " ----------]");
            System.out.println();
        }
    }

    private void printSimpleTypeMap(Transmission aSegment) {
        if (IS_LOG_TESTS) {
            SimpleTypeMap theSimpleTypeMap = aSegment.toSimpleTypeMap();
            for (String eKey : theSimpleTypeMap.sortedKeys()) {
                System.out.println(eKey + " = " + theSimpleTypeMap.get((Object)eKey));
            }
            System.out.println();
        }
    }

    private void printSchema(Transmission aSegment) {
        if (IS_LOG_TESTS) {
            System.out.println(aSegment.toSchema());
            System.out.println();
        }
    }

    private void printSegment(Transmission aSegment) {
        if (IS_LOG_TESTS) {
            SimpleTypeMap theSimpleTypeMap = aSegment.toSimpleTypeMap();
            for (String eKey : theSimpleTypeMap.sortedKeys()) {
                System.out.println(eKey + " = " + theSimpleTypeMap.get((Object)eKey));
            }
            System.out.println();
        }
    }

    static enum ReadySteadyGo {
        READY,
        STEADY,
        GO;

    }
}

