/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.numerical.CrcAlgorithm;
import org.refcodes.numerical.CrcAlgorithmConfig;
import org.refcodes.serial.BadCrcChecksumSequenceException;
import org.refcodes.serial.CrcSegmentDecorator;
import org.refcodes.serial.IntSegment;
import org.refcodes.serial.LengthSegmentDecoratorSegment;
import org.refcodes.serial.Section;
import org.refcodes.serial.Segment;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSugar;
import org.refcodes.serial.TransmissionException;

public class CrcSegmentTest {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");

    @Test
    public void testCrcSegmentFacade() throws TransmissionException {
        CrcSegmentDecorator theSegment = SerialSugar.crcPrefixSegment((Segment)SerialSugar.allocSegment((Section)SerialSugar.stringSection((String)"Hello World!")), (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE);
        Sequence theSequence = theSegment.toSequence();
        if (IS_LOG_TESTS) {
            System.out.println("Sequence (hex) = " + theSequence.toHexString());
            System.out.println("Transmission = " + theSegment.toString());
            System.out.println("AbstractSchema = " + theSegment.toSchema());
        }
        CrcSegmentDecorator theOtherSegment = SerialSugar.crcPrefixSegment((Segment)SerialSugar.allocSegment((Section)SerialSugar.stringSection()), (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE);
        theOtherSegment.fromTransmission(theSequence);
        Assertions.assertEquals((Object)theSegment, (Object)theOtherSegment);
        if (IS_LOG_TESTS) {
            System.out.println("Other segment = " + theOtherSegment.toString());
            System.out.println("Other schema = " + theOtherSegment.toSchema());
        }
        try {
            theSequence.setByteAt(1, (byte)1);
            theOtherSegment.fromTransmission(theSequence);
            Assertions.fail((String)"Expected a <BadCrcChecksumSequenceException> here!");
        }
        catch (BadCrcChecksumSequenceException badCrcChecksumSequenceException) {
            // empty catch block
        }
    }

    @Test
    public void testCrcBody() throws TransmissionException {
        LengthSegmentDecoratorSegment theSegment = new LengthSegmentDecoratorSegment((Segment)new IntSegment(Integer.valueOf(5161)));
        CrcSegmentDecorator theCrcHeader = new CrcSegmentDecorator((Segment)theSegment, (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE);
        long theCrcChecksum = theCrcHeader.getCrcChecksum();
        if (IS_LOG_TESTS) {
            System.out.println("Checksum for payload size <" + theSegment.getAllocLength() + "> = " + theCrcChecksum);
        }
        Sequence theSequence = theCrcHeader.toSequence();
        if (IS_LOG_TESTS) {
            System.out.println("To sequence = " + theSequence.toHexString());
        }
        theCrcHeader.fromTransmission(theSequence);
        theSequence = theCrcHeader.toSequence();
        if (IS_LOG_TESTS) {
            System.out.println("From sequence = " + theSequence.toHexString());
        }
        if (IS_LOG_TESTS) {
            System.out.println("Other checksum for payload size <" + theSegment.getAllocLength() + "> = " + theCrcChecksum);
        }
    }

    @Test
    public void testCrcHeader1() throws TransmissionException {
        String thePayload = "Hello World!";
        CrcSegmentDecorator theSegment = SerialSugar.crcPrefixSegment((Segment)SerialSugar.segmentComposite((Segment[])new Segment[]{SerialSugar.magicBytesSegment((byte[])new byte[]{-64, -34, -2, -19}), SerialSugar.allocSegment((Section)SerialSugar.stringSection((String)thePayload))}), (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE);
        if (IS_LOG_TESTS) {
            System.out.println("Transmission = " + theSegment.toString());
        }
        CrcSegmentDecorator theOtherSegment = SerialSugar.crcPrefixSegment((Segment)SerialSugar.segmentComposite((Segment[])new Segment.SegmentMixin[]{SerialSugar.magicBytesSegment((byte[])new byte[]{-64, -34, -2, -19}), SerialSugar.intSegment((Integer)(thePayload.length() + 1))}), (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE);
        if (IS_LOG_TESTS) {
            System.out.println("Other segment = " + theOtherSegment.toString());
        }
        Assertions.assertNotEquals((long)theSegment.getCrcChecksum(), (long)theOtherSegment.getCrcChecksum());
    }

    @Test
    public void testCrcHeader2() throws TransmissionException {
        String thePayload = "Hello World!";
        CrcSegmentDecorator theSegment = SerialSugar.crcPrefixSegment((Segment)SerialSugar.segmentComposite((Segment[])new Segment[]{SerialSugar.magicBytesSegment((byte[])new byte[]{-64, -34, -2, -19}), SerialSugar.allocSegment((Section)SerialSugar.stringSection((String)thePayload))}), (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE);
        if (IS_LOG_TESTS) {
            System.out.println("Transmission = " + theSegment.toString());
        }
        CrcSegmentDecorator theOtherSegment = SerialSugar.crcPrefixSegment((Segment)SerialSugar.segmentComposite((Segment[])new Segment.SegmentMixin[]{SerialSugar.magicBytesSegment((byte[])new byte[]{-64, -34, -2, -19}), SerialSugar.intSegment((Integer)thePayload.length())}), (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE);
        if (IS_LOG_TESTS) {
            System.out.println("Other segment = " + theOtherSegment.toString());
        }
        Assertions.assertNotEquals((long)theSegment.getCrcChecksum(), (long)theOtherSegment.getCrcChecksum());
    }
}

