/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.refcodes.numerical.Endianess;
import org.refcodes.serial.AbstractPayloadSegment;
import org.refcodes.serial.AllocSectionDecoratorSegment;
import org.refcodes.serial.AsciizArraySegment;
import org.refcodes.serial.AsciizSegment;
import org.refcodes.serial.BooleanArraySection;
import org.refcodes.serial.BooleanSegment;
import org.refcodes.serial.ByteArraySection;
import org.refcodes.serial.ByteSegment;
import org.refcodes.serial.DoubleArraySection;
import org.refcodes.serial.DoubleSegment;
import org.refcodes.serial.FixedSegmentArraySection;
import org.refcodes.serial.FloatArraySection;
import org.refcodes.serial.FloatSegment;
import org.refcodes.serial.IntArraySection;
import org.refcodes.serial.IntSegment;
import org.refcodes.serial.LengthSegmentDecoratorSegment;
import org.refcodes.serial.LongArraySection;
import org.refcodes.serial.LongSegment;
import org.refcodes.serial.NumberSegment;
import org.refcodes.serial.Section;
import org.refcodes.serial.Segment;
import org.refcodes.serial.SegmentComposite;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSugar;
import org.refcodes.serial.ShortArraySection;
import org.refcodes.serial.ShortSegment;
import org.refcodes.serial.StringArraySection;
import org.refcodes.serial.StringSection;
import org.refcodes.serial.TransmissionException;

public class DataTypesTest {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");

    @Test
    public void testAsciizSegment1() throws TransmissionException {
        AsciizSegment theSegment = SerialSugar.asciizSegment((String)"Hallo Welt!");
        Sequence theSequence = theSegment.toSequence();
        if (IS_LOG_TESTS) {
            System.out.println("AllocationBodyFacade (hex) = " + theSequence.toHexString());
            System.out.println("AllocationBodyFacade = " + theSegment.toString());
            System.out.println("AbstractSchema = " + theSegment.toSchema());
        }
        Assertions.assertEquals((int)12, (int)theSegment.getLength());
        AsciizSegment theOtherSegment = SerialSugar.asciizSegment();
        Assertions.assertEquals((int)1, (int)theOtherSegment.getLength());
        theOtherSegment.fromTransmission(theSequence);
        if (IS_LOG_TESTS) {
            System.out.println("Other segment = " + theOtherSegment.toString());
            System.out.println("Other schema = " + theOtherSegment.toSchema());
        }
        Assertions.assertEquals((Object)theSegment.getPayload(), (Object)theOtherSegment.getPayload());
        Assertions.assertEquals((int)12, (int)theOtherSegment.getLength());
    }

    @Test
    public void testAsciizSegment2() throws TransmissionException {
        AsciizSegment theSegment = SerialSugar.asciizSegment();
        Sequence theSequence = theSegment.toSequence();
        if (IS_LOG_TESTS) {
            System.out.println("AllocationBodyFacade (hex) = " + theSequence.toHexString());
            System.out.println("AllocationBodyFacade = " + theSegment.toString());
            System.out.println("AbstractSchema = " + theSegment.toSchema());
        }
        Assertions.assertEquals((int)1, (int)theSegment.getLength());
        AsciizSegment theOtherSegment = SerialSugar.asciizSegment();
        theOtherSegment.fromTransmission(theSequence);
        if (IS_LOG_TESTS) {
            System.out.println("Other segment = " + theOtherSegment.toString());
            System.out.println("Other schema = " + theOtherSegment.toSchema());
        }
        Assertions.assertEquals((Object)theSegment.getPayload(), (Object)theOtherSegment.getPayload());
        Assertions.assertEquals((int)1, (int)theOtherSegment.getLength());
    }

    @Test
    public void testAsciizSegment3() throws TransmissionException {
        AsciizSegment theSegment = SerialSugar.asciizSegment();
        Sequence theSequence = theSegment.toSequence();
        if (IS_LOG_TESTS) {
            System.out.println("AllocationBodyFacade (hex) = " + theSequence.toHexString());
            System.out.println("AllocationBodyFacade = " + theSegment.toString());
            System.out.println("AbstractSchema = " + theSegment.toSchema());
        }
        Assertions.assertEquals((int)1, (int)theSegment.getLength());
        AsciizSegment theOtherSegment = SerialSugar.asciizSegment();
        Assertions.assertEquals((int)1, (int)theOtherSegment.getLength());
        theOtherSegment.fromTransmission(theSequence);
        if (IS_LOG_TESTS) {
            System.out.println("Other segment = " + theOtherSegment.toString());
            System.out.println("Other schema = " + theOtherSegment.toSchema());
        }
        Assertions.assertEquals((Object)theSegment.getPayload(), (Object)theOtherSegment.getPayload());
        Assertions.assertEquals((int)1, (int)theOtherSegment.getLength());
    }

    @Test
    public void testAsciizSegment4() throws TransmissionException {
        AbstractPayloadSegment[] abstractPayloadSegmentArray = new AbstractPayloadSegment[4];
        IntSegment theIntSegment = SerialSugar.intSegment((Integer)2);
        abstractPayloadSegmentArray[0] = theIntSegment;
        AsciizSegment theAsciizSegment1 = SerialSugar.asciizSegment((String)"Hello world!");
        abstractPayloadSegmentArray[1] = theAsciizSegment1;
        AsciizSegment theAsciizSegment2 = SerialSugar.asciizSegment((String)"Hallo Welt!");
        abstractPayloadSegmentArray[2] = theAsciizSegment2;
        FloatSegment theFloatSegment = SerialSugar.floatSegment((Float)Float.valueOf(3.14f));
        abstractPayloadSegmentArray[3] = theFloatSegment;
        SegmentComposite theSegment = SerialSugar.segmentComposite((Segment[])abstractPayloadSegmentArray);
        Sequence theSequence = theSegment.toSequence();
        if (IS_LOG_TESTS) {
            System.out.println("AllocationBodyFacade (hex) = " + theSequence.toHexString());
            System.out.println("AllocationBodyFacade = " + theSegment.toString());
            System.out.println("AbstractSchema = " + theSegment.toSchema());
        }
        Assertions.assertEquals((int)33, (int)theSegment.getLength());
        AbstractPayloadSegment[] abstractPayloadSegmentArray2 = new AbstractPayloadSegment[4];
        IntSegment theOtherIntSegment = SerialSugar.intSegment();
        abstractPayloadSegmentArray2[0] = theOtherIntSegment;
        AsciizSegment theOtherAsciizSegment1 = SerialSugar.asciizSegment();
        abstractPayloadSegmentArray2[1] = theOtherAsciizSegment1;
        AsciizSegment theOtherAsciizSegment2 = SerialSugar.asciizSegment();
        abstractPayloadSegmentArray2[2] = theOtherAsciizSegment2;
        FloatSegment theOtherFloatSegment = SerialSugar.floatSegment();
        abstractPayloadSegmentArray2[3] = theOtherFloatSegment;
        SegmentComposite theOtherSegment = SerialSugar.segmentComposite((Segment[])abstractPayloadSegmentArray2);
        theOtherSegment.fromTransmission(theSequence);
        if (IS_LOG_TESTS) {
            System.out.println("Other segment = " + theOtherSegment.toString());
            System.out.println("Other schema = " + theOtherSegment.toSchema());
        }
        Assertions.assertEquals((Integer)((Integer)theIntSegment.getPayload()), (Integer)((Integer)theOtherIntSegment.getPayload()));
        Assertions.assertEquals((Object)theAsciizSegment1.getPayload(), (Object)theOtherAsciizSegment1.getPayload());
        Assertions.assertEquals((Object)theAsciizSegment2.getPayload(), (Object)theOtherAsciizSegment2.getPayload());
        Assertions.assertEquals((Float)((Float)theFloatSegment.getPayload()), (Float)((Float)theOtherFloatSegment.getPayload()));
        Assertions.assertEquals((int)33, (int)theOtherSegment.getLength());
    }

    @Test
    public void testAsciizArraySegment1() throws TransmissionException {
        AsciizArraySegment theSegment = SerialSugar.asciizArraySegment((String[])new String[]{"Hallo Welt!"});
        Sequence theSequence = theSegment.toSequence();
        if (IS_LOG_TESTS) {
            System.out.println("AllocationBodyFacade (hex) = " + theSequence.toHexString());
            System.out.println("AllocationBodyFacade = " + theSegment.toString());
            System.out.println("AbstractSchema = " + theSegment.toSchema());
        }
        Assertions.assertEquals((int)16, (int)theSegment.getLength());
        AsciizArraySegment theOtherSegment = SerialSugar.asciizArraySegment((String[])new String[0]);
        Assertions.assertEquals((int)4, (int)theOtherSegment.getLength());
        theOtherSegment.fromTransmission(theSequence);
        if (IS_LOG_TESTS) {
            System.out.println("Other segment = " + theOtherSegment.toString());
            System.out.println("Other schema = " + theOtherSegment.toSchema());
        }
        Assertions.assertArrayEquals((Object[])((Object[])theSegment.getPayload()), (Object[])((Object[])theOtherSegment.getPayload()));
        Assertions.assertEquals((int)16, (int)theOtherSegment.getLength());
    }

    @Test
    public void testAsciizArraySegment2() throws TransmissionException {
        AsciizArraySegment theSegment = SerialSugar.asciizArraySegment((String[])new String[]{"Hallo Welt!", "Hello world!"});
        Sequence theSequence = theSegment.toSequence();
        if (IS_LOG_TESTS) {
            System.out.println("AllocationBodyFacade (hex) = " + theSequence.toHexString());
            System.out.println("AllocationBodyFacade = " + theSegment.toString());
            System.out.println("AbstractSchema = " + theSegment.toSchema());
        }
        Assertions.assertEquals((int)29, (int)theSegment.getLength());
        AsciizArraySegment theOtherSegment = SerialSugar.asciizArraySegment((String[])new String[0]);
        Assertions.assertEquals((int)4, (int)theOtherSegment.getLength());
        theOtherSegment.fromTransmission(theSequence);
        if (IS_LOG_TESTS) {
            System.out.println("Other segment = " + theOtherSegment.toString());
            System.out.println("Other schema = " + theOtherSegment.toSchema());
        }
        Assertions.assertArrayEquals((Object[])((Object[])theSegment.getPayload()), (Object[])((Object[])theOtherSegment.getPayload()));
        Assertions.assertEquals((int)29, (int)theOtherSegment.getLength());
    }

    @Test
    public void testAsciizArraySegment3() throws TransmissionException {
        AsciizArraySegment theSegment = SerialSugar.asciizArraySegment((String[])new String[0]);
        Sequence theSequence = theSegment.toSequence();
        if (IS_LOG_TESTS) {
            System.out.println("AllocationBodyFacade (hex) = " + theSequence.toHexString());
            System.out.println("AllocationBodyFacade = " + theSegment.toString());
            System.out.println("AbstractSchema = " + theSegment.toSchema());
        }
        Assertions.assertEquals((int)4, (int)theSegment.getLength());
        AsciizArraySegment theOtherSegment = SerialSugar.asciizArraySegment((String[])new String[0]);
        Assertions.assertEquals((int)4, (int)theOtherSegment.getLength());
        theOtherSegment.fromTransmission(theSequence);
        if (IS_LOG_TESTS) {
            System.out.println("Other segment = " + theOtherSegment.toString());
            System.out.println("Other schema = " + theOtherSegment.toSchema());
        }
        Assertions.assertArrayEquals((Object[])((Object[])theSegment.getPayload()), (Object[])((Object[])theOtherSegment.getPayload()));
        Assertions.assertEquals((int)4, (int)theOtherSegment.getLength());
    }

    @Test
    public void testAsciizArraySegment4() throws TransmissionException {
        AbstractPayloadSegment[] abstractPayloadSegmentArray = new AbstractPayloadSegment[3];
        IntSegment theIntSegment = SerialSugar.intSegment((Integer)2);
        abstractPayloadSegmentArray[0] = theIntSegment;
        AsciizArraySegment theAsciizArraySegment = SerialSugar.asciizArraySegment((String[])new String[]{"Hello world!"});
        abstractPayloadSegmentArray[1] = theAsciizArraySegment;
        FloatSegment theFloatSegment = SerialSugar.floatSegment((Float)Float.valueOf(3.14f));
        abstractPayloadSegmentArray[2] = theFloatSegment;
        SegmentComposite theSegment = SerialSugar.segmentComposite((Segment[])abstractPayloadSegmentArray);
        Sequence theSequence = theSegment.toSequence();
        if (IS_LOG_TESTS) {
            System.out.println("AllocationBodyFacade (hex) = " + theSequence.toHexString());
            System.out.println("AllocationBodyFacade = " + theSegment.toString());
            System.out.println("AbstractSchema = " + theSegment.toSchema());
        }
        Assertions.assertEquals((int)25, (int)theSegment.getLength());
        AbstractPayloadSegment[] abstractPayloadSegmentArray2 = new AbstractPayloadSegment[3];
        IntSegment theOtherIntSegment = SerialSugar.intSegment();
        abstractPayloadSegmentArray2[0] = theOtherIntSegment;
        AsciizArraySegment theOtherAsciizArraySegment = SerialSugar.asciizArraySegment((String[])new String[0]);
        abstractPayloadSegmentArray2[1] = theOtherAsciizArraySegment;
        FloatSegment theOtherFloatSegment = SerialSugar.floatSegment();
        abstractPayloadSegmentArray2[2] = theOtherFloatSegment;
        SegmentComposite theOtherSegment = SerialSugar.segmentComposite((Segment[])abstractPayloadSegmentArray2);
        theOtherSegment.fromTransmission(theSequence);
        if (IS_LOG_TESTS) {
            System.out.println("Other segment = " + theOtherSegment.toString());
            System.out.println("Other schema = " + theOtherSegment.toSchema());
        }
        Assertions.assertEquals((Integer)((Integer)theIntSegment.getPayload()), (Integer)((Integer)theOtherIntSegment.getPayload()));
        Assertions.assertArrayEquals((Object[])((Object[])theAsciizArraySegment.getPayload()), (Object[])((Object[])theOtherAsciizArraySegment.getPayload()));
        Assertions.assertEquals((Float)((Float)theFloatSegment.getPayload()), (Float)((Float)theOtherFloatSegment.getPayload()));
        Assertions.assertEquals((int)25, (int)theOtherSegment.getLength());
    }

    @Test
    public void testAsciizArraySegment5() throws TransmissionException {
        AbstractPayloadSegment[] abstractPayloadSegmentArray = new AbstractPayloadSegment[3];
        IntSegment theIntSegment = SerialSugar.intSegment((Integer)2);
        abstractPayloadSegmentArray[0] = theIntSegment;
        AsciizArraySegment theAsciizArraySegment = SerialSugar.asciizArraySegment((String[])new String[]{"Hello world!", "Hallo Welt!"});
        abstractPayloadSegmentArray[1] = theAsciizArraySegment;
        FloatSegment theFloatSegment = SerialSugar.floatSegment((Float)Float.valueOf(3.14f));
        abstractPayloadSegmentArray[2] = theFloatSegment;
        SegmentComposite theSegment = SerialSugar.segmentComposite((Segment[])abstractPayloadSegmentArray);
        Sequence theSequence = theSegment.toSequence();
        if (IS_LOG_TESTS) {
            System.out.println("AllocationBodyFacade (hex) = " + theSequence.toHexString());
            System.out.println("AllocationBodyFacade = " + theSegment.toString());
            System.out.println("AbstractSchema = " + theSegment.toSchema());
        }
        Assertions.assertEquals((int)37, (int)theSegment.getLength());
        AbstractPayloadSegment[] abstractPayloadSegmentArray2 = new AbstractPayloadSegment[3];
        IntSegment theOtherIntSegment = SerialSugar.intSegment();
        abstractPayloadSegmentArray2[0] = theOtherIntSegment;
        AsciizArraySegment theOtherAsciizArraySegment = SerialSugar.asciizArraySegment((String[])new String[0]);
        abstractPayloadSegmentArray2[1] = theOtherAsciizArraySegment;
        FloatSegment theOtherFloatSegment = SerialSugar.floatSegment();
        abstractPayloadSegmentArray2[2] = theOtherFloatSegment;
        SegmentComposite theOtherSegment = SerialSugar.segmentComposite((Segment[])abstractPayloadSegmentArray2);
        theOtherSegment.fromTransmission(theSequence);
        if (IS_LOG_TESTS) {
            System.out.println("Other segment = " + theOtherSegment.toString());
            System.out.println("Other schema = " + theOtherSegment.toSchema());
        }
        Assertions.assertEquals((Integer)((Integer)theIntSegment.getPayload()), (Integer)((Integer)theOtherIntSegment.getPayload()));
        Assertions.assertArrayEquals((Object[])((Object[])theAsciizArraySegment.getPayload()), (Object[])((Object[])theOtherAsciizArraySegment.getPayload()));
        Assertions.assertEquals((Float)((Float)theFloatSegment.getPayload()), (Float)((Float)theOtherFloatSegment.getPayload()));
        Assertions.assertEquals((int)37, (int)theOtherSegment.getLength());
    }

    @Test
    public void testAsciizArraySegment6() throws TransmissionException {
        AbstractPayloadSegment[] abstractPayloadSegmentArray = new AbstractPayloadSegment[3];
        IntSegment theIntSegment = SerialSugar.intSegment((Integer)2);
        abstractPayloadSegmentArray[0] = theIntSegment;
        AsciizArraySegment theAsciizArraySegment = SerialSugar.asciizArraySegment((String[])new String[0]);
        abstractPayloadSegmentArray[1] = theAsciizArraySegment;
        FloatSegment theFloatSegment = SerialSugar.floatSegment((Float)Float.valueOf(3.14f));
        abstractPayloadSegmentArray[2] = theFloatSegment;
        SegmentComposite theSegment = SerialSugar.segmentComposite((Segment[])abstractPayloadSegmentArray);
        Sequence theSequence = theSegment.toSequence();
        if (IS_LOG_TESTS) {
            System.out.println("AllocationBodyFacade (hex) = " + theSequence.toHexString());
            System.out.println("AllocationBodyFacade = " + theSegment.toString());
            System.out.println("AbstractSchema = " + theSegment.toSchema());
        }
        Assertions.assertEquals((int)12, (int)theSegment.getLength());
        AbstractPayloadSegment[] abstractPayloadSegmentArray2 = new AbstractPayloadSegment[3];
        IntSegment theOtherIntSegment = SerialSugar.intSegment();
        abstractPayloadSegmentArray2[0] = theOtherIntSegment;
        AsciizArraySegment theOtherAsciizArraySegment = SerialSugar.asciizArraySegment((String[])new String[0]);
        abstractPayloadSegmentArray2[1] = theOtherAsciizArraySegment;
        FloatSegment theOtherFloatSegment = SerialSugar.floatSegment();
        abstractPayloadSegmentArray2[2] = theOtherFloatSegment;
        SegmentComposite theOtherSegment = SerialSugar.segmentComposite((Segment[])abstractPayloadSegmentArray2);
        theOtherSegment.fromTransmission(theSequence);
        if (IS_LOG_TESTS) {
            System.out.println("Other segment = " + theOtherSegment.toString());
            System.out.println("Other schema = " + theOtherSegment.toSchema());
        }
        Assertions.assertEquals((Integer)((Integer)theIntSegment.getPayload()), (Integer)((Integer)theOtherIntSegment.getPayload()));
        Assertions.assertArrayEquals((Object[])((Object[])theAsciizArraySegment.getPayload()), (Object[])((Object[])theOtherAsciizArraySegment.getPayload()));
        Assertions.assertEquals((Float)((Float)theFloatSegment.getPayload()), (Float)((Float)theOtherFloatSegment.getPayload()));
        Assertions.assertEquals((int)12, (int)theOtherSegment.getLength());
    }

    @Test
    public void testAsciizArraySegment7() throws TransmissionException {
        AbstractPayloadSegment[] abstractPayloadSegmentArray = new AbstractPayloadSegment[3];
        IntSegment theIntSegment = SerialSugar.intSegment((Integer)2);
        abstractPayloadSegmentArray[0] = theIntSegment;
        AsciizArraySegment theAsciizArraySegment = SerialSugar.asciizArraySegment((int)1, (Endianess)Endianess.BIG_ENDIAN, (String[])new String[]{"Hello world!", "Hallo Welt!"});
        abstractPayloadSegmentArray[1] = theAsciizArraySegment;
        FloatSegment theFloatSegment = SerialSugar.floatSegment((Float)Float.valueOf(3.14f));
        abstractPayloadSegmentArray[2] = theFloatSegment;
        SegmentComposite theSegment = SerialSugar.segmentComposite((Segment[])abstractPayloadSegmentArray);
        Sequence theSequence = theSegment.toSequence();
        if (IS_LOG_TESTS) {
            System.out.println("AllocationBodyFacade (hex) = " + theSequence.toHexString());
            System.out.println("AllocationBodyFacade = " + theSegment.toString());
            System.out.println("AbstractSchema = " + theSegment.toSchema());
        }
        Assertions.assertEquals((int)34, (int)theSegment.getLength());
        AbstractPayloadSegment[] abstractPayloadSegmentArray2 = new AbstractPayloadSegment[3];
        IntSegment theOtherIntSegment = SerialSugar.intSegment();
        abstractPayloadSegmentArray2[0] = theOtherIntSegment;
        AsciizArraySegment theOtherAsciizArraySegment = SerialSugar.asciizArraySegment((int)1, (Endianess)Endianess.BIG_ENDIAN, (String[])new String[0]);
        abstractPayloadSegmentArray2[1] = theOtherAsciizArraySegment;
        FloatSegment theOtherFloatSegment = SerialSugar.floatSegment();
        abstractPayloadSegmentArray2[2] = theOtherFloatSegment;
        SegmentComposite theOtherSegment = SerialSugar.segmentComposite((Segment[])abstractPayloadSegmentArray2);
        theOtherSegment.fromTransmission(theSequence);
        if (IS_LOG_TESTS) {
            System.out.println("Other segment = " + theOtherSegment.toString());
            System.out.println("Other schema = " + theOtherSegment.toSchema());
        }
        Assertions.assertEquals((Integer)((Integer)theIntSegment.getPayload()), (Integer)((Integer)theOtherIntSegment.getPayload()));
        Assertions.assertArrayEquals((Object[])((Object[])theAsciizArraySegment.getPayload()), (Object[])((Object[])theOtherAsciizArraySegment.getPayload()));
        Assertions.assertEquals((Float)((Float)theFloatSegment.getPayload()), (Float)((Float)theOtherFloatSegment.getPayload()));
        Assertions.assertEquals((int)34, (int)theOtherSegment.getLength());
    }

    @Test
    public void testBooleanSegment() throws TransmissionException {
        for (boolean eBool : new boolean[]{true, false}) {
            LengthSegmentDecoratorSegment theSegment = SerialSugar.lengthSegment((Segment)SerialSugar.booleanSegment((boolean)eBool));
            Sequence theSequence = theSegment.toSequence();
            if (IS_LOG_TESTS) {
                System.out.println("Sequence (hex) = " + theSequence.toHexString(", "));
                System.out.println("Transmission = " + theSegment.toString());
                System.out.println("AbstractSchema = " + theSegment.toSchema());
            }
            LengthSegmentDecoratorSegment theOtherSegment = SerialSugar.lengthSegment((Segment)SerialSugar.booleanSegment());
            theOtherSegment.fromTransmission(theSequence);
            if (IS_LOG_TESTS) {
                System.out.println("Other segment = " + theOtherSegment.toString());
                System.out.println("Other schema = " + theOtherSegment.toSchema());
            }
            Assertions.assertEquals((Object)((BooleanSegment)theSegment.getDecoratee()).getPayload(), (Object)((BooleanSegment)theOtherSegment.getDecoratee()).getPayload());
        }
    }

    @Test
    public void testBooleanArray() throws TransmissionException {
        for (int i = 0; i < 1024; ++i) {
            if (IS_LOG_TESTS) {
                System.out.println();
                System.out.println("---------- Testing for <" + i + "> random boolean digits ----------");
            }
            AllocSectionDecoratorSegment theSegment = SerialSugar.allocSegment((Section)SerialSugar.booleanArraySection((boolean[])this.toRndBooleanArray(i)));
            Sequence theSequence = theSegment.toSequence();
            if (IS_LOG_TESTS) {
                System.out.println("Sequence (hex) = " + theSequence.toHexString(", "));
                System.out.println("Transmission = " + theSegment.toString());
                System.out.println("AbstractSchema = " + theSegment.toSchema());
            }
            AllocSectionDecoratorSegment theOtherSegment = SerialSugar.allocSegment((Section)SerialSugar.booleanArraySection());
            theOtherSegment.fromTransmission(theSequence);
            if (IS_LOG_TESTS) {
                System.out.println("Other segment = " + theOtherSegment.toString());
                System.out.println("Other schema = " + theOtherSegment.toSchema());
            }
            Assertions.assertArrayEquals((boolean[])((boolean[])((BooleanArraySection)theSegment.getDecoratee()).getPayload()), (boolean[])((boolean[])((BooleanArraySection)theOtherSegment.getDecoratee()).getPayload()));
        }
    }

    private boolean[] toRndBooleanArray(int aLength) {
        boolean[] theResult = new boolean[aLength];
        for (int i = 0; i < theResult.length; ++i) {
            theResult[i] = Math.random() < 0.5;
        }
        return theResult;
    }

    @Test
    public void testByteSegment() throws TransmissionException {
        for (int i = -128; i <= 127; ++i) {
            LengthSegmentDecoratorSegment theSegment = SerialSugar.lengthSegment((Segment)SerialSugar.byteSegment((Byte)((byte)i)));
            Sequence theSequence = theSegment.toSequence();
            if (IS_LOG_TESTS) {
                System.out.println("Sequence (hex) = " + theSequence.toHexString(", "));
                System.out.println("Transmission = " + theSegment.toString());
                System.out.println("AbstractSchema = " + theSegment.toSchema());
            }
            LengthSegmentDecoratorSegment theOtherSegment = SerialSugar.lengthSegment((Segment)SerialSugar.byteSegment());
            theOtherSegment.fromTransmission(theSequence);
            if (IS_LOG_TESTS) {
                System.out.println("Other segment = " + theOtherSegment.toString());
                System.out.println("Other schema = " + theOtherSegment.toSchema());
            }
            Assertions.assertEquals((Byte)((Byte)((ByteSegment)theSegment.getDecoratee()).getPayload()), (Byte)((Byte)((ByteSegment)theOtherSegment.getDecoratee()).getPayload()));
        }
    }

    @Test
    public void testByteArray() throws TransmissionException {
        for (int i = 0; i < 1024; ++i) {
            if (IS_LOG_TESTS) {
                System.out.println();
                System.out.println("---------- Testing for <" + i + "> random byte digits ----------");
            }
            AllocSectionDecoratorSegment theSegment = SerialSugar.allocSegment((Section)SerialSugar.byteArraySection((byte[])this.toRndByteArray(i)));
            Sequence theSequence = theSegment.toSequence();
            if (IS_LOG_TESTS) {
                System.out.println("Sequence (hex) = " + theSequence.toHexString(", "));
                System.out.println("Transmission = " + theSegment.toString());
                System.out.println("AbstractSchema = " + theSegment.toSchema());
            }
            AllocSectionDecoratorSegment theOtherSegment = SerialSugar.allocSegment((Section)SerialSugar.byteArraySection());
            theOtherSegment.fromTransmission(theSequence);
            if (IS_LOG_TESTS) {
                System.out.println("Other segment = " + theOtherSegment.toString());
                System.out.println("Other schema = " + theOtherSegment.toSchema());
            }
            Assertions.assertArrayEquals((byte[])((byte[])((ByteArraySection)theSegment.getDecoratee()).getPayload()), (byte[])((byte[])((ByteArraySection)theOtherSegment.getDecoratee()).getPayload()));
        }
    }

    private byte[] toRndByteArray(int aLength) {
        Random theRnd = new Random();
        byte[] theResult = new byte[aLength];
        theRnd.nextBytes(theResult);
        return theResult;
    }

    @Test
    public void testFixedLengthByteArray() throws TransmissionException {
        for (int i = 0; i < 1024; ++i) {
            if (IS_LOG_TESTS) {
                System.out.println();
                System.out.println("---------- Testing for <" + i + "> random byte digits ----------");
            }
            AllocSectionDecoratorSegment theSegment = SerialSugar.allocSegment((Section)SerialSugar.fixedSegmentArraySection((Segment[])this.toRndByteSegmentArray(i)));
            Sequence theSequence = theSegment.toSequence();
            if (IS_LOG_TESTS) {
                System.out.println("Sequence (hex) = " + theSequence.toHexString(", "));
                System.out.println("Transmission = " + theSegment.toString());
            }
            AllocSectionDecoratorSegment theOtherSegment = SerialSugar.allocSegment((Section)SerialSugar.fixedSegmentArraySection(ByteSegment.class));
            theOtherSegment.fromTransmission(theSequence);
            if (IS_LOG_TESTS) {
                System.out.println("Other segment = " + theOtherSegment.toString());
            }
            Assertions.assertArrayEquals((Object[])((FixedSegmentArraySection)theSegment.getDecoratee()).getArray(), (Object[])((FixedSegmentArraySection)theOtherSegment.getDecoratee()).getArray());
            AllocSectionDecoratorSegment theReferenceSegment = SerialSugar.allocSegment((Section)SerialSugar.byteArraySection());
            theReferenceSegment.fromTransmission(theOtherSegment.toSequence());
            Sequence theReferenceSequence = theReferenceSegment.toSequence();
            if (IS_LOG_TESTS) {
                System.out.println("Reference sequence (hex) = " + theReferenceSequence.toHexString(", "));
                System.out.println("Reference segment = " + theReferenceSegment.toString());
            }
            Assertions.assertArrayEquals((byte[])theSegment.toSequence().toBytes(), (byte[])theReferenceSegment.toSequence().toBytes());
        }
    }

    private ByteSegment[] toRndByteSegmentArray(int aLength) {
        ByteSegment[] theByteSegmentArray = new ByteSegment[aLength];
        byte[] theBytes = this.toRndByteArray(aLength);
        for (int i = 0; i < theByteSegmentArray.length; ++i) {
            theByteSegmentArray[i] = new ByteSegment(Byte.valueOf(theBytes[i]));
        }
        return theByteSegmentArray;
    }

    @Test
    public void testShortSegment() throws TransmissionException {
        for (Endianess eEndianess : Endianess.values()) {
            for (int i = Short.MIN_VALUE; i <= Short.MAX_VALUE; ++i) {
                LengthSegmentDecoratorSegment theSegment = SerialSugar.lengthSegment((Segment)SerialSugar.shortSegment((Short)((short)i), (Endianess)eEndianess));
                Sequence theSequence = theSegment.toSequence();
                if (IS_LOG_TESTS) {
                    System.out.println("Sequence (hex) = " + theSequence.toHexString(", "));
                    System.out.println("Transmission = " + theSegment.toString());
                }
                LengthSegmentDecoratorSegment theOtherSegment = SerialSugar.lengthSegment((Segment)SerialSugar.shortSegment((Endianess)eEndianess));
                theOtherSegment.fromTransmission(theSequence);
                if (IS_LOG_TESTS) {
                    System.out.println("Other segment = " + theOtherSegment.toString());
                }
                Assertions.assertEquals((Short)((Short)((ShortSegment)theSegment.getDecoratee()).getPayload()), (Short)((Short)((ShortSegment)theOtherSegment.getDecoratee()).getPayload()));
            }
        }
    }

    @Test
    public void testShortArray() throws TransmissionException {
        for (int i = 0; i < 1024; ++i) {
            if (IS_LOG_TESTS) {
                System.out.println();
                System.out.println("---------- Testing for <" + i + "> random short digits ----------");
            }
            AllocSectionDecoratorSegment theSegment = SerialSugar.allocSegment((Section)SerialSugar.shortArraySection((short[])this.toRndShortArray(i)));
            Sequence theSequence = theSegment.toSequence();
            if (IS_LOG_TESTS) {
                System.out.println("Sequence (hex) = " + theSequence.toHexString(", "));
                System.out.println("Transmission = " + theSegment.toString());
            }
            AllocSectionDecoratorSegment theOtherSegment = SerialSugar.allocSegment((Section)SerialSugar.shortArraySection());
            theOtherSegment.fromTransmission(theSequence);
            if (IS_LOG_TESTS) {
                System.out.println("Other segment = " + theOtherSegment.toString());
            }
            Assertions.assertArrayEquals((short[])((short[])((ShortArraySection)theSegment.getDecoratee()).getPayload()), (short[])((short[])((ShortArraySection)theOtherSegment.getDecoratee()).getPayload()));
        }
    }

    private short[] toRndShortArray(int aLength) {
        Random theRnd = new Random();
        short[] theResult = new short[aLength];
        for (int i = 0; i < theResult.length; ++i) {
            theResult[i] = (short)(theRnd.nextBoolean() ? theRnd.nextFloat() * 32767.0f : theRnd.nextFloat() * -32768.0f);
        }
        return theResult;
    }

    @Test
    public void testFixedLengthShortArray() throws TransmissionException {
        for (int i = 0; i < 1024; ++i) {
            if (IS_LOG_TESTS) {
                System.out.println();
                System.out.println("---------- Testing for <" + i + "> random short digits ----------");
            }
            AllocSectionDecoratorSegment theSegment = SerialSugar.allocSegment((Section)SerialSugar.fixedSegmentArraySection((Segment[])this.toRndShortSegmentArray(i)));
            Sequence theSequence = theSegment.toSequence();
            if (IS_LOG_TESTS) {
                System.out.println("Sequence (hex) = " + theSequence.toHexString(", "));
                System.out.println("Transmission = " + theSegment.toString());
            }
            AllocSectionDecoratorSegment theOtherSegment = SerialSugar.allocSegment((Section)SerialSugar.fixedSegmentArraySection(ShortSegment.class));
            theOtherSegment.fromTransmission(theSequence);
            if (IS_LOG_TESTS) {
                System.out.println("Other segment = " + theOtherSegment.toString());
            }
            Assertions.assertArrayEquals((Object[])((FixedSegmentArraySection)theSegment.getDecoratee()).getArray(), (Object[])((FixedSegmentArraySection)theOtherSegment.getDecoratee()).getArray());
            AllocSectionDecoratorSegment theReferenceSegment = SerialSugar.allocSegment((Section)SerialSugar.shortArraySection());
            theReferenceSegment.fromTransmission(theOtherSegment.toSequence());
            Sequence theReferenceSequence = theReferenceSegment.toSequence();
            if (IS_LOG_TESTS) {
                System.out.println("Reference sequence (hex) = " + theReferenceSequence.toHexString(", "));
                System.out.println("Reference segment = " + theReferenceSegment.toString());
            }
            Assertions.assertArrayEquals((byte[])theSegment.toSequence().toBytes(), (byte[])theReferenceSegment.toSequence().toBytes());
        }
    }

    private ShortSegment[] toRndShortSegmentArray(int aLength) {
        ShortSegment[] theShortSegmentArray = new ShortSegment[aLength];
        short[] theShorts = this.toRndShortArray(aLength);
        for (int i = 0; i < theShortSegmentArray.length; ++i) {
            theShortSegmentArray[i] = new ShortSegment(Short.valueOf(theShorts[i]));
        }
        return theShortSegmentArray;
    }

    @Test
    public void testIntSegment() throws TransmissionException {
        for (Endianess eEndianess : Endianess.values()) {
            for (int i = Short.MIN_VALUE; i <= Short.MAX_VALUE; ++i) {
                int l = i == Short.MIN_VALUE ? Integer.MIN_VALUE : (i == Short.MAX_VALUE ? Integer.MAX_VALUE : i);
                LengthSegmentDecoratorSegment theSegment = SerialSugar.lengthSegment((Segment)SerialSugar.intSegment((Integer)l, (Endianess)eEndianess));
                Sequence theSequence = theSegment.toSequence();
                if (IS_LOG_TESTS) {
                    System.out.println("Sequence (hex) = " + theSequence.toHexString(", "));
                    System.out.println("Transmission = " + theSegment.toString());
                }
                LengthSegmentDecoratorSegment theOtherSegment = SerialSugar.lengthSegment((Segment)SerialSugar.intSegment((Endianess)eEndianess));
                theOtherSegment.fromTransmission(theSequence);
                if (IS_LOG_TESTS) {
                    System.out.println("Other segment = " + theOtherSegment.toString());
                }
                Assertions.assertEquals((Integer)((Integer)((IntSegment)theSegment.getDecoratee()).getPayload()), (Integer)((Integer)((IntSegment)theOtherSegment.getDecoratee()).getPayload()));
            }
        }
    }

    @Test
    public void testIntArray() throws TransmissionException {
        for (int i = 0; i < 1024; ++i) {
            if (IS_LOG_TESTS) {
                System.out.println();
                System.out.println("---------- Testing for <" + i + "> random int digits ----------");
            }
            AllocSectionDecoratorSegment theSegment = SerialSugar.allocSegment((Section)SerialSugar.intArraySection((int[])this.toRndIntArray(i)));
            Sequence theSequence = theSegment.toSequence();
            if (IS_LOG_TESTS) {
                System.out.println("Sequence (hex) = " + theSequence.toHexString(", "));
                System.out.println("Transmission = " + theSegment.toString());
            }
            AllocSectionDecoratorSegment theOtherSegment = SerialSugar.allocSegment((Section)SerialSugar.intArraySection());
            theOtherSegment.fromTransmission(theSequence);
            if (IS_LOG_TESTS) {
                System.out.println("Other segment = " + theOtherSegment.toString());
            }
            Assertions.assertArrayEquals((int[])((int[])((IntArraySection)theSegment.getDecoratee()).getPayload()), (int[])((int[])((IntArraySection)theOtherSegment.getDecoratee()).getPayload()));
        }
    }

    private int[] toRndIntArray(int aLength) {
        Random theRnd = new Random();
        int[] theResult = new int[aLength];
        for (int i = 0; i < theResult.length; ++i) {
            theResult[i] = theRnd.nextInt();
        }
        return theResult;
    }

    @Test
    public void testFixedLengthIntArray() throws TransmissionException {
        for (int i = 0; i < 1024; ++i) {
            if (IS_LOG_TESTS) {
                System.out.println();
                System.out.println("---------- Testing for <" + i + "> random int digits ----------");
            }
            AllocSectionDecoratorSegment theSegment = SerialSugar.allocSegment((Section)SerialSugar.fixedSegmentArraySection((Segment[])this.toRndIntSegmentArray(i)));
            Sequence theSequence = theSegment.toSequence();
            if (IS_LOG_TESTS) {
                System.out.println("Sequence (hex) = " + theSequence.toHexString(", "));
                System.out.println("Transmission = " + theSegment.toString());
            }
            AllocSectionDecoratorSegment theOtherSegment = SerialSugar.allocSegment((Section)SerialSugar.fixedSegmentArraySection(IntSegment.class));
            theOtherSegment.fromTransmission(theSequence);
            if (IS_LOG_TESTS) {
                System.out.println("Other segment = " + theOtherSegment.toString());
            }
            Assertions.assertArrayEquals((Object[])((FixedSegmentArraySection)theSegment.getDecoratee()).getArray(), (Object[])((FixedSegmentArraySection)theOtherSegment.getDecoratee()).getArray());
            AllocSectionDecoratorSegment theReferenceSegment = SerialSugar.allocSegment((Section)SerialSugar.intArraySection());
            theReferenceSegment.fromTransmission(theOtherSegment.toSequence());
            Sequence theReferenceSequence = theReferenceSegment.toSequence();
            if (IS_LOG_TESTS) {
                System.out.println("Reference sequence (hex) = " + theReferenceSequence.toHexString(", "));
                System.out.println("Reference segment = " + theReferenceSegment.toString());
            }
            Assertions.assertArrayEquals((byte[])theSegment.toSequence().toBytes(), (byte[])theReferenceSegment.toSequence().toBytes());
        }
    }

    private IntSegment[] toRndIntSegmentArray(int aLength) {
        IntSegment[] theIntSegmentArray = new IntSegment[aLength];
        int[] theIntegers = this.toRndIntArray(aLength);
        for (int i = 0; i < theIntSegmentArray.length; ++i) {
            theIntSegmentArray[i] = new IntSegment(Integer.valueOf(theIntegers[i]));
        }
        return theIntSegmentArray;
    }

    @Test
    public void testLongSegment() throws TransmissionException {
        for (Endianess eEndianess : Endianess.values()) {
            for (int i = Short.MIN_VALUE; i <= Short.MAX_VALUE; ++i) {
                long l = i == Short.MIN_VALUE ? Long.MIN_VALUE : (i == Short.MAX_VALUE ? Long.MAX_VALUE : (long)i);
                LengthSegmentDecoratorSegment theSegment = SerialSugar.lengthSegment((Segment)SerialSugar.longSegment((Long)l, (Endianess)eEndianess));
                Sequence theSequence = theSegment.toSequence();
                if (IS_LOG_TESTS) {
                    System.out.println("Sequence (hex) = " + theSequence.toHexString(", "));
                    System.out.println("Transmission = " + theSegment.toString());
                }
                LengthSegmentDecoratorSegment theOtherSegment = SerialSugar.lengthSegment((Segment)SerialSugar.longSegment((Endianess)eEndianess));
                theOtherSegment.fromTransmission(theSequence);
                if (IS_LOG_TESTS) {
                    System.out.println("Other segment = " + theOtherSegment.toString());
                }
                Assertions.assertEquals((Long)((Long)((LongSegment)theSegment.getDecoratee()).getPayload()), (Long)((Long)((LongSegment)theOtherSegment.getDecoratee()).getPayload()));
            }
        }
    }

    @Test
    public void testLongArray() throws TransmissionException {
        for (int i = 0; i < 1024; ++i) {
            if (IS_LOG_TESTS) {
                System.out.println();
                System.out.println("---------- Testing for <" + i + "> random long digits ----------");
            }
            AllocSectionDecoratorSegment theSegment = SerialSugar.allocSegment((Section)SerialSugar.longArraySection((long[])this.toRndLongArray(i)));
            Sequence theSequence = theSegment.toSequence();
            if (IS_LOG_TESTS) {
                System.out.println("Sequence (hex) = " + theSequence.toHexString(", "));
                System.out.println("Transmission = " + theSegment.toString());
            }
            AllocSectionDecoratorSegment theOtherSegment = SerialSugar.allocSegment((Section)SerialSugar.longArraySection());
            theOtherSegment.fromTransmission(theSequence);
            if (IS_LOG_TESTS) {
                System.out.println("Other segment = " + theOtherSegment.toString());
            }
            Assertions.assertArrayEquals((long[])((long[])((LongArraySection)theSegment.getDecoratee()).getPayload()), (long[])((long[])((LongArraySection)theOtherSegment.getDecoratee()).getPayload()));
        }
    }

    private long[] toRndLongArray(int aLength) {
        Random theRnd = new Random();
        long[] theResult = new long[aLength];
        for (int i = 0; i < theResult.length; ++i) {
            theResult[i] = theRnd.nextLong();
        }
        return theResult;
    }

    @Test
    public void testFixedLengthLongArray() throws TransmissionException {
        for (int i = 0; i < 1024; ++i) {
            if (IS_LOG_TESTS) {
                System.out.println();
                System.out.println("---------- Testing for <" + i + "> random long digits ----------");
            }
            AllocSectionDecoratorSegment theSegment = SerialSugar.allocSegment((Section)SerialSugar.fixedSegmentArraySection((Segment[])this.toRndLongSegmentArray(i)));
            Sequence theSequence = theSegment.toSequence();
            if (IS_LOG_TESTS) {
                System.out.println("Sequence (hex) = " + theSequence.toHexString(", "));
                System.out.println("Transmission = " + theSegment.toString());
            }
            AllocSectionDecoratorSegment theOtherSegment = SerialSugar.allocSegment((Section)SerialSugar.fixedSegmentArraySection(LongSegment.class));
            theOtherSegment.fromTransmission(theSequence);
            if (IS_LOG_TESTS) {
                System.out.println("Other segment = " + theOtherSegment.toString());
            }
            Assertions.assertArrayEquals((Object[])((FixedSegmentArraySection)theSegment.getDecoratee()).getArray(), (Object[])((FixedSegmentArraySection)theOtherSegment.getDecoratee()).getArray());
            AllocSectionDecoratorSegment theReferenceSegment = SerialSugar.allocSegment((Section)SerialSugar.longArraySection());
            theReferenceSegment.fromTransmission(theOtherSegment.toSequence());
            Sequence theReferenceSequence = theReferenceSegment.toSequence();
            if (IS_LOG_TESTS) {
                System.out.println("Reference sequence (hex) = " + theReferenceSequence.toHexString(", "));
                System.out.println("Reference segment = " + theReferenceSegment.toString());
            }
            Assertions.assertArrayEquals((byte[])theSegment.toSequence().toBytes(), (byte[])theReferenceSegment.toSequence().toBytes());
        }
    }

    private LongSegment[] toRndLongSegmentArray(int aLength) {
        LongSegment[] theLongSegmentArray = new LongSegment[aLength];
        long[] theLongs = this.toRndLongArray(aLength);
        for (int i = 0; i < theLongSegmentArray.length; ++i) {
            theLongSegmentArray[i] = new LongSegment(Long.valueOf(theLongs[i]));
        }
        return theLongSegmentArray;
    }

    @Test
    public void testFloatSegment() throws TransmissionException {
        for (Endianess eEndianess : Endianess.values()) {
            for (int i = Short.MIN_VALUE; i <= Short.MAX_VALUE; ++i) {
                float l;
                float f = i == Short.MIN_VALUE ? Float.MIN_VALUE : (l = i == Short.MAX_VALUE ? Float.MAX_VALUE : (float)i * (float)Math.PI);
                if (IS_LOG_TESTS) {
                    System.out.print("Endianess = " + eEndianess + ", value= ");
                    System.out.printf("%f%n", Float.valueOf(l));
                }
                LengthSegmentDecoratorSegment theSegment = SerialSugar.lengthSegment((Segment)SerialSugar.floatSegment((Float)Float.valueOf(l), (Endianess)eEndianess));
                Sequence theSequence = theSegment.toSequence();
                if (IS_LOG_TESTS) {
                    System.out.println("Sequence (hex) = " + theSequence.toHexString(", "));
                    System.out.println("Transmission = " + theSegment.toString());
                }
                LengthSegmentDecoratorSegment theOtherSegment = SerialSugar.lengthSegment((Segment)SerialSugar.floatSegment((Endianess)eEndianess));
                theOtherSegment.fromTransmission(theSequence);
                if (IS_LOG_TESTS) {
                    System.out.println("Other sequence (hex) = " + theOtherSegment.toSequence().toHexString(", "));
                    System.out.println("Other segment = " + theOtherSegment.toString());
                }
                if (IS_LOG_TESTS) {
                    System.out.println("theSegment.value = " + ((FloatSegment)theSegment.getDecoratee()).getPayload());
                    System.out.println("theOtherSegment.value = " + ((FloatSegment)theOtherSegment.getDecoratee()).getPayload());
                }
                Assertions.assertEquals((Float)((Float)((FloatSegment)theSegment.getDecoratee()).getPayload()), (Float)((Float)((FloatSegment)theOtherSegment.getDecoratee()).getPayload()));
            }
        }
    }

    @Test
    public void testFloatArray() throws TransmissionException {
        for (int i = 0; i < 1024; ++i) {
            if (IS_LOG_TESTS) {
                System.out.println();
                System.out.println("---------- Testing for <" + i + "> random float digits ----------");
            }
            AllocSectionDecoratorSegment theSegment = SerialSugar.allocSegment((Section)SerialSugar.floatArraySection((float[])this.toRndFloatArray(i)));
            Sequence theSequence = theSegment.toSequence();
            if (IS_LOG_TESTS) {
                System.out.println("Sequence (hex) = " + theSequence.toHexString(", "));
                System.out.println("Transmission = " + theSegment.toString());
            }
            AllocSectionDecoratorSegment theOtherSegment = SerialSugar.allocSegment((Section)SerialSugar.floatArraySection());
            theOtherSegment.fromTransmission(theSequence);
            if (IS_LOG_TESTS) {
                System.out.println("Other segment = " + theOtherSegment.toString());
            }
            Assertions.assertArrayEquals((float[])((float[])((FloatArraySection)theSegment.getDecoratee()).getPayload()), (float[])((float[])((FloatArraySection)theOtherSegment.getDecoratee()).getPayload()));
        }
    }

    private float[] toRndFloatArray(int aLength) {
        Random theRnd = new Random();
        float[] theResult = new float[aLength];
        for (int i = 0; i < theResult.length; ++i) {
            theResult[i] = theRnd.nextBoolean() ? theRnd.nextFloat() * Float.MAX_VALUE : theRnd.nextFloat() * Float.MIN_VALUE * -1.0f;
        }
        return theResult;
    }

    @Test
    public void testFixedLengthFloatArray() throws TransmissionException {
        for (int i = 0; i < 1024; ++i) {
            if (IS_LOG_TESTS) {
                System.out.println();
                System.out.println("---------- Testing for <" + i + "> random float digits ----------");
            }
            AllocSectionDecoratorSegment theSegment = SerialSugar.allocSegment((Section)SerialSugar.fixedSegmentArraySection((Segment[])this.toRndFloatSegmentArray(i)));
            Sequence theSequence = theSegment.toSequence();
            if (IS_LOG_TESTS) {
                System.out.println("Sequence (hex) = " + theSequence.toHexString(", "));
                System.out.println("Transmission = " + theSegment.toString());
            }
            AllocSectionDecoratorSegment theOtherSegment = SerialSugar.allocSegment((Section)SerialSugar.fixedSegmentArraySection(FloatSegment.class));
            theOtherSegment.fromTransmission(theSequence);
            if (IS_LOG_TESTS) {
                System.out.println("Other segment = " + theOtherSegment.toString());
            }
            Assertions.assertArrayEquals((Object[])((FixedSegmentArraySection)theSegment.getDecoratee()).getArray(), (Object[])((FixedSegmentArraySection)theOtherSegment.getDecoratee()).getArray());
            AllocSectionDecoratorSegment theReferenceSegment = SerialSugar.allocSegment((Section)SerialSugar.floatArraySection());
            theReferenceSegment.fromTransmission(theOtherSegment.toSequence());
            Sequence theReferenceSequence = theReferenceSegment.toSequence();
            if (IS_LOG_TESTS) {
                System.out.println("Reference sequence (hex) = " + theReferenceSequence.toHexString(", "));
                System.out.println("Reference segment = " + theReferenceSegment.toString());
            }
            Assertions.assertArrayEquals((byte[])theSegment.toSequence().toBytes(), (byte[])theReferenceSegment.toSequence().toBytes());
        }
    }

    private FloatSegment[] toRndFloatSegmentArray(int aLength) {
        FloatSegment[] theFloatSegmentArray = new FloatSegment[aLength];
        float[] theFloats = this.toRndFloatArray(aLength);
        for (int i = 0; i < theFloatSegmentArray.length; ++i) {
            theFloatSegmentArray[i] = new FloatSegment(Float.valueOf(theFloats[i]));
        }
        return theFloatSegmentArray;
    }

    @Test
    public void testDoubleSegment() throws TransmissionException {
        for (Endianess eEndianess : Endianess.values()) {
            for (int i = Short.MIN_VALUE; i <= Short.MAX_VALUE; ++i) {
                double l = i == Short.MIN_VALUE ? Double.MIN_VALUE : (i == Short.MAX_VALUE ? Double.MAX_VALUE : (double)i * Math.PI);
                LengthSegmentDecoratorSegment theSegment = SerialSugar.lengthSegment((Segment)SerialSugar.doubleSegment((Double)l, (Endianess)eEndianess));
                Sequence theSequence = theSegment.toSequence();
                if (IS_LOG_TESTS) {
                    System.out.println("Sequence (hex) = " + theSequence.toHexString(", "));
                    System.out.println("Transmission = " + theSegment.toString());
                }
                LengthSegmentDecoratorSegment theOtherSegment = SerialSugar.lengthSegment((Segment)SerialSugar.doubleSegment((Endianess)eEndianess));
                theOtherSegment.fromTransmission(theSequence);
                if (IS_LOG_TESTS) {
                    System.out.println("Other segment = " + theOtherSegment.toString());
                }
                Assertions.assertEquals((Double)((Double)((DoubleSegment)theSegment.getDecoratee()).getPayload()), (Double)((Double)((DoubleSegment)theOtherSegment.getDecoratee()).getPayload()));
            }
        }
    }

    @Test
    public void testDoubleArray() throws TransmissionException {
        for (int i = 0; i < 1024; ++i) {
            if (IS_LOG_TESTS) {
                System.out.println();
                System.out.println("---------- Testing for <" + i + "> random double digits ----------");
            }
            AllocSectionDecoratorSegment theSegment = SerialSugar.allocSegment((Section)SerialSugar.doubleArraySection((double[])this.toRndDoubleArray(i)));
            Sequence theSequence = theSegment.toSequence();
            if (IS_LOG_TESTS) {
                System.out.println("Sequence (hex) = " + theSequence.toHexString(", "));
                System.out.println("Transmission = " + theSegment.toString());
            }
            AllocSectionDecoratorSegment theOtherSegment = SerialSugar.allocSegment((Section)SerialSugar.doubleArraySection());
            theOtherSegment.fromTransmission(theSequence);
            if (IS_LOG_TESTS) {
                System.out.println("Other segment = " + theOtherSegment.toString());
            }
            Assertions.assertArrayEquals((double[])((double[])((DoubleArraySection)theSegment.getDecoratee()).getPayload()), (double[])((double[])((DoubleArraySection)theOtherSegment.getDecoratee()).getPayload()));
        }
    }

    private double[] toRndDoubleArray(int aLength) {
        Random theRnd = new Random();
        double[] theResult = new double[aLength];
        for (int i = 0; i < theResult.length; ++i) {
            theResult[i] = theRnd.nextBoolean() ? theRnd.nextDouble() * Double.MAX_VALUE : theRnd.nextDouble() * Double.MIN_VALUE * -1.0;
        }
        return theResult;
    }

    @Test
    public void testFixedLengthDoubleArray() throws TransmissionException {
        for (int i = 0; i < 1024; ++i) {
            if (IS_LOG_TESTS) {
                System.out.println();
                System.out.println("---------- Testing for <" + i + "> random double digits ----------");
            }
            AllocSectionDecoratorSegment theSegment = SerialSugar.allocSegment((Section)SerialSugar.fixedSegmentArraySection((Segment[])this.toRndDoubleSegmentArray(i)));
            Sequence theSequence = theSegment.toSequence();
            if (IS_LOG_TESTS) {
                System.out.println("Sequence (hex) = " + theSequence.toHexString(", "));
                System.out.println("Transmission = " + theSegment.toString());
            }
            AllocSectionDecoratorSegment theOtherSegment = SerialSugar.allocSegment((Section)SerialSugar.fixedSegmentArraySection(DoubleSegment.class));
            theOtherSegment.fromTransmission(theSequence);
            if (IS_LOG_TESTS) {
                System.out.println("Other segment = " + theOtherSegment.toString());
            }
            Assertions.assertArrayEquals((Object[])((FixedSegmentArraySection)theSegment.getDecoratee()).getArray(), (Object[])((FixedSegmentArraySection)theOtherSegment.getDecoratee()).getArray());
            AllocSectionDecoratorSegment theReferenceSegment = SerialSugar.allocSegment((Section)SerialSugar.doubleArraySection());
            theReferenceSegment.fromTransmission(theOtherSegment.toSequence());
            Sequence theReferenceSequence = theReferenceSegment.toSequence();
            if (IS_LOG_TESTS) {
                System.out.println("Reference sequence (hex) = " + theReferenceSequence.toHexString(", "));
                System.out.println("Reference segment = " + theReferenceSegment.toString());
            }
            Assertions.assertArrayEquals((byte[])theSegment.toSequence().toBytes(), (byte[])theReferenceSegment.toSequence().toBytes());
        }
    }

    private DoubleSegment[] toRndDoubleSegmentArray(int aLength) {
        DoubleSegment[] theDoubleSegmentArray = new DoubleSegment[aLength];
        double[] theDoubles = this.toRndDoubleArray(aLength);
        for (int i = 0; i < theDoubleSegmentArray.length; ++i) {
            theDoubleSegmentArray[i] = new DoubleSegment(Double.valueOf(theDoubles[i]));
        }
        return theDoubleSegmentArray;
    }

    @Test
    public void testStringSegment() throws TransmissionException {
        AllocSectionDecoratorSegment theSegment = SerialSugar.allocSegment((Section)SerialSugar.stringSection((String)"Hallo Welt!"));
        Sequence theSequence = theSegment.toSequence();
        if (IS_LOG_TESTS) {
            System.out.println("AllocationBodyFacade (hex) = " + theSequence.toHexString());
            System.out.println("AllocationBodyFacade = " + theSegment.toString());
            System.out.println("AbstractSchema = " + theSegment.toSchema());
        }
        AllocSectionDecoratorSegment theOtherSegment = SerialSugar.allocSegment((Section)SerialSugar.stringSection());
        theOtherSegment.fromTransmission(theSequence);
        if (IS_LOG_TESTS) {
            System.out.println("Other segment = " + theOtherSegment.toString());
            System.out.println("Other schema = " + theOtherSegment.toSchema());
        }
        Assertions.assertEquals((Object)((StringSection)theSegment.getDecoratee()).getPayload(), (Object)((StringSection)theOtherSegment.getDecoratee()).getPayload());
    }

    @Test
    public void testStringArrayBody() throws TransmissionException {
        AllocSectionDecoratorSegment theSegment = SerialSugar.allocSegment((Section)SerialSugar.stringArraySection((String[])new String[]{"Hallo Welt!", "Hello World!", "\u0e2a\u0e27\u0e31\u0e2a\u0e14\u0e35\u0e08\u0e31\u0e01\u0e23\u0e27\u0e32\u0e25!"}));
        Sequence theSequence = theSegment.toSequence();
        if (IS_LOG_TESTS) {
            System.out.println("Sequence (hex) = " + theSequence.toHexString());
            System.out.println("Transmission = " + theSegment.toString());
            System.out.println("AbstractSchema = " + theSegment.toSchema());
        }
        AllocSectionDecoratorSegment theOtherSegment = SerialSugar.allocSegment((Section)SerialSugar.stringArraySection());
        theOtherSegment.fromTransmission(theSequence);
        if (IS_LOG_TESTS) {
            System.out.println("Other segment = " + theOtherSegment.toString());
            System.out.println("Other schema = " + theOtherSegment.toSchema());
        }
        Assertions.assertArrayEquals((Object[])((StringArraySection)theSegment.getDecoratee()).getPayload(), (Object[])((StringArraySection)theOtherSegment.getDecoratee()).getPayload());
    }

    @Test
    public void testNumberSegment1() throws TransmissionException {
        for (Endianess eEndianess : Endianess.values()) {
            for (int i = Short.MIN_VALUE; i <= Short.MAX_VALUE; ++i) {
                long l = i == Short.MIN_VALUE ? Integer.MIN_VALUE : (i == Short.MAX_VALUE ? Integer.MAX_VALUE : i);
                LengthSegmentDecoratorSegment theSegment = SerialSugar.lengthSegment((Segment)SerialSugar.numberSegment((int)4, (Long)l, (Endianess)eEndianess));
                Sequence theSequence = theSegment.toSequence();
                if (IS_LOG_TESTS) {
                    System.out.println("Sequence (hex) = " + theSequence.toHexString(", "));
                    System.out.println("Transmission = " + theSegment.toString());
                }
                LengthSegmentDecoratorSegment theOtherSegment = SerialSugar.lengthSegment((Segment)SerialSugar.numberSegment((int)4, (Endianess)eEndianess));
                theOtherSegment.fromTransmission(theSequence);
                if (IS_LOG_TESTS) {
                    System.out.println("Other segment = " + theOtherSegment.toString());
                }
                Assertions.assertEquals((Long)((Long)((NumberSegment)theSegment.getDecoratee()).getPayload()), (Long)((Long)((NumberSegment)theOtherSegment.getDecoratee()).getPayload()));
            }
        }
    }

    @Test
    public void testNumberSegment2() throws TransmissionException {
        for (Endianess eEndianess : Endianess.values()) {
            for (int i = Short.MIN_VALUE; i <= Short.MAX_VALUE; ++i) {
                long l = i == Short.MIN_VALUE ? Long.MIN_VALUE : (i == Short.MAX_VALUE ? Long.MAX_VALUE : (long)i);
                LengthSegmentDecoratorSegment theSegment = SerialSugar.lengthSegment((Segment)SerialSugar.numberSegment((int)8, (Long)l, (Endianess)eEndianess));
                Sequence theSequence = theSegment.toSequence();
                if (IS_LOG_TESTS) {
                    System.out.println("Sequence (hex) = " + theSequence.toHexString(", "));
                    System.out.println("Transmission = " + theSegment.toString());
                }
                LengthSegmentDecoratorSegment theOtherSegment = SerialSugar.lengthSegment((Segment)SerialSugar.numberSegment((int)8, (Endianess)eEndianess));
                theOtherSegment.fromTransmission(theSequence);
                if (IS_LOG_TESTS) {
                    System.out.println("Other segment = " + theOtherSegment.toString());
                }
                Assertions.assertEquals((Long)((Long)((NumberSegment)theSegment.getDecoratee()).getPayload()), (Long)((Long)((NumberSegment)theOtherSegment.getDecoratee()).getPayload()));
            }
        }
    }

    @Test
    public void testNumberSegment3() throws TransmissionException {
        for (Endianess eEndianess : Endianess.values()) {
            for (int i = Short.MIN_VALUE; i <= Short.MAX_VALUE; ++i) {
                long l = i == Short.MIN_VALUE ? Integer.MIN_VALUE : (i == Short.MAX_VALUE ? Integer.MAX_VALUE : i);
                LengthSegmentDecoratorSegment theSegment = SerialSugar.lengthSegment((Segment)SerialSugar.numberSegment((int)5, (Long)l, (Endianess)eEndianess));
                Sequence theSequence = theSegment.toSequence();
                if (IS_LOG_TESTS) {
                    System.out.println("Sequence (hex) = " + theSequence.toHexString(", "));
                    System.out.println("Transmission = " + theSegment.toString());
                }
                LengthSegmentDecoratorSegment theOtherSegment = SerialSugar.lengthSegment((Segment)SerialSugar.numberSegment((int)5, (Endianess)eEndianess));
                theOtherSegment.fromTransmission(theSequence);
                if (IS_LOG_TESTS) {
                    System.out.println("Other segment = " + theOtherSegment.toString());
                }
                Assertions.assertEquals((Long)((Long)((NumberSegment)theSegment.getDecoratee()).getPayload()), (Long)((Long)((NumberSegment)theOtherSegment.getDecoratee()).getPayload()));
            }
        }
    }

    @Disabled
    @Test
    public void testEdgeCase1() throws TransmissionException {
        int i = -128;
        LengthSegmentDecoratorSegment theSegment = SerialSugar.lengthSegment((Segment)SerialSugar.shortSegment((Short)((short)i)));
        Sequence theSequence = theSegment.toSequence();
        if (IS_LOG_TESTS) {
            System.out.println("Sequence (hex) = " + theSequence.toHexString(", "));
            System.out.println("Transmission = " + theSegment.toString());
        }
        LengthSegmentDecoratorSegment theOtherSegment = SerialSugar.lengthSegment((Segment)SerialSugar.shortSegment());
        theOtherSegment.fromTransmission(theSequence);
        if (IS_LOG_TESTS) {
            System.out.println("Other sequence (hex) = " + theOtherSegment.toSequence().toHexString(", "));
            System.out.println("Other segment = " + theOtherSegment.toString());
        }
        Assertions.assertEquals((Short)((Short)((ShortSegment)theSegment.getDecoratee()).getPayload()), (Short)((Short)((ShortSegment)theOtherSegment.getDecoratee()).getPayload()));
    }

    @Test
    public void testEdgeCase2() throws TransmissionException {
        float l = -78131.414f;
        Endianess theEndianess = Endianess.LITTLE_ENDIAN;
        if (IS_LOG_TESTS) {
            System.out.print("Endianess = " + theEndianess + ", value= ");
            System.out.printf("%f%n", Float.valueOf(l));
        }
        LengthSegmentDecoratorSegment theSegment = SerialSugar.lengthSegment((Segment)SerialSugar.floatSegment((Float)Float.valueOf(l), (Endianess)theEndianess));
        Sequence theSequence = theSegment.toSequence();
        if (IS_LOG_TESTS) {
            System.out.println("Sequence (hex) = " + theSequence.toHexString(", "));
            System.out.println("Transmission = " + theSegment.toString());
        }
        LengthSegmentDecoratorSegment theOtherSegment = SerialSugar.lengthSegment((Segment)SerialSugar.floatSegment((Endianess)theEndianess));
        theOtherSegment.fromTransmission(theSequence);
        if (IS_LOG_TESTS) {
            System.out.println("Other sequence (hex) = " + theOtherSegment.toSequence().toHexString(", "));
            System.out.println("Other segment = " + theOtherSegment.toString());
        }
        if (IS_LOG_TESTS) {
            System.out.print("theSegment.value = ");
            System.out.printf("%f%n", ((FloatSegment)theSegment.getDecoratee()).getPayload());
            System.out.print("theOtherSegment.value = ");
            System.out.printf("%f%n", ((FloatSegment)theOtherSegment.getDecoratee()).getPayload());
        }
        Assertions.assertEquals((Float)((Float)((FloatSegment)theSegment.getDecoratee()).getPayload()), (Float)((Float)((FloatSegment)theOtherSegment.getDecoratee()).getPayload()));
    }
}

