/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.serial.AllocSectionDecoratorSegment;
import org.refcodes.serial.DynamicTypeSection;
import org.refcodes.serial.DynamicTypeSegment;
import org.refcodes.serial.Section;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSugar;
import org.refcodes.serial.TestFixures;
import org.refcodes.serial.TransmissionException;

public class DynamicTypeTest
extends TestFixures {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");

    @Test
    public void testDynamicTypeSection1() throws TransmissionException {
        int[] theValues = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        if (IS_LOG_TESTS) {
            System.out.println(Arrays.toString(theValues));
        }
        AllocSectionDecoratorSegment theSegment = SerialSugar.allocSegment((Section)SerialSugar.dynamicTypeSection((Object)theValues));
        if (IS_LOG_TESTS) {
            System.out.println(theSegment.toSchema());
        }
        Sequence theSequence = theSegment.toSequence();
        DynamicTypeSection theOtherDynamicSection = SerialSugar.dynamicTypeSection();
        AllocSectionDecoratorSegment theOtherSegment = SerialSugar.allocSegment((Section)theOtherDynamicSection);
        theOtherSegment.fromTransmission(theSequence);
        if (IS_LOG_TESTS) {
            System.out.println(theOtherSegment.toSchema());
        }
        int[] theOtherValues = (int[])theOtherDynamicSection.toType(int[].class);
        if (IS_LOG_TESTS) {
            System.out.println(Arrays.toString(theOtherValues));
        }
        Assertions.assertArrayEquals((int[])theValues, (int[])theOtherValues);
    }

    @Test
    public void testDynamicTypeSection2() throws TransmissionException {
        TestFixures.Values theValues = new TestFixures.Values();
        theValues._booleans = new boolean[]{true, false, true, false, true, false, true, false, true, false};
        theValues._bytes = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        theValues._chars = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', '0'};
        theValues._shorts = new short[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        theValues._ints = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        theValues._longs = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 0L};
        theValues._floats = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 0.0f};
        theValues._doubles = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 0.0};
        theValues._strings = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "0"};
        if (IS_LOG_TESTS) {
            System.out.println(theValues);
        }
        DynamicTypeSegment theDynamicTypeSegment = SerialSugar.dynamicTypeSegment((Object)theValues);
        if (IS_LOG_TESTS) {
            System.out.println(theDynamicTypeSegment.toSchema());
        }
        Sequence theSequence = theDynamicTypeSegment.toSequence();
        DynamicTypeSegment theOtherDynamicSegment = SerialSugar.dynamicTypeSegment();
        theOtherDynamicSegment.fromTransmission(theSequence);
        if (IS_LOG_TESTS) {
            System.out.println(theOtherDynamicSegment.toSchema());
        }
        TestFixures.Values theOtherValues = (TestFixures.Values)theOtherDynamicSegment.toType(TestFixures.Values.class);
        if (IS_LOG_TESTS) {
            System.out.println(theOtherValues);
        }
        Assertions.assertEquals((Object)theValues, (Object)theOtherValues);
    }

    @Test
    public void testDynamicTypeSegment1() throws TransmissionException {
        int[] theValues = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        if (IS_LOG_TESTS) {
            System.out.println(Arrays.toString(theValues));
        }
        DynamicTypeSegment theDynamicTypeSegment = SerialSugar.dynamicTypeSegment((Object)theValues);
        if (IS_LOG_TESTS) {
            System.out.println(theDynamicTypeSegment.toSchema());
        }
        Sequence theSequence = theDynamicTypeSegment.toSequence();
        DynamicTypeSegment theOtherDynamicSegment = SerialSugar.dynamicTypeSegment();
        theOtherDynamicSegment.fromTransmission(theSequence);
        if (IS_LOG_TESTS) {
            System.out.println(theOtherDynamicSegment.toSchema());
        }
        int[] theOtherValues = (int[])theOtherDynamicSegment.toType(int[].class);
        if (IS_LOG_TESTS) {
            System.out.println(Arrays.toString(theOtherValues));
        }
        Assertions.assertArrayEquals((int[])theValues, (int[])theOtherValues);
    }

    @Test
    public void testDynamicTypeSegment2() throws TransmissionException {
        TestFixures.Values theValues = new TestFixures.Values();
        theValues._booleans = new boolean[]{true, false, true, false, true, false, true, false, true, false};
        theValues._bytes = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        theValues._chars = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', '0'};
        theValues._shorts = new short[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        theValues._ints = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        theValues._longs = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 0L};
        theValues._floats = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 0.0f};
        theValues._doubles = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 0.0};
        theValues._strings = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "0"};
        if (IS_LOG_TESTS) {
            System.out.println(theValues);
        }
        AllocSectionDecoratorSegment theSegment = SerialSugar.allocSegment((Section)SerialSugar.dynamicTypeSection((Object)theValues));
        if (IS_LOG_TESTS) {
            System.out.println(theSegment.toSchema());
        }
        Sequence theSequence = theSegment.toSequence();
        DynamicTypeSection theOtherDynamicSection = SerialSugar.dynamicTypeSection();
        AllocSectionDecoratorSegment theOtherSegment = SerialSugar.allocSegment((Section)theOtherDynamicSection);
        theOtherSegment.fromTransmission(theSequence);
        if (IS_LOG_TESTS) {
            System.out.println(theOtherSegment.toSchema());
        }
        TestFixures.Values theOtherValues = (TestFixures.Values)theOtherDynamicSection.toType(TestFixures.Values.class);
        if (IS_LOG_TESTS) {
            System.out.println(theOtherValues);
        }
        Assertions.assertEquals((Object)theValues, (Object)theOtherValues);
    }
}

