/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import org.refcodes.numerical.CrcAlgorithm;
import org.refcodes.numerical.CrcAlgorithmConfig;
import org.refcodes.numerical.Endianess;
import org.refcodes.numerical.NumericalUtility;
import org.refcodes.serial.BooleanSegment;
import org.refcodes.serial.ComplexTypeSegment;
import org.refcodes.serial.CrcSegmentDecorator;
import org.refcodes.serial.IntSegment;
import org.refcodes.serial.Section;
import org.refcodes.serial.Segment;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.SerialSugar;
import org.refcodes.serial.StringSection;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;

public class Example {
    public static void main(String[] args) throws TransmissionException {
        Example.example1();
    }

    public static void example1() throws TransmissionException {
        Segment[] segmentArray = new Segment[3];
        BooleanSegment theFlag = SerialSugar.booleanSegment((boolean)true);
        segmentArray[0] = theFlag;
        IntSegment theValue = SerialSugar.intSegment((Integer)5161, (Endianess)Endianess.LITTLE_ENDIAN);
        segmentArray[1] = theValue;
        StringSection theString = SerialSugar.stringSection((String)"Hello world!");
        segmentArray[2] = SerialSugar.allocSegment((Section)theString, (int)2, (Endianess)Endianess.LITTLE_ENDIAN);
        CrcSegmentDecorator theSegment = SerialSugar.crcPrefixSegment((Segment)SerialSugar.segmentComposite((Segment[])segmentArray), (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE);
        byte[] theBytes = theSegment.toSequence().toBytes();
        System.out.println(NumericalUtility.toHexString((String)" ", (byte[])theBytes));
        System.out.println(theFlag.getPayload());
        System.out.println(theValue.getPayload());
        System.out.println((String)theString.getPayload());
        theFlag.setPayload((Object)false);
        byte[] theOtherBytes = theSegment.toSequence().toBytes();
        System.out.println(NumericalUtility.toHexString((String)" ", (byte[])theOtherBytes));
        System.out.println(theFlag.getPayload());
        System.out.println(theValue.getPayload());
        System.out.println((String)theString.getPayload());
        theSegment.fromTransmission(theBytes);
        System.out.println(theFlag.getPayload());
        System.out.println(theValue.getPayload());
        System.out.println((String)theString.getPayload());
        SerialSchema theSchema = theSegment.toSchema();
        System.out.println(theSchema);
    }

    public static void example2() throws TransmissionException {
        TransmissionMetrics theMetrics = TransmissionMetrics.builder().withEndianess(Endianess.LITTLE_ENDIAN).withLengthWidth(2).withCrcAlgorithm((CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE).build();
        Segment[] segmentArray = new Segment[3];
        BooleanSegment theFlag = SerialSugar.booleanSegment((boolean)true);
        segmentArray[0] = theFlag;
        IntSegment theValue = SerialSugar.intSegment((Integer)5161, (TransmissionMetrics)theMetrics);
        segmentArray[1] = theValue;
        StringSection theString = SerialSugar.stringSection((String)"Hello world!");
        segmentArray[2] = SerialSugar.allocSegment((Section)theString, (TransmissionMetrics)theMetrics);
        CrcSegmentDecorator theSegment = SerialSugar.crcPrefixSegment((Segment)SerialSugar.segmentComposite((Segment[])segmentArray), (TransmissionMetrics)theMetrics);
        byte[] theBytes = theSegment.toSequence().toBytes();
        System.out.println(NumericalUtility.toHexString((String)" ", (byte[])theBytes));
        System.out.println(theFlag.getPayload());
        System.out.println(theValue.getPayload());
        System.out.println((String)theString.getPayload());
        theFlag.setPayload((Object)false);
        byte[] theOtherBytes = theSegment.toSequence().toBytes();
        System.out.println(NumericalUtility.toHexString((String)" ", (byte[])theOtherBytes));
        System.out.println(theFlag.getPayload());
        System.out.println(theValue.getPayload());
        System.out.println((String)theString.getPayload());
        theSegment.fromTransmission(theBytes);
        System.out.println(theFlag.getPayload());
        System.out.println(theValue.getPayload());
        System.out.println((String)theString.getPayload());
        System.out.println(theSegment.toSchema());
    }

    public static void example3() throws TransmissionException {
        TransmissionMetrics theMetrics = TransmissionMetrics.builder().withEndianess(Endianess.LITTLE_ENDIAN).withLengthWidth(2).withCrcAlgorithm((CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE).build();
        Sensor[] theSensors = new Sensor[]{new Sensor("SensorA", 103343), new Sensor("SensorB", 22109), new Sensor("SensorC", 313773)};
        ComplexTypeSegment theSegment = SerialSugar.complexTypeSegment((Object)theSensors, (TransmissionMetrics)theMetrics);
        byte[] theBytes = theSegment.toSequence().toBytes();
        System.out.println(NumericalUtility.toHexString((String)" ", (byte[])theBytes));
        ComplexTypeSegment theOtherSegment = SerialSugar.complexTypeSegment(Sensor[].class, (TransmissionMetrics)theMetrics);
        theOtherSegment.fromTransmission(theBytes);
        Sensor[] theOtherSensors = (Sensor[])theOtherSegment.getPayload();
        System.out.println(theOtherSensors[0].getName() + "=" + theOtherSensors[0].getPayload());
        System.out.println(theOtherSensors[1].getName() + "=" + theOtherSensors[1].getPayload());
        System.out.println(theOtherSensors[2].getName() + "=" + theOtherSensors[2].getPayload());
        System.out.println(theSegment.toSchema());
    }

    public static class Sensor {
        public int _value;
        public String _name;

        public Sensor() {
        }

        public Sensor(String aName, int aValue) {
            this._name = aName;
            this._value = aValue;
        }

        public String getName() {
            return this._name;
        }

        public int getPayload() {
            return this._value;
        }
    }
}

