/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Scanner;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.data.SystemProperty;
import org.refcodes.data.Text;
import org.refcodes.serial.AbstractLoopbackPortTest;
import org.refcodes.serial.AllocSectionDecoratorSegment;
import org.refcodes.serial.CrcSegmentDecorator;
import org.refcodes.serial.FileSection;
import org.refcodes.serial.Port;
import org.refcodes.serial.Section;
import org.refcodes.serial.Segment;
import org.refcodes.serial.SegmentResult;
import org.refcodes.serial.SerialSugar;
import org.refcodes.serial.StringSection;
import org.refcodes.serial.TransmissionMetrics;

public class FileTest
extends AbstractLoopbackPortTest {
    private static final String PASSWORDS_TXT = "passwords.txt";
    private static final String LF = SystemProperty.LINE_SEPARATOR.getValue();
    private static final String EOB = LF + "-----------------------" + LF;
    private static final String SHORT_TEXT = Text.ARECIBO_MESSAGE.getText() + EOB + Text.ARECIBO_MESSAGE.getText() + EOB + Text.ARECIBO_MESSAGE.getText() + EOB + Text.ARECIBO_MESSAGE.getText() + EOB + Text.ARECIBO_MESSAGE.getText() + EOB + Text.ARECIBO_MESSAGE.getText() + EOB + Text.ARECIBO_MESSAGE.getText() + EOB + Text.ARECIBO_MESSAGE.getText() + EOB + Text.ARECIBO_MESSAGE.getText() + EOB + Text.ARECIBO_MESSAGE.getText() + EOB + Text.ARECIBO_MESSAGE.getText() + EOB + Text.ARECIBO_MESSAGE.getText() + EOB + Text.ARECIBO_MESSAGE.getText() + EOB + Text.ARECIBO_MESSAGE.getText() + EOB + Text.ARECIBO_MESSAGE.getText() + EOB;
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");

    @Test
    public void testFileSection1() throws IOException, InterruptedException {
        if (this.hasPorts()) {
            Port theTransmitPort = (Port)this.getTransmitterPort().withOpen();
            Port theReceiverPort = (Port)this.getReceiverPort().withOpen();
            TransmissionMetrics theMetrics = new TransmissionMetrics();
            CrcSegmentDecorator theSendSegment = SerialSugar.crcSegment((Segment)SerialSugar.allocSegment((Section)SerialSugar.stringSection((String)SHORT_TEXT)), (TransmissionMetrics)theMetrics);
            File theTempFile = File.createTempFile(this.getClass().getName(), ".tmp");
            theTempFile.deleteOnExit();
            if (IS_LOG_TESTS) {
                System.out.println("Before: Temp file = " + theTempFile.getAbsolutePath());
                System.out.println("Before: Temp file size = " + theTempFile.length());
            }
            CrcSegmentDecorator theReceiveSegment = SerialSugar.crcSegment((Segment)SerialSugar.allocSegment((Section)new FileSection(theTempFile)), (TransmissionMetrics)theMetrics);
            SegmentResult theResult = theReceiverPort.onReceiveSegment((Segment)theReceiveSegment);
            long start = System.currentTimeMillis();
            theTransmitPort.transmitSegment((Segment)theSendSegment);
            long durationInSecs = (System.currentTimeMillis() - start) / 1000L;
            theResult.waitForResult();
            if (IS_LOG_TESTS) {
                System.out.println("Duration in Seconds = " + durationInSecs);
                System.out.println("Bytes/S = " + (Serializable)(durationInSecs != 0L ? Long.valueOf((long)theReceiveSegment.getLength() / durationInSecs) : "~"));
                System.out.println("After: Temp file = " + theTempFile.getAbsolutePath());
                System.out.println("After: Temp file size = " + theTempFile.length());
                System.out.println(theReceiveSegment.toSchema());
            }
            String[] theReferenceText = SHORT_TEXT.split(LF);
            int i = 0;
            try (Scanner theScanner = new Scanner(theTempFile, theMetrics.getEncoding().name());){
                theScanner.useDelimiter(LF);
                while (theScanner.hasNext()) {
                    String eFileLine = theScanner.next();
                    if (IS_LOG_TESTS) {
                        System.out.println("\"" + eFileLine + "\" [" + i + "]");
                    }
                    Assertions.assertEquals((Object)theReferenceText[i], (Object)eFileLine);
                    ++i;
                }
            }
            Assertions.assertEquals((int)theReferenceText.length, (int)i);
            theSendSegment = SerialSugar.crcSegment((Segment)SerialSugar.allocSegment((Section)new FileSection(theTempFile)), (TransmissionMetrics)theMetrics);
            StringSection theStringSection = SerialSugar.stringSection();
            theReceiveSegment = SerialSugar.crcSegment((Segment)SerialSugar.allocSegment((Section)theStringSection), (TransmissionMetrics)theMetrics);
            theResult = theReceiverPort.onReceiveSegment((Segment)theReceiveSegment);
            theTransmitPort.transmitSegment((Segment)theSendSegment);
            theResult.waitForResult();
            Assertions.assertEquals((Object)SHORT_TEXT, (Object)theStringSection.getPayload());
            theTransmitPort.close();
            theReceiverPort.close();
        }
    }

    @Test
    public void testFileSection2() throws IOException, InterruptedException {
        if (this.hasPorts()) {
            Port theTransmitPort = (Port)this.getTransmitterPort().withOpen();
            Port theReceiverPort = (Port)this.getReceiverPort().withOpen();
            File theTempFile = File.createTempFile(this.getClass().getName(), ".tmp");
            theTempFile.deleteOnExit();
            String theBasePath = theTempFile.getParent();
            TransmissionMetrics theMetrics = new TransmissionMetrics();
            CrcSegmentDecorator theSendSegment = SerialSugar.crcSegment((Segment)SerialSugar.segmentComposite((Segment[])new AllocSectionDecoratorSegment[]{SerialSugar.allocSegment((Section)SerialSugar.stringSection((String)PASSWORDS_TXT)), SerialSugar.allocSegment((Section)SerialSugar.stringSection((String)SHORT_TEXT))}), (TransmissionMetrics)theMetrics);
            AllocSectionDecoratorSegment[] allocSectionDecoratorSegmentArray = new AllocSectionDecoratorSegment[2];
            StringSection theFilenameSection = SerialSugar.stringSection();
            allocSectionDecoratorSegmentArray[0] = SerialSugar.allocSegment((Section)theFilenameSection);
            FileSection theFileSection = SerialSugar.fileSection((String)theBasePath, () -> (String)theFilenameSection.getPayload());
            allocSectionDecoratorSegmentArray[1] = SerialSugar.allocSegment((Section)theFileSection);
            CrcSegmentDecorator theReceiveSegment = SerialSugar.crcSegment((Segment)SerialSugar.segmentComposite((Segment[])allocSectionDecoratorSegmentArray), (TransmissionMetrics)theMetrics);
            SegmentResult theResult = theReceiverPort.onReceiveSegment((Segment)theReceiveSegment);
            theTransmitPort.transmitSegment((Segment)theSendSegment);
            theResult.waitForResult();
            File thePayloadFile = theFileSection.toPayloadFile();
            if (IS_LOG_TESTS) {
                System.out.println(thePayloadFile.getAbsolutePath());
            }
            thePayloadFile.deleteOnExit();
            Assertions.assertTrue((boolean)thePayloadFile.getAbsolutePath().endsWith(PASSWORDS_TXT));
            theSendSegment = SerialSugar.crcSegment((Segment)SerialSugar.segmentComposite((Segment[])new AllocSectionDecoratorSegment[]{SerialSugar.allocSegment((Section)SerialSugar.stringSection((String)PASSWORDS_TXT)), SerialSugar.allocSegment((Section)SerialSugar.fileSection((File)thePayloadFile))}), (TransmissionMetrics)theMetrics);
            AllocSectionDecoratorSegment[] allocSectionDecoratorSegmentArray2 = new AllocSectionDecoratorSegment[2];
            allocSectionDecoratorSegmentArray2[0] = SerialSugar.allocSegment((Section)SerialSugar.stringSection());
            StringSection theStringSection = SerialSugar.stringSection();
            allocSectionDecoratorSegmentArray2[1] = SerialSugar.allocSegment((Section)theStringSection);
            theReceiveSegment = SerialSugar.crcSegment((Segment)SerialSugar.segmentComposite((Segment[])allocSectionDecoratorSegmentArray2), (TransmissionMetrics)theMetrics);
            theResult = theReceiverPort.onReceiveSegment((Segment)theReceiveSegment);
            theTransmitPort.transmitSegment((Segment)theSendSegment);
            theResult.waitForResult();
            Assertions.assertEquals((Object)SHORT_TEXT, (Object)theStringSection.getPayload());
            theTransmitPort.close();
            theReceiverPort.close();
        }
    }
}

