/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.numerical.CrcAlgorithm;
import org.refcodes.numerical.CrcAlgorithmConfig;
import org.refcodes.numerical.Invertible;
import org.refcodes.serial.AbstractLoopbackPortTest;
import org.refcodes.serial.BadCrcChecksumException;
import org.refcodes.serial.ComplexTypeSegment;
import org.refcodes.serial.InvertibleSegmentDecorator;
import org.refcodes.serial.LengthSegmentDecoratorSegment;
import org.refcodes.serial.Port;
import org.refcodes.serial.ReadyToSendSegmentDecorator;
import org.refcodes.serial.Section;
import org.refcodes.serial.Segment;
import org.refcodes.serial.SegmentResult;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSugar;
import org.refcodes.serial.SerialTransceiver;
import org.refcodes.serial.TestFixures;
import org.refcodes.serial.TransmissionException;

public class InvertibleTest
extends AbstractLoopbackPortTest {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");
    private static final int LOOPS = 15;

    @Test
    public void testInvertibleSimple() throws TransmissionException {
        LengthSegmentDecoratorSegment theSegment = SerialSugar.lengthSegment((Segment)SerialSugar.allocSegment((Section)SerialSugar.invertibleSection((Section)SerialSugar.stringSection((String)"Hello World!"), (Invertible)new InvertibleXor(-2))));
        if (IS_LOG_TESTS) {
            System.out.println(theSegment.toSchema());
        }
        Sequence theSequence = theSegment.toSequence();
        LengthSegmentDecoratorSegment theOtherSegment = SerialSugar.lengthSegment((Segment)SerialSugar.allocSegment((Section)SerialSugar.invertibleSection((Section)SerialSugar.stringSection(), (Invertible)new InvertibleXor(-2))));
        theOtherSegment.fromTransmission(theSequence);
        if (IS_LOG_TESTS) {
            System.out.println(theOtherSegment.toSchema());
        }
        Assertions.assertEquals((Object)theSegment, (Object)theOtherSegment);
    }

    @Test
    public void testInvertibleSimpleFail() throws TransmissionException {
        LengthSegmentDecoratorSegment theSegment = SerialSugar.lengthSegment((Segment)SerialSugar.allocSegment((Section)SerialSugar.invertibleSection((Section)SerialSugar.stringSection((String)"Hello World!"), (Invertible)new InvertibleXor(-2))));
        if (IS_LOG_TESTS) {
            System.out.println(theSegment.toSchema());
        }
        Sequence theSequence = theSegment.toSequence();
        LengthSegmentDecoratorSegment theOtherSegment = SerialSugar.lengthSegment((Segment)SerialSugar.allocSegment((Section)SerialSugar.invertibleSection((Section)SerialSugar.stringSection(), (Invertible)new InvertibleXor(-1))));
        theOtherSegment.fromTransmission(theSequence);
        if (IS_LOG_TESTS) {
            System.out.println(theOtherSegment.toSchema());
        }
        Assertions.assertNotEquals((Object)theSegment, (Object)theOtherSegment);
    }

    @Test
    public void testInvertibleComplex() throws IOException {
        if (this.hasPorts()) {
            Port theTransmitPort = (Port)this.getTransmitterPort().withOpen();
            Port theReceiverPort = (Port)this.getReceiverPort().withOpen();
            TestFixures.WeatherData theSenderData = TestFixures.createWeatherData();
            InvertibleXor theInvertibleXor = new InvertibleXor(16);
            ReadyToSendSegmentDecorator theSenderSeg = SerialSugar.readyToSendSegment((Segment)SerialSugar.invertibleSegment((Segment)SerialSugar.crcPrefixSegment((Segment)SerialSugar.complexTypeSegment((Object)theSenderData), (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE), (Invertible)theInvertibleXor));
            ComplexTypeSegment theReceiverSegment = SerialSugar.complexTypeSegment(TestFixures.WeatherData.class);
            ReadyToSendSegmentDecorator theReceiverSeg = SerialSugar.readyToSendSegment((Segment)SerialSugar.invertibleSegment((Segment)SerialSugar.crcPrefixSegment((Segment)theReceiverSegment, (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE), (Invertible)theInvertibleXor));
            for (int i = 0; i < 15; ++i) {
                SegmentResult theResult = theReceiverPort.onReceiveSegment((Segment)theReceiverSeg);
                theSenderSeg.transmitTo((SerialTransceiver)theTransmitPort);
                theResult.waitForResult();
                if (IS_LOG_TESTS) {
                    try {
                        System.out.println("Expected [" + theInvertibleXor.bijectionXor + "]= " + theResult.getResult());
                    }
                    catch (BadCrcChecksumException e) {
                        System.out.println("Unexpected exceptio = " + e.getMessage());
                        Assertions.fail((String)("Not Expecting a <" + BadCrcChecksumException.class.getSimpleName() + "> instead of a resul!t"));
                    }
                }
                TestFixures.WeatherData theReceiverData = (TestFixures.WeatherData)theReceiverSegment.getPayload();
                if (IS_LOG_TESTS) {
                    System.out.println(theReceiverData);
                }
                Assertions.assertEquals((Object)theSenderData, (Object)theReceiverData);
                theInvertibleXor.inversionXor = theInvertibleXor.bijectionXor = (byte)(theInvertibleXor.bijectionXor + 1);
            }
            theTransmitPort.close();
            theReceiverPort.close();
        } else {
            System.out.println("Skipping test, please connect your null modem cable to two serial ports on your box, seeking for exactly two FT232 (ftdi_sio) type ports!");
        }
    }

    @Test
    public void testInvertibleComplexFail() throws IOException {
        if (this.hasPorts()) {
            Port theTransmitPort = (Port)this.getTransmitterPort().withOpen();
            Port theReceiverPort = (Port)this.getReceiverPort().withOpen();
            TestFixures.WeatherData theSenderData = TestFixures.createWeatherData();
            InvertibleSegmentDecorator theSenderSeg = SerialSugar.invertibleSegment((Segment)SerialSugar.crcPrefixSegment((Segment)SerialSugar.complexTypeSegment((Object)theSenderData), (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE), (Invertible)new InvertibleXor(16));
            ComplexTypeSegment theReceiverSegment = SerialSugar.complexTypeSegment(TestFixures.WeatherData.class);
            InvertibleSegmentDecorator theReceiverSeg = SerialSugar.invertibleSegment((Segment)SerialSugar.crcPrefixSegment((Segment)theReceiverSegment, (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE), (Invertible)new InvertibleXor(-61));
            SegmentResult theResult = theReceiverPort.onReceiveSegment((Segment)theReceiverSeg);
            theSenderSeg.transmitTo((SerialTransceiver)theTransmitPort);
            theResult.waitForResult();
            if (IS_LOG_TESTS) {
                try {
                    System.out.println("Result = " + theResult.getResult());
                    Assertions.fail((String)("Expecting a <" + BadCrcChecksumException.class.getSimpleName() + "> instead of a resul!t"));
                }
                catch (BadCrcChecksumException expected) {
                    System.out.println("Expected = " + expected.getMessage());
                }
            }
            TestFixures.WeatherData theReceiverData = (TestFixures.WeatherData)theReceiverSegment.getPayload();
            if (IS_LOG_TESTS) {
                System.out.println(theReceiverData);
            }
            Assertions.assertNotEquals((Object)theSenderData, (Object)theReceiverData);
            theTransmitPort.close();
            theReceiverPort.close();
        } else {
            System.out.println("Skipping test, please connect your null modem cable to two serial ports on your box, seeking for exactly two FT232 (ftdi_sio) type ports!");
        }
    }

    class InvertibleXor
    implements Invertible<Byte, Byte> {
        private byte bijectionXor;
        private byte inversionXor;

        public InvertibleXor(byte aXor) {
            this.bijectionXor = aXor;
            this.inversionXor = aXor;
        }

        public InvertibleXor(byte aBijectionXor, byte aInversionXor) {
            this.bijectionXor = aBijectionXor;
            this.inversionXor = aInversionXor;
        }

        public Byte applyBijection(Byte aValue) {
            return (byte)(aValue ^ this.bijectionXor);
        }

        public Byte applyInversion(Byte aValue) {
            return (byte)(aValue ^ this.inversionXor);
        }
    }
}

