/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.numerical.CrcAlgorithm;
import org.refcodes.numerical.CrcAlgorithmConfig;
import org.refcodes.numerical.Endianess;
import org.refcodes.properties.Properties;
import org.refcodes.properties.PropertiesBuilderImpl;
import org.refcodes.serial.AllocSegmentHead;
import org.refcodes.serial.CrcSegmentDecorator;
import org.refcodes.serial.CrossoverLoopbackPort;
import org.refcodes.serial.CrossoverLoopbackPortHub;
import org.refcodes.serial.FloatSegment;
import org.refcodes.serial.LengthSegmentDecoratorSegment;
import org.refcodes.serial.LoopbackPort;
import org.refcodes.serial.LoopbackPortHub;
import org.refcodes.serial.NoSuchPortExcpetion;
import org.refcodes.serial.PropertiesSection;
import org.refcodes.serial.Section;
import org.refcodes.serial.Segment;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSugar;
import org.refcodes.serial.TransmissionException;

public class LoopbackPortTest {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");

    @Test
    public void testSegmentComposition() throws TransmissionException, IOException {
        LoopbackPort thePort = new LoopbackPort("/dev/ttyLoopback" + UUID.randomUUID().toString()).withOpen();
        PropertiesBuilderImpl theBuilder = new PropertiesBuilderImpl();
        theBuilder.put((Object)"/sensor/0/name", (Object)"temp01");
        theBuilder.putFloat("/sensor/0/value", Float.valueOf(12.37f));
        theBuilder.put((Object)"/sensor/1/name", (Object)"temp01");
        theBuilder.putFloat("/sensor/1/value", Float.valueOf(8.71f));
        for (int eLengthWidth = 2; eLengthWidth <= 8; ++eLengthWidth) {
            for (Endianess eEndianess : Endianess.values()) {
                if (IS_LOG_TESTS) {
                    System.out.println("---------- Length width = <" + eLengthWidth + ">, endianess = <" + eEndianess + "> ----------");
                }
                Segment[] segmentArray = new Segment[4];
                AllocSegmentHead theLen = SerialSugar.allocSegmentHead((int)eLengthWidth, (Endianess)eEndianess);
                segmentArray[0] = theLen;
                segmentArray[1] = SerialSugar.booleanSegment((boolean)true);
                segmentArray[2] = SerialSugar.intSegment((Integer)5161);
                segmentArray[3] = (Segment)theLen.letBody((Object)SerialSugar.allocSegmentBody((Section)new PropertiesSection((Properties)theBuilder)));
                CrcSegmentDecorator theSegment = SerialSugar.crcPrefixSegment((Segment)SerialSugar.segmentComposite((Segment[])segmentArray), (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE);
                thePort.transmitSegment((Segment)theSegment);
                Sequence theSequence = theSegment.toSequence();
                if (IS_LOG_TESTS) {
                    System.out.println("Sequence (hex) = " + theSequence.toHexString());
                    System.out.println("Transmission = " + theSegment.toString());
                    System.out.println("AbstractSchema = " + theSegment.toSchema());
                }
                Segment[] segmentArray2 = new Segment[4];
                AllocSegmentHead theOtherLen = SerialSugar.allocSegmentHead((int)eLengthWidth, (Endianess)eEndianess);
                segmentArray2[0] = theOtherLen;
                segmentArray2[1] = SerialSugar.booleanSegment();
                segmentArray2[2] = SerialSugar.intSegment();
                segmentArray2[3] = (Segment)theOtherLen.letBody((Object)SerialSugar.allocSegmentBody((Section)new PropertiesSection()));
                CrcSegmentDecorator theOtherSegment = SerialSugar.crcPrefixSegment((Segment)SerialSugar.segmentComposite((Segment[])segmentArray2), (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE);
                thePort.receiveSegment((Segment)theOtherSegment);
                Assertions.assertEquals((Object)theOtherSegment, (Object)theOtherSegment);
                if (!IS_LOG_TESTS) continue;
                System.out.println("Other segment = " + theOtherSegment.toString());
                System.out.println("Other schema = " + theOtherSegment.toSchema());
            }
        }
    }

    @Test
    public void testFloatSegment() throws TransmissionException, IOException {
        LoopbackPort thePort = new LoopbackPort("/dev/ttyLoopback" + UUID.randomUUID().toString()).withOpen();
        for (Endianess eEndianess : Endianess.values()) {
            for (int i = Short.MIN_VALUE; i <= Short.MAX_VALUE; ++i) {
                float l;
                float f = i == Short.MIN_VALUE ? Float.MIN_VALUE : (l = i == Short.MAX_VALUE ? Float.MAX_VALUE : (float)i * (float)Math.PI);
                if (IS_LOG_TESTS) {
                    System.out.println("---------- Endianess = <" + eEndianess + ">, l = <" + l + "> ----------");
                }
                LengthSegmentDecoratorSegment theSegment = SerialSugar.lengthSegment((Segment)SerialSugar.floatSegment((Float)Float.valueOf(l), (Endianess)eEndianess));
                thePort.transmitSegment((Segment)theSegment);
                Sequence theSequence = theSegment.toSequence();
                if (IS_LOG_TESTS) {
                    System.out.println("Sequence (hex) = " + theSequence.toHexString(", "));
                    System.out.println("Transmission = " + theSegment.toString());
                }
                LengthSegmentDecoratorSegment theOtherSegment = SerialSugar.lengthSegment((Segment)SerialSugar.floatSegment((Endianess)eEndianess));
                thePort.receiveSegment((Segment)theOtherSegment);
                if (IS_LOG_TESTS) {
                    System.out.println("Other segment = " + theOtherSegment.toString());
                }
                Assertions.assertEquals((Float)((Float)((FloatSegment)theSegment.getDecoratee()).getPayload()), (Float)((Float)((FloatSegment)theOtherSegment.getDecoratee()).getPayload()));
            }
        }
    }

    @Test
    public void testCrossoverLoopbackPort1() throws TransmissionException, IOException {
        LoopbackPort theTransmitter = new LoopbackPort("/dev/ttyLoopback" + UUID.randomUUID().toString()).withOpen();
        LoopbackPort theReceiver = new CrossoverLoopbackPort(theTransmitter).withOpen();
        PropertiesBuilderImpl theBuilder = new PropertiesBuilderImpl();
        theBuilder.put((Object)"/sensor/0/name", (Object)"temp01");
        theBuilder.putFloat("/sensor/0/value", Float.valueOf(12.37f));
        theBuilder.put((Object)"/sensor/1/name", (Object)"temp01");
        theBuilder.putFloat("/sensor/1/value", Float.valueOf(8.71f));
        for (int eLengthWidth = 2; eLengthWidth <= 8; ++eLengthWidth) {
            for (Endianess eEndianess : Endianess.values()) {
                if (IS_LOG_TESTS) {
                    System.out.println("---------- Length width = <" + eLengthWidth + ">, endianess = <" + eEndianess + "> ----------");
                }
                Segment[] segmentArray = new Segment[4];
                AllocSegmentHead theLen = SerialSugar.allocSegmentHead((int)eLengthWidth, (Endianess)eEndianess);
                segmentArray[0] = theLen;
                segmentArray[1] = SerialSugar.booleanSegment((boolean)true);
                segmentArray[2] = SerialSugar.intSegment((Integer)5161);
                segmentArray[3] = (Segment)theLen.letBody((Object)SerialSugar.allocSegmentBody((Section)new PropertiesSection((Properties)theBuilder)));
                CrcSegmentDecorator theSegment = SerialSugar.crcPrefixSegment((Segment)SerialSugar.segmentComposite((Segment[])segmentArray), (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE);
                theTransmitter.transmitSegment((Segment)theSegment);
                Sequence theSequence = theSegment.toSequence();
                if (IS_LOG_TESTS) {
                    System.out.println("Sequence (hex) = " + theSequence.toHexString());
                    System.out.println("Transmission = " + theSegment.toString());
                    System.out.println("AbstractSchema = " + theSegment.toSchema());
                }
                Segment[] segmentArray2 = new Segment[4];
                AllocSegmentHead theOtherLen = SerialSugar.allocSegmentHead((int)eLengthWidth, (Endianess)eEndianess);
                segmentArray2[0] = theOtherLen;
                segmentArray2[1] = SerialSugar.booleanSegment();
                segmentArray2[2] = SerialSugar.intSegment();
                segmentArray2[3] = (Segment)theOtherLen.letBody((Object)SerialSugar.allocSegmentBody((Section)new PropertiesSection()));
                CrcSegmentDecorator theOtherSegment = SerialSugar.crcPrefixSegment((Segment)SerialSugar.segmentComposite((Segment[])segmentArray2), (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE);
                theReceiver.receiveSegment((Segment)theOtherSegment);
                Assertions.assertEquals((Object)theOtherSegment, (Object)theOtherSegment);
                if (!IS_LOG_TESTS) continue;
                System.out.println("Other segment = " + theOtherSegment.toString());
                System.out.println("Other schema = " + theOtherSegment.toSchema());
            }
        }
    }

    @Test
    public void testCrossoverLoopbackPort2() throws TransmissionException, IOException, NoSuchPortExcpetion {
        LoopbackPortHub theTransmitterHub = new LoopbackPortHub();
        CrossoverLoopbackPortHub theReceiverHub = new CrossoverLoopbackPortHub(theTransmitterHub);
        String thePortName = "/dev/ttyLoopback" + UUID.randomUUID().toString();
        LoopbackPort theTransmitter = theTransmitterHub.toPort(thePortName).withOpen();
        LoopbackPort theReceiver = theReceiverHub.toPort(thePortName).withOpen();
        for (Endianess eEndianess : Endianess.values()) {
            for (int i = Short.MIN_VALUE; i <= Short.MAX_VALUE; ++i) {
                float l;
                float f = i == Short.MIN_VALUE ? Float.MIN_VALUE : (l = i == Short.MAX_VALUE ? Float.MAX_VALUE : (float)i * (float)Math.PI);
                if (IS_LOG_TESTS) {
                    System.out.println("---------- Endianess = <" + eEndianess + ">, l = <" + l + "> ----------");
                }
                LengthSegmentDecoratorSegment theSegment = SerialSugar.lengthSegment((Segment)SerialSugar.floatSegment((Float)Float.valueOf(l), (Endianess)eEndianess));
                theTransmitter.transmitSegment((Segment)theSegment);
                Sequence theSequence = theSegment.toSequence();
                if (IS_LOG_TESTS) {
                    System.out.println("Sequence (hex) = " + theSequence.toHexString(", "));
                    System.out.println("Transmission = " + theSegment.toString());
                }
                LengthSegmentDecoratorSegment theOtherSegment = SerialSugar.lengthSegment((Segment)SerialSugar.floatSegment((Endianess)eEndianess));
                theReceiver.receiveSegment((Segment)theOtherSegment);
                if (IS_LOG_TESTS) {
                    System.out.println("Other segment = " + theOtherSegment.toString());
                }
                Assertions.assertEquals((Float)((Float)((FloatSegment)theSegment.getDecoratee()).getPayload()), (Float)((Float)((FloatSegment)theOtherSegment.getDecoratee()).getPayload()));
            }
        }
    }

    @Test
    public void testEdgeCase() throws TransmissionException, IOException {
        LoopbackPort thePort = new LoopbackPort("/dev/ttyLoopback" + UUID.randomUUID().toString()).withOpen();
        Endianess eEndianess = Endianess.LITTLE_ENDIAN;
        float l = -102239.99f;
        if (IS_LOG_TESTS) {
            System.out.println("---------- Endianess = <" + eEndianess + ">, l = <" + l + "> ----------");
        }
        LengthSegmentDecoratorSegment theSegment = SerialSugar.lengthSegment((Segment)SerialSugar.floatSegment((Float)Float.valueOf(l), (Endianess)eEndianess));
        thePort.transmitSegment((Segment)theSegment);
        Sequence theSequence = theSegment.toSequence();
        if (IS_LOG_TESTS) {
            System.out.println("Sequence (hex) = " + theSequence.toHexString(", "));
            System.out.println("Transmission = " + theSegment.toString());
        }
        LengthSegmentDecoratorSegment theOtherSegment = SerialSugar.lengthSegment((Segment)SerialSugar.floatSegment((Endianess)eEndianess));
        thePort.receiveSegment((Segment)theOtherSegment);
        if (IS_LOG_TESTS) {
            System.out.println("Other sequence (hex) = " + theOtherSegment.toSequence().toHexString());
            System.out.println("Other segment = " + theOtherSegment.toString());
        }
        Assertions.assertEquals((Float)((Float)((FloatSegment)theSegment.getDecoratee()).getPayload()), (Float)((Float)((FloatSegment)theOtherSegment.getDecoratee()).getPayload()));
    }
}

