/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.exception.TimeoutIOException;
import org.refcodes.numerical.CrcAlgorithm;
import org.refcodes.numerical.CrcAlgorithmConfig;
import org.refcodes.serial.AbstractLoopbackPortTest;
import org.refcodes.serial.AllocSectionDecoratorSegment;
import org.refcodes.serial.AssertMagicBytesSectionDecorator;
import org.refcodes.serial.AssertMagicBytesSegment;
import org.refcodes.serial.AssertMagicBytesSegmentDecorator;
import org.refcodes.serial.BadCrcChecksumSequenceException;
import org.refcodes.serial.BadMagicBytesException;
import org.refcodes.serial.CrcSegmentDecorator;
import org.refcodes.serial.LengthSegmentDecoratorSegment;
import org.refcodes.serial.MagicBytesSectionDecorator;
import org.refcodes.serial.MagicBytesSectionMultiplexer;
import org.refcodes.serial.MagicBytesSegment;
import org.refcodes.serial.MagicBytesSegmentDecorator;
import org.refcodes.serial.MagicBytesSegmentMultiplexer;
import org.refcodes.serial.NoSuchPortExcpetion;
import org.refcodes.serial.Port;
import org.refcodes.serial.Section;
import org.refcodes.serial.Segment;
import org.refcodes.serial.SegmentComposite;
import org.refcodes.serial.SegmentResult;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSugar;
import org.refcodes.serial.SerialTransceiver;
import org.refcodes.serial.StringArraySection;
import org.refcodes.serial.StringSection;
import org.refcodes.serial.StringSegment;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionSequenceException;
import org.refcodes.struct.SimpleTypeMap;
import org.refcodes.textual.VerboseTextBuilder;

public class MagicBytesTest
extends AbstractLoopbackPortTest {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");
    private static final int WAIT_TIMEOUT = 5000;
    private static final int LOOPS = 15;

    @Test
    public void testMagicBytesSegmentDispatcher1() throws TransmissionException {
        StringSegment theString1 = SerialSugar.stringSegment();
        AssertMagicBytesSegmentDecorator theMagicBytes1 = SerialSugar.assertMagicBytesSegment((Segment)theString1, (byte[])"A00".getBytes());
        StringSegment theString2 = SerialSugar.stringSegment();
        AssertMagicBytesSegmentDecorator theMagicBytes2 = SerialSugar.assertMagicBytesSegment((Segment)theString2, (byte[])"A01".getBytes());
        StringSegment theString3 = SerialSugar.stringSegment();
        AssertMagicBytesSegmentDecorator theMagicBytes3 = SerialSugar.assertMagicBytesSegment((Segment)theString3, (byte[])"B02".getBytes());
        MagicBytesSegmentMultiplexer theMultiplexer = new MagicBytesSegmentMultiplexer(new Segment[]{theMagicBytes1, theMagicBytes2, theMagicBytes3});
        MagicBytesSegmentDecorator theTransmission = SerialSugar.magicBytesSegment((Segment)SerialSugar.stringSegment((String)"A01!"), (byte[])"A01".getBytes());
        theMultiplexer.fromTransmission(theTransmission.toSequence());
        if (IS_LOG_TESTS) {
            System.out.println(new String(theMagicBytes1.getPayload()) + ": " + theString1.getPayload());
            System.out.println(new String(theMagicBytes2.getPayload()) + ": " + theString2.getPayload());
            System.out.println(new String(theMagicBytes3.getPayload()) + ": " + theString3.getPayload());
        }
        Assertions.assertNull((Object)theString1.getPayload());
        Assertions.assertEquals((Object)"A01!", (Object)theString2.getPayload());
        Assertions.assertNull((Object)theString3.getPayload());
    }

    @Test
    public void testMagicBytesSegmentDispatcher2() throws TransmissionException {
        StringSegment theString1 = SerialSugar.stringSegment();
        AssertMagicBytesSegmentDecorator theMagicBytes1 = SerialSugar.assertMagicBytesSegment((Segment)theString1, (byte[])"A00".getBytes());
        StringSegment theString2 = SerialSugar.stringSegment();
        AssertMagicBytesSegmentDecorator theMagicBytes2 = SerialSugar.assertMagicBytesSegment((Segment)theString2, (byte[])"A01".getBytes());
        StringSegment theString3 = SerialSugar.stringSegment();
        AssertMagicBytesSegmentDecorator theMagicBytes3 = SerialSugar.assertMagicBytesSegment((Segment)theString3, (byte[])"B02".getBytes());
        MagicBytesSegmentMultiplexer theMultiplexer = new MagicBytesSegmentMultiplexer(new Segment[]{theMagicBytes1, theMagicBytes2, theMagicBytes3});
        MagicBytesSegmentDecorator theTransmission = SerialSugar.magicBytesSegment((Segment)SerialSugar.stringSegment((String)"A00!"), (byte[])"A00".getBytes());
        theMultiplexer.fromTransmission(theTransmission.toSequence());
        theTransmission = SerialSugar.magicBytesSegment((Segment)SerialSugar.stringSegment((String)"A01!"), (byte[])"A01".getBytes());
        theMultiplexer.fromTransmission(theTransmission.toSequence());
        theTransmission = SerialSugar.magicBytesSegment((Segment)SerialSugar.stringSegment((String)"B02!"), (byte[])"B02".getBytes());
        theMultiplexer.fromTransmission(theTransmission.toSequence());
        if (IS_LOG_TESTS) {
            System.out.println(new String(theMagicBytes1.getPayload()) + ": " + theString1.getPayload());
            System.out.println(new String(theMagicBytes2.getPayload()) + ": " + theString2.getPayload());
            System.out.println(new String(theMagicBytes3.getPayload()) + ": " + theString3.getPayload());
        }
        Assertions.assertEquals((Object)"A00!", (Object)theString1.getPayload());
        Assertions.assertEquals((Object)"A01!", (Object)theString2.getPayload());
        Assertions.assertEquals((Object)"B02!", (Object)theString3.getPayload());
    }

    @Test
    public void testMagicBytesSegmentDispatcher3() throws IOException {
        if (this.hasPorts()) {
            Port theTransmitPort = (Port)this.getTransmitterPort().withOpen();
            Port theReceiverPort = (Port)this.getReceiverPort().withOpen();
            StringSegment theString1 = SerialSugar.stringSegment();
            AssertMagicBytesSegmentDecorator theMagicBytes1 = SerialSugar.assertMagicBytesSegment((Segment)theString1, (byte[])"A00".getBytes());
            StringSegment theString2 = SerialSugar.stringSegment();
            AssertMagicBytesSegmentDecorator theMagicBytes2 = SerialSugar.assertMagicBytesSegment((Segment)theString2, (byte[])"A01".getBytes());
            StringSegment theString3 = SerialSugar.stringSegment();
            AssertMagicBytesSegmentDecorator theMagicBytes3 = SerialSugar.assertMagicBytesSegment((Segment)theString3, (byte[])"B02".getBytes());
            MagicBytesSegmentMultiplexer theMultiplexer = new MagicBytesSegmentMultiplexer(new Segment[]{theMagicBytes1, theMagicBytes2, theMagicBytes3});
            MagicBytesSegmentDecorator theTransmission = SerialSugar.magicBytesSegment((Segment)SerialSugar.stringSegment((String)"A01!"), (byte[])"A01".getBytes());
            theTransmitPort.transmitSegment((Segment)theTransmission);
            SegmentResult theResult = theReceiverPort.onReceiveSegment((Segment)theMultiplexer);
            theResult.waitForResult();
            if (IS_LOG_TESTS) {
                System.out.println(new String(theMagicBytes1.getPayload()) + ": " + theString1.getPayload());
                System.out.println(new String(theMagicBytes2.getPayload()) + ": " + theString2.getPayload());
                System.out.println(new String(theMagicBytes3.getPayload()) + ": " + theString3.getPayload());
            }
            Assertions.assertNull((Object)theString1.getPayload());
            Assertions.assertEquals((Object)"A01!", (Object)theString2.getPayload());
            Assertions.assertNull((Object)theString3.getPayload());
        } else {
            System.out.println("Skipping test, please connect your null modem cable to two serial ports on your box, seeking for exactly two FT232 (ftdi_sio) type ports!");
        }
    }

    @Test
    public void testMagicBytesSectionDispatcher1() throws TransmissionException {
        StringSection theString1 = SerialSugar.stringSection();
        AssertMagicBytesSectionDecorator theMagicBytes1 = SerialSugar.assertMagicBytesSection((Section)theString1, (byte[])"A00".getBytes());
        StringSection theString2 = SerialSugar.stringSection();
        AssertMagicBytesSectionDecorator theMagicBytes2 = SerialSugar.assertMagicBytesSection((Section)theString2, (byte[])"A01".getBytes());
        StringSection theString3 = SerialSugar.stringSection();
        AssertMagicBytesSectionDecorator theMagicBytes3 = SerialSugar.assertMagicBytesSection((Section)theString3, (byte[])"B02".getBytes());
        MagicBytesSectionMultiplexer theMultiplexer = new MagicBytesSectionMultiplexer(new Section[]{theMagicBytes1, theMagicBytes2, theMagicBytes3});
        MagicBytesSectionDecorator theTransmission = SerialSugar.magicBytesSection((Section)SerialSugar.stringSection((String)"A01!"), (byte[])"A01".getBytes());
        theMultiplexer.fromTransmission(theTransmission.toSequence(), theTransmission.getLength());
        if (IS_LOG_TESTS) {
            System.out.println(new String(theMagicBytes1.getPayload()) + ": " + (String)theString1.getPayload());
            System.out.println(new String(theMagicBytes2.getPayload()) + ": " + (String)theString2.getPayload());
            System.out.println(new String(theMagicBytes3.getPayload()) + ": " + (String)theString3.getPayload());
        }
        Assertions.assertNull((Object)theString1.getPayload());
        Assertions.assertEquals((Object)"A01!", (Object)theString2.getPayload());
        Assertions.assertNull((Object)theString3.getPayload());
    }

    @Test
    public void testMagicBytesSectionDispatcher2() throws TransmissionException {
        StringSection theString1 = SerialSugar.stringSection();
        AssertMagicBytesSectionDecorator theMagicBytes1 = SerialSugar.assertMagicBytesSection((Section)theString1, (byte[])"A00".getBytes());
        StringSection theString2 = SerialSugar.stringSection();
        AssertMagicBytesSectionDecorator theMagicBytes2 = SerialSugar.assertMagicBytesSection((Section)theString2, (byte[])"A01".getBytes());
        StringSection theString3 = SerialSugar.stringSection();
        AssertMagicBytesSectionDecorator theMagicBytes3 = SerialSugar.assertMagicBytesSection((Section)theString3, (byte[])"B02".getBytes());
        MagicBytesSectionMultiplexer theMultiplexer = new MagicBytesSectionMultiplexer(new Section[]{theMagicBytes1, theMagicBytes2, theMagicBytes3});
        MagicBytesSectionDecorator theTransmission = SerialSugar.magicBytesSection((Section)SerialSugar.stringSection((String)"A00!"), (byte[])"A00".getBytes());
        theMultiplexer.fromTransmission(theTransmission.toSequence(), theTransmission.getLength());
        theTransmission = SerialSugar.magicBytesSection((Section)SerialSugar.stringSection((String)"A01!"), (byte[])"A01".getBytes());
        theMultiplexer.fromTransmission(theTransmission.toSequence(), theTransmission.getLength());
        theTransmission = SerialSugar.magicBytesSection((Section)SerialSugar.stringSection((String)"B02!"), (byte[])"B02".getBytes());
        theMultiplexer.fromTransmission(theTransmission.toSequence(), theTransmission.getLength());
        if (IS_LOG_TESTS) {
            System.out.println(new String(theMagicBytes1.getPayload()) + ": " + (String)theString1.getPayload());
            System.out.println(new String(theMagicBytes2.getPayload()) + ": " + (String)theString2.getPayload());
            System.out.println(new String(theMagicBytes3.getPayload()) + ": " + (String)theString3.getPayload());
        }
        Assertions.assertEquals((Object)"A00!", (Object)theString1.getPayload());
        Assertions.assertEquals((Object)"A01!", (Object)theString2.getPayload());
        Assertions.assertEquals((Object)"B02!", (Object)theString3.getPayload());
    }

    @Test
    public void testMagicBytesPlain() throws TransmissionException {
        MagicBytesSegment theSegment = SerialSugar.magicBytesSegment((String)"FEED C0DE", (Charset)StandardCharsets.US_ASCII);
        if (IS_LOG_TESTS) {
            System.out.println(theSegment.toSchema());
        }
        Sequence theSequence = theSegment.toSequence();
        MagicBytesSegment theOtherSegment = SerialSugar.magicBytesSegment((int)9);
        theOtherSegment.fromTransmission(theSequence);
        if (IS_LOG_TESTS) {
            System.out.println(theOtherSegment.toSchema());
        }
        Assertions.assertEquals((Object)theSegment, (Object)theOtherSegment);
    }

    @Test
    public void testAssertMagicBytesPlainPass() throws TransmissionException {
        AssertMagicBytesSegment theSegment = SerialSugar.assertMagicBytesSegment((String)"FEED C0DE", (Charset)StandardCharsets.US_ASCII);
        if (IS_LOG_TESTS) {
            System.out.println(theSegment.toSchema());
        }
        Sequence theSequence = theSegment.toSequence();
        AssertMagicBytesSegment theOtherSegment = SerialSugar.assertMagicBytesSegment((String)"FEED C0DE", (Charset)StandardCharsets.US_ASCII);
        theOtherSegment.fromTransmission(theSequence);
        if (IS_LOG_TESTS) {
            System.out.println(theOtherSegment.toSchema());
        }
        Assertions.assertEquals((Object)theSegment, (Object)theOtherSegment);
    }

    @Test
    public void testAssertMagicBytesPlainFail() throws TransmissionException {
        block3: {
            AssertMagicBytesSegment theSegment = SerialSugar.assertMagicBytesSegment((String)"FEED C0DE", (Charset)StandardCharsets.US_ASCII);
            if (IS_LOG_TESTS) {
                System.out.println(theSegment.toSchema());
            }
            Sequence theSequence = theSegment.toSequence();
            AssertMagicBytesSegment theOtherSegment = SerialSugar.assertMagicBytesSegment((String)"BAD", (Charset)StandardCharsets.US_ASCII);
            try {
                theOtherSegment.fromTransmission(theSequence);
                Assertions.fail((String)"Expected a <BadMagicBytesException> here!");
            }
            catch (BadMagicBytesException e) {
                if (!IS_LOG_TESTS) break block3;
                System.out.println("Expected: " + e.getMessage());
            }
        }
    }

    @Test
    public void testMagicBytesComposite() throws TransmissionException {
        SegmentComposite theSegment = SerialSugar.segmentComposite((Segment[])new MagicBytesSegment[]{SerialSugar.magicBytesSegment((String)"FEED C0DE", (Charset)StandardCharsets.US_ASCII), SerialSugar.magicBytesSegment((byte[])new byte[]{-64, -34, -2, -19})});
        if (IS_LOG_TESTS) {
            System.out.println(theSegment.toSchema());
        }
        Sequence theSequence = theSegment.toSequence();
        SegmentComposite theOtherSegment = SerialSugar.segmentComposite((Segment[])new MagicBytesSegment[]{SerialSugar.magicBytesSegment((int)9), SerialSugar.magicBytesSegment((int)4)});
        theOtherSegment.fromTransmission(theSequence);
        if (IS_LOG_TESTS) {
            System.out.println(theOtherSegment.toSchema());
        }
        Assertions.assertEquals((Object)theSegment, (Object)theOtherSegment);
    }

    @Test
    public void testMagicBytesSimple() throws TransmissionException {
        LengthSegmentDecoratorSegment theSegment = SerialSugar.lengthSegment((Segment)SerialSugar.magicBytesSegment((Segment)SerialSugar.allocSegment((Section)SerialSugar.stringSection((String)"Hello World!")), (byte[])new byte[]{-64, -34, -2, -19}));
        if (IS_LOG_TESTS) {
            System.out.println(theSegment.toSchema());
        }
        Sequence theSequence = theSegment.toSequence();
        LengthSegmentDecoratorSegment theOtherSegment = SerialSugar.lengthSegment((Segment)SerialSugar.magicBytesSegment((Segment)SerialSugar.allocSegment((Section)SerialSugar.stringSection()), (int)4));
        theOtherSegment.fromTransmission(theSequence);
        if (IS_LOG_TESTS) {
            System.out.println(theOtherSegment.toSchema());
        }
        Assertions.assertEquals((Object)theSegment, (Object)theOtherSegment);
    }

    @Test
    public void testMagicBytesComplex() throws TransmissionException {
        CrcSegmentDecorator theSegment = SerialSugar.crcPrefixSegment((Segment)SerialSugar.lengthSegment((Segment)SerialSugar.magicBytesSegment((Segment)SerialSugar.allocSegment((Section)SerialSugar.stringSection((String)"Hello World!")), (byte[])new byte[]{-64, -34, -2, -19})), (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_X25);
        if (IS_LOG_TESTS) {
            System.out.println(theSegment.toSchema());
        }
        Sequence theSequence = theSegment.toSequence();
        CrcSegmentDecorator theOtherSegment = SerialSugar.crcPrefixSegment((Segment)SerialSugar.lengthSegment((Segment)SerialSugar.magicBytesSegment((Segment)SerialSugar.allocSegment((Section)SerialSugar.stringSection()), (int)4)), (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_X25);
        theOtherSegment.fromTransmission(theSequence);
        if (IS_LOG_TESTS) {
            System.out.println(theOtherSegment.toSchema());
        }
        Assertions.assertEquals((Object)theSegment, (Object)theOtherSegment);
        theSequence.setByteAt(0, (byte)65);
        try {
            theOtherSegment.fromTransmission(theSequence);
            Assertions.fail((String)"Expected an exception of type <BadCrcChecksumSequenceException>!");
        }
        catch (BadCrcChecksumSequenceException badCrcChecksumSequenceException) {
            // empty catch block
        }
        if (IS_LOG_TESTS) {
            SimpleTypeMap theSimpleTypeMap = theSegment.toSimpleTypeMap();
            for (String eKey : theSimpleTypeMap.sortedKeys()) {
                System.out.println(eKey + " = " + theSimpleTypeMap.get((Object)eKey));
            }
        }
    }

    @Test
    public void testAssertMagicBytesPass() throws TransmissionSequenceException, IOException, NoSuchPortExcpetion, InterruptedException {
        if (this.hasPorts()) {
            Port theTransmitPort = (Port)this.getTransmitterPort().withOpen();
            Port theReceiverPort = (Port)this.getReceiverPort().withOpen();
            Object[] thePayload = new String[]{"Hello", "World", "!!!"};
            SegmentComposite theSenderSeg = SerialSugar.segmentComposite((Segment[])new Segment[]{SerialSugar.assertMagicBytesSegment((String)"MZ"), SerialSugar.allocSegment((Section)SerialSugar.stringArraySection((String[])thePayload))});
            Segment[] segmentArray = new Segment[2];
            segmentArray[0] = SerialSugar.assertMagicBytesSegment((String)"MZ");
            StringArraySection theReceiverPayloadSec = SerialSugar.stringArraySection();
            segmentArray[1] = SerialSugar.allocSegment((Section)theReceiverPayloadSec);
            SegmentComposite theReceiverSeg = SerialSugar.segmentComposite((Segment[])segmentArray);
            for (int i = 0; i < 15; ++i) {
                theReceiverPayloadSec.setPayload(null);
                SegmentResult theResult = theReceiverPort.onReceiveSegment((Segment)theReceiverSeg);
                theSenderSeg.transmitTo((SerialTransceiver)theTransmitPort);
                try {
                    theResult.waitForResult(5000L);
                }
                catch (TimeoutIOException e) {
                    System.err.println(e.getMessage());
                    try {
                        System.err.println(theResult.getResult());
                        String[] theReceiverData = theReceiverPayloadSec.getPayload();
                        System.err.println(VerboseTextBuilder.asString((String[])theReceiverData));
                    }
                    catch (TimeoutIOException timeoutIOException) {
                        // empty catch block
                    }
                    throw e;
                }
                Object[] theReceiverData = theReceiverPayloadSec.getPayload();
                if (IS_LOG_TESTS) {
                    System.out.println(VerboseTextBuilder.asString((String[])theReceiverData));
                }
                Assertions.assertArrayEquals((Object[])thePayload, (Object[])theReceiverData);
            }
            theTransmitPort.close();
            theReceiverPort.close();
        } else {
            System.out.println("Skipping test, please connect your null modem cable to two serial ports on your box, seeking for exactly two FT232 (ftdi_sio) type ports!");
        }
    }

    @Test
    public void testAssertMagicBytesFail() throws TransmissionSequenceException, IOException, NoSuchPortExcpetion, InterruptedException {
        if (this.hasPorts()) {
            Port theReceiverPort;
            Port theTransmitPort;
            block8: {
                theTransmitPort = (Port)this.getTransmitterPort().withOpen();
                theReceiverPort = (Port)this.getReceiverPort().withOpen();
                String[] thePayload = new String[]{"Hello", "World", "!!!"};
                SegmentComposite theSenderSeg = SerialSugar.segmentComposite((Segment[])new Segment[]{SerialSugar.assertMagicBytesSegment((String)"MZ"), SerialSugar.allocSegment((Section)SerialSugar.stringArraySection((String[])thePayload))});
                Segment[] segmentArray = new Segment[2];
                segmentArray[0] = SerialSugar.assertMagicBytesSegment((String)"P2P");
                StringArraySection theReceiverPayloadSec = SerialSugar.stringArraySection();
                segmentArray[1] = SerialSugar.allocSegment((Section)theReceiverPayloadSec);
                SegmentComposite theReceiverSeg = SerialSugar.segmentComposite((Segment[])segmentArray);
                SegmentResult theResult = theReceiverPort.onReceiveSegment((Segment)theReceiverSeg);
                theSenderSeg.transmitTo((SerialTransceiver)theTransmitPort);
                try {
                    theResult.waitForResult(5000L);
                }
                catch (TimeoutIOException e) {
                    System.err.println(e.getMessage());
                    try {
                        System.err.println(theResult.getResult());
                        String[] theReceiverData = theReceiverPayloadSec.getPayload();
                        System.err.println(VerboseTextBuilder.asString((String[])theReceiverData));
                    }
                    catch (TimeoutIOException timeoutIOException) {
                        // empty catch block
                    }
                    throw e;
                }
                try {
                    theResult.getResult();
                    Assertions.fail((String)"Expected a <BadMagicBytesException> here!");
                }
                catch (BadMagicBytesException e) {
                    if (!IS_LOG_TESTS) break block8;
                    System.out.println("Expected: " + e.getMessage());
                }
            }
            theTransmitPort.close();
            theReceiverPort.close();
        } else {
            System.out.println("Skipping test, please connect your null modem cable to two serial ports on your box, seeking for exactly two FT232 (ftdi_sio) type ports!");
        }
    }

    @Test
    public void testAssertMagicBytesSegmentPass() throws TransmissionSequenceException, IOException, NoSuchPortExcpetion, InterruptedException {
        if (this.hasPorts()) {
            Port theTransmitPort = (Port)this.getTransmitterPort().withOpen();
            Port theReceiverPort = (Port)this.getReceiverPort().withOpen();
            StringArraySection theSenderPayloadSec = SerialSugar.stringArraySection();
            AssertMagicBytesSegmentDecorator theSenderSeg = SerialSugar.assertMagicBytesSegment((Segment)SerialSugar.allocSegment((Section)theSenderPayloadSec), (byte[])new byte[]{-1, -2});
            StringArraySection theReceiverPayloadSec = SerialSugar.stringArraySection();
            AssertMagicBytesSegmentDecorator theReceiverSeg = SerialSugar.assertMagicBytesSegment((Segment)SerialSugar.allocSegment((Section)theReceiverPayloadSec), (byte[])new byte[]{-1, -2});
            for (int i = 0; i < 15; ++i) {
                Object[] ePayload = new String[]{"Hello", "World", "!!!", "" + i};
                theSenderPayloadSec.setPayload((String[])ePayload);
                theReceiverPayloadSec.setPayload(null);
                SegmentResult theResult = theReceiverPort.onReceiveSegment((Segment)theReceiverSeg);
                theSenderSeg.transmitTo((SerialTransceiver)theTransmitPort);
                try {
                    theResult.waitForResult(5000L);
                }
                catch (TimeoutIOException e) {
                    System.err.println(e.getMessage());
                    try {
                        System.err.println(theResult.getResult());
                        String[] theReceiverData = theReceiverPayloadSec.getPayload();
                        System.err.println(VerboseTextBuilder.asString((String[])theReceiverData));
                    }
                    catch (TimeoutIOException timeoutIOException) {
                        // empty catch block
                    }
                    throw e;
                }
                Object[] theReceiverData = theReceiverPayloadSec.getPayload();
                if (IS_LOG_TESTS) {
                    System.out.println(VerboseTextBuilder.asString((String[])theReceiverData));
                }
                Assertions.assertArrayEquals((Object[])ePayload, (Object[])theReceiverData);
            }
            theTransmitPort.close();
            theReceiverPort.close();
        } else {
            System.out.println("Skipping test, please connect your null modem cable to two serial ports on your box, seeking for exactly two FT232 (ftdi_sio) type ports!");
        }
    }

    @Test
    public void testAssertMagicBytesSegmentFail() throws TransmissionSequenceException, IOException, NoSuchPortExcpetion, InterruptedException {
        if (this.hasPorts()) {
            Port theReceiverPort;
            Port theTransmitPort;
            block8: {
                theTransmitPort = (Port)this.getTransmitterPort().withOpen();
                theReceiverPort = (Port)this.getReceiverPort().withOpen();
                String[] thePayload = new String[]{"Hello", "World", "!!!"};
                AssertMagicBytesSegmentDecorator theSenderSeg = SerialSugar.assertMagicBytesSegment((Segment)SerialSugar.allocSegment((Section)SerialSugar.stringArraySection((String[])thePayload)), (byte[])new byte[]{-1, -2});
                StringArraySection theReceiverPayloadSec = SerialSugar.stringArraySection();
                AssertMagicBytesSegmentDecorator theReceiverSeg = SerialSugar.assertMagicBytesSegment((Segment)SerialSugar.allocSegment((Section)theReceiverPayloadSec), (byte[])new byte[]{-1, -5, 127});
                SegmentResult theResult = theReceiverPort.onReceiveSegment((Segment)theReceiverSeg);
                theSenderSeg.transmitTo((SerialTransceiver)theTransmitPort);
                try {
                    theResult.waitForResult(5000L);
                }
                catch (TimeoutIOException e) {
                    System.err.println(e.getMessage());
                    try {
                        System.err.println(theResult.getResult());
                        String[] theReceiverData = theReceiverPayloadSec.getPayload();
                        System.err.println(VerboseTextBuilder.asString((String[])theReceiverData));
                    }
                    catch (TimeoutIOException timeoutIOException) {
                        // empty catch block
                    }
                    throw e;
                }
                try {
                    theResult.getResult();
                    Assertions.fail((String)"Expected a <BadMagicBytesException> here!");
                }
                catch (BadMagicBytesException e) {
                    if (!IS_LOG_TESTS) break block8;
                    System.out.println("Expected: " + e.getMessage());
                }
            }
            theTransmitPort.close();
            theReceiverPort.close();
        } else {
            System.out.println("Skipping test, please connect your null modem cable to two serial ports on your box, seeking for exactly two FT232 (ftdi_sio) type ports!");
        }
    }

    @Test
    public void testAssertMagicBytesSectionPass() throws TransmissionSequenceException, IOException, NoSuchPortExcpetion, InterruptedException {
        if (this.hasPorts()) {
            Port theTransmitPort = (Port)this.getTransmitterPort().withOpen();
            Port theReceiverPort = (Port)this.getReceiverPort().withOpen();
            Object[] thePayload = new String[]{"Hello", "World", "!!!"};
            AllocSectionDecoratorSegment theSenderSeg = SerialSugar.allocSegment((Section)SerialSugar.assertMagicBytesSection((Section)SerialSugar.stringArraySection((String[])thePayload), (String)"MZ"));
            StringArraySection theReceiverPayloadSec = SerialSugar.stringArraySection();
            AllocSectionDecoratorSegment theReceiverSeg = SerialSugar.allocSegment((Section)SerialSugar.assertMagicBytesSection((Section)theReceiverPayloadSec, (String)"MZ"));
            for (int i = 0; i < 15; ++i) {
                theReceiverPayloadSec.setPayload(null);
                SegmentResult theResult = theReceiverPort.onReceiveSegment((Segment)theReceiverSeg);
                theSenderSeg.transmitTo((SerialTransceiver)theTransmitPort);
                try {
                    theResult.waitForResult(5000L);
                }
                catch (TimeoutIOException e) {
                    System.err.println(e.getMessage());
                    try {
                        System.err.println(theResult.getResult());
                        String[] theReceiverData = theReceiverPayloadSec.getPayload();
                        System.err.println(VerboseTextBuilder.asString((String[])theReceiverData));
                    }
                    catch (TimeoutIOException timeoutIOException) {
                        // empty catch block
                    }
                    throw e;
                }
                Object[] theReceiverData = theReceiverPayloadSec.getPayload();
                if (IS_LOG_TESTS) {
                    System.out.println(VerboseTextBuilder.asString((String[])theReceiverData));
                }
                Assertions.assertArrayEquals((Object[])thePayload, (Object[])theReceiverData);
            }
            theTransmitPort.close();
            theReceiverPort.close();
        } else {
            System.out.println("Skipping test, please connect your null modem cable to two serial ports on your box, seeking for exactly two FT232 (ftdi_sio) type ports!");
        }
    }

    @Test
    public void testAssertMagicBytesSectionFail() throws TransmissionSequenceException, IOException, NoSuchPortExcpetion, InterruptedException {
        if (this.hasPorts()) {
            Port theReceiverPort;
            Port theTransmitPort;
            block8: {
                theTransmitPort = (Port)this.getTransmitterPort().withOpen();
                theReceiverPort = (Port)this.getReceiverPort().withOpen();
                String[] thePayload = new String[]{"Hello", "World", "!!!"};
                AllocSectionDecoratorSegment theSenderSeg = SerialSugar.allocSegment((Section)SerialSugar.assertMagicBytesSection((Section)SerialSugar.stringArraySection((String[])thePayload), (String)"MZ"));
                StringArraySection theReceiverPayloadSec = SerialSugar.stringArraySection();
                AllocSectionDecoratorSegment theReceiverSeg = SerialSugar.allocSegment((Section)SerialSugar.assertMagicBytesSection((Section)theReceiverPayloadSec, (String)"FEEDC0DE"));
                SegmentResult theResult = theReceiverPort.onReceiveSegment((Segment)theReceiverSeg);
                theSenderSeg.transmitTo((SerialTransceiver)theTransmitPort);
                try {
                    theResult.waitForResult(5000L);
                }
                catch (TimeoutIOException e) {
                    System.err.println(e.getMessage());
                    try {
                        System.err.println(theResult.getResult());
                        String[] theReceiverData = theReceiverPayloadSec.getPayload();
                        System.err.println(VerboseTextBuilder.asString((String[])theReceiverData));
                    }
                    catch (TimeoutIOException timeoutIOException) {
                        // empty catch block
                    }
                    throw e;
                }
                try {
                    theResult.getResult();
                    Assertions.fail((String)"Expected a <BadMagicBytesException> here!");
                }
                catch (BadMagicBytesException e) {
                    if (!IS_LOG_TESTS) break block8;
                    System.out.println("Expected: " + e.getMessage());
                }
            }
            theTransmitPort.close();
            theReceiverPort.close();
        } else {
            System.out.println("Skipping test, please connect your null modem cable to two serial ports on your box, seeking for exactly two FT232 (ftdi_sio) type ports!");
        }
    }
}

