/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.refcodes.data.Text;
import org.refcodes.mixin.ConcatenateMode;
import org.refcodes.numerical.CrcAlgorithm;
import org.refcodes.numerical.CrcAlgorithmConfig;
import org.refcodes.numerical.Endianess;
import org.refcodes.numerical.NumericalUtility;
import org.refcodes.serial.AbstractLoopbackPortTest;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.ComplexTypeSegment;
import org.refcodes.serial.NoSuchPortExcpetion;
import org.refcodes.serial.PacketInputStream;
import org.refcodes.serial.PacketOutputStream;
import org.refcodes.serial.Port;
import org.refcodes.serial.Section;
import org.refcodes.serial.Segment;
import org.refcodes.serial.SegmentPackager;
import org.refcodes.serial.SegmentResult;
import org.refcodes.serial.SerialSugar;
import org.refcodes.serial.SerialTransceiver;
import org.refcodes.serial.StopAndWaitPacketStreamSectionDecorator;
import org.refcodes.serial.StopAndWaitPacketStreamSegmentDecorator;
import org.refcodes.serial.StringArraySection;
import org.refcodes.serial.StringSection;
import org.refcodes.serial.TestFixures;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.serial.TransmissionSequenceException;
import org.refcodes.textual.VerboseTextBuilder;

public class PacketStreamTest
extends AbstractLoopbackPortTest {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");
    private static final int LOOPS = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Disabled
    public void testPackeStream() throws IOException, InterruptedException {
        if (this.hasPorts()) {
            Port theTransmitPort = (Port)this.getTransmitterPort().withOpen();
            Port theReceiverPort = (Port)this.getReceiverPort().withOpen();
            int theBlockSize = 64;
            final PacketInputStream thePacketIn = PacketInputStream.builder().withInputStream(theReceiverPort.getInputStream()).withBlockSize(theBlockSize).build();
            PacketOutputStream thePacketOut = PacketOutputStream.builder().withOutputStream(theReceiverPort.getOutputStream()).withBlockSize(theBlockSize).build();
            final byte[] theOutBytes = "Hallo Welt!".getBytes();
            final byte[] theInBytes = new byte[theOutBytes.length];
            Thread t = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        int eRead;
                        for (int i = 0; (eRead = thePacketIn.read()) != -1 && i < theOutBytes.length; ++i) {
                            if (IS_LOG_TESTS) {
                                System.out.println(i + " - " + (char)eRead);
                            }
                            theInBytes[i] = (byte)eRead;
                        }
                        if (IS_LOG_TESTS) {
                            System.out.println("EOT = " + eRead);
                        }
                        1 var3_3 = this;
                        synchronized (var3_3) {
                            this.notifyAll();
                        }
                    }
                    catch (IOException e) {
                        System.out.println(e.getClass().getSimpleName() + ": " + e.getMessage());
                    }
                }
            });
            t.start();
            thePacketOut.write(theOutBytes, 0, 3);
            thePacketOut.flush();
            thePacketOut.write(theOutBytes, 3, theOutBytes.length - 3);
            thePacketOut.flush();
            PacketStreamTest packetStreamTest = this;
            synchronized (packetStreamTest) {
                this.wait(500L);
            }
            theTransmitPort.close();
            theReceiverPort.close();
            Assertions.assertArrayEquals((byte[])theOutBytes, (byte[])theInBytes);
        } else {
            System.out.println("Skipping test, please connect your null modem cable to two serial ports on your box, seeking for exactly two FT232 (ftdi_sio) type ports!");
        }
    }

    @Test
    public void testSegmentTransmitReceive1() throws IOException, TransmissionException {
        ByteArrayOutputStream theOutputStream = new ByteArrayOutputStream();
        StringSection theStringSection = new StringSection(Text.ARECIBO_MESSAGE.getText());
        TransmissionMetrics theMetrics = TransmissionMetrics.builder().withEndianess(Endianess.LITTLE_ENDIAN).withCrcAlgorithm((CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE).withCrcChecksumConcatenateMode(ConcatenateMode.PREPEND).withSequenceNumberWidth(2).withSequenceNumberInitValue(511).withBlockSize(5).withAcknowledgeSegmentPackager((SegmentPackager)SerialSugar.dummySegmentPackager()).withPacketSegmentPackager((SegmentPackager)SerialSugar.dummySegmentPackager()).build();
        StopAndWaitPacketStreamSegmentDecorator thePacketSection = SerialSugar.stopAndWaitPacketStreamSegment((Segment)SerialSugar.allocSegment((Section)theStringSection), (TransmissionMetrics)theMetrics);
        thePacketSection.transmitTo((OutputStream)theOutputStream);
        if (IS_LOG_TESTS) {
            System.out.println(NumericalUtility.toHexString((byte[])theOutputStream.toByteArray(), (String)":", (int)7));
        }
        StringSection theOtherStringSection = new StringSection();
        StopAndWaitPacketStreamSegmentDecorator theOtherPacketSection = SerialSugar.stopAndWaitPacketStreamSegment((Segment)SerialSugar.allocSegment((Section)theOtherStringSection), (TransmissionMetrics)theMetrics);
        ByteArrayInputStream theInputStream = new ByteArrayInputStream(theOutputStream.toByteArray());
        theOtherPacketSection.receiveFrom((InputStream)theInputStream);
        if (IS_LOG_TESTS) {
            System.out.println("String section: \"" + (String)theStringSection.getPayload() + "\"");
            System.out.println("Other string section: \"" + (String)theOtherStringSection.getPayload() + "\"");
        }
        Assertions.assertEquals((Object)theStringSection, (Object)theOtherStringSection);
    }

    @Test
    public void testSegmentTransmitReceive1Crc() throws IOException, TransmissionException {
        ByteArrayOutputStream theOutputStream = new ByteArrayOutputStream();
        StringSection theStringSection = new StringSection(Text.ARECIBO_MESSAGE.getText());
        TransmissionMetrics theMetrics = TransmissionMetrics.builder().withEndianess(Endianess.LITTLE_ENDIAN).withCrcAlgorithm((CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE).withCrcChecksumConcatenateMode(ConcatenateMode.PREPEND).withSequenceNumberWidth(2).withSequenceNumberInitValue(511).withBlockSize(5).build();
        StopAndWaitPacketStreamSegmentDecorator thePacketSection = SerialSugar.stopAndWaitPacketStreamSegment((Segment)SerialSugar.allocSegment((Section)theStringSection), (TransmissionMetrics)theMetrics);
        thePacketSection.transmitTo((OutputStream)theOutputStream);
        if (IS_LOG_TESTS) {
            System.out.println(NumericalUtility.toHexString((byte[])theOutputStream.toByteArray(), (String)":", (int)9));
        }
        StringSection theOtherStringSection = new StringSection();
        StopAndWaitPacketStreamSegmentDecorator theOtherPacketSection = SerialSugar.stopAndWaitPacketStreamSegment((Segment)SerialSugar.allocSegment((Section)theOtherStringSection), (TransmissionMetrics)theMetrics);
        ByteArrayInputStream theInputStream = new ByteArrayInputStream(theOutputStream.toByteArray());
        theOtherPacketSection.receiveFrom((InputStream)theInputStream);
        if (IS_LOG_TESTS) {
            System.out.println("String section: \"" + (String)theStringSection.getPayload() + "\"");
            System.out.println("Other string section: \"" + (String)theOtherStringSection.getPayload() + "\"");
        }
        Assertions.assertEquals((Object)theStringSection, (Object)theOtherStringSection);
    }

    @Test
    public void testStopAndWaitSegmentTransmitReceive1() throws IOException, TransmissionException, InterruptedException {
        if (this.hasPorts()) {
            Port theTransmitPort = (Port)this.getTransmitterPort().withOpen();
            Port theReceiverPort = (Port)this.getReceiverPort().withOpen();
            StringSection theStringSection = new StringSection(Text.ARECIBO_MESSAGE.getText());
            TransmissionMetrics theMetrics = TransmissionMetrics.builder().withEndianess(Endianess.LITTLE_ENDIAN).withCrcAlgorithm((CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE).withCrcChecksumConcatenateMode(ConcatenateMode.PREPEND).withSequenceNumberWidth(2).withSequenceNumberInitValue(511).withBlockSize(256).withAcknowledgeSegmentPackager((SegmentPackager)SerialSugar.dummySegmentPackager()).withPacketSegmentPackager((SegmentPackager)SerialSugar.dummySegmentPackager()).build();
            StopAndWaitPacketStreamSegmentDecorator thePacketSection = SerialSugar.stopAndWaitPacketStreamSegment((Segment)SerialSugar.allocSegment((Section)theStringSection), (TransmissionMetrics)theMetrics);
            StringSection theOtherStringSection = new StringSection();
            StopAndWaitPacketStreamSegmentDecorator theOtherPacketSection = SerialSugar.stopAndWaitPacketStreamSegment((Segment)SerialSugar.allocSegment((Section)theOtherStringSection), (TransmissionMetrics)theMetrics);
            SegmentResult theResult = theReceiverPort.onReceiveSegment((Segment)theOtherPacketSection);
            thePacketSection.transmitTo((SerialTransceiver)theTransmitPort);
            theResult.waitForResult();
            if (IS_LOG_TESTS) {
                System.out.println("String section: \"" + (String)theStringSection.getPayload() + "\"");
                System.out.println("Other string section: \"" + (String)theOtherStringSection.getPayload() + "\"");
            }
            Assertions.assertEquals((Object)theStringSection, (Object)theOtherStringSection);
            theTransmitPort.close();
            theReceiverPort.close();
        } else {
            System.out.println("Skipping test, please connect your null modem cable to two serial ports on your box, seeking for exactly two FT232 (ftdi_sio) type ports!");
        }
    }

    @Test
    public void testStopAndWaitSegmentTransmitReceive1Crc() throws IOException, TransmissionException, InterruptedException {
        if (this.hasPorts()) {
            Port theTransmitPort = (Port)this.getTransmitterPort().withOpen();
            Port theReceiverPort = (Port)this.getReceiverPort().withOpen();
            StringSection theStringSection = new StringSection(Text.ARECIBO_MESSAGE.getText());
            TransmissionMetrics theMetrics = TransmissionMetrics.builder().withEndianess(Endianess.LITTLE_ENDIAN).withCrcAlgorithm((CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE).withCrcChecksumConcatenateMode(ConcatenateMode.PREPEND).withSequenceNumberWidth(2).withSequenceNumberInitValue(511).withBlockSize(256).build();
            StopAndWaitPacketStreamSegmentDecorator thePacketSection = SerialSugar.stopAndWaitPacketStreamSegment((Segment)SerialSugar.allocSegment((Section)theStringSection), (TransmissionMetrics)theMetrics);
            StringSection theOtherStringSection = new StringSection();
            StopAndWaitPacketStreamSegmentDecorator theOtherPacketSection = SerialSugar.stopAndWaitPacketStreamSegment((Segment)SerialSugar.allocSegment((Section)theOtherStringSection), (TransmissionMetrics)theMetrics);
            SegmentResult theResult = theReceiverPort.onReceiveSegment((Segment)theOtherPacketSection);
            thePacketSection.transmitTo((SerialTransceiver)theTransmitPort);
            theResult.waitForResult();
            if (IS_LOG_TESTS) {
                System.out.println("String section: \"" + (String)theStringSection.getPayload() + "\"");
                System.out.println("Other string section: \"" + (String)theOtherStringSection.getPayload() + "\"");
            }
            Assertions.assertEquals((Object)theStringSection, (Object)theOtherStringSection);
            theTransmitPort.close();
            theReceiverPort.close();
        } else {
            System.out.println("Skipping test, please connect your null modem cable to two serial ports on your box, seeking for exactly two FT232 (ftdi_sio) type ports!");
        }
    }

    @Test
    public void testSegmentTransmitReceive2() throws IOException, TransmissionException {
        ByteArrayOutputStream theOutputStream = new ByteArrayOutputStream();
        StringArraySection theStringSection = new StringArraySection(new String[]{"AAAAA", "BBBBB", "CCCCC", "DDDDD", "EEEEE", ""});
        TransmissionMetrics theMetrics = TransmissionMetrics.builder().withEndianess(Endianess.LITTLE_ENDIAN).withCrcAlgorithm((CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE).withCrcChecksumConcatenateMode(ConcatenateMode.PREPEND).withSequenceNumberWidth(2).withSequenceNumberInitValue(511).withBlockSize(5).withAcknowledgeSegmentPackager((SegmentPackager)SerialSugar.dummySegmentPackager()).withPacketSegmentPackager((SegmentPackager)SerialSugar.dummySegmentPackager()).build();
        StopAndWaitPacketStreamSegmentDecorator thePacketSection = SerialSugar.stopAndWaitPacketStreamSegment((Segment)SerialSugar.allocSegment((Section)theStringSection), (TransmissionMetrics)theMetrics);
        thePacketSection.transmitTo((OutputStream)theOutputStream);
        if (IS_LOG_TESTS) {
            System.out.println(NumericalUtility.toHexString((byte[])theOutputStream.toByteArray(), (String)":", (int)7));
        }
        StringArraySection theOtherStringSection = new StringArraySection();
        StopAndWaitPacketStreamSegmentDecorator theOtherPacketSection = SerialSugar.stopAndWaitPacketStreamSegment((Segment)SerialSugar.allocSegment((Section)theOtherStringSection), (TransmissionMetrics)theMetrics);
        ByteArrayInputStream theInputStream = new ByteArrayInputStream(theOutputStream.toByteArray());
        theOtherPacketSection.receiveFrom((InputStream)theInputStream);
        if (IS_LOG_TESTS) {
            System.out.println(VerboseTextBuilder.asString((String[])theOtherStringSection.getPayload()));
        }
        if (IS_LOG_TESTS) {
            System.out.println("String section: " + VerboseTextBuilder.asString((String[])theStringSection.getPayload()));
            System.out.println("Other string section: " + VerboseTextBuilder.asString((String[])theOtherStringSection.getPayload()));
        }
        Assertions.assertArrayEquals((Object[])theStringSection.getPayload(), (Object[])theOtherStringSection.getPayload());
    }

    @Test
    public void testSegmentTransmitReceive2Crc() throws IOException, TransmissionException {
        ByteArrayOutputStream theOutputStream = new ByteArrayOutputStream();
        StringArraySection theStringSection = new StringArraySection(new String[]{"AAAAA", "BBBBB", "CCCCC", "DDDDD", "EEEEE", ""});
        TransmissionMetrics theMetrics = TransmissionMetrics.builder().withEndianess(Endianess.LITTLE_ENDIAN).withCrcAlgorithm((CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE).withCrcChecksumConcatenateMode(ConcatenateMode.PREPEND).withSequenceNumberWidth(2).withSequenceNumberInitValue(511).withBlockSize(5).build();
        StopAndWaitPacketStreamSegmentDecorator thePacketSection = SerialSugar.stopAndWaitPacketStreamSegment((Segment)SerialSugar.allocSegment((Section)theStringSection), (TransmissionMetrics)theMetrics);
        thePacketSection.transmitTo((OutputStream)theOutputStream);
        if (IS_LOG_TESTS) {
            System.out.println(NumericalUtility.toHexString((byte[])theOutputStream.toByteArray(), (String)":", (int)9));
        }
        StringArraySection theOtherStringSection = new StringArraySection();
        StopAndWaitPacketStreamSegmentDecorator theOtherPacketSection = SerialSugar.stopAndWaitPacketStreamSegment((Segment)SerialSugar.allocSegment((Section)theOtherStringSection), (TransmissionMetrics)theMetrics);
        ByteArrayInputStream theInputStream = new ByteArrayInputStream(theOutputStream.toByteArray());
        theOtherPacketSection.receiveFrom((InputStream)theInputStream);
        if (IS_LOG_TESTS) {
            System.out.println(VerboseTextBuilder.asString((String[])theOtherStringSection.getPayload()));
        }
        if (IS_LOG_TESTS) {
            System.out.println("String section: " + VerboseTextBuilder.asString((String[])theStringSection.getPayload()));
            System.out.println("Other string section: " + VerboseTextBuilder.asString((String[])theOtherStringSection.getPayload()));
        }
        Assertions.assertArrayEquals((Object[])theStringSection.getPayload(), (Object[])theOtherStringSection.getPayload());
    }

    @Test
    public void testStopAndWaitSegmentTransmitReceive2() throws IOException, TransmissionException, InterruptedException {
        if (this.hasPorts()) {
            Port theTransmitPort = (Port)this.getTransmitterPort().withOpen();
            Port theReceiverPort = (Port)this.getReceiverPort().withOpen();
            StringArraySection theStringSection = new StringArraySection(new String[]{"AAAAA", "BBBBB", "CCCCC", "DDDDD", "EEEEE", ""});
            TransmissionMetrics theMetrics = TransmissionMetrics.builder().withEndianess(Endianess.LITTLE_ENDIAN).withCrcAlgorithm((CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE).withCrcChecksumConcatenateMode(ConcatenateMode.PREPEND).withSequenceNumberWidth(2).withSequenceNumberInitValue(0).withBlockSize(5).withAcknowledgeSegmentPackager((SegmentPackager)SerialSugar.dummySegmentPackager()).withPacketSegmentPackager((SegmentPackager)SerialSugar.dummySegmentPackager()).build();
            StopAndWaitPacketStreamSegmentDecorator thePacketSection = SerialSugar.stopAndWaitPacketStreamSegment((Segment)SerialSugar.allocSegment((Section)theStringSection), (TransmissionMetrics)theMetrics);
            StringArraySection theOtherStringSection = new StringArraySection();
            StopAndWaitPacketStreamSegmentDecorator theOtherPacketSection = SerialSugar.stopAndWaitPacketStreamSegment((Segment)SerialSugar.allocSegment((Section)theOtherStringSection), (TransmissionMetrics)theMetrics);
            SegmentResult theResult = theReceiverPort.onReceiveSegment((Segment)theOtherPacketSection);
            thePacketSection.transmitTo((SerialTransceiver)theTransmitPort);
            theResult.waitForResult();
            if (IS_LOG_TESTS) {
                System.out.println("String section: " + VerboseTextBuilder.asString((String[])theStringSection.getPayload()));
                System.out.println("Other string section: " + VerboseTextBuilder.asString((String[])theOtherStringSection.getPayload()));
            }
            Assertions.assertArrayEquals((Object[])theStringSection.getPayload(), (Object[])theOtherStringSection.getPayload());
            theTransmitPort.close();
            theReceiverPort.close();
        } else {
            System.out.println("Skipping test, please connect your null modem cable to two serial ports on your box, seeking for exactly two FT232 (ftdi_sio) type ports!");
        }
    }

    @Test
    public void testStopAndWaitSegmentTransmitReceive2Crc() throws IOException, TransmissionException, InterruptedException {
        if (this.hasPorts()) {
            Port theTransmitPort = (Port)this.getTransmitterPort().withOpen();
            Port theReceiverPort = (Port)this.getReceiverPort().withOpen();
            StringArraySection theStringSection = new StringArraySection(new String[]{"AAAAA", "BBBBB", "CCCCC", "DDDDD", "EEEEE", ""});
            TransmissionMetrics theMetrics = TransmissionMetrics.builder().withEndianess(Endianess.LITTLE_ENDIAN).withCrcAlgorithm((CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE).withCrcChecksumConcatenateMode(ConcatenateMode.PREPEND).withSequenceNumberWidth(2).withSequenceNumberInitValue(0).withBlockSize(5).build();
            StopAndWaitPacketStreamSegmentDecorator thePacketSection = SerialSugar.stopAndWaitPacketStreamSegment((Segment)SerialSugar.allocSegment((Section)theStringSection), (TransmissionMetrics)theMetrics);
            StringArraySection theOtherStringSection = new StringArraySection();
            StopAndWaitPacketStreamSegmentDecorator theOtherPacketSection = SerialSugar.stopAndWaitPacketStreamSegment((Segment)SerialSugar.allocSegment((Section)theOtherStringSection), (TransmissionMetrics)theMetrics);
            SegmentResult theResult = theReceiverPort.onReceiveSegment((Segment)theOtherPacketSection);
            thePacketSection.transmitTo((SerialTransceiver)theTransmitPort);
            theResult.waitForResult();
            if (IS_LOG_TESTS) {
                System.out.println("String section: " + VerboseTextBuilder.asString((String[])theStringSection.getPayload()));
                System.out.println("Other string section: " + VerboseTextBuilder.asString((String[])theOtherStringSection.getPayload()));
            }
            Assertions.assertArrayEquals((Object[])theStringSection.getPayload(), (Object[])theOtherStringSection.getPayload());
            theTransmitPort.close();
            theReceiverPort.close();
        } else {
            System.out.println("Skipping test, please connect your null modem cable to two serial ports on your box, seeking for exactly two FT232 (ftdi_sio) type ports!");
        }
    }

    @Test
    public void testSectionTransmitReceive1() throws IOException, TransmissionException {
        ByteArrayOutputStream theOutputStream = new ByteArrayOutputStream();
        StringSection theStringSection = new StringSection(Text.ARECIBO_MESSAGE.getText());
        TransmissionMetrics theMetrics = TransmissionMetrics.builder().withEndianess(Endianess.LITTLE_ENDIAN).withCrcAlgorithm((CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE).withCrcChecksumConcatenateMode(ConcatenateMode.PREPEND).withSequenceNumberWidth(2).withSequenceNumberInitValue(0).withBlockSize(5).withAcknowledgeSegmentPackager((SegmentPackager)SerialSugar.dummySegmentPackager()).withPacketSegmentPackager((SegmentPackager)SerialSugar.dummySegmentPackager()).build();
        StopAndWaitPacketStreamSectionDecorator thePacketSection = SerialSugar.stopAndWaitPacketStreamSection((Section)theStringSection, (TransmissionMetrics)theMetrics);
        thePacketSection.transmitTo((OutputStream)theOutputStream);
        if (IS_LOG_TESTS) {
            System.out.println(NumericalUtility.toHexString((byte[])theOutputStream.toByteArray(), (String)":", (int)7));
        }
        StringSection theOtherStringSection = new StringSection();
        StopAndWaitPacketStreamSectionDecorator theOtherPacketSection = SerialSugar.stopAndWaitPacketStreamSection((Section)theOtherStringSection, (TransmissionMetrics)theMetrics);
        ByteArrayInputStream theInputStream = new ByteArrayInputStream(theOutputStream.toByteArray());
        theOtherPacketSection.receiveFrom((InputStream)theInputStream, thePacketSection.getLength());
        if (IS_LOG_TESTS) {
            System.out.println("String section: \"" + (String)theStringSection.getPayload() + "\"");
            System.out.println("Other string section: \"" + (String)theOtherStringSection.getPayload() + "\"");
        }
        Assertions.assertEquals((Object)theStringSection, (Object)theOtherStringSection);
    }

    @Test
    public void testSectionTransmitReceive1Crc() throws IOException, TransmissionException {
        ByteArrayOutputStream theOutputStream = new ByteArrayOutputStream();
        StringSection theStringSection = new StringSection(Text.ARECIBO_MESSAGE.getText());
        TransmissionMetrics theMetrics = TransmissionMetrics.builder().withEndianess(Endianess.LITTLE_ENDIAN).withCrcAlgorithm((CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE).withCrcChecksumConcatenateMode(ConcatenateMode.PREPEND).withSequenceNumberWidth(2).withSequenceNumberInitValue(511).withBlockSize(5).build();
        StopAndWaitPacketStreamSectionDecorator thePacketSection = SerialSugar.stopAndWaitPacketStreamSection((Section)theStringSection, (TransmissionMetrics)theMetrics);
        thePacketSection.transmitTo((OutputStream)theOutputStream);
        if (IS_LOG_TESTS) {
            System.out.println(NumericalUtility.toHexString((byte[])theOutputStream.toByteArray(), (String)":", (int)9));
        }
        StringSection theOtherStringSection = new StringSection();
        StopAndWaitPacketStreamSectionDecorator theOtherPacketSection = SerialSugar.stopAndWaitPacketStreamSection((Section)theOtherStringSection, (TransmissionMetrics)theMetrics);
        ByteArrayInputStream theInputStream = new ByteArrayInputStream(theOutputStream.toByteArray());
        theOtherPacketSection.receiveFrom((InputStream)theInputStream, thePacketSection.getLength());
        if (IS_LOG_TESTS) {
            System.out.println("String section: \"" + (String)theStringSection.getPayload() + "\"");
            System.out.println("Other string section: \"" + (String)theOtherStringSection.getPayload() + "\"");
        }
        Assertions.assertEquals((Object)theStringSection, (Object)theOtherStringSection);
    }

    @Test
    public void testSectionTransmitReceive2() throws IOException, TransmissionException {
        ByteArrayOutputStream theOutputStream = new ByteArrayOutputStream();
        StringArraySection theStringSection = new StringArraySection(new String[]{"AAAAA", "BBBBB", "CCCCC", "DDDDD", "EEEEE", ""});
        TransmissionMetrics theMetrics = TransmissionMetrics.builder().withEndianess(Endianess.LITTLE_ENDIAN).withCrcAlgorithm((CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE).withCrcChecksumConcatenateMode(ConcatenateMode.PREPEND).withSequenceNumberWidth(2).withSequenceNumberInitValue(511).withBlockSize(5).withAcknowledgeSegmentPackager((SegmentPackager)SerialSugar.dummySegmentPackager()).withPacketSegmentPackager((SegmentPackager)SerialSugar.dummySegmentPackager()).build();
        StopAndWaitPacketStreamSectionDecorator thePacketSection = SerialSugar.stopAndWaitPacketStreamSection((Section)theStringSection, (TransmissionMetrics)theMetrics);
        thePacketSection.transmitTo((OutputStream)theOutputStream);
        if (IS_LOG_TESTS) {
            System.out.println(NumericalUtility.toHexString((byte[])theOutputStream.toByteArray(), (String)":", (int)7));
        }
        StringArraySection theOtherStringSection = new StringArraySection();
        StopAndWaitPacketStreamSectionDecorator theOtherPacketSection = SerialSugar.stopAndWaitPacketStreamSection((Section)theOtherStringSection, (TransmissionMetrics)theMetrics);
        ByteArrayInputStream theInputStream = new ByteArrayInputStream(theOutputStream.toByteArray());
        theOtherPacketSection.receiveFrom((InputStream)theInputStream, thePacketSection.getLength());
        if (IS_LOG_TESTS) {
            System.out.println(VerboseTextBuilder.asString((String[])theOtherStringSection.getPayload()));
        }
        if (IS_LOG_TESTS) {
            System.out.println("String section: " + VerboseTextBuilder.asString((String[])theStringSection.getPayload()));
            System.out.println("Other string section: " + VerboseTextBuilder.asString((String[])theOtherStringSection.getPayload()));
        }
        Assertions.assertArrayEquals((Object[])theStringSection.getPayload(), (Object[])theOtherStringSection.getPayload());
    }

    @Test
    public void testSectionTransmitReceive2Crc() throws IOException, TransmissionException {
        ByteArrayOutputStream theOutputStream = new ByteArrayOutputStream();
        StringArraySection theStringSection = new StringArraySection(new String[]{"AAAAA", "BBBBB", "CCCCC", "DDDDD", "EEEEE", ""});
        TransmissionMetrics theMetrics = TransmissionMetrics.builder().withEndianess(Endianess.LITTLE_ENDIAN).withCrcAlgorithm((CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE).withCrcChecksumConcatenateMode(ConcatenateMode.PREPEND).withSequenceNumberWidth(2).withSequenceNumberInitValue(511).withBlockSize(5).build();
        StopAndWaitPacketStreamSectionDecorator thePacketSection = SerialSugar.stopAndWaitPacketStreamSection((Section)theStringSection, (TransmissionMetrics)theMetrics);
        thePacketSection.transmitTo((OutputStream)theOutputStream);
        if (IS_LOG_TESTS) {
            System.out.println(NumericalUtility.toHexString((byte[])theOutputStream.toByteArray(), (String)":", (int)9));
        }
        StringArraySection theOtherStringSection = new StringArraySection();
        StopAndWaitPacketStreamSectionDecorator theOtherPacketSection = SerialSugar.stopAndWaitPacketStreamSection((Section)theOtherStringSection, (TransmissionMetrics)theMetrics);
        ByteArrayInputStream theInputStream = new ByteArrayInputStream(theOutputStream.toByteArray());
        theOtherPacketSection.receiveFrom((InputStream)theInputStream, thePacketSection.getLength());
        if (IS_LOG_TESTS) {
            System.out.println(VerboseTextBuilder.asString((String[])theOtherStringSection.getPayload()));
        }
        if (IS_LOG_TESTS) {
            System.out.println("String section: " + VerboseTextBuilder.asString((String[])theStringSection.getPayload()));
            System.out.println("Other string section: " + VerboseTextBuilder.asString((String[])theOtherStringSection.getPayload()));
        }
        Assertions.assertArrayEquals((Object[])theStringSection.getPayload(), (Object[])theOtherStringSection.getPayload());
    }

    @Test
    public void testStopAndWaitPacketStreamSegmentDecorator() throws TransmissionSequenceException, IOException, NoSuchPortExcpetion, InterruptedException {
        if (this.hasPorts()) {
            Port theTransmitPort = (Port)this.getTransmitterPort().withOpen();
            Port theReceiverPort = (Port)this.getReceiverPort().withOpen();
            TestFixures.WeatherData theSenderData = TestFixures.createWeatherData();
            StopAndWaitPacketStreamSegmentDecorator theSenderSeg = SerialSugar.stopAndWaitPacketStreamSegmentBuilder().withDecoratee((Segment)SerialSugar.crcPrefixSegment((Segment)SerialSugar.complexTypeSegment((Object)theSenderData), (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE)).withBlockSize(8).build();
            ComplexTypeSegment theReceiverComplexSegment = SerialSugar.complexTypeSegment(TestFixures.WeatherData.class);
            StopAndWaitPacketStreamSegmentDecorator theReceiverSeg = SerialSugar.stopAndWaitPacketStreamSegmentBuilder().withDecoratee((Segment)SerialSugar.crcPrefixSegment((Segment)theReceiverComplexSegment, (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE)).withBlockSize(8).build();
            for (int i = 0; i < 3; ++i) {
                SegmentResult theResult = theReceiverPort.onReceiveSegment((Segment)theReceiverSeg);
                theSenderSeg.transmitTo((SerialTransceiver)theTransmitPort);
                theResult.waitForResult();
                TestFixures.WeatherData theReceiverData = (TestFixures.WeatherData)theReceiverComplexSegment.getPayload();
                if (IS_LOG_TESTS) {
                    System.out.println(theReceiverData);
                }
                Assertions.assertEquals((Object)theSenderData, (Object)theReceiverData);
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            theTransmitPort.close();
            theReceiverPort.close();
        } else {
            System.out.println("Skipping test, please connect your null modem cable to two serial ports on your box, seeking for exactly two FT232 (ftdi_sio) type ports!");
        }
    }

    @Test
    public void testEdgeCase1() throws IOException, InterruptedException {
        ByteArrayOutputStream theByteOut = new ByteArrayOutputStream();
        int theBlockSize = 6;
        PacketOutputStream thePacketOut = PacketOutputStream.builder().withOutputStream((OutputStream)theByteOut).withBlockSize(theBlockSize).build();
        ByteArraySequence theSeqOut = new ByteArraySequence(new byte[]{1, 2, -1, 4, -1, 0});
        if (IS_LOG_TESTS) {
            System.out.println("Sequence:");
            System.out.println(NumericalUtility.toHexString((String)":", (int)10, (byte[])theSeqOut.toBytes()));
        }
        theSeqOut.writeTo((OutputStream)thePacketOut);
        thePacketOut.flush();
        if (IS_LOG_TESTS) {
            System.out.println("ByteArrayOutputStream:");
            System.out.println(NumericalUtility.toHexString((String)":", (int)thePacketOut.getPacketSize(), (byte[])theByteOut.toByteArray()));
        }
        ByteArrayInputStream theByteIn = new ByteArrayInputStream(theByteOut.toByteArray());
        try (PacketInputStream thePacketIn = PacketInputStream.builder().withInputStream((InputStream)theByteIn).withBlockSize(theBlockSize).build();){
            ByteArraySequence theInSeq = new ByteArraySequence((InputStream)thePacketIn);
            if (IS_LOG_TESTS) {
                System.out.println("ByteArrayInputStream:");
                System.out.println(NumericalUtility.toHexString((String)":", (int)thePacketOut.getPacketSize(), (byte[])theInSeq.toBytes()));
            }
            Assertions.assertArrayEquals((byte[])theSeqOut.toBytes(), (byte[])theInSeq.toBytes());
        }
    }

    @Test
    public void testEdgeCase2() throws IOException, InterruptedException {
        ByteArrayOutputStream theByteOut = new ByteArrayOutputStream();
        int theBlockSize = 1;
        PacketOutputStream thePacketOut = PacketOutputStream.builder().withOutputStream((OutputStream)theByteOut).withBlockSize(theBlockSize).build();
        ByteArraySequence theSeqOut = new ByteArraySequence(new byte[]{1, 2, -1, 4, -1, 0});
        if (IS_LOG_TESTS) {
            System.out.println("Sequence:");
            System.out.println(NumericalUtility.toHexString((String)":", (int)thePacketOut.getPacketSize(), (byte[])theSeqOut.toBytes()));
        }
        theSeqOut.writeTo((OutputStream)thePacketOut);
        thePacketOut.flush();
        if (IS_LOG_TESTS) {
            System.out.println("ByteArrayOutputStream:");
            System.out.println(NumericalUtility.toHexString((String)":", (int)thePacketOut.getPacketSize(), (byte[])theByteOut.toByteArray()));
        }
        ByteArrayInputStream theByteIn = new ByteArrayInputStream(theByteOut.toByteArray());
        try (PacketInputStream thePacketIn = PacketInputStream.builder().withInputStream((InputStream)theByteIn).withBlockSize(theBlockSize).build();){
            ByteArraySequence theInSeq = new ByteArraySequence((InputStream)thePacketIn);
            if (IS_LOG_TESTS) {
                System.out.println("ByteArrayInputStream:");
                System.out.println(NumericalUtility.toHexString((String)":", (int)thePacketOut.getPacketSize(), (byte[])theInSeq.toBytes()));
            }
            Assertions.assertArrayEquals((byte[])theSeqOut.toBytes(), (byte[])theInSeq.toBytes());
        }
    }

    @Test
    public void testEdgeCase3() throws IOException, InterruptedException {
        ByteArrayOutputStream theByteOut = new ByteArrayOutputStream();
        int theBlockSize = 3;
        PacketOutputStream thePacketOut = PacketOutputStream.builder().withOutputStream((OutputStream)theByteOut).withBlockSize(theBlockSize).build();
        ByteArraySequence theSeqOut = new ByteArraySequence(new byte[]{1, 2, -1, 4, -1, 0});
        if (IS_LOG_TESTS) {
            System.out.println("Sequence:");
            System.out.println(NumericalUtility.toHexString((String)":", (int)10, (byte[])theSeqOut.toBytes()));
        }
        theSeqOut.writeTo((OutputStream)thePacketOut);
        thePacketOut.flush();
        if (IS_LOG_TESTS) {
            System.out.println("ByteArrayOutputStream:");
            System.out.println(NumericalUtility.toHexString((String)":", (int)thePacketOut.getPacketSize(), (byte[])theByteOut.toByteArray()));
        }
        ByteArrayInputStream theByteIn = new ByteArrayInputStream(theByteOut.toByteArray());
        try (PacketInputStream thePacketIn = PacketInputStream.builder().withInputStream((InputStream)theByteIn).withBlockSize(theBlockSize).build();){
            ByteArraySequence theInSeq = new ByteArraySequence((InputStream)thePacketIn);
            if (IS_LOG_TESTS) {
                System.out.println("ByteArrayInputStream:");
                System.out.println(NumericalUtility.toHexString((String)":", (int)10, (byte[])theInSeq.toBytes()));
            }
            Assertions.assertArrayEquals((byte[])theSeqOut.toBytes(), (byte[])theInSeq.toBytes());
        }
    }

    @Test
    public void testEdgeCase4() throws IOException, InterruptedException {
        ByteArrayOutputStream theByteOut = new ByteArrayOutputStream();
        int theBlockSize = 10;
        PacketOutputStream thePacketOut = PacketOutputStream.builder().withOutputStream((OutputStream)theByteOut).withBlockSize(theBlockSize).build();
        ByteArraySequence theSeqOut = new ByteArraySequence(new byte[]{1, 2, -1, 4, -1, 0});
        if (IS_LOG_TESTS) {
            System.out.println("Sequence:");
            System.out.println(NumericalUtility.toHexString((String)":", (int)10, (byte[])theSeqOut.toBytes()));
        }
        theSeqOut.writeTo((OutputStream)thePacketOut);
        thePacketOut.flush();
        if (IS_LOG_TESTS) {
            System.out.println("ByteArrayOutputStream:");
            System.out.println(NumericalUtility.toHexString((String)":", (int)thePacketOut.getPacketSize(), (byte[])theByteOut.toByteArray()));
        }
        ByteArrayInputStream theByteIn = new ByteArrayInputStream(theByteOut.toByteArray());
        try (PacketInputStream thePacketIn = PacketInputStream.builder().withInputStream((InputStream)theByteIn).withBlockSize(theBlockSize).build();){
            ByteArraySequence theInSeq = new ByteArraySequence((InputStream)thePacketIn);
            if (IS_LOG_TESTS) {
                System.out.println("ByteArrayInputStream:");
                System.out.println(NumericalUtility.toHexString((String)":", (int)10, (byte[])theInSeq.toBytes()));
            }
            Assertions.assertArrayEquals((byte[])theSeqOut.toBytes(), (byte[])theInSeq.toBytes());
        }
    }
}

